/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.misc;

import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;

public final class FluidSourceInteractionHandler {
    private static final int _UNKNOWN = -1;
    private static final int _BIT_MEASURE = 1;
    private static final int _MUSHROOM = 2;

    private int getWhatHeld(ItemStack held) {
        int type = -1;
        Item item = held.func_77973_b();
        if (!MinecraftGlue.ItemStacks_isEmpty(held) && item != VfpObj.Fungi_Purged_obj) {
            if (item == VfpObj.Bit_Pipette_obj) {
                type = 1;
            } else if (MinecraftGlue.RID.matches(held, "foodMushroom")) {
                type = 2;
            }
        }
        return type;
    }

    @SubscribeEvent
    public void onRightClickFluidSource(PlayerInteractEvent.RightClickBlock event) {
        BlockPos blockpos;
        IBlockState state;
        RayTraceResult mop;
        ItemStack held;
        int what;
        World world = event.getWorld();
        boolean ss = !world.field_72995_K;
        EntityPlayer player = event.getEntityPlayer();
        if (!player.func_70093_af() && (what = this.getWhatHeld(held = player.func_184586_b(event.getHand()))) != -1 && (mop = DummyItem.INSTANCE.rayTrace(world, player)) != null && mop.field_72313_a == RayTraceResult.Type.BLOCK && (state = world.func_180495_p(blockpos = mop.func_178782_a())).func_185904_a() == MinecraftGlue.Material_water && state.func_177228_b().containsKey((Object)BlockLiquid.field_176367_b) && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
            ItemStack generated = null;
            if (what == 1) {
                generated = new ItemStack(VfpObj.Water_Portion_obj);
                if (ss) {
                    player.func_71029_a(StatList.func_188057_b((Item)held.func_77973_b()));
                }
                if (player.field_71071_by.func_70441_a(generated)) {
                    MinecraftGlue.Effects.playBottleOfWaterScoopedUp(world, player);
                } else {
                    generated = null;
                }
            } else if (what == 2) {
                generated = new ItemStack(VfpObj.Fungi_Purged_obj);
                if (!player.field_71071_by.func_70441_a(generated)) {
                    player.func_71019_a(generated, false);
                }
                MinecraftGlue.Effects.playBottleOfWaterScoopedUp(world, player);
                if (MinecraftGlue.getPlayerInSurvival(player)) {
                    MinecraftGlue.consumeItemFromStack(player, held, event.getHand(), false);
                }
            }
            if (generated != null) {
                MinecraftGlue.refreshPlayerHUD(player);
                event.setCanceled(true);
            }
        }
    }

    private static final class DummyItem
    extends Item {
        static final DummyItem INSTANCE = new DummyItem();

        DummyItem() {
        }

        public RayTraceResult rayTrace(World world, EntityPlayer player) {
            return this.func_77621_a(world, player, true);
        }
    }
}

