/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.misc;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.jwaresoftware.mcmods.vfp.common.DictionaryNameItemAdaptor;
import org.jwaresoftware.mcmods.vfp.common.FoodColor;
import org.jwaresoftware.mcmods.vfp.common.Ingredient;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;

public final class Juices
extends VfpLiquidMultiItem {
    public static final int GENERIC_JUICE_COLOR = 10796325;
    private static final List<Ingredient> VARIANT_FLAVORS = new ArrayList<Ingredient>();
    private static final VfpVariantSet VARIANT_SET = new VfpLiquidMultiItem.VariantSet((VfpProfile)VfpOid.Juice, (Class)Juices.class){

        @Override
        protected VfpVariant[] declaredVariants() {
            return this.values().toArray(VfpVariant.EMPTY_ARRAY);
        }
    };
    private static Juices INSTANCE;
    private static ItemStack[] TYPED_INSTANCES;

    public static final synchronized boolean register(Flavor flavor) {
        return Juices.register(flavor, VARIANT_FLAVORS, "juice");
    }

    public Juices(VfpOid oid, CreativeTabs tab) {
        super((VfpProfile)oid, VARIANT_SET, tab);
    }

    @Override
    protected ItemStack getNewEmptyContainer() {
        return new ItemStack(VfpObj.Our_Empty_Bottle_obj);
    }

    @Override
    protected VfpCapacity getItemMaxStackSize() {
        return VfpConfig.getInstance().maxDrinksStackCapacity(super.getItemMaxStackSize());
    }

    @Override
    protected Integer getVariantColorFromMeta(VfpVariant type, Ingredient ingredient, int renderPass) {
        Integer colorValue = super.getVariantColorFromMeta(type, ingredient, renderPass);
        if (colorValue == null) {
            colorValue = 10796325;
        }
        return colorValue;
    }

    public static final synchronized Juices get() {
        if (INSTANCE == null && VARIANT_FLAVORS.size() > 0) {
            ArrayList<VfpTransientVariant> variants = new ArrayList<VfpTransientVariant>(13);
            String typeName = VARIANT_SET.typeName();
            for (Ingredient ingredient : VARIANT_FLAVORS) {
                variants.add(new VfpTransientVariant(ingredient.id(), typeName, LikeFood.juice, ingredient, null, VARIANT_SET));
            }
            INSTANCE = VfpBuilder.newMultiItem(VfpOid.Juice, Juices.class, VfpBuilder.User.INTERNAL);
            for (Ingredient ingredient : VARIANT_FLAVORS) {
                if (!ingredient.isEnabled()) continue;
                ItemStack a_juice_drink = new ItemStack((Item)INSTANCE, 1, ingredient.id());
                OreDictionary.registerOre((String)"foodDrink", (ItemStack)a_juice_drink);
            }
        }
        return INSTANCE;
    }

    public static final void registerAllUnder(String forgeid) {
        if (INSTANCE != null) {
            for (Ingredient ingredient : VARIANT_FLAVORS) {
                if (!ingredient.isEnabled()) continue;
                ItemStack a_juice_drink = new ItemStack((Item)INSTANCE, 1, ingredient.id());
                OreDictionary.registerOre((String)forgeid, (ItemStack)a_juice_drink);
            }
        }
    }

    public static final synchronized void autorecipe() {
        if (TYPED_INSTANCES == null && Juices.get() != null) {
            ArrayList<ItemStack> instances = new ArrayList<ItemStack>(13);
            for (int i = 0; i < VARIANT_FLAVORS.size(); ++i) {
                Flavor ingredient = (Flavor)VARIANT_FLAVORS.get(i);
                instances.add(new ItemStack((Item)INSTANCE, 1, ingredient.id()));
                if (!ingredient.isEnabled()) continue;
                ItemStack juice_drink = new ItemStack((Item)INSTANCE, 1, ingredient.id());
                String mainitem = ingredient.isClassifier() ? ingredient.recipeitemName() : ingredient.recipeitem();
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(juice_drink, new Object[]{"xx", ingredient.recipeitem2() != null ? "yb" : "b ", Character.valueOf('x'), mainitem, Character.valueOf('y'), ingredient.recipeitem2() != null ? ingredient.recipeitem2() : VfpObj.Eek_obj, Character.valueOf('b'), "itemEmptyBottle"}));
            }
            TYPED_INSTANCES = instances.toArray(new ItemStack[0]);
        }
    }

    public static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    public static final class Flavor
    extends Ingredient
    implements FoodColor {
        private final int _colorValue;
        private final Object _secondaryIngredient;

        public Flavor(String name, int id, ItemStack primary, Object secondary, int colorValue) {
            super(name, id, primary, 2);
            this._secondaryIngredient = secondary;
            this._colorValue = colorValue >= 0 ? colorValue : 10796325;
        }

        public Flavor(String name, int id, Item primary, Object secondary, int colorValue) {
            this(name, id, new ItemStack(primary), secondary, colorValue);
        }

        public Flavor(String name, int id, String primary, Object secondary, int colorValue) {
            this(name, id, DictionaryNameItemAdaptor.newi(primary), secondary, colorValue);
        }

        @Override
        public int color(ItemStack stack) {
            return this._colorValue;
        }

        public Object recipeitem2() {
            return this._secondaryIngredient;
        }
    }
}

