/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.misc;

import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.jwaresoftware.mcmods.vfp.Integrations;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.agents.JuJuExtensions;
import org.jwaresoftware.mcmods.vfp.carton.BagsOf;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.OneXp;
import org.jwaresoftware.mcmods.vfp.common.PackagedFood;
import org.jwaresoftware.mcmods.vfp.common.VfpAware;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpCraftOnlyItem;
import org.jwaresoftware.mcmods.vfp.common.VfpFertilizerItem;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.core.ModDrops;
import org.jwaresoftware.mcmods.vfp.core.VfpAchievements;
import org.jwaresoftware.mcmods.vfp.core.VfpBuildHelperSupport;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.core.VfpRuntime;
import org.jwaresoftware.mcmods.vfp.integrations.IntegrationsImpl;
import org.jwaresoftware.mcmods.vfp.misc.DeckerSandwiches;
import org.jwaresoftware.mcmods.vfp.misc.EdibleCactus;
import org.jwaresoftware.mcmods.vfp.misc.FluidSourceInteractionHandler;
import org.jwaresoftware.mcmods.vfp.misc.Gelos;
import org.jwaresoftware.mcmods.vfp.misc.GenericDeckerSandwichRecipe;
import org.jwaresoftware.mcmods.vfp.misc.Juices;
import org.jwaresoftware.mcmods.vfp.misc.Migration;
import org.jwaresoftware.mcmods.vfp.misc.RoastedSeeds;
import org.jwaresoftware.mcmods.vfp.misc.Sandwiches;
import org.jwaresoftware.mcmods.vfp.misc.StewedItems;
import org.jwaresoftware.mcmods.vfp.misc.Tatoes;
import org.jwaresoftware.mcmods.vfp.misc.VfpCutterItem;
import org.jwaresoftware.mcmods.vfp.sugar.DrinkSyrups;
import org.jwaresoftware.mcmods.vfp.sugar.FizzyDrinks;
import org.jwaresoftware.mcmods.vfp.sugar.SimpleCookies;
import org.jwaresoftware.mcmods.vfp.sugar.Snowcones;
import org.jwaresoftware.mcmods.vfp.wheat.Breads;
import org.jwaresoftware.mcmods.vfp.wheat.DoughBallType;

public final class MiscBuildHelper
extends VfpBuildHelperSupport {
    private static final int FLINT_CUTTER_USES = 16;

    @Override
    protected String categoryName() {
        return "Miscellaneous";
    }

    @Override
    public void doBuildEventBusHandlers(FMLStateEvent event, VfpRuntime runtime) {
        ModDrops.HarvestDropsHandler eventHandler = ModDrops.HarvestDropsHandler.init(runtime.getConfig());
        if (eventHandler != null) {
            MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        }
        MinecraftForge.EVENT_BUS.register((Object)new FluidSourceInteractionHandler());
    }

    @Override
    public void doBuildPrimaryObjects(FMLStateEvent event, VfpRuntime runtime) {
        VfpConfig config = runtime.getConfig();
        boolean brewingEnabled = config.includePotionBrewing();
        VfpObj.Red_Flint_obj = VfpBuilder.newItem(VfpOid.Red_Flint);
        OreDictionary.registerOre((String)"itemRawFlint", (Item)MinecraftGlue.Items_flint);
        OreDictionary.registerOre((String)"itemRawFlint", (Item)VfpObj.Red_Flint_obj);
        VfpCutterItem cutter = new VfpCutterItem((VfpProfile)VfpOid.Flint_Cutter, 16).autoregister(VfpCutterItem.class);
        VfpObj.Flint_Cutter_obj = cutter;
        VfpCutterItem.registerAllUnder("itemFoodCutter", VfpObj.Flint_Cutter_obj);
        VfpObj.Sand_Jar_obj = new VfpCraftOnlyItem((VfpProfile)VfpOid.Sand_Jar, true).autoregister();
        VfpObj.Weighted_Plate_obj = VfpBuilder.newCraftOnlyItem(VfpOid.Weighted_Plate);
        VfpObj.Sandwich_Press_Plate_obj = VfpBuilder.newCraftOnlyItem(VfpOid.Sandwich_Press_Plate);
        VfpObj.Flesh_Meal_obj = new VfpFertilizerItem(VfpOid.Flesh_Meal).autoregister();
        VfpFertilizerItem.initDispenseBehavior(VfpObj.Flesh_Meal_obj);
        OreDictionary.registerOre((String)"itemFleshmeal", (Item)VfpObj.Flesh_Meal_obj);
        OreDictionary.registerOre((String)"bonemeal", (Item)VfpObj.Flesh_Meal_obj);
        VfpObj.Animal_Hide_Tie_obj = VfpBuilder.newItem(VfpOid.Animal_Hide_Tie);
        IntegrationsImpl.registerAsTie(MinecraftGlue.Items_string);
        IntegrationsImpl.registerAsTie(VfpObj.Animal_Hide_Tie_obj);
        VfpObj.Portion_Leather_obj = VfpBuilder.newItem(VfpOid.Portion_Leather);
        OreDictionary.registerOre((String)"portionHideSmall", (Item)MinecraftGlue.Items_rabbit_hide);
        OreDictionary.registerOre((String)"portionHideSmall", (Item)VfpObj.Portion_Leather_obj);
        VfpObj.Bone_Pencil_obj = VfpBuilder.newMisc(VfpOid.Bone_Pencil);
        VfpObj.Fire_Proofing_Powder_obj = VfpBuilder.newBrewingItem(VfpOid.Fire_Proofing_Powder, brewingEnabled ? MinecraftGlue.BrewEffect.magmaCreamEffect : null, false);
        VfpObj.Fermented_Feather_obj = VfpBuilder.newBrewingItem(VfpOid.Fermented_Feather, brewingEnabled ? MinecraftGlue.BrewEffect.fermentedSpiderEyeEffect : null, false);
        SimpleCookies.register(FoodPowders.toIngredient(FoodPowders.Type.COCOA, SimpleCookies.COCOA_COOKIE_ID, null));
        SimpleCookies.register(FoodPowders.toIngredient(FoodPowders.Type.CACTUS, SimpleCookies.KLINGON_COOKIE_ID, "klingon"));
        SimpleCookies.register(FoodPowders.toIngredient(FoodPowders.Type.APPLE, SimpleCookies.APPLE_COOKIE_ID, null));
        for (FoodPowders.Type powder : FoodPowders.Type.values()) {
            if (!powder.isDrinkFlavor() || powder == FoodPowders.Type.CREAM || powder == FoodPowders.Type.MILK) continue;
            Gelos.register(powder);
        }
        VfpObj.Roasted_Seeds_obj = RoastedSeeds.get(config);
        VfpObj.Raw_Veg_Medley_obj = VfpBuilder.newFood(VfpOid.Raw_Vegetables, LikeFood.raw_veg_medley);
        VfpObj.Roasted_Veg_Medley_obj = VfpBuilder.newFood(VfpOid.Roasted_Vegetables, LikeFood.roast_veg_medley);
        VfpObj.Portion_Roasted_Veg_obj = VfpBuilder.newFood(VfpOid.Portion_Roasted_Veg, LikeFood.roast_veg).func_77642_a(MinecraftGlue.Items_bowl);
        VfpObj.Chopped_Alliums_obj = VfpBuilder.newPortion(VfpOid.Chopped_Alliums);
        VfpObj.Caramelized_Alliums_obj = VfpBuilder.newFood(VfpOid.Caramelized_Alliums, LikeFood.crumb);
        VfpObj.Sauteed_Alliums_Mushrooms_obj = VfpBuilder.newFood(VfpOid.Sauteed_Alliums_Mushrooms, LikeFood.veg_portion);
        VfpObj.Edible_Cactus_obj = EdibleCactus.get(config);
        OreDictionary.registerOre((String)"ingredientSalad", (Item)VfpObj.Portion_Roasted_Veg_obj);
        OreDictionary.registerOre((String)"ingredientAllium", (Item)VfpObj.Chopped_Alliums_obj);
        OreDictionary.registerOre((String)"ingredientCondiment", (Item)VfpObj.Caramelized_Alliums_obj);
        OreDictionary.registerOre((String)"ingredientCondiment", (Item)VfpObj.Sauteed_Alliums_Mushrooms_obj);
        VfpObj.Fungi_Purged_obj = VfpBuilder.newFood(VfpOid.Fungi_Purged, LikeFood.uncooked_mushroom);
        OreDictionary.registerOre((String)"ingredientKebabFill", (Item)VfpObj.Fungi_Purged_obj);
        OreDictionary.registerOre((String)"ingredientMushroom", (Item)VfpObj.Fungi_Purged_obj);
        OreDictionary.registerOre((String)"foodMushroom", (Item)VfpObj.Fungi_Purged_obj);
        VfpObj.Sandwiches_obj = Sandwiches.get(config);
        VfpObj.Decker_Sandwiches_obj = DeckerSandwiches.get(config);
        VfpObj.Pumpkin_Portion_obj = VfpBuilder.newFood(VfpOid.Pumpkin_Portion, LikeFood.uncooked_potato);
        OreDictionary.registerOre((String)"ingredientKebabMain", (Item)VfpObj.Pumpkin_Portion_obj);
        VfpObj.Roasted_Pumpkin_Portion_obj = VfpBuilder.newFood(VfpOid.Roasted_Pumpkin_Portion, LikeFood.carrot);
        OreDictionary.registerOre((String)"ingredientKebabMain", (Item)VfpObj.Roasted_Pumpkin_Portion_obj);
        VfpObj.Stewed_Items_obj = StewedItems.get();
        VfpObj.Tatoes_obj = Tatoes.get();
        this.setupJuices(config);
        this.setupSnocones(config);
        VfpObj.Roast_Corn_obj = VfpBuilder.newOptionalFood(VfpOid.Roast_Corn, LikeFood.potato, VfpAware.IdDomain.MODID, Integrations.CFP.modid());
        VfpObj.Roasted_Eggplant_obj = VfpBuilder.newOptionalFood(VfpOid.Roasted_Eggplant, LikeFood.potato, VfpAware.IdDomain.MODID, Integrations.CFP.modid());
        if (config.isModLoaded(Integrations.CFP) || config.isModLoaded(Integrations.ReW)) {
            OreDictionary.registerOre((String)"foodGrilledeggplant", (Item)VfpObj.Roasted_Eggplant_obj);
        }
    }

    @Override
    public void doInitLikeFoods(VfpRuntime runtime) {
        VfpObj.SimpleCookies_obj = SimpleCookies.get();
        VfpObj.FizzyDrinks_obj = FizzyDrinks.get();
        VfpObj.Gelos_obj = Gelos.get();
        VfpObj.Juices_obj = Juices.get();
        VfpObj.Snocones_obj = Snowcones.get();
        LikeFood.buttered_potato.food().item(MinecraftGlue.Items_baked_potato);
        LikeFood.mashed_potato.food().item(Tatoes.pinkmash());
        LikeFood.stuffed_potato.food().item(Tatoes.wellstuffed());
        LikeFood.overstuffed_potato.food().item(Tatoes.fishstuffed());
        LikeFood.raw_veg_medley.food().item(VfpObj.Raw_Veg_Medley_obj);
        LikeFood.roast_veg_medley.food().item(VfpObj.Roasted_Veg_Medley_obj);
        LikeFood.roast_veg.food().item(VfpObj.Portion_Roasted_Veg_obj);
    }

    @Override
    public void doDefineLoot(VfpRuntime runtime) {
        MinecraftGlue.Loot.addFishedUpJunk("vanillafoodpantry", VfpOid.Bit_Pipette.fmlid(), VfpObj.Bit_Pipette_obj);
        MinecraftGlue.Loot.addFishedUpJunk("vanillafoodpantry", VfpOid.Flint_Cutter.fmlid(), VfpCutterItem.junk());
        MinecraftGlue.Loot.addFishedUpJunk("vanillafoodpantry", VfpOid.Empty_Jar.fmlid(), VfpObj.Empty_Jar_obj);
        MinecraftGlue.Loot.addFishedUpJunk("vanillafoodpantry", VfpOid.Dark_Empty_Jar.fmlid(), VfpObj.Dark_Empty_Jar_obj);
        MinecraftGlue.Loot.addFishedUpJunk("vanillafoodpantry", VfpOid.Animal_Hide_Tie.fmlid(), VfpObj.Animal_Hide_Tie_obj);
        MinecraftGlue.Loot.addFishedUpUncommon("vanillafoodpantry", VfpOid.Jungle_Juice_Jar.fmlid(), JuJuExtensions.jujujuice());
        MinecraftGlue.Loot.addFishedUpUncommon("vanillafoodpantry", VfpOid.Ink_Pearl_Shard.fmlid(), VfpObj.Ink_Pearl_Shard_obj);
    }

    private void autorecipeRottenThings() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MinecraftGlue.Items_rotten_flesh, 3), new Object[]{"mmm", " j ", Character.valueOf('m'), "foodRedMeat", Character.valueOf('j'), "additivePoisoner"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MinecraftGlue.Items_rotten_flesh, 3), new Object[]{"mmm", "j  ", Character.valueOf('m'), "foodRedMeat", Character.valueOf('j'), "additivePoisoner"}));
        GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Flesh_Meal_obj, VfpCapacity.MAX_STACK_LCD.count()), new Object[]{"rrr", "cfw", Character.valueOf('r'), "rottenflesh", Character.valueOf('c'), VfpObj.Charcoal_obj, Character.valueOf('f'), FoodPowders.get(FoodPowders.Type.FEATHER, 1), Character.valueOf('w'), "portionWaterSmall"}), VfpOid.Flesh_Meal.craftingXp()));
        ItemStack bonemeal = VfpObj.Bonemeal_obj.func_77946_l();
        MinecraftGlue.ItemStacks_setSize(bonemeal, 7);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(bonemeal, new Object[]{"xbx", "xbx", "xbx", Character.valueOf('x'), VfpObj.Flesh_Meal_obj, Character.valueOf('b'), VfpObj.Small_Bone_obj}));
        if (VfpUtils.ingredientDefined("dustBleach")) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(bonemeal, new Object[]{"xxx", "xbx", "xxx", Character.valueOf('x'), VfpObj.Flesh_Meal_obj, Character.valueOf('b'), "dustBleach"}));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Fermented_Feather_obj, 3), new Object[]{"fff", "fff", "jB ", Character.valueOf('f'), "feather", Character.valueOf('j'), "additivePoisoner", Character.valueOf('B'), VfpObj.Fermenting_Bucket_obj}));
        if (VfpUtils.ingredientDefined("packFeathers")) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Fermented_Feather_obj, 13), new Object[]{"fff", "jB ", Character.valueOf('f'), "packFeathers", Character.valueOf('j'), "additivePoisoner", Character.valueOf('B'), VfpObj.Fermenting_Bucket_obj}));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MinecraftGlue.Items_poisonous_potato, 6), new Object[]{"ppp", "ppp", "j  ", Character.valueOf('p'), MinecraftGlue.Items_potato, Character.valueOf('j'), "additivePoisoner"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MinecraftGlue.Items_poisonous_potato, 6), new Object[]{"ppp", "ppp", " j ", Character.valueOf('p'), MinecraftGlue.Items_potato, Character.valueOf('j'), "additivePoisoner"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MinecraftGlue.Items_poisonous_potato, 2), new Object[]{"pp", "x ", Character.valueOf('p'), MinecraftGlue.Items_potato, Character.valueOf('x'), VfpObj.Fermented_Feather_obj}));
    }

    private void autorecipeVanillaStorageBlockIntegration(VfpConfig config) {
        if (config.useMushroomBlocksForPantry()) {
            VfpBuilder.autorecipe(this.categoryName(), VfpCapacity.STANDARD_BLOCK, (Object)MinecraftGlue.Blocks_brown_mushroom, MinecraftGlue.Blocks_brown_mushroom_block, MinecraftGlue.Blocks_brown_mushroom);
            VfpBuilder.autorecipe(this.categoryName(), VfpCapacity.STANDARD_BLOCK, (Object)MinecraftGlue.Blocks_red_mushroom, MinecraftGlue.Blocks_red_mushroom_block, MinecraftGlue.Blocks_red_mushroom);
        } else {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(MinecraftGlue.Blocks_brown_mushroom, VfpCapacity.STANDARD_BLOCK.count()), new Object[]{MinecraftGlue.Blocks_brown_mushroom_block, "itemFoodCutter"}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(MinecraftGlue.Blocks_red_mushroom, VfpCapacity.STANDARD_BLOCK.count()), new Object[]{MinecraftGlue.Blocks_red_mushroom_block, "itemFoodCutter"}));
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(MinecraftGlue.Items_melon, VfpCapacity.STANDARD_BLOCK.count()), new Object[]{MinecraftGlue.Blocks_melon_block, "itemFoodCutter"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Pumpkin_Portion_obj, VfpCapacity.STANDARD_BLOCK.count()), new Object[]{MinecraftGlue.Blocks_pumpkin, "itemFoodCutter"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(MinecraftGlue.Blocks_pumpkin, new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), VfpObj.Pumpkin_Portion_obj}));
        if (config.allowGeneralFlintCutter()) {
            ItemStack any_wool_block = new ItemStack(MinecraftGlue.Blocks_wool, 1, Short.MAX_VALUE);
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(MinecraftGlue.Items_string, 4), new Object[]{any_wool_block, "itemFoodCutter"}));
        }
    }

    private void autorecipeCutterAnimalHideIntegration(VfpConfig config) {
        if (config.includeCraftableGravel()) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MinecraftGlue.Blocks_gravel, 3), new Object[]{"xx", "xc", Character.valueOf('x'), "sand", Character.valueOf('c'), "cobblestone"}));
        }
        ItemStack flint_cutter_unused = new ItemStack(VfpObj.Flint_Cutter_obj, 1, 16);
        GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(flint_cutter_unused, new Object[]{"x ", " x", Character.valueOf('x'), "itemRawFlint"}), VfpOid.Flint_Cutter.craftingXp()));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Animal_Hide_Tie_obj, 6), new Object[]{"leather", VfpObj.Red_Flint_obj}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Animal_Hide_Tie_obj, 1), new Object[]{MinecraftGlue.Items_rabbit_hide, VfpObj.Red_Flint_obj}));
        if (config.allowGeneralFlintCutter()) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Portion_Leather_obj, 4), new Object[]{"leather", "itemFoodCutter"}));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MinecraftGlue.Items_fishing_rod), new Object[]{"  #", " #X", "# X", Character.valueOf('#'), MinecraftGlue.Items_stick, Character.valueOf('X'), VfpObj.Animal_Hide_Tie_obj}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MinecraftGlue.Items_bow), new Object[]{" #X", "# X", " #X", Character.valueOf('X'), VfpObj.Animal_Hide_Tie_obj, Character.valueOf('#'), MinecraftGlue.Items_stick}));
        Object stickiness = MinecraftGlue.Items_slime_ball;
        if (VfpUtils.ingredientDefined("portionAdhesive")) {
            stickiness = "portionAdhesive";
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MinecraftGlue.Items_lead, 2), new Object[]{"~~ ", "~O ", "  ~", Character.valueOf('~'), VfpObj.Animal_Hide_Tie_obj, Character.valueOf('O'), stickiness}));
    }

    private void autorecipeVegetablesMisc(VfpConfig config) {
        EdibleCactus.autorecipe(config);
        ItemStack allium = new ItemStack(MinecraftGlue.Blocks_red_flower, 1, BlockFlower.EnumFlowerType.ALLIUM.func_176968_b());
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Chopped_Alliums_obj), new Object[]{"AAA", "AAA", "X  ", Character.valueOf('A'), allium, Character.valueOf('X'), "itemFoodCutter"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Caramelized_Alliums_obj, 4), new Object[]{"AAX", "sS ", "obh", Character.valueOf('A'), "ingredientAllium", Character.valueOf('s'), "portionSaltSmall", Character.valueOf('S'), "portionSugarSmall", Character.valueOf('o'), "portionOil", Character.valueOf('b'), "ingredientButter", Character.valueOf('X'), "itemFoodCutter", Character.valueOf('h'), "portionHeatSmall"}));
        String bellpepper = config.getPresentAs("bellpepper");
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Sauteed_Alliums_Mushrooms_obj, 2), new Object[]{bellpepper == null ? "A  " : "Ap ", "MMX", "obh", Character.valueOf('A'), "ingredientAllium", Character.valueOf('M'), "foodMushroom", Character.valueOf('o'), "portionOil", Character.valueOf('b'), "ingredientButter", Character.valueOf('p'), bellpepper != null ? bellpepper : MinecraftGlue.Items_air, Character.valueOf('X'), "itemFoodCutter", Character.valueOf('h'), "portionHeatSmall"}));
        GameRegistry.addSmelting((Item)VfpObj.Pumpkin_Portion_obj, (ItemStack)new ItemStack(VfpObj.Roasted_Pumpkin_Portion_obj), (float)LikeFood.uncooked_carrot.smeltExperience());
        if (!config.isPresent("roast_seeds")) {
            GameRegistry.addSmelting((Block)MinecraftGlue.Blocks_pumpkin, (ItemStack)new ItemStack(VfpObj.Roasted_Pumpkin_Portion_obj, VfpCapacity.STANDARD_BLOCK.count()), (float)(LikeFood.uncooked_carrot.smeltExperience() * (float)VfpCapacity.STANDARD_BLOCK.count()));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(VfpBuilder.newItemInstance(VfpObj.Raw_Veg_Medley_obj), new Object[]{"pcP", "xxx", "Xos", Character.valueOf('p'), MinecraftGlue.Items_potato, Character.valueOf('c'), "foodCarrot", Character.valueOf('P'), VfpObj.Pumpkin_Portion_obj, Character.valueOf('x'), "ingredientKebabFill", Character.valueOf('X'), "itemFoodCutter", Character.valueOf('o'), "portionOil", Character.valueOf('s'), "portionSaltSmall"}));
        ItemStack roast_veg_medley = VfpBuilder.newItemInstance(VfpObj.Roasted_Veg_Medley_obj);
        GameRegistry.addSmelting((Item)VfpObj.Raw_Veg_Medley_obj, (ItemStack)roast_veg_medley, (float)LikeFood.raw_veg_medley.smeltExperience());
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Portion_Roasted_Veg_obj, 3), new Object[]{" v ", "bbb", Character.valueOf('v'), roast_veg_medley, Character.valueOf('b'), MinecraftGlue.Items_bowl}));
    }

    private void autorecipeMultisourceVFPMisc(VfpConfig config) {
        GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(FoodPowders.get(FoodPowders.Type.VINEGAR, VfpCapacity.ADDITIVE_BATCH.count()), new Object[]{"aaa", "aaa", "Fbd", Character.valueOf('a'), "foodApple", Character.valueOf('F'), VfpObj.Fermenting_Bucket_obj, Character.valueOf('b'), "itemCheeseCloth", Character.valueOf('d'), "additiveDrying"}), OneXp.Per03.value()));
        GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(FoodPowders.get(FoodPowders.Type.POTATO_STARCH, VfpCapacity.ADDITIVE_BATCH.count()), new Object[]{"ppc", "bsw", "d  ", Character.valueOf('p'), MinecraftGlue.Items_potato, Character.valueOf('c'), "itemFoodCutter", Character.valueOf('b'), "itemCheeseCloth", Character.valueOf('s'), MinecraftGlue.Blocks_snow, Character.valueOf('w'), "portionWaterLarge", Character.valueOf('d'), "additiveDrying"}), OneXp.Per03.value()));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Acornmeal_Portion_obj, 2), new Object[]{"aaa", "aaa", "Wbd", Character.valueOf('a'), VfpObj.Oak_Acorn_obj, Character.valueOf('W'), "portionWaterLarge", Character.valueOf('b'), "itemCheeseCloth", Character.valueOf('d'), "additiveDrying"}));
        ItemStack cheese_powder = FoodPowders.get(FoodPowders.Type.CHEESE, 1);
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(DoughBallType.cheese(2), new Object[]{"foodDough", cheese_powder, cheese_powder}));
        GameRegistry.addSmelting((ItemStack)DoughBallType.cheese(1), (ItemStack)DoughBallType.cookedCheese(1), (float)LikeFood.mini_bread.smeltExperience());
        ItemStack bagof_eggs = BagsOf.sample(PackagedFood.EGG);
        if (!MinecraftGlue.ItemStacks_isEmpty(bagof_eggs)) {
            GameRegistry.addSmelting((ItemStack)bagof_eggs, (ItemStack)new ItemStack(VfpObj.Fried_Egg_obj, VfpCapacity.TRAY.count()), (float)(LikeFood.uncooked_egg.smeltExperience() * (float)VfpCapacity.TRAY.count()));
        }
        PackagedFood[] meats = new PackagedFood[]{PackagedFood.CHICKEN, PackagedFood.COOKED_CHICKEN, PackagedFood.BEEF, PackagedFood.COOKED_BEEF, PackagedFood.PORK, PackagedFood.COOKED_PORK, PackagedFood.MUTTON, PackagedFood.COOKED_MUTTON, PackagedFood.RABBIT, PackagedFood.COOKED_RABBIT, PackagedFood.SQUID, PackagedFood.COOKED_SQUID, PackagedFood.LLAMA, PackagedFood.COOKED_LLAMA};
        int n = meats.length;
        for (int i = 0; i < n; i += 2) {
            ItemStack bagof_meat = BagsOf.sample(meats[i]);
            if (MinecraftGlue.ItemStacks_isEmpty(bagof_meat)) continue;
            GameRegistry.addSmelting((ItemStack)bagof_meat, (ItemStack)meats[i + 1].food().sample(VfpCapacity.TRAY.count()), (float)(meats[i].food().smeltExperience() * (float)VfpCapacity.TRAY.count()));
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Fungi_Purged_obj), new Object[]{"foodMushroom", "portionWaterSmall"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(MinecraftGlue.Items_mushroom_stew), new Object[]{VfpObj.Fungi_Purged_obj, VfpObj.Fungi_Purged_obj, MinecraftGlue.Items_bowl}));
    }

    private void autorecipeOtherSourcesOfHeat(VfpConfig config) {
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Heat_Portion_obj, 8), new Object[]{new ItemStack(MinecraftGlue.Items_coal, 1, Short.MAX_VALUE), "itemFoodCutter"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Heat_Portion_obj, 12), new Object[]{MinecraftGlue.Items_blaze_rod, "itemFoodCutter"}));
        if (config.allowGeneralFlintCutter()) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Heat_Portion_obj, 2), new Object[]{"logWood", "itemFoodCutter"}));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MinecraftGlue.Items_blaze_rod), new Object[]{"H ", " H", Character.valueOf('H'), VfpObj.Lava_Sand_Portion_obj}));
        if (config.allowGeneralFlintCutter()) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Heat_Portion_obj, 24), new Object[]{MinecraftGlue.Blocks_magma, "itemFoodCutter"}));
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(MinecraftGlue.Items_flint_steel), new Object[]{"ingotIron", VfpObj.Red_Flint_obj}));
    }

    private void autorecipeOtherSourcesOfWater(VfpConfig config) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Weighted_Plate_obj), new Object[]{"sg", "gp", Character.valueOf('s'), new ItemStack(MinecraftGlue.Blocks_stone), Character.valueOf('g'), "paneGlassColorless", Character.valueOf('p'), MinecraftGlue.Blocks_stone_pressure_plate}));
        if (config.craftOtherSourcesOfWater()) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Water_Bucket_obj), new Object[]{"SS", "SS", "B ", Character.valueOf('S'), MinecraftGlue.Blocks_snow, Character.valueOf('B'), VfpObj.Empty_Bucket_obj}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Water_Bucket_obj), new Object[]{"I ", "B ", Character.valueOf('I'), MinecraftGlue.Blocks_ice, Character.valueOf('B'), VfpObj.Empty_Bucket_obj}));
            if (config.allowGeneralFlintCutter()) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MinecraftGlue.Blocks_ice, 4), new Object[]{"I ", "hx", Character.valueOf('I'), MinecraftGlue.Blocks_packed_ice, Character.valueOf('h'), "portionHeatSmall", Character.valueOf('x'), "itemFoodCutter"}));
            }
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MinecraftGlue.Blocks_ice), new Object[]{"pw", "SS", "SS", Character.valueOf('S'), MinecraftGlue.Blocks_snow, Character.valueOf('w'), "portionWaterSmall", Character.valueOf('p'), VfpObj.Weighted_Plate_obj}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MinecraftGlue.Blocks_packed_ice), new Object[]{"pw", "II", "II", Character.valueOf('I'), MinecraftGlue.Blocks_ice, Character.valueOf('w'), "portionWaterSmall", Character.valueOf('p'), VfpObj.Weighted_Plate_obj}));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(VfpObj.Water_Bottle_obj, new Object[]{"www", "wbw", "www", Character.valueOf('w'), "portionWaterSmall", Character.valueOf('b'), VfpObj.Empty_Bottle_obj}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Water_Portion_obj, VfpCapacity.BUCKET.count()), new Object[]{MinecraftGlue.Blocks_ice, VfpObj.Heat_Portion_obj}));
    }

    private void autorecipeNoTroubleBrewingMisc(VfpConfig config) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Fire_Proofing_Powder_obj, 1), new Object[]{"In", "nn", Character.valueOf('I'), MinecraftGlue.Blocks_ice, Character.valueOf('n'), MinecraftGlue.Blocks_netherrack}));
    }

    private void autorecipeUncraftables(VfpConfig config) {
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Bone_Pencil_obj, 2), new Object[]{MinecraftGlue.Items_bone, "portionHeatSmall", VfpObj.Charcoal_obj}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(MinecraftGlue.Items_name_tag), new Object[]{"portionHideSmall", "itemTieNormal", VfpObj.Bone_Pencil_obj}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(MinecraftGlue.Items_writable_book), new Object[]{VfpObj.Bone_Pencil_obj, VfpObj.Bone_Pencil_obj, MinecraftGlue.Items_book}));
    }

    @Override
    public void doBuildRecipes(VfpRuntime runtime) {
        VfpConfig config = runtime.getConfig();
        GenericDeckerSandwichRecipe.lateinit(config);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Sand_Jar_obj, 2), new Object[]{"x ", "jj", Character.valueOf('x'), MinecraftGlue.Blocks_sand, Character.valueOf('j'), "itemEmptyJar"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Sandwich_Press_Plate_obj), new Object[]{"sg ", "gpg", " gs", Character.valueOf('s'), new ItemStack(MinecraftGlue.Blocks_stone), Character.valueOf('g'), "paneGlassColorless", Character.valueOf('p'), MinecraftGlue.Blocks_stone_pressure_plate}));
        SimpleCookies.autorecipe();
        FizzyDrinks.autorecipe();
        Gelos.autorecipe();
        RoastedSeeds.autorecipe(config);
        Juices.autorecipe();
        Snowcones.autorecipe();
        Sandwiches.autorecipe(config);
        DeckerSandwiches.autorecipe(config);
        StewedItems.autorecipe(config);
        Tatoes.autorecipe(config);
        this.autorecipeCutterAnimalHideIntegration(config);
        this.autorecipeOtherSourcesOfHeat(config);
        this.autorecipeVegetablesMisc(config);
        this.autorecipeMultisourceVFPMisc(config);
        this.autorecipeRottenThings();
        this.autorecipeVanillaStorageBlockIntegration(config);
        IntegrationsImpl.autorecipeMisc(config);
        this.autorecipeOtherSourcesOfWater(config);
        this.autorecipeNoTroubleBrewingMisc(config);
        this.autorecipeUncraftables(config);
        if (config.craftPantryMigrationRecipes()) {
            new Migration().doBuildRecipes(runtime);
        }
    }

    @Override
    public void doBuildAchievementList(FMLStateEvent event, VfpRuntime runtime) {
        VfpRewards.addRewardingCraftItem(VfpObj.Pumpkin_Portion_obj, VfpAchievements.Id.PortionInTime);
        for (ItemStack stew : StewedItems.achievementCandidates()) {
            VfpRewards.addRewardingCraftItem(stew, VfpAchievements.Id.NowYoureCooking);
        }
        VfpRewards.addRewardingCraftItem(Breads.uncooked_muscle(1), VfpAchievements.Id.PowahFirstAid);
        for (ItemStack stew : Tatoes.achievementCandidates()) {
            VfpRewards.addRewardingCraftItem(stew, VfpAchievements.Id.WellStuffed);
        }
        VfpRewards.addRewardingCraftItem(DeckerSandwiches.empty(), VfpAchievements.Id.AllHandsOnDeck);
    }

    @Override
    public void doInitRenderModels(FMLStateEvent event, VfpRuntime runtime) {
        if (!runtime.hasUI()) {
            return;
        }
        VfpCutterItem cutter = (VfpCutterItem)VfpObj.Flint_Cutter_obj;
        runtime.doRenderSetupOrFail(VfpOid.Flint_Cutter, VfpObj.Flint_Cutter_obj, cutter.getUsesRenderNames(), cutter.getUsesRenderMetas());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Red_Flint, VfpObj.Red_Flint_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Animal_Hide_Tie, VfpObj.Animal_Hide_Tie_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Portion_Leather, VfpObj.Portion_Leather_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Bone_Pencil, VfpObj.Bone_Pencil_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Sand_Jar, VfpObj.Sand_Jar_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Weighted_Plate, VfpObj.Weighted_Plate_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Sandwich_Press_Plate, VfpObj.Sandwich_Press_Plate_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Flesh_Meal, VfpObj.Flesh_Meal_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Fire_Proofing_Powder, VfpObj.Fire_Proofing_Powder_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Fermented_Feather, VfpObj.Fermented_Feather_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Fungi_Purged, VfpObj.Fungi_Purged_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Roasted_Seeds, VfpObj.Roasted_Seeds_obj, RoastedSeeds.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Pumpkin_Portion, VfpObj.Pumpkin_Portion_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Roasted_Pumpkin_Portion, VfpObj.Roasted_Pumpkin_Portion_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Roast_Corn, VfpObj.Roast_Corn_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Roasted_Eggplant, VfpObj.Roasted_Eggplant_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Chopped_Alliums, VfpObj.Chopped_Alliums_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Raw_Vegetables, VfpObj.Raw_Veg_Medley_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Roasted_Vegetables, VfpObj.Roasted_Veg_Medley_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Portion_Roasted_Veg, VfpObj.Portion_Roasted_Veg_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Caramelized_Alliums, VfpObj.Caramelized_Alliums_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Sauteed_Alliums_Mushrooms, VfpObj.Sauteed_Alliums_Mushrooms_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Juice, VfpObj.Juices_obj, Juices.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Cookie, VfpObj.SimpleCookies_obj, SimpleCookies.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.FizzyDrink, VfpObj.FizzyDrinks_obj, FizzyDrinks.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Gelo, VfpObj.Gelos_obj, Gelos.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Snowcone, VfpObj.Snocones_obj, Snowcones.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Sandwich, VfpObj.Sandwiches_obj, Sandwiches.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Decker, VfpObj.Decker_Sandwiches_obj, DeckerSandwiches.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Stewed, VfpObj.Stewed_Items_obj, StewedItems.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Tatoes, VfpObj.Tatoes_obj, Tatoes.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Edible_Cactus, VfpObj.Edible_Cactus_obj, EdibleCactus.variants());
    }

    private void setupJuices(VfpConfig config) {
        int MOD_OFFSET = 10;
        int id0 = FoodPowders.Usage.DRINK_FLAVOR.idFirst();
        Juices.register(new Juices.Flavor("apple", id0 + 0, "foodApple", null, 10974244));
        Juices.register(new Juices.Flavor("carrot", id0 + 1, MinecraftGlue.Items_carrot, null, MinecraftGlue.MapColor_ADOBE.field_76291_p));
        Juices.register(new Juices.Flavor("cane", id0 + 2, MinecraftGlue.Items_reeds, (Object)MinecraftGlue.Items_melon, 15189861));
        Juices.register(new Juices.Flavor("cactus", id0 + 3, new ItemStack(MinecraftGlue.Blocks_cactus), null, 10009467));
        if (config.includeModRecipes()) {
            int id = id0 + 10;
            String item1 = null;
            String item2 = null;
            item1 = config.getPresentAs("tomato");
            item2 = config.getPresentAs("leek");
            if (item1 != null && item2 != null) {
                Juices.register(new Juices.Flavor("tomato", id, item1, (Object)item2, 12791562));
            }
            ++id;
            item1 = config.getPresentAs("grapes");
            if (item1 != null) {
                Juices.register(new Juices.Flavor("grape", id, item1, (Object)"foodApple", 8595540));
            }
            ++id;
            item1 = config.getPresentAs("kiwi");
            if (item1 != null) {
                Juices.register(new Juices.Flavor("kiwi", id, item1, (Object)MinecraftGlue.Items_melon, 12308059));
            }
            ++id;
            item1 = config.getPresentAs("broccoli");
            item2 = config.getPresentAs("cucumber");
            if (item1 != null && item2 != null) {
                Juices.register(new Juices.Flavor("veggies", id, item1, (Object)item2, -1));
            }
            ++id;
            item1 = config.getPresentAs("mango");
            if (item1 != null) {
                Juices.register(new Juices.Flavor("mango", id, item1, (Object)MinecraftGlue.Items_melon, 16759296));
            }
            ++id;
        }
    }

    private void setupSnocones(VfpConfig config) {
        boolean customAllowed = config.includeModRecipes();
        for (DrinkSyrups.Flavor flavor : DrinkSyrups.Flavor.values()) {
            if (!flavor.isAlwaysPresent() && (!customAllowed || !DrinkSyrups.isAvailable(flavor))) continue;
            Snowcones.register(flavor);
        }
    }
}

