/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.misc;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.Named;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.meats.PigMeats;
import org.jwaresoftware.mcmods.vfp.wheat.Breads;
import org.jwaresoftware.mcmods.vfp.wheat.Fries;

public final class StewedItems
extends VfpLiquidMultiItem {
    private static final int RECIPE_BATCH = 3;
    private static boolean _GOT_ROASTED_EGGPLANT = false;
    private static boolean _GOT_EARTHINESS = false;
    private static final VfpVariantSet VARIANT_SET = new VfpVariantSet.ByMapInstanceVType(VfpOid.Stewed, StewedItems.class, "dish");
    private static StewedItems INSTANCE;
    private static ItemStack[] TYPED_INSTANCES;

    public StewedItems(VfpOid oid, CreativeTabs tab) {
        super((VfpProfile)oid, VARIANT_SET, tab);
        this.func_77642_a(null);
    }

    @Override
    protected ItemStack getNewEmptyContainer() {
        return new ItemStack(MinecraftGlue.Items_bowl);
    }

    @Override
    protected VfpCapacity getItemMaxStackSize() {
        return VfpConfig.getInstance().maxSoupsStackCapacity(super.getItemMaxStackSize());
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        VfpVariant variant = VfpVariant.byItemStack(stack, this._variant_default);
        return variant != null ? MinecraftGlue.I18N_ITEM_KEY_PREFIX() + variant.fmlid() : UNKNOWN_NAME;
    }

    @Override
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.EAT;
    }

    @Override
    protected boolean showSubItem(VfpVariant variant, CreativeTabs forTab, CreativeTabs pickedTab) {
        boolean show = true;
        DishDef dish = variant.datadata(DishDef.class);
        if (dish == DishDef.eggplant) {
            show = _GOT_ROASTED_EGGPLANT;
        } else if (dish == DishDef.earthy) {
            show = _GOT_EARTHINESS;
        }
        return show;
    }

    private static final ItemStack newStewDish(int amount, int meta) {
        VfpVariant variant = VfpVariant.byMetadata(meta, StewedItems.INSTANCE._variant_default);
        DishDef dish = variant.datadata(DishDef.class);
        ItemStack stew = dish.isMulti() ? StewedItems.createMultiuseInstance((Item)INSTANCE, amount, meta, variant.food().healAmount(), LikeFood.mushroom_stew.healAmount()) : new ItemStack((Item)INSTANCE, amount, meta);
        return stew;
    }

    @Override
    public ItemStack createInstance(Item item, int amount, int meta) {
        return item == INSTANCE ? StewedItems.newStewDish(amount, meta) : MinecraftGlue.ItemStacks_NULLSTACK();
    }

    static final synchronized StewedItems get() {
        if (INSTANCE == null) {
            ArrayList<VfpVariant> variants = new ArrayList<VfpVariant>(31);
            for (DishDef dishDef : DishDef.values()) {
                dishDef.install(variants, VARIANT_SET);
            }
            INSTANCE = VfpBuilder.newMultiItem(VfpOid.Stewed, StewedItems.class, VfpBuilder.User.INTERNAL);
        }
        return INSTANCE;
    }

    private static void addCombo(DishDef dishDef, ItemStack stewed_item, List<ItemStack> instances) {
        if (dishDef.addCombo()) {
            String completer = "portionBread";
            switch (dishDef.mealCompleter()) {
                case FLATBREAD: {
                    completer = Breads.flat(1);
                    break;
                }
                case FRIES: {
                    completer = Fries.plain(1);
                }
            }
            ItemStack meal_item = StewedItems.newStewDish(1, dishDef.meal_meta());
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(meal_item, new Object[]{stewed_item, completer}));
            instances.add(meal_item);
        }
    }

    static final synchronized void autorecipe(VfpConfig config) {
        if (TYPED_INSTANCES == null) {
            StewedItems.get();
            ArrayList<ItemStack> instances = new ArrayList<ItemStack>(16);
            FoodPowders.Type herbmix = FoodPowders.findType("stew_mix");
            ItemStack herbmix_powder = herbmix != null ? FoodPowders.get(herbmix, 1) : null;
            ItemStack stewed_item = StewedItems.newStewDish(3, DishDef.pumpkin.meta());
            if (herbmix_powder != null) {
                GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(stewed_item, new Object[]{"xxf", "vhW", "bbb", Character.valueOf('x'), VfpObj.Roasted_Pumpkin_Portion_obj, Character.valueOf('f'), PigMeats.salted_pigtail(1), Character.valueOf('v'), config.getPresentAs("onion"), Character.valueOf('h'), herbmix_powder, Character.valueOf('W'), "portionBroth", Character.valueOf('b'), MinecraftGlue.Items_bowl}), VfpOid.Stewed.craftingXp()));
            } else {
                GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(stewed_item, new Object[]{"xxf", "vhW", "bbb", Character.valueOf('x'), VfpObj.Roasted_Pumpkin_Portion_obj, Character.valueOf('f'), PigMeats.salted_pigtail(1), Character.valueOf('v'), MinecraftGlue.Items_carrot, Character.valueOf('h'), "foodPotato", Character.valueOf('W'), "portionBroth", Character.valueOf('b'), MinecraftGlue.Items_bowl}), VfpOid.Stewed.craftingXp()));
            }
            MinecraftGlue.ItemStacks_setSize(stewed_item, 1);
            instances.add(stewed_item);
            StewedItems.addCombo(DishDef.pumpkin, stewed_item, instances);
            stewed_item = StewedItems.newStewDish(3, DishDef.eggplant.meta());
            _GOT_ROASTED_EGGPLANT = VfpUtils.ingredientDefined("foodGrilledeggplant");
            if (_GOT_ROASTED_EGGPLANT) {
                if (herbmix_powder != null) {
                    String secondary = "foodPotato";
                    if (config.isPresent("tomato")) {
                        secondary = config.getPresentAs("tomato");
                    }
                    GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(stewed_item, new Object[]{"xxf", "vhW", "bbb", Character.valueOf('x'), "foodGrilledeggplant", Character.valueOf('f'), VfpObj.Salt_Fish_obj, Character.valueOf('v'), secondary, Character.valueOf('h'), herbmix_powder, Character.valueOf('W'), "portionBroth", Character.valueOf('b'), MinecraftGlue.Items_bowl}), VfpOid.Stewed.craftingXp()));
                } else {
                    GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(stewed_item, new Object[]{"xxf", "vvW", "bbb", Character.valueOf('x'), "foodGrilledeggplant", Character.valueOf('f'), VfpObj.Salt_Fish_obj, Character.valueOf('v'), "foodPotato", Character.valueOf('W'), "portionBroth", Character.valueOf('b'), MinecraftGlue.Items_bowl}), VfpOid.Stewed.craftingXp()));
                }
            }
            MinecraftGlue.ItemStacks_setSize(stewed_item, 1);
            instances.add(stewed_item);
            if (_GOT_ROASTED_EGGPLANT) {
                StewedItems.addCombo(DishDef.eggplant, stewed_item, instances);
            }
            stewed_item = StewedItems.newStewDish(3, DishDef.veggie.meta());
            if (herbmix_powder != null) {
                GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(stewed_item, new Object[]{"vvv", "fhW", "bbb", Character.valueOf('v'), "ingredientKebabMain", Character.valueOf('f'), "ingredientKebabFill", Character.valueOf('h'), herbmix_powder, Character.valueOf('W'), "portionBroth", Character.valueOf('b'), MinecraftGlue.Items_bowl}), VfpOid.Stewed.craftingXp()));
            } else {
                GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(stewed_item, new Object[]{"vvv", "fhW", "bbb", Character.valueOf('v'), "ingredientKebabMain", Character.valueOf('f'), "ingredientKebabFill", Character.valueOf('h'), "portionSalt", Character.valueOf('W'), "portionWaterLarge", Character.valueOf('b'), MinecraftGlue.Items_bowl}), VfpOid.Stewed.craftingXp()));
            }
            MinecraftGlue.ItemStacks_setSize(stewed_item, 1);
            instances.add(stewed_item);
            StewedItems.addCombo(DishDef.veggie, stewed_item, instances);
            stewed_item = StewedItems.newStewDish(3, DishDef.polarbear.meta());
            Object mushrooms = VfpObj.Sauteed_Alliums_Mushrooms_obj;
            if (MinecraftGlue.ingredientDefinedLooking("packMushrooms")) {
                mushrooms = "packMushrooms";
            }
            GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(stewed_item, new Object[]{"xxm", "ppW", "bbb", Character.valueOf('x'), VfpObj.Bear_Cooked_obj, Character.valueOf('m'), mushrooms, Character.valueOf('p'), "foodPotato", Character.valueOf('W'), "portionBroth", Character.valueOf('b'), MinecraftGlue.Items_bowl}), VfpOid.Stewed.craftingXp()));
            MinecraftGlue.ItemStacks_setSize(stewed_item, 1);
            instances.add(stewed_item);
            stewed_item = StewedItems.newStewDish(3, DishDef.acorn.meta());
            String cornmeal = null;
            if (config.isPresent("cornmeal")) {
                cornmeal = config.getPresentAs("cornmeal");
            }
            GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(stewed_item, new Object[]{"xxa", "fWh", "bbb", Character.valueOf('x'), "foodNativeGameMeatCooked", Character.valueOf('a'), VfpObj.Acornmeal_Portion_obj, Character.valueOf('f'), cornmeal == null ? "portionSaltSmall" : cornmeal, Character.valueOf('W'), "portionWaterLarge", Character.valueOf('h'), "portionHeatSmall", Character.valueOf('b'), MinecraftGlue.Items_bowl}), VfpOid.Stewed.craftingXp()));
            MinecraftGlue.ItemStacks_setSize(stewed_item, 1);
            instances.add(stewed_item);
            stewed_item = StewedItems.newStewDish(3, DishDef.gruel.meta());
            GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(stewed_item, new Object[]{"CCC", "Mf ", "bbb", Character.valueOf('C'), "ingredientCereal", Character.valueOf('M'), "portionMilkLarge", Character.valueOf('f'), "portionHeatSmall", Character.valueOf('b'), MinecraftGlue.Items_bowl}), VfpOid.Stewed.craftingXp()));
            MinecraftGlue.ItemStacks_setSize(stewed_item, 1);
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(stewed_item, new Object[]{"mC", "fb", Character.valueOf('m'), "portionMilk", Character.valueOf('C'), "ingredientCereal", Character.valueOf('f'), "portionHeatSmall", Character.valueOf('b'), MinecraftGlue.Items_bowl}));
            MinecraftGlue.ItemStacks_setSize(stewed_item, 1);
            instances.add(stewed_item);
            StewedItems.addCombo(DishDef.gruel, stewed_item, instances);
            stewed_item = StewedItems.newStewDish(1, DishDef.sop.meta());
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(stewed_item, new Object[]{"Bv", " b", Character.valueOf('B'), "portionBroth", Character.valueOf('v'), "powderSoupFlavor", Character.valueOf('b'), MinecraftGlue.Items_bowl}));
            instances.add(stewed_item);
            StewedItems.addCombo(DishDef.sop, stewed_item, instances);
            stewed_item = StewedItems.newStewDish(1, DishDef.egg_sop.meta());
            GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(stewed_item, new Object[]{"Bv", "eb", Character.valueOf('B'), "portionBroth", Character.valueOf('v'), "powderSoupFlavor", Character.valueOf('e'), "foodEggFried", Character.valueOf('b'), MinecraftGlue.Items_bowl}), VfpOid.Stewed.craftingXp()));
            instances.add(stewed_item);
            StewedItems.addCombo(DishDef.egg_sop, stewed_item, instances);
            StewedItems.addCombo(DishDef.mushroom, new ItemStack(MinecraftGlue.Items_mushroom_stew), instances);
            StewedItems.addCombo(DishDef.beetroot, new ItemStack(MinecraftGlue.Items_beetroot_soup), instances);
            stewed_item = StewedItems.newStewDish(1, DishDef.cave.meta());
            GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(stewed_item, new Object[]{"Mm", "mb", Character.valueOf('M'), VfpObj.Bat_Cooked_obj, Character.valueOf('m'), "foodMushroom", Character.valueOf('b'), MinecraftGlue.Items_bowl}), VfpOid.Stewed.craftingXp()));
            instances.add(stewed_item);
            stewed_item = StewedItems.newStewDish(1, DishDef.earthy.meta());
            _GOT_EARTHINESS = VfpUtils.ingredientDefined("foodWildPotato");
            if (_GOT_EARTHINESS) {
                GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(stewed_item, new Object[]{"PT", "CE", "Bb", Character.valueOf('P'), "foodWildPotato", Character.valueOf('T'), "foodBeets", Character.valueOf('C'), "foodCarrot", Character.valueOf('E'), VfpObj.Earthworms_Purged_obj, Character.valueOf('B'), "portionBroth", Character.valueOf('b'), MinecraftGlue.Items_bowl}), VfpOid.Stewed.craftingXp()));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(stewed_item, new Object[]{"PT", "CE", "b ", Character.valueOf('P'), "foodWildPotato", Character.valueOf('T'), "foodBeets", Character.valueOf('C'), "foodCarrot", Character.valueOf('E'), VfpObj.Earthworms_Purged_obj, Character.valueOf('b'), MinecraftGlue.Items_mushroom_stew}));
            }
            instances.add(stewed_item);
            TYPED_INSTANCES = instances.toArray(new ItemStack[0]);
        }
    }

    static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    public static final List<ItemStack> achievementCandidates() {
        ArrayList<ItemStack> candidates = new ArrayList<ItemStack>();
        for (DishDef dishDef : DishDef.values()) {
            if (!dishDef.getsAchievement()) continue;
            candidates.add(StewedItems.newStewDish(1, dishDef.meta()));
        }
        return candidates;
    }

    static enum DishDef implements Named
    {
        pumpkin(0, "stewed_pumpkin", true, false, Completer.FLATBREAD),
        eggplant(5, "stewed_eggplant", true, false, Completer.FLATBREAD),
        veggie(10, "stewed_veggie", true, false, Completer.FLATBREAD),
        polarbear(15, "stewed_polar_bear", false, true, null),
        gruel(20, "basic_gruel", true, false, LikeFood.gruel, Completer.BREADSLICE, false),
        sop(25, "basic_sop", false, false, LikeFood.sop, Completer.BREADSLICE, false),
        egg_sop(30, "friedegg_sop", false, false, new LikeFood("egg_sop", -1, LikeFood.sop, LikeFood.fried_egg), Completer.BREADSLICE, false),
        mushroom(35, "mstew", true, false, LikeFood.mushroom_stew, Completer.BREADSLICE, true),
        beetroot(37, "bsoup", true, false, LikeFood.beetsoup, Completer.BREADSLICE, true),
        acorn(40, "acorn_meat_stew", false, false, LikeFood.acorn_stew, null, false),
        cave(45, "cave_stew", false, false, LikeFood.rabbit_stew, null, false),
        earthy(50, "earthy_stew", true, true, LikeFood.meat_stew, null, false);

        private final int _meta;
        private final String _id;
        private LikeFood _like;
        private final boolean _veggie;
        private final boolean _multi;
        private final boolean _mc_extension;
        private final Completer _meal_completer;

        private DishDef(int meta, String id, @Nullable boolean veg, @Nullable boolean multi, LikeFood like, Completer addon, boolean extension) {
            this._meta = meta;
            this._id = id;
            this._veggie = veg;
            this._multi = multi;
            this._like = like;
            this._mc_extension = extension;
            this._meal_completer = addon;
        }

        private DishDef(int meta, String id, @Nullable boolean veg, boolean multi, Completer addon) {
            this(meta, id, veg, multi, null, addon, false);
        }

        final int meta() {
            return this._meta;
        }

        final int meal_meta() {
            return this._meta + 1;
        }

        String fmlid() {
            return this._id;
        }

        final boolean addCombo() {
            return this._meal_completer != null;
        }

        Completer mealCompleter() {
            return this._meal_completer;
        }

        boolean getsAchievement() {
            return this._like == null;
        }

        boolean isMulti() {
            return this._multi;
        }

        final void install(List<VfpVariant> variants, VfpVariantSet variantset) {
            LikeFood like;
            String fmlid = this.fmlid();
            LikeFood likeFood = this._like != null ? this._like : (like = this._veggie ? LikeFood.vegetable_stew : LikeFood.meat_stew);
            if (!this._mc_extension) {
                variants.add(new VfpTransientVariant(this.meta(), fmlid, like, this, null, variantset));
            }
            if (this.addCombo()) {
                fmlid = fmlid + "_combo";
                LikeFood likeFood2 = like = this._veggie ? LikeFood.vegetable_stew_meal : LikeFood.meat_stew_meal;
                if (this._like != null) {
                    like = new LikeFood(fmlid, -1, this._like, LikeFood.sandwich);
                }
                variants.add(new VfpTransientVariant(this.meal_meta(), fmlid, like, this, null, variantset));
            }
        }
    }

    static enum Completer {
        RICE,
        FLATBREAD,
        BREADSLICE,
        PASTA,
        FRIES;

    }
}

