/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.sugar;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.agents.Water;
import org.jwaresoftware.mcmods.vfp.common.FoodColor;
import org.jwaresoftware.mcmods.vfp.common.IMultiColored;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPlainItem;

public class DrinkSyrups
extends VfpPlainItem
implements IMultiColored,
FoodColor {
    public static final int MAX_USES = 3;
    private static final Flavor _LAST_FLAVOR;
    private static final Flavor[] FLAVORS;
    private static final String[] FLAVOR_NAMES;
    private static final Flavor[] FLAVORS_REFS;
    private static final int _NO_COLOR = 0xFFFFFF;

    public DrinkSyrups() {
        super(VfpOid.Drink_Syrup);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public static DrinkSyrups get(VfpConfig config) {
        DrinkSyrups syrups = new DrinkSyrups().autoregister(DrinkSyrups.class);
        for (int i = 0; i < FLAVORS.length; ++i) {
            String ingredientName = "ingredientSyrup" + FLAVOR_NAMES[i];
            Flavor flavor = FLAVORS[i];
            for (int u = 3; u > 0; --u) {
                OreDictionary.registerOre((String)ingredientName, (ItemStack)new ItemStack((Item)syrups, 1, flavor.meta(u)));
            }
        }
        return syrups;
    }

    public static String getIngredientName(@Nonnull Flavor flavor) {
        int i = flavor.ordinal();
        return "ingredientSyrup" + FLAVOR_NAMES[i];
    }

    public boolean hasContainerItem(ItemStack stack) {
        return this.getSyrupLevel(stack) > 0;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        ItemStack out = MinecraftGlue.ItemStacks_NULLSTACK();
        Flavor flavor = this.getFlavor(stack);
        if (flavor != null) {
            int at = this.getSyrupLevel(stack.func_77960_j());
            if (at > 1) {
                int meta = flavor.meta(at - 1);
                out = new ItemStack((Item)this, 1, meta);
                MinecraftGlue.ItemStacks_copyDisplayName(stack, out);
            } else {
                out = this.getNewEmptyBottle();
            }
        }
        return out;
    }

    @Nullable
    protected final Flavor getFlavor(@Nonnull ItemStack stack) {
        int meta_in = stack.func_77960_j();
        if (stack.func_77973_b() != this || meta_in <= 0) {
            return null;
        }
        int index = (meta_in - 1) / 3;
        return index < FLAVORS_REFS.length ? FLAVORS_REFS[index] : null;
    }

    protected final int getSyrupLevel(int meta) {
        int n = meta % 3;
        return n == 0 ? 3 : n;
    }

    protected final int getSyrupLevel(ItemStack stack) {
        Flavor flavor = this.getFlavor(stack);
        return flavor == null ? 0 : this.getSyrupLevel(stack.func_77960_j());
    }

    @Nonnull
    protected ItemStack getNewEmptyBottle() {
        return new ItemStack(VfpObj.Our_Empty_Bottle_obj);
    }

    @Override
    public int getColorFrom(ItemStack stack, int tintIndex) {
        return tintIndex <= 0 ? this.color(stack) : 0xFFFFFF;
    }

    @Override
    public int color(ItemStack stack) {
        Flavor flavor = this.getFlavor(stack);
        return flavor == null ? 0xF1F1F1 : flavor.color();
    }

    public String func_77667_c(ItemStack stack) {
        String out = super.func_77667_c(stack);
        Flavor flavor = this.getFlavor(stack);
        if (flavor != null) {
            out = out + FLAVOR_NAMES[flavor.ordinal()];
        }
        return out;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltip, boolean advanced) {
        super.func_77624_a(stack, player, tooltip, advanced);
        int at = this.getSyrupLevel(stack);
        if (at > 0) {
            tooltip.add(MinecraftGlue.Strings.translateFormatted(at == 1 ? "multiuse.left.1" : "multiuse.left.n", at));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        for (Flavor flavor : FLAVORS) {
            if (!DrinkSyrups.isAvailable(flavor)) continue;
            subItems.add((Object)new ItemStack(item, 1, flavor.meta()));
        }
    }

    public static final int[] getUsesRenderMetas() {
        int[] metas = new int[FLAVORS.length * 3];
        int i = 0;
        for (Flavor flavor : FLAVORS) {
            for (int u = 3; u > 0; --u) {
                metas[i++] = flavor.meta(u);
            }
        }
        return metas;
    }

    public static final String[] getUsesRenderNames() {
        String basename = "vanillafoodpantry:" + VfpOid.Drink_Syrup.fmlid() + "_";
        String[] names = new String[FLAVORS.length * 3];
        int i = 0;
        while (i < names.length) {
            for (int u = 3; u > 0; --u) {
                names[i++] = basename + u + "of" + 3;
            }
        }
        return names;
    }

    public static final boolean isAvailable(Flavor flavor) {
        boolean is = false;
        if (flavor != null && !(is = flavor.isAlwaysPresent())) {
            ItemStack powder = flavor.foodPowder();
            is = !MinecraftGlue.ItemStacks_isEmpty(powder);
        }
        return is;
    }

    public static final void autorecipe(VfpConfig config) {
        ItemStack syrup_base = Water.sweet(1);
        for (Flavor flavor : FLAVORS) {
            ItemStack powder = flavor.foodPowder();
            if (MinecraftGlue.ItemStacks_isEmpty(powder)) continue;
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Drink_Syrup_obj, 1, flavor.meta()), new Object[]{"fff", "fff", "w  ", Character.valueOf('f'), powder, Character.valueOf('w'), syrup_base}));
        }
    }

    static {
        int i;
        _LAST_FLAVOR = Flavor.MOCHA;
        FLAVORS = Flavor.values();
        FLAVOR_NAMES = new String[FLAVORS.length];
        for (i = 0; i < FLAVORS.length; ++i) {
            DrinkSyrups.FLAVOR_NAMES[i] = "_" + FLAVORS[i].name().toLowerCase(Locale.US);
        }
        FLAVORS_REFS = new Flavor[_LAST_FLAVOR.index() + 1];
        for (i = 0; i < FLAVORS_REFS.length; ++i) {
            DrinkSyrups.FLAVORS_REFS[i] = null;
        }
        Flavor[] flavorArray = FLAVORS;
        int n = flavorArray.length;
        for (int j = 0; j < n; ++j) {
            Flavor flavor;
            DrinkSyrups.FLAVORS_REFS[flavor.index()] = flavor = flavorArray[j];
        }
    }

    public static enum Flavor {
        APPLE(0, 16773841, 1, FoodPowders.Type.APPLE),
        MELON(1, 0xFFBBBB, 0xFFD4D4, 1, FoodPowders.Type.MELON),
        CHORUSFRUIT(2, 0xBA9BBA, 13150152, 0, FoodPowders.Type.CHORUSFRUIT),
        CHOCOLATE(3, 3414272, 9396536, 0, FoodPowders.Type.COCOA),
        BERRY(10, 16733536, 0, "berry"),
        CITRUS(11, 13563136, 1, "citrus"),
        COCONUT(12, 0xF5F5F5, 1),
        MANGO(13, 16759296, 0, "mango"),
        PINEAPPLE(14, 16769875, 1, "pineapple"),
        MOCHA(15, 7289344, 10776384, 0, "mocha");

        private final int _indexValue;
        private final int _colorValue;
        private int _lightcolorValue;
        private Object _foodPowder;
        private final boolean _iceeeFlag;

        private Flavor(int index, int colorValue, int lightcolorValue, int iceee, Object fp) {
            this._indexValue = index;
            this._colorValue = colorValue;
            this._lightcolorValue = lightcolorValue;
            this._foodPowder = fp;
            this._iceeeFlag = iceee != 0;
        }

        private Flavor(int index, int colorValue, int iceee, Object fp) {
            this(index, colorValue, 0, iceee, fp);
        }

        private Flavor(int index, int colorValue, int iceee) {
            this(index, colorValue, 0, iceee, null);
        }

        final int index() {
            return this._indexValue;
        }

        public int color() {
            return this._colorValue;
        }

        public int lightcolor() {
            return this._lightcolorValue == 0 ? this._colorValue : this._lightcolorValue;
        }

        @Nullable
        final ItemStack foodPowder() {
            return this._foodPowder instanceof FoodPowders.Type ? FoodPowders.get((FoodPowders.Type)this._foodPowder, 1) : (this._foodPowder instanceof String ? FoodPowders.get(FoodPowders.findType((String)this._foodPowder), 1) : null);
        }

        final int meta(int usesleft) {
            return this.index() * 3 + usesleft;
        }

        public final int meta() {
            return this.meta(3);
        }

        public final int altmeta() {
            return this.meta(1);
        }

        public final boolean isIceee() {
            return this._iceeeFlag;
        }

        public final boolean isAlwaysPresent() {
            return this._indexValue < 10;
        }
    }
}

