/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.sugar;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.common.Ingredient;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;

public class SimpleCookies
extends VfpPantryMultiItem {
    public static final int SUGAR_COOKIE_ID = FoodPowders.Usage.COOKIE_FLAVOR.idFirst();
    public static final int MOLASSES_COOKIE_ID = SUGAR_COOKIE_ID + 1;
    public static final int COCOA_COOKIE_ID = FoodPowders.Usage.COOKIE_FLAVOR.idLast() - FoodPowders.Type.COCOA.meta();
    public static final int APPLE_COOKIE_ID = FoodPowders.Usage.COOKIE_FLAVOR.idLast() - FoodPowders.Type.APPLE.meta();
    public static final int KLINGON_COOKIE_ID = FoodPowders.Usage.COOKIE_FLAVOR.idLast() - FoodPowders.Type.CACTUS.meta();
    private static final List<Ingredient> VARIANT_INGREDIENTS = new ArrayList<Ingredient>();
    static VfpVariant[] VARIANT_ARRAY;
    private static final VfpVariantSet VARIANT_SET;
    private static SimpleCookies INSTANCE;
    private static ItemStack[] TYPED_INSTANCES;

    public static final synchronized boolean register(Ingredient ingredient) {
        Validate.notNull((Object)ingredient, (String)"A non-null ingredient is required for simple cookie", (Object[])new Object[0]);
        boolean added = false;
        if (!VARIANT_INGREDIENTS.contains(ingredient)) {
            VARIANT_INGREDIENTS.add(ingredient);
            added = true;
        }
        return added;
    }

    public static final synchronized boolean register(String cookieName, int id, Item ingredient) {
        Validate.notNull((Object)ingredient, (String)"A non-null cookie flavor ingredient is required", (Object[])new Object[0]);
        return SimpleCookies.register(new Ingredient(cookieName, id, new ItemStack(ingredient)));
    }

    public SimpleCookies(VfpOid oid, CreativeTabs tab) {
        super((VfpProfile)oid, false, VARIANT_ARRAY, tab);
    }

    public static final synchronized SimpleCookies get() {
        if (INSTANCE == null && VARIANT_INGREDIENTS.size() > 0) {
            ArrayList<VfpTransientVariant> variants = new ArrayList<VfpTransientVariant>(16);
            String basename = VARIANT_SET.typeName();
            for (Ingredient ingredient : VARIANT_INGREDIENTS) {
                String fmlid = basename + "_" + ingredient.name().toLowerCase(Locale.US);
                variants.add(new VfpTransientVariant(ingredient.id(), fmlid, LikeFood.cookie, ingredient, null, VARIANT_SET));
            }
            VARIANT_ARRAY = variants.toArray(VfpVariant.EMPTY_ARRAY);
            INSTANCE = VfpBuilder.newMultiItem(VfpOid.Cookie, SimpleCookies.class, VfpBuilder.User.INTERNAL);
            for (Ingredient ingredient : VARIANT_INGREDIENTS) {
                if (!ingredient.isEnabled()) continue;
                ItemStack a_cookie = new ItemStack((Item)INSTANCE, 1, ingredient.id());
                OreDictionary.registerOre((String)"foodCookie", (ItemStack)a_cookie);
            }
        }
        return INSTANCE;
    }

    public static final synchronized void autorecipe() {
        if (TYPED_INSTANCES == null && SimpleCookies.get() != null) {
            ArrayList<ItemStack> instances = new ArrayList<ItemStack>(16);
            for (int i = 0; i < VARIANT_ARRAY.length; ++i) {
                VfpVariant variant = VARIANT_ARRAY[i];
                Ingredient ingredient = variant.datadata(Ingredient.class);
                instances.add(new ItemStack((Item)INSTANCE, 1, ingredient.id()));
                if (!ingredient.isEnabled()) continue;
                ItemStack cookie_batch = new ItemStack((Item)INSTANCE, VfpCapacity.COOKIE_BATCH.count(), ingredient.id());
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(cookie_batch, new Object[]{"ff", "si", Character.valueOf('f'), "foodFlour", Character.valueOf('s'), "ingredientSweetener", Character.valueOf('i'), ingredient.recipeitem()}));
            }
            TYPED_INSTANCES = instances.toArray(new ItemStack[0]);
        }
    }

    public static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    static {
        VARIANT_SET = new VfpVariantSet.ByMapInstance((VfpProfile)VfpOid.Cookie, (Class)SimpleCookies.class, "type"){

            @Override
            protected VfpVariant[] declaredVariants() {
                assert (VARIANT_ARRAY != null);
                return VARIANT_ARRAY;
            }
        };
    }
}

