/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.sugar;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.common.IMultiColored;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.sugar.DrinkSyrups;

public final class Snowcones
extends VfpPantryMultiItem
implements IMultiColored {
    private static final List<DrinkSyrups.Flavor> CONE_FLAVORS = new ArrayList<DrinkSyrups.Flavor>();
    static VfpVariant[] VARIANT_ARRAY;
    private static final VfpVariantSet VARIANT_SET;
    private static Snowcones INSTANCE;
    private static ItemStack[] TYPED_INSTANCES;

    public static final synchronized boolean register(DrinkSyrups.Flavor flavor) {
        Validate.notNull((Object)((Object)flavor), (String)"A non-null flavor is required for an iceee", (Object[])new Object[0]);
        boolean added = false;
        if (!CONE_FLAVORS.contains((Object)flavor)) {
            CONE_FLAVORS.add(flavor);
            added = true;
        }
        return added;
    }

    public Snowcones(VfpOid oid, CreativeTabs tab) {
        super((VfpProfile)oid, false, VARIANT_ARRAY, tab);
    }

    @Override
    public int getColorFrom(ItemStack stack, int tintIndex) {
        int default_color_num;
        int color_num = default_color_num = 0xFFFFFF;
        if (tintIndex <= 0) {
            DrinkSyrups.Flavor flavor = null;
            VfpVariant type = VARIANT_SET.lookup(stack.func_77960_j());
            if (type != null && (flavor = type.datadata(DrinkSyrups.Flavor.class)) != null && (color_num = flavor.lightcolor()) == 0) {
                color_num = default_color_num;
            }
        }
        return color_num;
    }

    public static final synchronized Snowcones get() {
        if (INSTANCE == null && !CONE_FLAVORS.isEmpty()) {
            ArrayList<VfpTransientVariant> variants = new ArrayList<VfpTransientVariant>(19);
            String basename = VARIANT_SET.typeName() + "_";
            for (DrinkSyrups.Flavor flavor : CONE_FLAVORS) {
                String fmlid = basename + flavor.name().toLowerCase(Locale.US);
                variants.add(new VfpTransientVariant(flavor.meta(), fmlid, LikeFood.sugarbomb, (Object)flavor, null, VARIANT_SET));
                if (flavor.isIceee()) continue;
                fmlid = fmlid + "_plain";
                variants.add(new VfpTransientVariant(flavor.altmeta(), fmlid, LikeFood.sugarbomb, (Object)flavor, null, VARIANT_SET));
            }
            VARIANT_ARRAY = variants.toArray(VfpVariant.EMPTY_ARRAY);
            INSTANCE = VfpBuilder.newMultiItem(VfpOid.Snowcone, Snowcones.class, VfpBuilder.User.INTERNAL);
            for (DrinkSyrups.Flavor flavor : CONE_FLAVORS) {
                ItemStack iceee = flavor.isIceee() ? new ItemStack((Item)INSTANCE, 1, flavor.meta()) : new ItemStack((Item)INSTANCE, 1, flavor.altmeta());
                OreDictionary.registerOre((String)"foodIceee", (ItemStack)iceee);
            }
        }
        return INSTANCE;
    }

    private static final void autorecipe(VfpVariant variant, DrinkSyrups.Flavor flavor, boolean iceeeFlag, List<ItemStack> instances) {
        instances.add(new ItemStack((Item)INSTANCE, 1, variant.metadata()));
        ItemStack snocone = new ItemStack((Item)INSTANCE, 2, variant.metadata());
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(snocone, new Object[]{iceeeFlag ? "S " : "cS", "ss", Character.valueOf('c'), "portionCondensedMilk", Character.valueOf('S'), DrinkSyrups.getIngredientName(flavor), Character.valueOf('s'), MinecraftGlue.Items_snowball}));
    }

    public static final synchronized void autorecipe() {
        if (TYPED_INSTANCES == null && Snowcones.get() != null) {
            ArrayList<ItemStack> instances = new ArrayList<ItemStack>(19);
            for (int i = 0; i < VARIANT_ARRAY.length; ++i) {
                VfpVariant variant = VARIANT_ARRAY[i];
                DrinkSyrups.Flavor flavor = variant.datadata(DrinkSyrups.Flavor.class);
                Snowcones.autorecipe(variant, flavor, flavor.isIceee(), instances);
                if (flavor.isIceee()) continue;
                variant = VARIANT_ARRAY[++i];
                Snowcones.autorecipe(variant, flavor, true, instances);
            }
            TYPED_INSTANCES = instances.toArray(new ItemStack[0]);
        }
    }

    public static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    static {
        VARIANT_SET = new VfpVariantSet.ByMapInstance((VfpProfile)VfpOid.Snowcone, (Class)Snowcones.class, "type"){

            @Override
            protected VfpVariant[] declaredVariants() {
                assert (VARIANT_ARRAY != null);
                return VARIANT_ARRAY;
            }

            @Override
            public String[] renderNames() {
                VfpVariant[] enumset = this.declaredVariants();
                String[] names = new String[enumset.length];
                String iceee = "vanillafoodpantry:iceee";
                String creamycone = "vanillafoodpantry:snowcone";
                for (int i = 0; i < enumset.length; ++i) {
                    DrinkSyrups.Flavor flavor = enumset[i].datadata(DrinkSyrups.Flavor.class);
                    String string = names[i] = flavor.isIceee() ? "vanillafoodpantry:iceee" : "vanillafoodpantry:snowcone";
                    if (flavor.isIceee()) continue;
                    names[++i] = "vanillafoodpantry:iceee";
                }
                return names;
            }
        };
    }
}

