/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.wheat;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.integrations.IntegrationsImpl;

public final class Breads
extends VfpPantryMultiItem {
    static final LikeFood B_PLAIN = LikeFood.flouronly_bread;
    static final LikeFood B_FRENCH = LikeFood.french_bread;
    static final LikeFood B_ENRICHED = LikeFood.enriched_bread;
    static final LikeFood B_SANDWICH = LikeFood.sandwich_bread;
    static final LikeFood B_SPECIALTY = LikeFood.specialty_bread;
    static final LikeFood B_MUSCLE = new LikeFood("musclebread", 0, B_SPECIALTY, LikeFood.muscle_boost, LikeFood.muscle_boost);
    static VfpVariant[] VARIANT_ARRAY;
    private static final VfpVariantSet VARIANT_SET;
    private static Breads INSTANCE;
    private static ItemStack[] TYPED_INSTANCES;

    public static final void validState() {
        Validate.validState((VARIANT_ARRAY != null ? 1 : 0) != 0, (String)"Breads variant array not allocated?", (Object[])new Object[0]);
        Validate.validState((INSTANCE != null ? 1 : 0) != 0, (String)"Breads item singleton not allocated?", (Object[])new Object[0]);
    }

    public Breads(VfpOid oid, CreativeTabs tab) {
        super((VfpProfile)oid, false, VARIANT_ARRAY, tab);
    }

    @Override
    protected void onFoodEaten(ItemStack eaten, ItemStack remaining, World world, EntityPlayer player) {
        BreadDef breadDef;
        if (!world.field_72995_K && (breadDef = VfpVariant.byItemStack(eaten, this._variant_default).datadata(BreadDef.class)).id() == BreadDef.Muscle.id()) {
            MinecraftGlue.Potions.onMuscleFoodEaten(player, -1);
        }
        super.onFoodEaten(eaten, remaining, world, player);
    }

    @Override
    public int func_77626_a(ItemStack bread) {
        int default_duration = super.func_77626_a(bread);
        BreadDef breadDef = VfpVariant.byItemStack(bread, this._variant_default).datadata(BreadDef.class);
        if (breadDef.id() == BreadDef.Muscle.id()) {
            default_duration = MinecraftGlue.HEARTY_FOOD_CONSUME_DURATION();
        }
        return default_duration;
    }

    @Override
    public ItemStack createInstance(Item item, int amount, int meta) {
        if (item != INSTANCE) {
            return MinecraftGlue.ItemStacks_NULLSTACK();
        }
        VfpVariant variant = VfpVariant.byMetadata(meta, this._variant_default);
        return Breads.newCookedBread(amount, variant.datadata(BreadDef.class));
    }

    private static ItemStack newCookedBread(int amount, BreadDef breadDef) {
        ItemStack a_bread = !breadDef.isMultiuse() ? new ItemStack((Item)INSTANCE, amount, breadDef.id()) : Breads.createMultiuseInstance((Item)INSTANCE, amount, breadDef.id(), breadDef.likeFood().healAmount(), LikeFood.bread.healAmount());
        return a_bread;
    }

    public static final synchronized Breads get() {
        if (INSTANCE == null) {
            ArrayList<VfpTransientVariant> variants = new ArrayList<VfpTransientVariant>(32);
            for (BreadDef breadDef : BreadDef.values()) {
                String fmlid = breadDef.unlocalizedName();
                LikeFood like = breadDef.cooked() ? breadDef.likeFood() : null;
                CreativeTabs tab = breadDef.cooked() ? null : MinecraftGlue.CreativeTabs_materials;
                variants.add(new VfpTransientVariant(breadDef.id(), fmlid, like, (Object)breadDef, tab, VARIANT_SET));
            }
            VARIANT_ARRAY = variants.toArray(VfpVariant.EMPTY_ARRAY);
            INSTANCE = VfpBuilder.newMultiItem(VfpOid.Breads, Breads.class, VfpBuilder.User.INTERNAL);
            Breads.validState();
            for (BreadDef breadDef : BreadDef.values()) {
                if (!breadDef.cooked()) continue;
                ItemStack a_bread = Breads.newCookedBread(1, breadDef);
                IntegrationsImpl.registerAsBread(a_bread, breadDef.sandwichOk(), new String[0]);
            }
            VfpObj.Portion_Bread_obj = VfpBuilder.newFood(VfpOid.Portion_Bread, LikeFood.sandwich);
            VfpObj.Flat_Bread_Pocket_obj = VfpBuilder.newFood(VfpOid.Flat_Bread_Pocket, LikeFood.bread_pocket);
            OreDictionary.registerOre((String)"portionBread", (Item)VfpObj.Portion_Bread_obj);
            OreDictionary.registerOre((String)"portionBread", (Item)VfpObj.Flat_Bread_Pocket_obj);
        }
        return INSTANCE;
    }

    private static final void autorecipeBreadSlices(@Nullable BreadDef breadDef, ItemStack cooked_bread) {
        int n = 3;
        if (breadDef != null) {
            if (!breadDef.sandwichOk()) {
                return;
            }
            n = Math.max(n, MathHelper.func_76123_f((float)((float)breadDef.likeFood().healAmount() / (float)LikeFood.sandwich.healAmount())));
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Portion_Bread_obj, n), new Object[]{cooked_bread, "itemFoodCutter"}));
    }

    public static final synchronized void autorecipe(VfpConfig config) {
        if (TYPED_INSTANCES == null && Breads.get() != null) {
            ArrayList<ItemStack> instances = new ArrayList<ItemStack>(16);
            ItemStack milk_powder = FoodPowders.get(FoodPowders.Type.MILK, 1);
            ItemStack cooked_bread = new ItemStack(MinecraftGlue.Items_bread);
            Breads.autorecipeBreadSlices(null, cooked_bread);
            ItemStack bread = new ItemStack((Item)INSTANCE, 1, BreadDef.Uncooked_French.id());
            instances.add(bread.func_77946_l());
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(bread, new Object[]{"dd.", "ew.", "...", Character.valueOf('d'), "foodDough", Character.valueOf('e'), VfpObj.Egg_White_obj, Character.valueOf('w'), "portionWaterSmall"}));
            cooked_bread = Breads.newCookedBread(1, BreadDef.French);
            GameRegistry.addSmelting((ItemStack)bread, (ItemStack)cooked_bread, (float)LikeFood.flouronly_bread.smeltExperience());
            Breads.autorecipeBreadSlices(BreadDef.French, cooked_bread);
            instances.add(cooked_bread.func_77946_l());
            bread = new ItemStack((Item)INSTANCE, 1, BreadDef.Uncooked_Plain.id());
            instances.add(bread.func_77946_l());
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(bread, new Object[]{"dd.", "em.", "...", Character.valueOf('d'), "foodDough", Character.valueOf('e'), "foodSimpleEgg", Character.valueOf('m'), milk_powder}));
            cooked_bread = Breads.newCookedBread(1, BreadDef.Plain);
            GameRegistry.addSmelting((ItemStack)bread, (ItemStack)cooked_bread, (float)LikeFood.enriched_bread.smeltExperience());
            Breads.autorecipeBreadSlices(BreadDef.Plain, cooked_bread);
            instances.add(cooked_bread.func_77946_l());
            bread = new ItemStack((Item)INSTANCE, 1, BreadDef.Uncooked_Egg.id());
            instances.add(bread.func_77946_l());
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(bread, new Object[]{"dd.", "em.", "EE.", Character.valueOf('d'), "foodDough", Character.valueOf('e'), "foodSimpleEgg", Character.valueOf('m'), milk_powder, Character.valueOf('E'), FoodPowders.get(FoodPowders.Type.EGG, 1)}));
            cooked_bread = Breads.newCookedBread(1, BreadDef.Egg);
            GameRegistry.addSmelting((ItemStack)bread, (ItemStack)cooked_bread, (float)LikeFood.sandwich_bread.smeltExperience());
            Breads.autorecipeBreadSlices(BreadDef.Egg, cooked_bread);
            instances.add(cooked_bread.func_77946_l());
            bread = new ItemStack((Item)INSTANCE, 1, BreadDef.Uncooked_Potato.id());
            instances.add(bread.func_77946_l());
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(bread, new Object[]{"dd.", "em.", "pp.", Character.valueOf('d'), "foodDough", Character.valueOf('e'), "foodSimpleEgg", Character.valueOf('m'), milk_powder, Character.valueOf('p'), FoodPowders.get(FoodPowders.Type.POTATO, 1)}));
            cooked_bread = Breads.newCookedBread(1, BreadDef.Potato);
            GameRegistry.addSmelting((ItemStack)bread, (ItemStack)cooked_bread, (float)LikeFood.sandwich_bread.smeltExperience());
            Breads.autorecipeBreadSlices(BreadDef.Potato, cooked_bread);
            instances.add(cooked_bread.func_77946_l());
            bread = new ItemStack((Item)INSTANCE, 1, BreadDef.Uncooked_Pumpkin.id());
            instances.add(bread.func_77946_l());
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(bread, new Object[]{"dd.", "es.", "pp.", Character.valueOf('d'), "foodDough", Character.valueOf('e'), "foodSimpleEgg", Character.valueOf('s'), "ingredientSweetener", Character.valueOf('p'), FoodPowders.get(FoodPowders.Type.PUMPKIN, 1)}));
            cooked_bread = Breads.newCookedBread(1, BreadDef.Pumpkin);
            GameRegistry.addSmelting((ItemStack)bread, (ItemStack)cooked_bread, (float)LikeFood.specialty_bread.smeltExperience());
            instances.add(cooked_bread.func_77946_l());
            bread = new ItemStack((Item)INSTANCE, 1, BreadDef.Uncooked_Apple.id());
            instances.add(bread.func_77946_l());
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(bread, new Object[]{"dd.", "es.", "aa.", Character.valueOf('d'), "foodDough", Character.valueOf('e'), "foodSimpleEgg", Character.valueOf('s'), "ingredientSweetener", Character.valueOf('a'), FoodPowders.get(FoodPowders.Type.APPLE, 1)}));
            cooked_bread = Breads.newCookedBread(1, BreadDef.Apple);
            GameRegistry.addSmelting((ItemStack)bread, (ItemStack)cooked_bread, (float)LikeFood.specialty_bread.smeltExperience());
            instances.add(cooked_bread.func_77946_l());
            bread = new ItemStack((Item)INSTANCE, 1, BreadDef.Uncooked_Molasses.id());
            instances.add(bread.func_77946_l());
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(bread, new Object[]{"dd.", "es.", "mc.", Character.valueOf('d'), "foodDough", Character.valueOf('e'), "foodSimpleEgg", Character.valueOf('s'), "ingredientSweetener", Character.valueOf('m'), VfpObj.Molasses_Ball_obj, Character.valueOf('c'), FoodPowders.get(FoodPowders.Type.COCOA, 1)}));
            cooked_bread = Breads.newCookedBread(1, BreadDef.Molasses);
            GameRegistry.addSmelting((ItemStack)bread, (ItemStack)cooked_bread, (float)LikeFood.specialty_bread.smeltExperience());
            instances.add(cooked_bread.func_77946_l());
            bread = new ItemStack((Item)INSTANCE, 1, BreadDef.Uncooked_Klingon.id());
            instances.add(bread.func_77946_l());
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(bread, new Object[]{"dd.", "es.", "xx.", Character.valueOf('d'), "foodDough", Character.valueOf('e'), "foodSimpleEgg", Character.valueOf('s'), "ingredientSweetener", Character.valueOf('x'), FoodPowders.get(FoodPowders.Type.CACTUS, 1)}));
            cooked_bread = Breads.newCookedBread(1, BreadDef.Klingon);
            GameRegistry.addSmelting((ItemStack)bread, (ItemStack)cooked_bread, (float)LikeFood.specialty_bread.smeltExperience());
            instances.add(cooked_bread.func_77946_l());
            bread = new ItemStack((Item)INSTANCE, 1, BreadDef.Uncooked_Muscle.id());
            instances.add(bread.func_77946_l());
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(bread, new Object[]{"dd.", "es.", "xx.", Character.valueOf('d'), "foodDough", Character.valueOf('e'), "foodSimpleEgg", Character.valueOf('s'), "ingredientSweetener", Character.valueOf('x'), FoodPowders.get(FoodPowders.Type.MUSCLE, 1)}));
            cooked_bread = Breads.newCookedBread(1, BreadDef.Muscle);
            GameRegistry.addSmelting((ItemStack)bread, (ItemStack)cooked_bread, (float)LikeFood.specialty_bread.smeltExperience());
            instances.add(cooked_bread.func_77946_l());
            bread = new ItemStack((Item)INSTANCE, 1, BreadDef.Uncooked_Flat.id());
            instances.add(bread.func_77946_l());
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(bread, new Object[]{"foodDough", VfpObj.Sand_Jar_obj}));
            cooked_bread = Breads.newCookedBread(1, BreadDef.Flat);
            GameRegistry.addSmelting((ItemStack)bread, (ItemStack)cooked_bread, (float)LikeFood.flouronly_bread.smeltExperience());
            instances.add(cooked_bread.func_77946_l());
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Flat_Bread_Pocket_obj, 2), new Object[]{cooked_bread}));
            TYPED_INSTANCES = instances.toArray(new ItemStack[0]);
            for (VfpVariant variant : VARIANT_ARRAY) {
                BreadDef breadDef = variant.datadata(BreadDef.class);
                if (breadDef.cooked()) continue;
                VfpRewards.addRewardingCraftItem(new ItemStack((Item)INSTANCE, 1, breadDef.id()), breadDef.likeFood().craftExperience());
            }
        }
    }

    public static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    public static final ItemStack french(int amount) {
        return Breads.newCookedBread(amount, BreadDef.French);
    }

    public static final ItemStack uncooked_french(int amount) {
        return new ItemStack((Item)INSTANCE, amount, BreadDef.Uncooked_French.id());
    }

    public static final ItemStack enriched(int amount) {
        return Breads.newCookedBread(amount, BreadDef.Plain);
    }

    public static final ItemStack potato(int amount) {
        return Breads.newCookedBread(amount, BreadDef.Potato);
    }

    public static final ItemStack pumpkin(int amount) {
        return Breads.newCookedBread(amount, BreadDef.Pumpkin);
    }

    public static final ItemStack uncooked_pumpkin(int amount) {
        return new ItemStack((Item)INSTANCE, amount, BreadDef.Uncooked_Pumpkin.id());
    }

    public static final ItemStack flat(int amount) {
        return Breads.newCookedBread(amount, BreadDef.Flat);
    }

    public static final ItemStack uncooked_muscle(int amount) {
        return new ItemStack((Item)INSTANCE, amount, BreadDef.Uncooked_Muscle.id());
    }

    public static final List<ItemStack> achievementCandidates() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (VfpVariant variant : VARIANT_ARRAY) {
            BreadDef breadDef = variant.datadata(BreadDef.class);
            if (!breadDef.getsAchievement()) continue;
            list.add(new ItemStack((Item)INSTANCE, 1, breadDef.id()));
        }
        return list;
    }

    public static final void registerAllSandwichUnder(String forgeid) {
        if (INSTANCE != null) {
            NonNullList sandwichBreads = OreDictionary.getOres((String)"foodBreadSandwich", (boolean)false);
            for (ItemStack bread : sandwichBreads) {
                OreDictionary.registerOre((String)forgeid, (ItemStack)bread);
            }
        }
    }

    static {
        VARIANT_SET = new VfpVariantSet.ByMapInstance((VfpProfile)VfpOid.Breads, (Class)Breads.class, "type"){

            @Override
            protected VfpVariant[] declaredVariants() {
                assert (VARIANT_ARRAY != null);
                return VARIANT_ARRAY;
            }
        };
    }

    static enum BreadDef {
        Plain(true, "enriched", B_ENRICHED, FoodPowders.Usage.BREAD_FLAVOR.idFirst(), true, false),
        Uncooked_Plain("enriched", B_ENRICHED, BreadDef.Plain._id + 1, false),
        Molasses(true, "molasses", B_SPECIALTY, BreadDef.Uncooked_Plain._id + 1, false, true),
        Uncooked_Molasses(BreadDef.Molasses._name, BreadDef.Molasses._like, BreadDef.Molasses._id + 1, true),
        Egg(true, "egg", B_SANDWICH, BreadDef.Uncooked_Molasses._id + 1, true, true),
        Uncooked_Egg(BreadDef.Egg._name, BreadDef.Egg._like, BreadDef.Egg._id + 1, true),
        Apple(true, "apple", B_SPECIALTY, BreadDef.Uncooked_Egg._id + 1, false, true),
        Uncooked_Apple(BreadDef.Apple._name, BreadDef.Apple._like, BreadDef.Apple._id + 1, true),
        Pumpkin(true, "pumpkin", B_SPECIALTY, BreadDef.Uncooked_Apple._id + 1, false, true),
        Uncooked_Pumpkin(BreadDef.Pumpkin._name, BreadDef.Pumpkin._like, BreadDef.Pumpkin._id + 1, true),
        French(true, "french", B_FRENCH, BreadDef.Uncooked_Pumpkin._id + 1, true, false),
        Uncooked_French(BreadDef.French._name, BreadDef.French._like, BreadDef.French._id + 1, false),
        Potato(true, "potato", B_SANDWICH, BreadDef.Uncooked_French._id + 1, true, true),
        Uncooked_Potato(BreadDef.Potato._name, BreadDef.Potato._like, BreadDef.Potato._id + 1, true),
        Muscle(true, "muscle", B_MUSCLE, BreadDef.Uncooked_Potato._id + 1, false, true),
        Uncooked_Muscle(BreadDef.Muscle._name, BreadDef.Muscle._like, BreadDef.Muscle._id + 1, false),
        Klingon(true, "klingon", B_SPECIALTY, BreadDef.Uncooked_Muscle._id + 1, false, true),
        Uncooked_Klingon(BreadDef.Klingon._name, BreadDef.Klingon._like, BreadDef.Klingon._id + 1, true),
        Flat(true, "flat", B_PLAIN, BreadDef.Uncooked_Klingon._id + 1, false, false),
        Uncooked_Flat(BreadDef.Flat._name, BreadDef.Flat._like, BreadDef.Flat._id + 1, false);

        private final int _id;
        private final String _name;
        private final LikeFood _like;
        private final boolean _multi;
        private final boolean _sandwich;
        private final boolean _cooked;
        private final boolean _achievement;

        private BreadDef(boolean cooked, String name, LikeFood like, int id, boolean sandwich, boolean achievement) {
            this._id = id;
            this._name = name;
            this._cooked = cooked;
            this._like = like;
            this._multi = cooked && (like == B_SANDWICH || like == B_SPECIALTY || like == B_MUSCLE);
            this._sandwich = cooked && sandwich;
            this._achievement = !cooked && achievement;
        }

        private BreadDef(String name, LikeFood like, int id, boolean achievement) {
            this(false, name, like, id, false, achievement);
        }

        String unlocalizedName() {
            String p = this._cooked ? "" : "uncooked_";
            return this._name == null ? p + "bread" : p + this._name + "_bread";
        }

        int id() {
            return this._id;
        }

        boolean cooked() {
            return this._cooked;
        }

        boolean sandwichOk() {
            return this._sandwich;
        }

        boolean isMultiuse() {
            return this._multi;
        }

        LikeFood likeFood() {
            return this._like;
        }

        boolean getsAchievement() {
            return this._achievement;
        }
    }
}

