/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.wheat;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;

public final class Fries
extends VfpPantryMultiItem {
    private static final int FRIES_BATCH = 4;
    private static boolean HARD_RECIPE = false;
    private static final VfpVariantSet VARIANT_SET = new VfpVariantSet.ByMapInstanceVType(VfpOid.Fries, Fries.class, "type");
    private static final VfpVariant[] VARIANT_ARRAY = new VfpVariant[]{new VfpVariant(0, "fries_potatoes_raw", LikeFood.uncooked_potato, VARIANT_SET, true), new VfpVariant(1, "fries_potatoes", LikeFood.fries, VARIANT_SET, false), new VfpVariant(2, "fries_carrots_raw", LikeFood.uncooked_carrot, VARIANT_SET, false), new VfpVariant(3, "fries_carrots", LikeFood.fries, VARIANT_SET, false), new VfpVariant(4, "fries_klingon_raw", LikeFood.uncooked_potato, VARIANT_SET, false), new VfpVariant(5, "fries_klingon", LikeFood.fries, VARIANT_SET, false), new VfpVariant(6, "fries_cassava_raw", LikeFood.uncooked_potato, VARIANT_SET, false), new VfpVariant(7, "fries_cassava", LikeFood.fries, VARIANT_SET, false), new VfpVariant(8, "fries_sweetpotato_raw", LikeFood.uncooked_potato, VARIANT_SET, false), new VfpVariant(9, "fries_sweetpotato", LikeFood.fries, VARIANT_SET, false)};
    private static final int _LAST_VANILLA_FRIES_META = 5;
    private static Fries INSTANCE;
    private static ItemStack[] TYPED_INSTANCES;

    public Fries(VfpOid oid, CreativeTabs tab) {
        super((VfpProfile)oid, false, VARIANT_ARRAY, tab);
    }

    @Override
    protected boolean showSubItem(VfpVariant variant, CreativeTabs forTab, CreativeTabs pickedTab) {
        boolean show = true;
        int id = variant.metadata();
        if (id > 5) {
            VfpConfig config = VfpConfig.getInstance();
            show = config.includeModRecipes();
            if (show && (id == 6 || id == 7)) {
                show = config.isPresent("cassava");
            }
            if (show && (id == 8 || id == 9)) {
                show = config.isPresent("sweetpotato");
            }
        }
        return show;
    }

    static final synchronized Fries get() {
        if (INSTANCE == null) {
            INSTANCE = VfpBuilder.newMultiItem(VfpOid.Fries, Fries.class, VfpBuilder.User.INTERNAL);
        }
        return INSTANCE;
    }

    private static final void addXFries(int meta_raw, int meta, Object source, Object seasoning, List<ItemStack> instances) {
        ItemStack prepped_fries = new ItemStack((Item)INSTANCE, 4, meta_raw);
        ItemStack cooked_fries = new ItemStack((Item)INSTANCE, 1, meta);
        if (HARD_RECIPE && source == MinecraftGlue.Items_potato) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(prepped_fries, new Object[]{"ppk", seasoning == null ? "sv " : "svX", "Wh ", Character.valueOf('p'), source, Character.valueOf('k'), "itemFoodCutter", Character.valueOf('s'), "portionSaltSmall", Character.valueOf('v'), "ingredientVinegar", Character.valueOf('X'), seasoning == null ? VfpObj.Eek_obj : seasoning, Character.valueOf('W'), "portionWaterLarge", Character.valueOf('h'), "portionHeatSmall"}));
        } else if (seasoning == null) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(prepped_fries, new Object[]{source, source, "itemFoodCutter"}));
        } else {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(prepped_fries, new Object[]{source, source, seasoning, "itemFoodCutter"}));
        }
        MinecraftGlue.ItemStacks_setSize(prepped_fries, 1);
        GameRegistry.addSmelting((ItemStack)prepped_fries, (ItemStack)cooked_fries, (float)(LikeFood.uncooked_potato.smeltExperience() / 2.0f));
        instances.add(prepped_fries);
        instances.add(cooked_fries);
        OreDictionary.registerOre((String)"foodFrenchFries", (ItemStack)cooked_fries);
        OreDictionary.registerOre((String)"foodFries", (ItemStack)cooked_fries);
    }

    static final synchronized void autorecipe(VfpConfig config) {
        if (TYPED_INSTANCES == null) {
            Fries.get();
            ArrayList<ItemStack> instances = new ArrayList<ItemStack>(13);
            HARD_RECIPE = config.harderFries();
            Fries.addXFries(0, 1, MinecraftGlue.Items_potato, null, instances);
            Fries.addXFries(2, 3, MinecraftGlue.Items_carrot, null, instances);
            Fries.addXFries(4, 5, MinecraftGlue.Items_potato, FoodPowders.get(FoodPowders.Type.CACTUS, 1), instances);
            if (config.includeModRecipes()) {
                if (config.isPresent("cassava")) {
                    Fries.addXFries(6, 7, config.getPresentAs("cassava"), "portionSaltSmall", instances);
                }
                if (config.isPresent("sweetpotato")) {
                    Fries.addXFries(8, 9, config.getPresentAs("sweetpotato"), null, instances);
                }
            }
            TYPED_INSTANCES = instances.toArray(new ItemStack[0]);
        }
    }

    static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    public static ItemStack plain(int amount) {
        ItemStack stack = null;
        if (TYPED_INSTANCES != null) {
            stack = new ItemStack((Item)INSTANCE, amount, 1);
        }
        return stack;
    }

    public static ItemStack klingon(int amount) {
        ItemStack stack = null;
        if (TYPED_INSTANCES != null) {
            stack = new ItemStack((Item)INSTANCE, amount, 5);
        }
        return stack;
    }
}

