/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.wheat;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.agents.JJJJar;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpAware;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPlainItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.core.VfpAchievements;
import org.jwaresoftware.mcmods.vfp.core.VfpBuildHelperSupport;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.core.VfpRuntime;
import org.jwaresoftware.mcmods.vfp.wheat.Breads;
import org.jwaresoftware.mcmods.vfp.wheat.DoughBall;
import org.jwaresoftware.mcmods.vfp.wheat.DoughBallType;
import org.jwaresoftware.mcmods.vfp.wheat.Fries;
import org.jwaresoftware.mcmods.vfp.wheat.Muffins;
import org.jwaresoftware.mcmods.vfp.wheat.PocketSandwiches;

public final class WheatExtrasBuildHelper
extends VfpBuildHelperSupport {
    private static final CreativeTabs MISC_TAB = MinecraftGlue.CreativeTabs_misc;

    @Override
    protected String categoryName() {
        return "WheatExtras";
    }

    @Override
    public void doBuildPrimaryObjects(FMLStateEvent event, VfpRuntime runtime) {
        DoughBallType.validState();
        VfpObj.Flour_Portion_obj = VfpBuilder.newPortion(VfpOid.Flour_Portion);
        VfpObj.Flour_Pantry_Block_obj = VfpBuilder.newStorageBlock(VfpOid.Flour_Pantry_Block, VfpObj.Flour_Portion_obj);
        VfpObj.Dough_Balls_obj = VfpBuilder.newMultiItem(VfpOid.Dough_Ball, DoughBall.class, VfpBuilder.User.INTERNAL);
        VfpObj.Dough_Pantry_Block_obj = VfpBuilder.newStorageBlock(VfpOid.Dough_Pantry_Block, VfpObj.Dough_Balls_obj);
        VfpObj.Breads_obj = Breads.get();
        VfpObj.Bread_Pockets_obj = PocketSandwiches.get();
        VfpObj.Muffins_obj = Muffins.get();
        VfpObj.Fries_obj = Fries.get();
        VfpObj.Oak_Acorn_obj = VfpBuilder.newItem(VfpOid.Oak_Acorn);
        VfpObj.Acornmeal_Portion_obj = VfpBuilder.newPortion(VfpOid.Acornmeal_Portion);
        VfpObj.Cornmeal_Portion_obj = VfpBuilder.newOptionalFood(VfpOid.Cornmeal_Portion, LikeFood.air, VfpAware.IdDomain.OREDICT, "foodCorn");
        VfpObj.Bucket_Seedoil_obj = VfpBuilder.newItem(VfpOid.Bucket_Seedoil).func_77642_a(MinecraftGlue.Items_bucket);
        VfpObj.Seedoil_Jar_obj = JJJJar.newJar((VfpProfile)VfpOid.Seedoil_Jar, 5, "portionOil").func_77642_a(VfpObj.Dark_Empty_Jar_obj);
        VfpObj.Sticky_Paste_obj = VfpBuilder.newAdditive(VfpOid.Sticky_Paste, MISC_TAB);
        VfpObj.Empty_Paper_Bag_obj = new VfpPlainItem((VfpProfile)VfpOid.Empty_Paper_Bag, MISC_TAB).autoregister();
        VfpObj.Carton_Side_Blank_obj = new VfpPlainItem((VfpProfile)VfpOid.Carton_Side_Blank, MISC_TAB).autoregister();
        VfpObj.Empty_Carton_obj = new VfpPlainItem((VfpProfile)VfpOid.Empty_Carton, MISC_TAB).autoregister();
        VfpObj.Empty_Jar_Carton_obj = new VfpPlainItem((VfpProfile)VfpOid.Empty_Jar_Carton, MISC_TAB).autoregister();
        OreDictionary.registerOre((String)"itemPackagingBox", (Item)VfpObj.Empty_Carton_obj);
        OreDictionary.registerOre((String)"foodDough", (ItemStack)DoughBallType.plain(1));
        OreDictionary.registerOre((String)"foodBreadFried", (ItemStack)DoughBallType.cookedPlain(1));
        OreDictionary.registerOre((String)"foodBreadFried", (ItemStack)DoughBallType.cookedSweet(1));
        OreDictionary.registerOre((String)"blockFlour", (Block)VfpObj.Flour_Pantry_Block_obj);
        OreDictionary.registerOre((String)"ingredientCereal", (Item)VfpObj.Acornmeal_Portion_obj);
        OreDictionary.registerOre((String)"seedOakAcorn", (Item)VfpObj.Oak_Acorn_obj);
        this.earlyInitLikeBreadFoods(runtime.getConfig());
    }

    @Override
    public void doBuildSecondaryObjects(FMLStateEvent event, VfpRuntime runtime) {
        List<String> mappings;
        VfpConfig config = runtime.getConfig();
        if (config.alwaysIncludeSimpleFlourRecipe()) {
            config.builderContext().put("simpleFlourRecipe", true);
        } else if (!config.isSuperCompatibilityMode() && !(mappings = config.capturedContextOres()).contains("foodFlour")) {
            if (mappings.contains("foodFlourWheat")) {
                NonNullList flours = OreDictionary.getOres((String)"foodFlourWheat");
                for (ItemStack flour : flours) {
                    if (flour.func_77948_v()) continue;
                    if (config.isDebugMode()) {
                        FMLLog.finer((String)"using pre-existing '%s' registration as 'foodFlour' default", (Object[])new Object[]{flour.func_77977_a()});
                    }
                    OreDictionary.registerOre((String)"foodFlour", (ItemStack)flour);
                    break;
                }
            }
            if (!VfpUtils.ingredientDefined("foodFlour")) {
                config.builderContext().put("simpleFlourRecipe", true);
            }
        }
        OreDictionary.registerOre((String)"foodFlour", (Item)VfpObj.Flour_Portion_obj);
        if (MinecraftGlue.ingredientDefinedLooking("foodCorn")) {
            OreDictionary.registerOre((String)"foodFlourCorn", (Item)VfpObj.Cornmeal_Portion_obj);
            if (!config.isPresent("cornmeal")) {
                config.setPresentAs("cornmeal", "foodFlourCorn");
            }
        }
    }

    private void earlyInitLikeBreadFoods(VfpConfig config) {
        LikeFood.mini_bread.food().item(DoughBallType.cookedPlain(1));
        LikeFood.mini_bread_halved.food().item(DoughBallType.cookedPlain(1));
        LikeFood.sandwich.food().item(VfpObj.Portion_Bread_obj);
        LikeFood.french_bread.food().item(Breads.french(1));
        LikeFood.enriched_bread.food().item(Breads.enriched(1));
        LikeFood.sandwich_bread.food().item(Breads.potato(1));
        LikeFood.specialty_bread.food().item(Breads.pumpkin(1));
        LikeFood.bread_pocket.food().item(VfpObj.Flat_Bread_Pocket_obj);
        LikeFood.muffin.food().item(Muffins.pumpkin(1));
    }

    @Override
    public void doBuildRecipes(VfpRuntime runtime) {
        VfpConfig config = runtime.getConfig();
        if (config.builderContext().containsKey("simpleFlourRecipe")) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(VfpObj.Flour_Portion_obj, 1), (Object[])new Object[]{MinecraftGlue.Items_wheat});
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Flour_Portion_obj, 2), new Object[]{MinecraftGlue.Items_wheat, MinecraftGlue.Items_wheat, "additiveDrying"}));
        VfpBuilder.autorecipe(this.categoryName(), VfpCapacity.STANDARD_BLOCK, (Object)VfpObj.Flour_Portion_obj, VfpObj.Flour_Pantry_Block_obj, VfpObj.Flour_Portion_obj);
        if (MinecraftGlue.ingredientDefinedLooking("foodCorn")) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Cornmeal_Portion_obj, 4), new Object[]{"foodCorn", "foodCorn", "additiveDrying"}));
        }
        GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem((IRecipe)new ShapelessOreRecipe(DoughBallType.plain(1), new Object[]{"foodFlour", "foodFlour", "additiveLeavening", "portionWaterSmall"}), LikeFood.mini_bread.craftExperience()));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(DoughBallType.sweet(1), new Object[]{"foodDough", "ingredientSweetener"}));
        VfpBuilder.autorecipe(this.categoryName(), VfpCapacity.STANDARD_BLOCK, (Object)DoughBallType.plain(1), new ItemStack(VfpObj.Dough_Pantry_Block_obj), DoughBallType.plain(1));
        GameRegistry.addSmelting((ItemStack)DoughBallType.plain(1), (ItemStack)DoughBallType.cookedPlain(2), (float)LikeFood.mini_bread.smeltExperience());
        GameRegistry.addSmelting((ItemStack)DoughBallType.sweet(1), (ItemStack)DoughBallType.cookedSweet(2), (float)LikeFood.mini_bread.smeltExperience());
        Breads.autorecipe(config);
        Muffins.autorecipe(config);
        PocketSandwiches.autorecipe(config);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(FoodPowders.get(FoodPowders.Type.VINEGAR, VfpCapacity.ADDITIVE_BATCH.count()), new Object[]{"www", "www", "Fbd", Character.valueOf('w'), MinecraftGlue.Items_wheat, Character.valueOf('F'), VfpObj.Fermenting_Bucket_obj, Character.valueOf('b'), "itemCheeseCloth", Character.valueOf('d'), "additiveDrying"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(JJJJar.full(VfpObj.Seedoil_Jar_obj, 2), new Object[]{"B ", "jj", Character.valueOf('j'), VfpObj.Dark_Empty_Jar_obj, Character.valueOf('B'), VfpObj.Bucket_Seedoil_obj}));
        Fries.autorecipe(config);
        this.buildPackagingRecipes(config);
    }

    private void buildPackagingRecipes(VfpConfig config) {
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Sticky_Paste_obj, 8), new Object[]{"foodFlour", "portionWaterSmall"}));
        Object[] ingredients = new Object[9];
        for (int i = 0; i < 8; ++i) {
            ingredients[i] = "foodFlour";
        }
        ingredients[8] = "portionWater";
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Sticky_Paste_obj, VfpCapacity.MAX_STACK.count()), ingredients));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Sticky_Paste_obj, VfpCapacity.MAX_STACK.count()), new Object[]{"blockFlour", "portionWater"}));
        if (VfpUtils.ingredientDefined("portionAdhesive")) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Sticky_Paste_obj, 16), new Object[]{"portionAdhesive", "portionWaterSmall"}));
        } else {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Sticky_Paste_obj, 16), new Object[]{"slimeball", "portionWaterSmall"}));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Empty_Paper_Bag_obj), new Object[]{"...", "PgP", ".P.", Character.valueOf('P'), "paper", Character.valueOf('g'), VfpObj.Sticky_Paste_obj}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Carton_Side_Blank_obj), new Object[]{"PPP", "ggg", "PPP", Character.valueOf('P'), "paper", Character.valueOf('g'), VfpObj.Sticky_Paste_obj}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Empty_Carton_obj), new Object[]{"PPP", "ggg", "PPP", Character.valueOf('P'), VfpObj.Carton_Side_Blank_obj, Character.valueOf('g'), VfpObj.Sticky_Paste_obj}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Empty_Jar_Carton_obj), new Object[]{"jjj", "jcj", "jjj", Character.valueOf('j'), VfpObj.Empty_Jar_obj, Character.valueOf('c'), VfpObj.Empty_Carton_obj}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Empty_Jar_obj, 8), new Object[]{VfpObj.Empty_Jar_Carton_obj}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(MinecraftGlue.Items_book), new Object[]{"c  ", "ppp", "c  ", Character.valueOf('c'), VfpObj.Carton_Side_Blank_obj, Character.valueOf('p'), "paper"}));
    }

    @Override
    public void doBuildAchievementList(FMLStateEvent event, VfpRuntime runtime) {
        VfpRewards.addRewardingCraftItem(DoughBallType.plain(1), VfpAchievements.Id.MakingDough);
        for (ItemStack bread : Breads.achievementCandidates()) {
            VfpRewards.addRewardingCraftItem(bread, VfpAchievements.Id.BakerPrime);
        }
        for (ItemStack muffin : Muffins.achievementCandidates()) {
            VfpRewards.addRewardingCraftItem(muffin, VfpAchievements.Id.NeverMuffed);
        }
    }

    @Override
    public void doInitRenderModels(FMLStateEvent event, VfpRuntime runtime) {
        if (!runtime.hasUI()) {
            return;
        }
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Flour_Portion, VfpObj.Flour_Portion_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Flour_Pantry_Block, VfpObj.Flour_Pantry_Block_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Dough_Ball, VfpObj.Dough_Balls_obj, DoughBallType.get());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Dough_Pantry_Block, VfpObj.Dough_Pantry_Block_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Breads, VfpObj.Breads_obj, Breads.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Portion_Bread, VfpObj.Portion_Bread_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Flat_Bread_Pocket, VfpObj.Flat_Bread_Pocket_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Oak_Acorn, VfpObj.Oak_Acorn_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Acornmeal_Portion, VfpObj.Acornmeal_Portion_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Cornmeal_Portion, VfpObj.Cornmeal_Portion_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Muffins, VfpObj.Muffins_obj, Muffins.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Bread_Pocket, VfpObj.Bread_Pockets_obj, PocketSandwiches.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Fries, VfpObj.Fries_obj, Fries.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Sticky_Paste, VfpObj.Sticky_Paste_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Empty_Paper_Bag, VfpObj.Empty_Paper_Bag_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Carton_Side_Blank, VfpObj.Carton_Side_Blank_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Empty_Carton, VfpObj.Empty_Carton_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Empty_Jar_Carton, VfpObj.Empty_Jar_Carton_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Bucket_Seedoil, VfpObj.Bucket_Seedoil_obj);
        JJJJar seedoil = (JJJJar)VfpObj.Seedoil_Jar_obj;
        runtime.doRenderSetupOrFail(VfpOid.Seedoil_Jar, seedoil, seedoil.getUsesRenderNames(), seedoil.getUsesRenderMetas());
    }
}

