/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.carton;

import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.carton.BagsOf;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.PackagedFood;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryCarton;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiBlock;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;

public final class BakeryCarton
extends VfpPantryCarton {
    static final Object MARKER = new int[0];
    private static final VfpVariantSet VARIANT_SET = new VfpPantryCarton.VariantSet(VfpOid.Bakery_Carton, BakeryCarton.class);
    private static BakeryCarton INSTANCE;
    private static ItemStack[] TYPED_INSTANCES;
    private static int _CAKE_META;

    public BakeryCarton() {
        super((VfpProfile)VfpOid.Bakery_Carton, MinecraftGlue.Blocks_sponge, VfpObj.Eek_obj, VARIANT_SET, null);
    }

    @Override
    protected int quantityStoredPerInnerContainer(ItemStack stack) {
        if (stack.func_77960_j() == _CAKE_META) {
            return 1;
        }
        return super.quantityStoredPerInnerContainer(stack);
    }

    static final synchronized BakeryCarton makeObjects() {
        if (INSTANCE == null) {
            PackagedFood.Type bakery = PackagedFood.Type.bakery;
            VfpVariant[] variants = PackagedFood.init(bakery, VARIANT_SET, VfpObj.Bag_of_obj, BagsOf.variantsFor(bakery.name()), Arrays.asList(PackagedFood.BREAD, PackagedFood.CAKE, PackagedFood.COCOA_SEED, PackagedFood.COOKIE, PackagedFood.XBREAD, PackagedFood.PUMPKIN_PIE, PackagedFood.EGG_PIE), false);
            Validate.validState((variants != null && variants.length > 0 ? 1 : 0) != 0, (String)"Unable to create VFP bakery carton variants", (Object[])new Object[0]);
            INSTANCE = VfpPantryMultiBlock.create(VARIANT_SET, BakeryCarton.class, true);
        }
        return INSTANCE;
    }

    static final synchronized ItemStack[] buildRecipes(IForgeRegistry<IRecipe> recipes) {
        Validate.validState((INSTANCE != null ? 1 : 0) != 0, (String)"BakeryCarton must be initialized before being used", (Object[])new Object[0]);
        TYPED_INSTANCES = VfpPantryCarton.autorecipe(recipes, INSTANCE);
        ItemStack cake = BakeryCarton.get(PackagedFood.CAKE);
        _CAKE_META = cake.func_77960_j();
        return TYPED_INSTANCES;
    }

    static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    public static final ItemStack get(PackagedFood food) {
        VfpVariant variant;
        if (PackagedFood.Type.bakery.name().equals(food.type()) && (variant = INSTANCE.findVariant(food)) != null) {
            for (ItemStack stack : TYPED_INSTANCES) {
                if (stack.func_77960_j() != variant.metadata()) continue;
                return stack.func_77946_l();
            }
        }
        return null;
    }

    static {
        _CAKE_META = -1;
    }
}

