/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpPotionTypes;
import toughasnails.api.TANPotions;
import toughasnails.api.config.GameplayOption;
import toughasnails.api.config.ISyncedOption;
import toughasnails.api.config.SyncedConfig;
import toughasnails.api.stat.capability.ITemperature;
import toughasnails.api.stat.capability.IThirst;
import toughasnails.api.temperature.IModifierMonitor;
import toughasnails.api.temperature.ITemperatureModifier;
import toughasnails.api.temperature.Temperature;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.api.temperature.TemperatureScale;
import toughasnails.api.thirst.ThirstHelper;

@ParametersAreNonnullByDefault
public final class TANHelper {
    public static ItemStack ICE_CUBE = null;
    static boolean ENABLED = false;

    public static final boolean isEnabled() {
        return ENABLED;
    }

    public static final void initFinal(VfpConfig config) {
        if (MinecraftGlue.ModIntegration.TOUGH_AS_NAILS.isLoaded()) {
            ICE_CUBE = MinecraftGlue.ModIntegration.TOUGH_AS_NAILS.itemstack("ice_cube");
            ENABLED = config.enableTANIntegration();
            if (ENABLED) {
                TemperatureHelper.registerTemperatureModifier((ITemperatureModifier)new WarmingFoodModifier());
                TemperatureHelper.registerTemperatureModifier((ITemperatureModifier)new CoolingFoodModifier());
            }
        }
    }

    @Optional.Method(modid="toughasnails")
    public static final boolean manageTemperature() {
        return ENABLED && SyncedConfig.getBooleanValue((ISyncedOption)GameplayOption.ENABLE_TEMPERATURE);
    }

    @Optional.Method(modid="toughasnails")
    public static final boolean manageThirst() {
        return ENABLED && SyncedConfig.getBooleanValue((ISyncedOption)GameplayOption.ENABLE_THIRST);
    }

    @Optional.Method(modid="toughasnails")
    private static final boolean isThirsty(IThirst cap) {
        return cap != null && cap.getThirst() < 20;
    }

    public static final boolean isThirsty(@Nullable World world, EntityPlayer player) {
        boolean is = false;
        if (MinecraftGlue.ModIntegration.TOUGH_AS_NAILS.isLoaded() && TANHelper.manageThirst()) {
            IThirst cap = ThirstHelper.getThirstData((EntityPlayer)player);
            is = TANHelper.isThirsty(cap);
        }
        return is;
    }

    public static final boolean quenchThirst(EntityPlayer player, int thirstAmount, float hydration, float impurityChance) {
        boolean quenched = false;
        if (MinecraftGlue.ModIntegration.TOUGH_AS_NAILS.isLoaded() && TANHelper.manageThirst()) {
            IThirst cap = ThirstHelper.getThirstData((EntityPlayer)player);
            quenched = TANHelper.isThirsty(cap);
            cap.setExhaustion(0.0f);
            cap.addStats(thirstAmount, hydration);
            if (impurityChance > 0.0f && TANPotions.thirst != null && player.func_70681_au().nextFloat() < impurityChance) {
                MinecraftGlue.Potions.addPotionEffect((EntityLivingBase)player, TANPotions.thirst, 30, 0);
            }
        }
        return quenched;
    }

    public static final void hydrateFor(int thirstAmount, EntityPlayer player) {
        IThirst cap;
        if (MinecraftGlue.ModIntegration.TOUGH_AS_NAILS.isLoaded() && TANHelper.manageThirst() && (cap = ThirstHelper.getThirstData((EntityPlayer)player)) != null && TANPotions.hydration != null) {
            player.func_70690_d(MinecraftGlue.Potions.newStubbornPotionEffect(TANPotions.hydration, 1 + thirstAmount, 0, false, false));
        }
    }

    public static final boolean isPlayerAtExtremeTemperature(EntityPlayer player, boolean hot) {
        ITemperature temp;
        boolean is = false;
        if (MinecraftGlue.ModIntegration.TOUGH_AS_NAILS.isLoaded() && TANHelper.manageTemperature() && (temp = TemperatureHelper.getTemperatureData((EntityPlayer)player)) != null) {
            is = TemperatureScale.isScalePosInRange((int)temp.getTemperature().getRawValue(), (TemperatureScale.TemperatureRange)(hot ? TemperatureScale.TemperatureRange.HOT : TemperatureScale.TemperatureRange.ICY));
        }
        return is;
    }

    public static final boolean coolIfHot(EntityPlayer player, int instantCooldown, int ongoingTimesecs, int fortifyTimesecs) {
        int scaleValue;
        ITemperature temp;
        boolean cooled = false;
        if (MinecraftGlue.ModIntegration.TOUGH_AS_NAILS.isLoaded() && TANHelper.manageTemperature() && (temp = TemperatureHelper.getTemperatureData((EntityPlayer)player)) != null && TemperatureScale.isScalePosInRange((int)(scaleValue = temp.getTemperature().getRawValue()), (TemperatureScale.TemperatureRange)TemperatureScale.TemperatureRange.WARM, (TemperatureScale.TemperatureRange)TemperatureScale.TemperatureRange.HOT)) {
            boolean bl = cooled = instantCooldown > 0;
            if (cooled) {
                temp.setTemperature(new Temperature(scaleValue - instantCooldown));
                if (instantCooldown > 1) {
                    player.func_184589_d(TANPotions.hyperthermia);
                }
                if (ongoingTimesecs > 0) {
                    MinecraftGlue.Potions.addPotionEffect((EntityLivingBase)player, VfpPotionTypes.FOOD_COOLING, ongoingTimesecs, instantCooldown - 1);
                }
            }
            if (fortifyTimesecs > 0 && TANPotions.heat_resistance != null) {
                MinecraftGlue.Potions.addPotionEffect((EntityLivingBase)player, TANPotions.heat_resistance, fortifyTimesecs, 0, false, false);
            }
        }
        return cooled;
    }

    public static final boolean coolIfHot(EntityPlayer player, int instantCooldown, int ongoingTimesecs) {
        return TANHelper.coolIfHot(player, instantCooldown, ongoingTimesecs, -1);
    }

    public static final boolean warmIfCold(EntityPlayer player, int instantWarmup, int ongoingTimesecs, int fortifyTimesecs) {
        int scaleValue;
        ITemperature temp;
        boolean warmed = false;
        if (MinecraftGlue.ModIntegration.TOUGH_AS_NAILS.isLoaded() && TANHelper.manageTemperature() && (temp = TemperatureHelper.getTemperatureData((EntityPlayer)player)) != null && TemperatureScale.isScalePosInRange((int)(scaleValue = temp.getTemperature().getRawValue()), (TemperatureScale.TemperatureRange)TemperatureScale.TemperatureRange.ICY, (TemperatureScale.TemperatureRange)TemperatureScale.TemperatureRange.COOL)) {
            boolean bl = warmed = instantWarmup > 0;
            if (warmed) {
                temp.setTemperature(new Temperature(scaleValue + instantWarmup));
                if (instantWarmup > 1) {
                    player.func_184589_d(TANPotions.hypothermia);
                }
                if (ongoingTimesecs > 0) {
                    MinecraftGlue.Potions.addPotionEffect((EntityLivingBase)player, VfpPotionTypes.FOOD_WARMING, ongoingTimesecs, instantWarmup - 1);
                }
            }
            if (fortifyTimesecs > 0 && TANPotions.cold_resistance != null) {
                MinecraftGlue.Potions.addPotionEffect((EntityLivingBase)player, TANPotions.cold_resistance, fortifyTimesecs, 0, false, false);
            }
        }
        return warmed;
    }

    public static final boolean warmIfCold(EntityPlayer player, int instantWarmup, int ongoingTimesecs) {
        return TANHelper.warmIfCold(player, instantWarmup, ongoingTimesecs, -1);
    }

    @Optional.Interface(iface="toughasnails.api.temperature.ITemperatureModifier", modid="toughasnails")
    static final class CoolingFoodModifier
    implements ITemperatureModifier {
        CoolingFoodModifier() {
        }

        @Optional.Method(modid="toughasnails")
        public String getId() {
            return "vanillafoodpantry:coldfood";
        }

        @Optional.Method(modid="toughasnails")
        public boolean isPlayerSpecific() {
            return true;
        }

        @Optional.Method(modid="toughasnails")
        public Temperature applyEnvironmentModifiers(World w, BlockPos pos, Temperature iniT, IModifierMonitor m) {
            return iniT;
        }

        @Optional.Method(modid="toughasnails")
        public Temperature applyPlayerModifiers(EntityPlayer player, Temperature iniT, IModifierMonitor m) {
            Temperature outT = iniT;
            Potion p = VfpPotionTypes.FOOD_COOLING;
            if (TANHelper.manageTemperature() && player.func_70644_a(p)) {
                int newT = iniT.getRawValue();
                m.addEntry(new IModifierMonitor.Context(this.getId(), MinecraftGlue.Strings.translate("removeme.tooltip.tan.colddrink.name"), iniT, new Temperature(newT -= MathHelper.func_76125_a((int)(1 + player.func_70660_b(p).func_76458_c()), (int)1, (int)4))));
                outT = new Temperature(newT);
            }
            return outT;
        }
    }

    @Optional.Interface(iface="toughasnails.api.temperature.ITemperatureModifier", modid="toughasnails")
    static final class WarmingFoodModifier
    implements ITemperatureModifier {
        WarmingFoodModifier() {
        }

        @Optional.Method(modid="toughasnails")
        public String getId() {
            return "vanillafoodpantry:warmfood";
        }

        @Optional.Method(modid="toughasnails")
        public boolean isPlayerSpecific() {
            return true;
        }

        @Optional.Method(modid="toughasnails")
        public Temperature applyEnvironmentModifiers(World w, BlockPos pos, Temperature iniT, IModifierMonitor m) {
            return iniT;
        }

        @Optional.Method(modid="toughasnails")
        public Temperature applyPlayerModifiers(EntityPlayer player, Temperature iniT, IModifierMonitor m) {
            Temperature outT = iniT;
            Potion p = VfpPotionTypes.FOOD_WARMING;
            if (TANHelper.manageTemperature() && player.func_70644_a(p)) {
                int newT = iniT.getRawValue();
                m.addEntry(new IModifierMonitor.Context(this.getId(), MinecraftGlue.Strings.translate("removeme.tooltip.tan.warmfood.name"), iniT, new Temperature(newT += MathHelper.func_76125_a((int)(1 + player.func_70660_b(p).func_76458_c()), (int)1, (int)4))));
                outT = new Temperature(newT);
            }
            return outT;
        }
    }
}

