/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.smarthoppers.apis.IContraption;
import org.jwaresoftware.mcmods.smarthoppers.apis.IMultiuse;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpPlainItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;

@Optional.Interface(iface="org.jwaresoftware.mcmods.smarthoppers.apis.IMultiuse", modid="smarthoppers")
public class VfpMultiUseJarIngredient
extends VfpPlainItem
implements IMultiuse {
    public static final int DEFAULT_MAX_USES = 6;
    private final int _MAX_USES;
    protected boolean _useDurabilityBar;

    public VfpMultiUseJarIngredient(VfpProfile oid, int max_uses, boolean durability) {
        super(oid);
        Validate.isTrue((max_uses > 1 ? 1 : 0) != 0, (String)"More than one use is required for multiuse jar!", (Object[])new Object[0]);
        this._MAX_USES = max_uses;
        this._useDurabilityBar = durability;
        this.func_77625_d(VfpCapacity.LIQUID_STACK.count());
        this.func_185043_a(new ResourceLocation("uses"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, World world, EntityLivingBase entity) {
                return VfpMultiUseJarIngredient.getUsesLeft(stack);
            }
        });
        this.autoregister();
    }

    public VfpMultiUseJarIngredient(VfpProfile oid) {
        this(oid, 6, false);
    }

    public static VfpMultiUseJarIngredient newPlainJar(VfpProfile oid, int uses) {
        if (uses <= 0) {
            uses = 6;
        }
        return new VfpMultiUseJarIngredient(oid, uses, false);
    }

    public static VfpMultiUseJarIngredient newPlainJar(VfpProfile oid) {
        return new VfpMultiUseJarIngredient(oid);
    }

    public static final boolean isa(@Nullable ItemStack stack) {
        return !MinecraftGlue.ItemStacks_isEmpty(stack) && stack.func_77973_b() instanceof VfpMultiUseJarIngredient;
    }

    public final int getMaxUses() {
        return this._MAX_USES;
    }

    static final int getMaxUses(@Nonnull ItemStack jar) {
        return ((VfpMultiUseJarIngredient)jar.func_77973_b()).getMaxUses();
    }

    public static final int getUsesLeft(@Nonnull ItemStack jar) {
        int maxUses = VfpMultiUseJarIngredient.getMaxUses(jar);
        return MinecraftGlue.Instructions.getCheckedCapacity(jar, maxUses, maxUses);
    }

    protected final void setUsesLeft(ItemStack jar, int amount) {
        MinecraftGlue.Instructions.setCapacity(jar, amount);
    }

    protected void initDefaultContents(ItemStack jar) {
        this.setUsesLeft(jar, this.getMaxUses());
    }

    public ItemStack getNewEmptyContainer(@Nonnull ItemStack jar) {
        Item emptyJar = VfpObj.Empty_Jar_obj;
        if (super.func_77668_q() != null) {
            emptyJar = super.func_77668_q();
        }
        return new ItemStack(emptyJar);
    }

    public void func_77622_d(ItemStack jar, World world_unused, EntityPlayer player_unused) {
        this.initDefaultContents(jar);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return VfpMultiUseJarIngredient.isa(stack) ? VfpMultiUseJarIngredient.getUsesLeft(stack) > 0 : false;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        int left;
        ItemStack out = MinecraftGlue.ItemStacks_NULLSTACK();
        int n = left = VfpMultiUseJarIngredient.isa(stack) ? VfpMultiUseJarIngredient.getUsesLeft(stack) : -1;
        if (left > 1) {
            out = stack.func_77946_l();
            out.func_190920_e(1);
            this.setUsesLeft(out, left - 1);
        } else if (left == 1) {
            out = this.getNewEmptyContainer(stack);
        }
        return out;
    }

    @Optional.Method(modid="smarthoppers")
    public boolean represents(ItemStack multiuse, ItemStack candidate, IContraption smhc) {
        return ItemStack.func_185132_d((ItemStack)multiuse, (ItemStack)candidate);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack jar, World world, List tooltip, ITooltipFlag flags) {
        int left;
        super.func_77624_a(jar, world, tooltip, flags);
        if (!this._useDurabilityBar && (left = VfpMultiUseJarIngredient.getUsesLeft(jar)) > 0) {
            tooltip.add(MinecraftGlue.Strings.translateFormatted(left == 1 ? "multiuse.left.1" : "multiuse.left.n", left));
        }
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            ItemStack newjar = new ItemStack((Item)this);
            this.initDefaultContents(newjar);
            subItems.add((Object)newjar);
        }
    }

    public boolean showDurabilityBar(ItemStack jar) {
        return this._useDurabilityBar && VfpMultiUseJarIngredient.getUsesLeft(jar) < VfpMultiUseJarIngredient.getMaxUses(jar);
    }

    public double getDurabilityForDisplay(ItemStack jar) {
        double left = VfpMultiUseJarIngredient.getUsesLeft(jar);
        double total = VfpMultiUseJarIngredient.getMaxUses(jar);
        return total - left / total;
    }

    public String func_77653_i(ItemStack jar) {
        String displayName = super.func_77653_i(jar);
        if (this._useDurabilityBar) {
            displayName = MinecraftGlue.Strings.translateFormatted("tooltip.itemsuffix.XofY.int", displayName, VfpMultiUseJarIngredient.getUsesLeft(jar), VfpMultiUseJarIngredient.getMaxUses(jar));
        }
        return displayName;
    }
}

