/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.common.FoodPortion;
import org.jwaresoftware.mcmods.vfp.common.IReheatable;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpAware;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpPotionTypes;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import squeek.applecore.api.food.FoodValues;
import squeek.applecore.api.food.IEdible;

@Optional.InterfaceList(value={@Optional.Interface(iface="squeek.applecore.api.food.IEdible", modid="applecore")})
public class VfpPantryItem
extends ItemFood
implements VfpAware,
IEdible {
    public static final int DEFAULT_GOOD_POTION_EFFECT_DURATION_SECS = 30;
    public static final int DEFAULT_BAD_POTION_EFFECT_DURATION_SECS = 15;
    private static final int MAX_FOOD_POINTS_ALLOWED = 20;
    private static final int PORTION_FOOD_AMOUNT = 4;
    private static final int MAX_PORTION_FOOD_AMOUNT = 8;
    public static final int MAX_TOTAL_FOOD_VALUE_ALLOWED = LikeFood.HEFTIEST_FOOD.healAmount() * MinecraftGlue.TABLE_CRAFT_GRID_SIZE();
    static final float MAX_FOOD_SATURATION_ALLOWED = MinecraftGlue.DEFAULT_MAX_PLAYER_SATURATION_LEVEL();
    private static final String _NBT_FOOD_TOTAL_USED = "FoodUsed";
    private static final String _NBT_FOOD_TOTAL = "FoodTotal";
    private static final String _NBT_FOOD_PER_USE = "FoodPortion";
    protected static final String _NBT_FOOD_SATURATION = "FoodSaturation";
    static final TextFormatting _BLUE = TextFormatting.BLUE;
    static final TextFormatting _ENDD = TextFormatting.RESET;
    protected final VfpProfile _oid;
    protected final boolean _debugFlag;
    protected boolean _alwaysEdibleFlag;
    protected PotionEffect _potionEffect;
    protected float _effectProbability;
    protected final int _foodPoints;
    protected final float _saturationModifier;
    protected boolean _returnContainerOnConsumed;

    protected VfpPantryItem(VfpProfile oid, int foodPoints, float saturationFactor, boolean isWolfFood, CreativeTabs tab, boolean delayed) {
        super(foodPoints, saturationFactor, isWolfFood);
        Validate.isTrue((boolean)oid.isItem(), (String)"A pantry item's VFP type MUST align as an Item", (Object[])new Object[0]);
        this._oid = oid;
        this._debugFlag = VfpConfig.getInstance().isDebugMode();
        this._foodPoints = foodPoints;
        this._saturationModifier = saturationFactor;
        this.func_77655_b(oid.fmlid());
        tab = VfpUtils.bestTab(tab, null);
        if (tab != null) {
            this.func_77637_a(tab);
        }
        if (!delayed) {
            this.completeInit(oid);
        }
    }

    public VfpPantryItem(VfpProfile oid, int foodLevel, float saturationFactor, boolean isWolfFood, CreativeTabs tab) {
        this(oid, foodLevel, saturationFactor, isWolfFood, tab, false);
    }

    public VfpPantryItem(VfpProfile oid, int foodLevel, float saturationFactor, CreativeTabs tab) {
        this(oid, foodLevel, saturationFactor, false, tab);
    }

    public VfpPantryItem(VfpProfile oid, LikeFood like, CreativeTabs tab) {
        this(oid, like.healAmount(), like.saturationModifier(), false, tab);
    }

    public VfpPantryItem(VfpProfile oid, LikeFood like, CreativeTabs tab, boolean delayed) {
        this(oid, like.healAmount(), like.saturationModifier(), false, tab, delayed);
    }

    public VfpPantryItem(VfpProfile oid, LikeFood like, boolean isWolfFood, CreativeTabs tab) {
        this(oid, like.healAmount(), like.saturationModifier(), isWolfFood, tab);
    }

    public VfpPantryItem(VfpProfile oid) {
        this(oid, LikeFood.crumb, null);
    }

    @Override
    public final VfpProfile vfplink() {
        return this._oid;
    }

    public final <T extends VfpPantryItem> T autoregister(Class<T> of) {
        VfpUtils.autoregisterItem((Item)this, this._oid.fmlid());
        return (T)((VfpPantryItem)of.cast(this));
    }

    public final VfpPantryItem autoregister() {
        VfpUtils.autoregisterItem((Item)this, this._oid.fmlid());
        return this;
    }

    public final VfpPantryItem setConsumeFullyContainerItem(@Nonnull Item containerItem) {
        this.func_77642_a(containerItem);
        this._returnContainerOnConsumed = true;
        return this;
    }

    public final ItemFood func_77848_i() {
        this._alwaysEdibleFlag = true;
        return super.func_77848_i();
    }

    protected boolean isEdible(@Nullable ItemStack stack) {
        return this._oid.isEdible();
    }

    protected boolean isDrinkable(@Nullable ItemStack stack) {
        return this.isEdible(stack) && this._oid.isLiquid();
    }

    protected boolean isEdibleUse(ItemStack stack) {
        return this.isEdible(stack) && (stack == null || this.func_150905_g(stack) > 0);
    }

    protected boolean isMultiuse(ItemStack stack) {
        return this._oid.isCompressible() && this.isEdible(stack) && stack.func_77973_b() == this && MinecraftGlue.Instructions.hasXFoodFlag(stack);
    }

    @Nullable
    protected IReheatable getTemperatureChangeCapability(ItemStack stack) {
        IReheatable spi = null;
        if (!MinecraftGlue.ItemStacks_isEmpty(stack) && this.isEdible(stack) && stack.func_77973_b() instanceof IReheatable) {
            spi = (IReheatable)stack.func_77973_b();
        }
        return spi;
    }

    protected void completeInit(VfpProfile oid) {
        if (this.isEdible(null)) {
            if (oid.isHarmfulIfEatenDirectly()) {
                float chance = 0.0625f;
                if (oid.isHarmfulIfEatenDirectlyAlways()) {
                    chance = 1.0f;
                }
                this.addPotionEffect(MinecraftGlue.Potion_poison, this.getPotionEffectDurationSecs(false), 1, chance);
            } else if (oid.isEmptyCalorieSugarHigh()) {
                this.addPotionEffect(MinecraftGlue.Potion_moveSpeed, this.getPotionEffectDurationSecs(true), 1, 1.0f);
                this.func_77848_i();
            }
        }
    }

    protected int getPotionEffectDurationSecs(boolean good) {
        return good ? 30 : 15;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return !this.isEdibleUse(stack) ? EnumAction.NONE : (this.isDrinkable(stack) ? EnumAction.DRINK : super.func_77661_b(stack));
    }

    public int func_77626_a(ItemStack stack) {
        return !this.isEdibleUse(stack) ? 0 : (this.func_150905_g(stack) <= LikeFood.cookie.healAmount() ? MinecraftGlue.SHORT_FOOD_CONSUME_DURATION() : super.func_77626_a(stack));
    }

    protected int getDefaultPortionFoodPoints() {
        return -1;
    }

    public int getPortionFoodPoints(ItemStack stack) {
        int amount = this._foodPoints;
        if (this.isMultiuse(stack)) {
            NBTTagCompound instr = MinecraftGlue.Instructions.get(stack);
            if (instr.func_150297_b(_NBT_FOOD_PER_USE, 99)) {
                amount = instr.func_74762_e(_NBT_FOOD_PER_USE);
            } else {
                amount = this.getDefaultPortionFoodPoints();
                if (amount <= 0) {
                    amount = 4;
                }
            }
        }
        return amount;
    }

    public int getFoodPointsUsed(@Nonnull ItemStack stack) {
        int amount = -1;
        if (this.isMultiuse(stack)) {
            NBTTagCompound instr = MinecraftGlue.Instructions.get(stack);
            amount = instr.func_74762_e(_NBT_FOOD_TOTAL_USED);
        }
        return amount;
    }

    public int getTotalFoodPoints(@Nonnull ItemStack stack) {
        NBTTagCompound instr;
        int amount = this.getPortionFoodPoints(stack);
        if (this.isMultiuse(stack) && (instr = MinecraftGlue.Instructions.get(stack)).func_150297_b(_NBT_FOOD_TOTAL, 99)) {
            amount = instr.func_74762_e(_NBT_FOOD_TOTAL);
        }
        return amount;
    }

    public boolean setFoodPointsUsed(@Nonnull ItemStack stack, int foodAmount) {
        boolean fullyConsumed = true;
        if (this.isMultiuse(stack)) {
            NBTTagCompound instr = MinecraftGlue.Instructions.get(stack);
            int totalFoodAmount = instr.func_74762_e(_NBT_FOOD_TOTAL);
            instr.func_74768_a(_NBT_FOOD_TOTAL_USED, MathHelper.func_76125_a((int)foodAmount, (int)0, (int)totalFoodAmount));
            fullyConsumed = foodAmount >= totalFoodAmount;
        }
        return fullyConsumed;
    }

    public final int getAvailableFoodPoints(ItemStack stack) {
        int amount;
        if (this.isMultiuse(stack)) {
            amount = this.getTotalFoodPoints(stack) - this.getFoodPointsUsed(stack);
            amount = MathHelper.func_76125_a((int)amount, (int)0, (int)MAX_TOTAL_FOOD_VALUE_ALLOWED);
        } else {
            amount = this.getPortionFoodPoints(stack);
        }
        return amount;
    }

    public int func_150905_g(ItemStack stack) {
        NBTTagCompound instr;
        int left;
        int amount = this.getPortionFoodPoints(stack);
        if (this.isMultiuse(stack) && (left = (instr = MinecraftGlue.Instructions.get(stack)).func_74762_e(_NBT_FOOD_TOTAL) - instr.func_74762_e(_NBT_FOOD_TOTAL_USED)) < amount) {
            amount = left;
        }
        return amount;
    }

    protected final float computeSaturationModifierForWarmedFood(ItemStack stack, float modifier, float warmedMultiplier, boolean scaled) {
        IReheatable t_cap;
        if (modifier > 0.0f && (t_cap = this.getTemperatureChangeCapability(stack)) != null && t_cap.isHeated(stack)) {
            modifier *= warmedMultiplier;
            if (scaled) {
                // empty if block
            }
        }
        return modifier;
    }

    public int getItemStackLimit(ItemStack stack) {
        if (this.getFoodPointsUsed(stack) > 0) {
            return 1;
        }
        IReheatable t_cap = this.getTemperatureChangeCapability(stack);
        if (t_cap != null && t_cap.hasBonusTemperature(stack)) {
            return 1;
        }
        return super.getItemStackLimit(stack);
    }

    @Optional.Method(modid="applecore")
    public FoodValues getFoodValues(@Nonnull ItemStack stack) {
        FoodValues portion = FoodPortion.getCurrentThreadFoodValues();
        return portion != null ? portion : new FoodValues(this.func_150905_g(stack), this.func_150906_h(stack));
    }

    protected static ItemStack initMultiuseInstance(@Nonnull ItemStack food, int foodTotal, int foodPerUse) {
        NBTTagCompound instr = MinecraftGlue.Instructions.createshell(food);
        instr.func_74757_a("XFood", true);
        instr.func_74768_a(_NBT_FOOD_TOTAL, foodTotal);
        if (foodPerUse > 0) {
            instr.func_74768_a(_NBT_FOOD_PER_USE, foodPerUse);
        }
        return food;
    }

    protected static ItemStack createMultiuseInstance(Item item, int amount, int meta, int foodTotal, int foodPerUse) {
        ItemStack food = new ItemStack(item, amount, meta);
        return VfpPantryItem.initMultiuseInstance(food, foodTotal, foodPerUse);
    }

    public ItemStack createInstance(Item item, int amount, int meta) {
        if (item == null) {
            item = this;
        }
        return this._oid.isCompressible() && this._oid.isEdible() && this._foodPoints > MinecraftGlue.HEARTY_FOOD_POINTS_THRESHOLD() ? VfpPantryItem.createMultiuseInstance(item, amount, meta, this._foodPoints, this.getDefaultPortionFoodPoints()) : new ItemStack(item, amount, meta);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        boolean show = super.showDurabilityBar(stack);
        if (this.isMultiuse(stack)) {
            NBTTagCompound instr = MinecraftGlue.Instructions.get(stack);
            show = instr.func_74762_e(_NBT_FOOD_TOTAL_USED) > 0;
        }
        return show;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        NBTTagCompound instr;
        double durability = super.getDurabilityForDisplay(stack);
        if (this.isMultiuse(stack) && (instr = MinecraftGlue.Instructions.get(stack)).func_74762_e(_NBT_FOOD_TOTAL_USED) > 0) {
            double foodUsed = instr.func_74769_h(_NBT_FOOD_TOTAL_USED);
            double foodTotal = instr.func_74769_h(_NBT_FOOD_TOTAL);
            durability = foodUsed / foodTotal;
        }
        return durability;
    }

    protected boolean canConsume(ItemStack held, World world, EntityPlayer player) {
        return player.func_71043_e(this._alwaysEdibleFlag);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack held = player.func_184586_b(hand);
        EnumActionResult r = EnumActionResult.FAIL;
        if ((MinecraftGlue.ItemStacks_getSize(held) == 1 || !this.isMultiuse(held)) && this.canConsume(held, world, player)) {
            player.func_184598_c(hand);
            r = EnumActionResult.SUCCESS;
        }
        return ActionResult.newResult((EnumActionResult)r, (Object)held);
    }

    protected final void onPortionConsumed(ItemStack eaten, int foodAmount, float foodSaturation, World world, EntityPlayer player) {
        FoodPortion.onConsumed(eaten, foodAmount, foodSaturation, world, player);
        MinecraftGlue.Effects.playFoodConsumed(world, player);
        player.func_71029_a(StatList.func_188057_b((Item)this));
    }

    public static final ItemStack returnOrDropContainer(ItemStack remaining, EntityPlayer player, @Nonnull ItemStack emptyContainer) {
        if (MinecraftGlue.getPlayerInSurvival(player)) {
            if (MinecraftGlue.ItemStacks_isEmpty(remaining)) {
                return emptyContainer;
            }
            if (!player.field_71071_by.func_70441_a(emptyContainer)) {
                player.func_71019_a(emptyContainer, false);
            }
        }
        return remaining;
    }

    protected ItemStack onItemConsumedFully(ItemStack original, ItemStack remaining, World world, EntityPlayer player) {
        ItemStack container;
        if (this._returnContainerOnConsumed && original.func_77973_b().hasContainerItem(original) && !MinecraftGlue.ItemStacks_isEmpty(container = original.func_77973_b().getContainerItem(original))) {
            remaining = VfpPantryItem.returnOrDropContainer(remaining, player, container);
        }
        return remaining;
    }

    public ItemStack func_77654_b(ItemStack food, World world, EntityLivingBase entityLiving) {
        ItemStack remaining = food;
        EntityPlayer player = MinecraftGlue.getPlayerOrNull((Entity)entityLiving);
        if (player == null) {
            if (MinecraftGlue.ItemStacks_decrBy(food, 1)) {
                remaining = MinecraftGlue.ItemStacks_NULLSTACK();
            }
        } else {
            boolean consumedFully = false;
            ItemStack original = MinecraftGlue.ItemStacks_copyItemStackSingle(food);
            if (!this.isMultiuse(food)) {
                this.onPortionConsumed(food, this.func_150905_g(food), this.func_150906_h(food), world, player);
                if (MinecraftGlue.getPlayerInSurvival(player) && MinecraftGlue.ItemStacks_decrBy(food, 1)) {
                    remaining = MinecraftGlue.ItemStacks_NULLSTACK();
                }
                consumedFully = true;
            } else {
                int useAmount;
                int maxFoodAmount = 8;
                int minFoodAmount = this.getPortionFoodPoints(food);
                boolean needSaturation = false;
                if (player.func_110143_aJ() < player.func_110138_aP() * 0.75f) {
                    maxFoodAmount *= 2;
                    needSaturation = true;
                }
                if ((useAmount = 20 - player.func_71024_bL().func_75116_a()) > maxFoodAmount) {
                    useAmount = maxFoodAmount;
                }
                if (useAmount < minFoodAmount && (needSaturation || useAmount > 3)) {
                    useAmount = minFoodAmount;
                }
                int foodUsed = this.getFoodPointsUsed(food);
                int foodLeft = this.getTotalFoodPoints(food) - (foodUsed + useAmount);
                if (foodLeft <= 0) {
                    this.onPortionConsumed(food, useAmount += foodLeft, this.func_150906_h(food), world, player);
                    if (MinecraftGlue.getPlayerInSurvival(player) && MinecraftGlue.ItemStacks_decrBy(food, 1)) {
                        remaining = MinecraftGlue.ItemStacks_NULLSTACK();
                    }
                    consumedFully = true;
                } else {
                    this.onPortionConsumed(food, useAmount, this.func_150906_h(food), world, player);
                    if (MinecraftGlue.isaServerWorld((IBlockAccess)world)) {
                        this.setFoodPointsUsed(remaining, foodUsed + useAmount);
                    }
                }
            }
            this.onFoodEaten(original, remaining, world, player);
            if (consumedFully) {
                remaining = this.onItemConsumedFully(original, remaining, world, player);
            }
        }
        return remaining;
    }

    protected void applyPotionEffectsOnConsumed(ItemStack original, ItemStack remaining, World world, EntityPlayer player) {
        if (this._potionEffect != null && player.func_70681_au().nextFloat() < this._effectProbability) {
            player.func_70690_d(new PotionEffect(this._potionEffect));
        }
        if (this._oid.isHarmfulIfEatenDirectly()) {
            boolean apply;
            boolean bl = apply = this._oid.isHarmfulIfEatenDirectlyAlways() || player.func_70681_au().nextFloat() < 0.25f;
            if (apply) {
                MinecraftGlue.Potions.addPotionEffects((EntityLivingBase)player, VfpPotionTypes.FOOD_POISONING);
            }
        }
    }

    protected final void func_77849_c(ItemStack remaining, World world, EntityPlayer player) {
    }

    protected void onFoodEaten(ItemStack original, ItemStack remaining, World world, EntityPlayer player) {
        if (MinecraftGlue.isaServerWorld((IBlockAccess)world)) {
            this.applyPotionEffectsOnConsumed(original, remaining, world, player);
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193138_y.func_193148_a((EntityPlayerMP)player, original);
            }
        }
    }

    public final ItemFood func_185070_a(PotionEffect effect, float chance) {
        this._potionEffect = effect;
        this._effectProbability = chance;
        return this;
    }

    protected void addPotionEffect(Potion potion, int duration_secs, int amplifier, float chance) {
        MinecraftGlue.Potions.addPotionEffect(this, potion, duration_secs, amplifier, chance);
    }

    protected void addFoodPointsInformation_(ItemStack stack, World world, List<String> tooltip, boolean advanced) {
        IReheatable t_cap;
        if (this.isMultiuse(stack)) {
            int availPts = this.getAvailableFoodPoints(stack);
            int usesLeft = MathHelper.func_76123_f((float)((float)availPts / (float)this.getPortionFoodPoints(stack)));
            if (advanced) {
                tooltip.add(MinecraftGlue.Strings.translateFormatted("multiuse.food.left.advanced", usesLeft, availPts));
            } else {
                tooltip.add(MinecraftGlue.Strings.translateFormatted("multiuse.food.left", usesLeft));
            }
        }
        if ((t_cap = this.getTemperatureChangeCapability(stack)) != null) {
            t_cap.addBonusTemperatureInformation(stack, world, tooltip);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flags) {
        this.addFoodPointsInformation_(stack, world, tooltip, flags.func_194127_a() | this._debugFlag);
        if (this._debugFlag && this.isEdible(stack)) {
            String displayString = "VFP: " + _BLUE + "H: " + _ENDD + this.func_150905_g(stack) + ", " + _BLUE + "S: " + _ENDD + String.format("%.3f", Float.valueOf(this.func_150906_h(stack)));
            tooltip.add(displayString);
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            subItems.add((Object)this.createInstance((Item)this, 1, 0));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !oldStack.func_77969_a(newStack);
    }

    protected static final String _toString(ItemStack stack) {
        VfpPantryItem item;
        StringBuilder sb = new StringBuilder(50);
        sb.append(String.valueOf(stack));
        if (stack.func_77973_b() instanceof VfpPantryItem && (item = (VfpPantryItem)stack.func_77973_b()).isMultiuse(stack)) {
            sb.append("[");
            sb.append(item.getFoodPointsUsed(stack));
            sb.append("/");
            sb.append(item.getTotalFoodPoints(stack));
            sb.append("]");
        }
        return sb.toString();
    }
}

