/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpAware;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;

public class VfpPlainItem
extends Item
implements VfpAware {
    public static final String NBT_PORTION_CAPACITY = "PortionCapacity";
    public static final String NBT_PORTION_TYPE = "PortionType";
    protected final VfpProfile _oid;
    protected boolean _hidden = false;
    private boolean _uncommonFlag = false;

    public VfpPlainItem(VfpProfile oid, boolean hide, CreativeTabs tab) {
        Validate.isTrue((boolean)oid.isItem(), (String)"A plain item's VFP type MUST align as an Item", (Object[])new Object[0]);
        this._oid = oid;
        this._hidden = hide;
        this.func_77655_b(oid.fmlid());
        if (!hide) {
            tab = VfpUtils.bestTab(tab, MinecraftGlue.CreativeTabs_materials);
            this.func_77637_a(tab);
        }
    }

    public VfpPlainItem(VfpProfile oid, CreativeTabs tab) {
        this(oid, false, tab);
    }

    public VfpPlainItem(VfpProfile oid) {
        this(oid, false, null);
    }

    public VfpPlainItem(VfpProfile oid, boolean hide) {
        this(oid, hide, null);
    }

    public VfpPlainItem setUncommon(boolean flag) {
        this._uncommonFlag = flag;
        return this;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        EnumRarity e = super.func_77613_e(stack);
        return e == EnumRarity.COMMON ? (this._uncommonFlag ? EnumRarity.UNCOMMON : e) : e;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment e) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this._hidden) {
            super.func_150895_a(tab, subItems);
        }
    }

    @Override
    public final VfpProfile vfplink() {
        return this._oid;
    }

    public final <T extends VfpPlainItem> T autoregister(Class<T> of) {
        VfpUtils.autoregisterItem(this, this._oid.fmlid());
        return (T)((VfpPlainItem)of.cast(this));
    }

    public final VfpPlainItem autoregister() {
        VfpUtils.autoregisterItem(this, this._oid.fmlid());
        return this;
    }
}

