/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.HashMap;
import net.minecraft.init.PotionTypes;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.brewing.PotionBrewEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpMarkerPotion;

public final class VfpPotionTypes {
    private static final int _1MIN = 60;
    private static final int _3MINS = 180;
    private static final int _5MINS = 300;
    private static final int _8MINS = 480;
    public static Potion FOOD_WARMING;
    public static Potion FOOD_COOLING;
    public static PotionType STRONG_STIMULANT;
    public static PotionType WATER_NATIVE;
    public static PotionType LONG_WATER_NATIVE;
    public static PotionType WOLF_SPIRIT;
    public static PotionType SUPER_WOLF_SPIRIT;
    public static PotionType BEAR_SPIRIT;
    public static PotionType SUPER_BEAR_SPIRIT;
    public static PotionType FOOD_POISONING;
    public static PotionType BADD_JUJU;
    public static PotionType SUPER_GOOD_JUJU;
    public static PotionType SUGAR_BOMBED;
    public static PotionType UNDYING;
    public static PotionType LONG_UNDYING;
    public static PotionType VIGOR;
    public static PotionType STRONG_VIGOR;
    public static PotionType GENERIC_LUCK;
    public static PotionType SWAMP_ESSENCE;
    public static PotionType STRONG_SWAMP_ESSENCE;
    static final HashMap<PotionType, Integer> _typeToColorMap;

    public static final PotionType newType(String name, PotionEffect ... effects) {
        PotionType pt = (PotionType)new PotionType("vfp_" + name, effects).setRegistryName("vanillafoodpantry", name);
        ForgeRegistries.POTION_TYPES.register((IForgeRegistryEntry)pt);
        return pt;
    }

    public static final PotionType newInternalType(String name, PotionEffect ... effects) {
        PotionType pt = (PotionType)new PotionType("vfp_" + name, effects).setRegistryName("vanillafoodpantry", name);
        return pt;
    }

    public static final void init(VfpConfig config) {
        GENERIC_LUCK = (PotionType)PotionType.field_185176_a.func_82594_a((Object)new ResourceLocation("luck"));
        FOOD_WARMING = new VfpMarkerPotion("heated_food", true, false, 16753408, false);
        ForgeRegistries.POTIONS.register((IForgeRegistryEntry)FOOD_WARMING);
        FOOD_COOLING = new VfpMarkerPotion("cooled_food", true, false, 11063295, false);
        ForgeRegistries.POTIONS.register((IForgeRegistryEntry)FOOD_COOLING);
        VIGOR = VfpPotionTypes.newInternalType("vigor", MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_moveSpeed, 90, 0), MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_jump, 90, 0), MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_digSpeed, 90, 0));
        STRONG_VIGOR = VfpPotionTypes.newInternalType("strong_vigor", MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_moveSpeed, 90, 1), MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_jump, 90, 1), MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_digSpeed, 90, 1));
        if (!config.includePotionBrewing()) {
            STRONG_STIMULANT = PotionTypes.field_185229_a;
            WATER_NATIVE = PotionTypes.field_185229_a;
            LONG_WATER_NATIVE = PotionTypes.field_185229_a;
            WOLF_SPIRIT = PotionTypes.field_185229_a;
            SUPER_WOLF_SPIRIT = PotionTypes.field_185229_a;
            BEAR_SPIRIT = PotionTypes.field_185229_a;
            SUPER_BEAR_SPIRIT = PotionTypes.field_185229_a;
            BADD_JUJU = PotionTypes.field_185229_a;
            SUPER_GOOD_JUJU = PotionTypes.field_185229_a;
            UNDYING = PotionTypes.field_185229_a;
            LONG_UNDYING = PotionTypes.field_185229_a;
            SWAMP_ESSENCE = PotionTypes.field_185229_a;
            STRONG_SWAMP_ESSENCE = PotionTypes.field_185229_a;
            SUGAR_BOMBED = PotionTypes.field_185229_a;
            FOOD_POISONING = VfpPotionTypes.newInternalType("food_poisoning", MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_hunger, 60, 0), MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_nausea, 60, 0));
        } else {
            FOOD_POISONING = VfpPotionTypes.newType("food_poisoning", MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_hunger, 60, 0), MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_nausea, 60, 0));
            STRONG_STIMULANT = VfpPotionTypes.newType("strong_stimulant", MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_poison, 10, 0), MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_moveSpeed, 180, 3));
            WATER_NATIVE = VfpPotionTypes.newType("water_native", MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_nightVision, 180, 0), MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_waterBreathing, 180, 0));
            LONG_WATER_NATIVE = VfpPotionTypes.newType("long_water_native", MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_nightVision, 480, 0), MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_waterBreathing, 480, 0));
            WOLF_SPIRIT = VfpPotionTypes.newType("wolfspirit", MinecraftGlue.Potions.newHiddenPotionTypeEffect(MinecraftGlue.Potion_nightVision, 180, 0), MinecraftGlue.Potions.newHiddenPotionTypeEffect(MinecraftGlue.Potion_invisibility, 180, 0), MinecraftGlue.Potions.newHiddenPotionTypeEffect(MinecraftGlue.Potion_moveSpeed, 180, 1), MinecraftGlue.Potions.newHiddenPotionTypeEffect(MinecraftGlue.Potion_jump, 180, 1), MinecraftGlue.Potions.newHiddenPotionTypeEffect(MinecraftGlue.Potion_healthBoost, 180, 0));
            SUPER_WOLF_SPIRIT = VfpPotionTypes.newType("super_wolfspirit", MinecraftGlue.Potions.newHiddenPotionTypeEffect(MinecraftGlue.Potion_nightVision, 480, 0), MinecraftGlue.Potions.newHiddenPotionTypeEffect(MinecraftGlue.Potion_invisibility, 480, 0), MinecraftGlue.Potions.newHiddenPotionTypeEffect(MinecraftGlue.Potion_moveSpeed, 480, 3), MinecraftGlue.Potions.newHiddenPotionTypeEffect(MinecraftGlue.Potion_jump, 480, 4), MinecraftGlue.Potions.newHiddenPotionTypeEffect(MinecraftGlue.Potion_healthBoost, 480, 1));
            BEAR_SPIRIT = VfpPotionTypes.newType("bearspirit", MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_nightVision, 180, 0), MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_moveSpeed, 180, 0), MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_strength, 180, 2), MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_absorption, 180, 1), MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_resistance, 180, 0));
            SUPER_BEAR_SPIRIT = VfpPotionTypes.newType("super_bearspirit", MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_nightVision, 480, 0), MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_moveSpeed, 480, 1), MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_strength, 480, 2), MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_absorption, 480, 1), MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_resistance, 480, 1));
            BADD_JUJU = VfpPotionTypes.newType("badd_juju", MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_badLuck, 300, 0));
            SUPER_GOOD_JUJU = VfpPotionTypes.newType("super_good_juju", MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_luck, 480, 1));
            UNDYING = VfpPotionTypes.newType("undying", MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_resistance, 90, 4), MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_luck, 90, 0), MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_glowing, 90, 0));
            LONG_UNDYING = VfpPotionTypes.newType("long_undying", MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_resistance, 180, 4), MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_luck, 90, 0), MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_glowing, 180, 0));
            SWAMP_ESSENCE = VfpPotionTypes.newType("swamp_essence", MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_glowing, 90, 0), MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_levitation, 90, 0));
            STRONG_SWAMP_ESSENCE = VfpPotionTypes.newType("strong_swamp_essence", MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_glowing, 90, 0), MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_levitation, 90, 2));
            SUGAR_BOMBED = VfpPotionTypes.newType("sugar_bombed", MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_digSpeed, 180, 1), MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_jump, 180, 1), MinecraftGlue.Potions.newPotionTypeEffect(MinecraftGlue.Potion_moveSpeed, 180, 1));
            _typeToColorMap.put(FOOD_POISONING, 11510092);
            _typeToColorMap.put(STRONG_STIMULANT, 8171445);
            _typeToColorMap.put(WOLF_SPIRIT, 8344618);
            _typeToColorMap.put(SUPER_WOLF_SPIRIT, 8273408);
            _typeToColorMap.put(WATER_NATIVE, 50898);
            _typeToColorMap.put(LONG_WATER_NATIVE, 42186);
            _typeToColorMap.put(BEAR_SPIRIT, 9970776);
            _typeToColorMap.put(SUPER_BEAR_SPIRIT, 9970243);
            _typeToColorMap.put(BADD_JUJU, 0x755455);
            _typeToColorMap.put(SUPER_GOOD_JUJU, 59904);
            _typeToColorMap.put(UNDYING, 0xFFF000);
            _typeToColorMap.put(LONG_UNDYING, 16766976);
            _typeToColorMap.put(SWAMP_ESSENCE, 11653040);
            _typeToColorMap.put(STRONG_SWAMP_ESSENCE, 12576727);
            _typeToColorMap.put(SUGAR_BOMBED, 8171400);
        }
    }

    static {
        _typeToColorMap = new HashMap();
    }

    public static final class ForgeEventHandler {
        public static final ForgeEventHandler init(VfpConfig config) {
            return new ForgeEventHandler();
        }

        @SubscribeEvent
        public void onBrewed(PotionBrewEvent.Post event) {
            MinecraftGlue.BrewEffect.onBrewedSwitchColor(event, _typeToColorMap);
        }

        ForgeEventHandler() {
        }
    }
}

