/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.core;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeJungle;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.meats.MeatExtrasBuildHelper;
import org.jwaresoftware.mcmods.vfp.meats.PigMeats;
import org.jwaresoftware.mcmods.vfp.meats.WolfsSpiritElement;

public final class ModDrops {

    public static final class HarvestDropsHandler {
        static HarvestDropsHandler INSTANCE;
        private final boolean _flintDrops;
        private final boolean _moreShrooms;
        private final boolean _acornDrops;
        private final boolean _uglifruitDrops;
        private final boolean _harvestDrops;

        public static final HarvestDropsHandler init(VfpConfig config) {
            if (!config.includeModDrops()) {
                return null;
            }
            if (INSTANCE == null) {
                INSTANCE = new HarvestDropsHandler(config);
            }
            return INSTANCE.isEnabled() ? INSTANCE : null;
        }

        private HarvestDropsHandler(VfpConfig config) {
            this._flintDrops = config.isSuperCompatibilityMode() || config.alwaysIncludeRedFlintDrops();
            this._moreShrooms = config.increaseShroomDrops();
            this._acornDrops = config.includeAcornDrops();
            this._uglifruitDrops = config.includeUgliFruitDrops();
            this._harvestDrops = this._flintDrops || this._moreShrooms || this._acornDrops || this._uglifruitDrops;
        }

        final boolean isEnabled() {
            return this._harvestDrops;
        }

        @SubscribeEvent
        public void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
            World world = event.getWorld();
            if (!world.field_72995_K && world.func_82736_K().func_82766_b(MinecraftGlue.GAMERULE_TILE_DROPS()) && !event.isSilkTouching()) {
                Block block = event.getState().func_177230_c();
                if (this._flintDrops && block instanceof BlockGravel) {
                    int fortune = event.getFortuneLevel();
                    if (event.getHarvester() != null && event.getHarvester().func_70644_a(MinecraftGlue.Potion_luck)) {
                        fortune = 4;
                    }
                    if (fortune > 3) {
                        fortune = 3;
                    }
                    if (world.field_73012_v.nextInt(14 - fortune * 3) == 0) {
                        int j = 1;
                        if (fortune >= 2) {
                            ++j;
                        }
                        event.getDrops().add(new ItemStack(VfpObj.Red_Flint_obj, j));
                    }
                    return;
                }
                if (this._moreShrooms && block instanceof BlockHugeMushroom) {
                    int fortune = event.getFortuneLevel();
                    if (fortune < 1 && MeatExtrasBuildHelper.isUsingButcheringTool(event.getHarvester())) {
                        fortune = 1;
                    }
                    int n = VfpUtils.countDrops(event, false, Item.func_150898_a((Block)MinecraftGlue.GameBlocks.red_mushroom), Item.func_150898_a((Block)MinecraftGlue.GameBlocks.brown_mushroom));
                    Block smallblock = block == MinecraftGlue.GameBlocks.red_mushroom_block ? MinecraftGlue.GameBlocks.red_mushroom : MinecraftGlue.GameBlocks.brown_mushroom;
                    int N = n;
                    if (N == 0) {
                        N = 1;
                    }
                    if ((N += fortune) > 3) {
                        N = 3;
                    }
                    if (N > n) {
                        event.getDrops().add(new ItemStack(smallblock, N -= n));
                    }
                    return;
                }
                if ((this._acornDrops || this._uglifruitDrops) && block instanceof BlockLeaves) {
                    int n;
                    IBlockState state = event.getState();
                    boolean dropAcorns = false;
                    boolean dropUglies = false;
                    if (state.func_177228_b().containsKey((Object)BlockOldLeaf.field_176239_P)) {
                        if (state.func_177229_b((IProperty)BlockOldLeaf.field_176239_P) == BlockPlanks.EnumType.OAK) {
                            dropAcorns = true;
                        }
                        if (state.func_177229_b((IProperty)BlockOldLeaf.field_176239_P) == BlockPlanks.EnumType.JUNGLE) {
                            dropUglies = true;
                        }
                    }
                    if (!dropAcorns && state.func_177228_b().containsKey((Object)BlockNewLeaf.field_176240_P) && state.func_177229_b((IProperty)BlockNewLeaf.field_176240_P) == BlockPlanks.EnumType.DARK_OAK) {
                        dropAcorns = true;
                    }
                    if (dropAcorns && this._acornDrops && (n = world.field_73012_v.nextInt(2 + (event.getFortuneLevel() > 1 ? 1 : 0))) > 0 && world.field_73012_v.nextFloat() <= 0.08f) {
                        event.getDrops().add(new ItemStack(VfpObj.Oak_Acorn_obj, n));
                    }
                    if (dropUglies && this._uglifruitDrops && (n = world.field_73012_v.nextInt(2 + (event.getFortuneLevel() > 2 ? 1 : 0))) > 0) {
                        EntityPlayer player;
                        float threshold = world.func_180494_b(event.getPos()) instanceof BiomeJungle ? 0.032f : 0.016f;
                        EntityPlayer entityPlayer = player = MinecraftGlue.isRealPlayer((Entity)event.getHarvester()) ? event.getHarvester() : null;
                        if (player != null && player.func_184817_da() >= 1.0f) {
                            threshold += 0.01f;
                        }
                        if (world.field_73012_v.nextFloat() <= threshold) {
                            event.getDrops().add(new ItemStack(VfpObj.Raftugli_Fruit_obj, n));
                        }
                    }
                    return;
                }
            }
        }
    }

    public static final class AnimalDropsHandler {
        static AnimalDropsHandler INSTANCE;
        private final boolean _batDrops;
        private final boolean _pigDrops;
        private final boolean _horseDrops;
        private final boolean _wolfDrops;
        private final boolean _squidDrops;
        private final boolean _calfDrops;
        private final boolean _bearDrops;
        private final boolean _llamaDrops;
        private final boolean _ocelotDrops;
        private final boolean _skipHorseMeat;
        private final boolean _skipSquidMeat;
        private final boolean _skipWolfMeat;
        private final boolean _skipLlamaMeat;
        private final boolean _livingDrops;
        private final boolean _ensureDrops;
        private final boolean _skipBones;
        private final boolean _skipFleece;
        private final boolean _moreShrooms;
        private final String _booLabel;

        public static final AnimalDropsHandler init(VfpConfig config) {
            if (!config.includeModDrops()) {
                return null;
            }
            if (INSTANCE == null) {
                INSTANCE = new AnimalDropsHandler(config);
            }
            return INSTANCE.isEnabled() ? INSTANCE : null;
        }

        private AnimalDropsHandler(VfpConfig config) {
            this._batDrops = config.includeBatDrops();
            this._pigDrops = config.includePigDrops();
            this._calfDrops = config.includeCalfDrops();
            this._wolfDrops = config.includeWolfDrops();
            this._squidDrops = config.includeSquidDrops();
            this._horseDrops = config.includeHorseDrops();
            this._bearDrops = config.includePolarBearDrops();
            this._llamaDrops = config.includeLlamaDrops();
            this._ocelotDrops = config.includeOcelotDrops();
            this._skipLlamaMeat = config.excludeLlamaMeatDrops();
            this._skipHorseMeat = config.excludeHorseMeatDrops();
            this._skipSquidMeat = config.excludeSquidMeatDrops();
            this._skipWolfMeat = config.excludeWolfMeatDrops();
            this._ensureDrops = config.increaseMeatDrops();
            this._skipBones = !config.includeBoneDrops();
            this._skipFleece = config.llamasDropRegularWool();
            this._moreShrooms = config.increaseShroomDrops();
            this._booLabel = MinecraftGlue.Strings.translateDefault("item.bane_of_ocelots.name", "__" + System.nanoTime());
            this._livingDrops = this._batDrops || this._pigDrops || this._horseDrops || this._wolfDrops || this._ocelotDrops || this._squidDrops || this._calfDrops || this._bearDrops || this._llamaDrops || this._ensureDrops;
        }

        final boolean isEnabled() {
            return this._livingDrops;
        }

        @Nullable
        private EntityPlayer getPlayer(LivingDropsEvent event) {
            EntityPlayer player = null;
            DamageSource attacksource = event.getSource();
            if (attacksource instanceof EntityDamageSource && ((EntityDamageSource)attacksource).func_76346_g() instanceof EntityPlayer && !MinecraftGlue.isRealNonSpectatingPlayer((Entity)(player = (EntityPlayer)((EntityDamageSource)attacksource).func_76346_g()))) {
                player = null;
            }
            return player;
        }

        @SubscribeEvent(priority=EventPriority.LOW)
        public void onLivingDrops(LivingDropsEvent event) {
            EntityLivingBase entity = event.getEntityLiving();
            World world = entity.func_130014_f_();
            if (!world.field_72995_K && world.func_82736_K().func_82766_b(MinecraftGlue.GAMERULE_MOB_LOOT())) {
                boolean all = MeatExtrasBuildHelper.isUsingButcheringTool(event);
                boolean onFire = entity.func_70027_ad();
                EntityPlayer player = this.getPlayer(event);
                boolean isLucky = player != null && player.func_184817_da() > 0.8f;
                boolean done = false;
                Random rand = entity.func_70681_au();
                if (!done && this._squidDrops) {
                    done = this.doSquidDrops(event, rand, entity, all, onFire, player, isLucky);
                }
                if (!done && this._llamaDrops) {
                    done = this.doLlamaDrops(event, rand, entity, all, onFire, player, isLucky);
                }
                if (!done && this._batDrops) {
                    done = this.doBatDrops(event, rand, entity, all, onFire, player, isLucky);
                }
                if (!done && this._horseDrops) {
                    done = this.doHorseDrops(event, rand, entity, all, onFire, player, isLucky);
                }
                if (!done && this._wolfDrops) {
                    done = this.doWolfDrops(event, rand, entity, all, onFire, player, isLucky);
                }
                if (!done && this._bearDrops) {
                    done = this.doBearDrops(event, rand, entity, all, onFire, player, isLucky);
                }
                if (!done && this._pigDrops) {
                    done = this.doPigDrops(event, rand, entity, all, onFire, player, isLucky);
                }
                if (!done && this._calfDrops) {
                    done = this.doCowDrops(event, rand, entity, all, onFire, player, isLucky);
                }
                if (this._ensureDrops) {
                    done = this.upsizeDrops(event, rand, entity, all, onFire, player, isLucky);
                }
            }
        }

        private int bonusLivesStolen(ItemStack pufferfish, Random rand) {
            if (!this._booLabel.equals(pufferfish.func_82833_r())) {
                return 0;
            }
            int level = EnchantmentHelper.func_77506_a((Enchantment)MinecraftGlue.Enchantment_bindingCurse, (ItemStack)pufferfish);
            return level > MinecraftGlue.Enchantment_bindingCurse.func_77325_b() ? MathHelper.func_76136_a((Random)rand, (int)1, (int)3) : 0;
        }

        @SubscribeEvent
        public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
            Entity target = event.getTarget();
            if (target.func_130014_f_().field_72995_K || event.isCanceled() || !this._ocelotDrops) {
                return;
            }
            EntityPlayer player = event.getEntityPlayer();
            ItemStack holding = MinecraftGlue.getPlayerHeldItem(player, event.getHand());
            if (holding != null && target instanceof EntityOcelot) {
                EntityOcelot ocelot = (EntityOcelot)target;
                if (ocelot.func_70909_n()) {
                    return;
                }
                Item item = holding.func_77973_b();
                float maxhealth = ocelot.func_110138_aP();
                float health = ocelot.func_110143_aJ();
                if (item == MinecraftGlue.Items_fish && holding.func_77960_j() == ItemFishFood.FishType.PUFFERFISH.func_150976_a()) {
                    int bonus = 0;
                    if (health >= maxhealth * 0.334f) {
                        int n = 0;
                        if (!ocelot.func_70644_a(MinecraftGlue.Potion_slowness)) {
                            if (ocelot.func_70681_au().nextFloat() < 0.021f) {
                                ++n;
                            }
                        } else if (health >= maxhealth * 0.9f) {
                            ++n;
                        } else if (ocelot.func_70681_au().nextFloat() < health / maxhealth - 0.15f) {
                            ++n;
                        }
                        if (n > 0) {
                            bonus = this.bonusLivesStolen(holding, player.func_70681_au());
                            ocelot.func_145779_a(VfpObj.Feline_Life_obj, n + bonus);
                        }
                    }
                    ocelot.func_70097_a(MinecraftGlue.DamageSource_void, maxhealth * 0.1667f * (float)(1 + bonus));
                    MinecraftGlue.consumeItemFromStack(player, holding, event.getHand(), true);
                    event.setCanceled(true);
                }
            }
        }

        private int countDrops(LivingDropsEvent event, boolean first, Item ... items) {
            int n = 0;
            for (EntityItem e : event.getDrops()) {
                ItemStack drop = e.func_92059_d();
                for (Item item : items) {
                    if (drop.func_77973_b() != item) continue;
                    ++n;
                    if (!first) continue;
                    return n;
                }
            }
            return n;
        }

        private boolean isXtremeLooting(int lootingLevel) {
            return lootingLevel > MinecraftGlue.HIGH_LOOTING * 2;
        }

        private static void dropItem(LivingDropsEvent event, ItemStack stack) {
            EntityLivingBase e = event.getEntityLiving();
            EntityItem drop = new EntityItem(e.func_130014_f_(), e.field_70165_t, e.field_70163_u, e.field_70161_v, stack);
            drop.func_174869_p();
            event.getDrops().add(drop);
        }

        private static void dropItem(LivingDropsEvent event, Item item, int count) {
            AnimalDropsHandler.dropItem(event, new ItemStack(item, count));
        }

        private boolean upsizeDrops(LivingDropsEvent event, Random rand, EntityLivingBase entity, boolean all, boolean onFire, EntityPlayer player, boolean isLucky) {
            ResourceLocation eid = EntityList.func_191301_a((Entity)entity);
            if (eid == null || !"minecraft".equals(eid.func_110624_b())) {
                return false;
            }
            if (!entity.func_70631_g_()) {
                int shroom_count;
                Class<?> entityClass;
                int bonus_count = rand.nextInt(2);
                int bonus_bones = 0;
                if (!this._skipBones) {
                    bonus_bones = this.countDrops(event, false, MinecraftGlue.Items_bone);
                    bonus_bones = bonus_bones > 1 || !all && event.getLootingLevel() <= 0 ? 0 : bonus_count + (bonus_count == 0 && isLucky ? 1 : 0);
                }
                if ((entityClass = entity.getClass()) == EntityCow.class || entityClass == EntityMooshroom.class) {
                    int hide_count;
                    int min_meat = (all ? 5 : (player != null ? 2 : 0)) + 1 + bonus_count;
                    int meat_count = this.countDrops(event, false, MinecraftGlue.Items_beef, MinecraftGlue.Items_cooked_beef);
                    if (meat_count < min_meat) {
                        AnimalDropsHandler.dropItem(event, onFire ? MinecraftGlue.Items_cooked_beef : MinecraftGlue.Items_beef, min_meat - meat_count);
                    }
                    if (all && (hide_count = this.countDrops(event, true, MinecraftGlue.Items_leather)) == 0) {
                        AnimalDropsHandler.dropItem(event, MinecraftGlue.Items_leather, 1);
                    }
                    if (bonus_bones > 0) {
                        AnimalDropsHandler.dropItem(event, MinecraftGlue.Items_bone, bonus_bones);
                    }
                    return true;
                }
                if (entityClass == EntityPig.class) {
                    int min_meat = (all ? 2 : (player != null ? 1 : 0)) + 1 + bonus_count;
                    int meat_count = this.countDrops(event, false, MinecraftGlue.Items_porkchop, MinecraftGlue.Items_cooked_porkchop);
                    if (meat_count < min_meat) {
                        AnimalDropsHandler.dropItem(event, onFire ? MinecraftGlue.Items_cooked_porkchop : MinecraftGlue.Items_porkchop, min_meat - meat_count);
                    }
                    if (bonus_bones > 0) {
                        AnimalDropsHandler.dropItem(event, MinecraftGlue.Items_bone, bonus_bones);
                    }
                    return true;
                }
                if (entityClass == EntitySheep.class) {
                    int min_wool;
                    int min_meat = (all ? 2 : (player != null ? 1 : 0)) + 1 + bonus_count;
                    int meat_count = this.countDrops(event, false, MinecraftGlue.Items_mutton, MinecraftGlue.Items_cooked_mutton);
                    if (meat_count < min_meat) {
                        AnimalDropsHandler.dropItem(event, onFire ? MinecraftGlue.Items_cooked_mutton : MinecraftGlue.Items_mutton, min_meat - meat_count);
                    }
                    if (bonus_bones > 0) {
                        AnimalDropsHandler.dropItem(event, MinecraftGlue.Items_bone, bonus_bones);
                    }
                    int wool_count = this.countDrops(event, false, Item.func_150898_a((Block)MinecraftGlue.Blocks_wool));
                    int n = min_wool = player != null ? 3 : 1;
                    if (wool_count < min_wool) {
                        wool_count = min_wool - wool_count;
                        AnimalDropsHandler.dropItem(event, new ItemStack(Item.func_150898_a((Block)MinecraftGlue.Blocks_wool), wool_count, ((EntitySheep)entity).func_175509_cj().func_176765_a()));
                    }
                    return true;
                }
                if (entityClass == EntityChicken.class) {
                    int feather_count;
                    if (bonus_bones > 0) {
                        AnimalDropsHandler.dropItem(event, VfpObj.Small_Bone_obj, bonus_bones);
                    }
                    if (all && (feather_count = this.countDrops(event, false, MinecraftGlue.Items_feather)) < 2) {
                        AnimalDropsHandler.dropItem(event, MinecraftGlue.Items_feather, 2 - feather_count);
                    }
                    return true;
                }
                if (entityClass == EntityLlama.class) {
                    int hide_count;
                    if (all && (hide_count = this.countDrops(event, true, MinecraftGlue.Items_leather)) == 0) {
                        AnimalDropsHandler.dropItem(event, MinecraftGlue.Items_leather, 1);
                    }
                    if (this._llamaDrops && bonus_bones > 0) {
                        AnimalDropsHandler.dropItem(event, MinecraftGlue.Items_bone, bonus_bones);
                    }
                    return true;
                }
                if (entityClass == EntityRabbit.class) {
                    int hide_count;
                    int meat_count = this.countDrops(event, true, MinecraftGlue.Items_rabbit, MinecraftGlue.Items_cooked_rabbit);
                    if (meat_count == 0) {
                        AnimalDropsHandler.dropItem(event, onFire ? MinecraftGlue.Items_cooked_rabbit : MinecraftGlue.Items_rabbit, 1);
                    }
                    if (all && (hide_count = this.countDrops(event, true, MinecraftGlue.Items_rabbit_hide)) == 0) {
                        AnimalDropsHandler.dropItem(event, MinecraftGlue.Items_rabbit_hide, 1);
                    }
                    if (bonus_bones > 0) {
                        AnimalDropsHandler.dropItem(event, VfpObj.Small_Bone_obj, bonus_bones);
                    }
                    return true;
                }
                if (entityClass == EntityPolarBear.class) {
                    int fish_count;
                    if (!this._skipBones) {
                        AnimalDropsHandler.dropItem(event, MinecraftGlue.Items_bone, 3 + bonus_bones);
                    }
                    if ((fish_count = this.countDrops(event, true, MinecraftGlue.Items_fish, MinecraftGlue.Items_cooked_fish)) == 0) {
                        fish_count = 1 + bonus_count;
                        AnimalDropsHandler.dropItem(event, onFire ? LikeFood.salmon.sample(fish_count) : LikeFood.uncooked_salmon.sample(fish_count));
                    }
                    return true;
                }
                if (entityClass == EntityHorse.class) {
                    int hide_count;
                    if (all && (hide_count = this.countDrops(event, true, MinecraftGlue.Items_leather)) == 0) {
                        AnimalDropsHandler.dropItem(event, MinecraftGlue.Items_leather, 1 + rand.nextInt(2));
                    }
                    return true;
                }
                if (entityClass == EntityShulker.class) {
                    int shell_count = this.countDrops(event, true, MinecraftGlue.Items_shulker_shell);
                    if (shell_count == 0) {
                        AnimalDropsHandler.dropItem(event, MinecraftGlue.Items_shulker_shell, 1 + bonus_bones);
                    }
                    return true;
                }
                if (entityClass == EntityMooshroom.class && this._moreShrooms && player != null && !onFire && (shroom_count = this.countDrops(event, false, Item.func_150898_a((Block)MinecraftGlue.GameBlocks.red_mushroom))) < 0 && (shroom_count = rand.nextInt(2)) > 0) {
                    AnimalDropsHandler.dropItem(event, new ItemStack(MinecraftGlue.GameBlocks.red_mushroom, shroom_count));
                }
            }
            return false;
        }

        private boolean doBatDrops(LivingDropsEvent event, Random rand, EntityLivingBase entity, boolean all, boolean onFire, EntityPlayer player, boolean isLucky) {
            boolean mine = entity instanceof EntityBat;
            if (mine) {
                int n;
                int n2 = n = event.getLootingLevel() > 0 || all ? 2 : 1;
                if (!onFire) {
                    boolean bonus;
                    entity.func_145779_a(VfpObj.Bat_Poop_obj, n + rand.nextInt(2));
                    entity.func_145779_a(VfpObj.Bat_Raw_obj, n + rand.nextInt(4));
                    if (!this._skipBones) {
                        entity.func_145779_a(VfpObj.Small_Bone_obj, rand.nextInt(2));
                    }
                    boolean bl = bonus = rand.nextInt(all ? 2 : (isLucky ? 4 : 16)) == 0;
                    if (bonus) {
                        entity.func_145779_a(VfpObj.Bat_Sonar_Sac_obj, 1);
                    }
                } else {
                    entity.func_145779_a(VfpObj.Bat_Cooked_obj, n);
                    entity.func_145779_a(VfpObj.Bat_Poop_obj, rand.nextInt(2));
                }
            }
            return mine;
        }

        private boolean doPigDrops(LivingDropsEvent event, Random rand, EntityLivingBase entity, boolean all, boolean onFire, EntityPlayer player, boolean isLucky) {
            boolean mine = entity instanceof EntityPig;
            if (mine) {
                int n;
                int n2 = n = event.getLootingLevel() > 1 || all ? 1 + rand.nextInt(2) : 1;
                if (!entity.func_70631_g_() && !onFire) {
                    AnimalDropsHandler.dropItem(event, PigMeats.hocks(n + rand.nextInt(2)));
                    AnimalDropsHandler.dropItem(event, PigMeats.pigtail(all ? 1 : rand.nextInt(2)));
                }
            }
            return mine;
        }

        private boolean doCowDrops(LivingDropsEvent event, Random rand, EntityLivingBase entity, boolean all, boolean onFire, EntityPlayer player, boolean isLucky) {
            boolean mine = entity instanceof EntityCow;
            if (mine && entity.func_70631_g_() && !onFire) {
                entity.func_145779_a(VfpObj.Calf_Stomach_obj, 1);
                entity.func_145779_a(VfpObj.Small_Bone_obj, 1);
            }
            return mine;
        }

        private boolean doSquidDrops(LivingDropsEvent event, Random rand, EntityLivingBase entity, boolean all, boolean onFire, EntityPlayer player, boolean isLucky) {
            boolean mine = entity instanceof EntitySquid;
            if (mine) {
                int n;
                int lootLevel = player == null || event.getSource().func_76346_g() != player ? 0 : event.getLootingLevel();
                boolean xlooting = this.isXtremeLooting(lootLevel);
                int n2 = n = lootLevel > 0 || all ? 2 : 1;
                if (!this._skipSquidMeat) {
                    if (onFire) {
                        AnimalDropsHandler.dropItem(event, VfpObj.Squid_Cooked_obj, n + rand.nextInt(2));
                    } else {
                        AnimalDropsHandler.dropItem(event, VfpObj.Squid_Raw_obj, n + rand.nextInt(2));
                    }
                }
                if (!onFire) {
                    int n3 = all || xlooting ? 1 : (n = rand.nextInt(4) == 0 ? 1 : 0);
                    if (n > 0) {
                        AnimalDropsHandler.dropItem(event, VfpObj.Ink_Pearl_Shard_obj, n += player != null ? (rand.nextInt(isLucky ? 8 : 16) == 0 ? 1 : 0) : 0);
                    }
                }
            }
            return mine;
        }

        private boolean doHorseDrops(LivingDropsEvent event, Random rand, EntityLivingBase entity, boolean all, boolean onFire, EntityPlayer player, boolean isLucky) {
            boolean mine = entity instanceof AbstractHorse;
            if (mine && !onFire) {
                int n;
                AbstractHorse horse = (AbstractHorse)entity;
                if (!MinecraftGlue.isLivingHorseOrPackAnimal((Entity)entity) || horse instanceof EntityLlama) {
                    return mine;
                }
                boolean isAdult = !horse.func_70631_g_();
                boolean uncommonDrop = rand.nextInt(all || isLucky ? 8 : 16) == 0;
                int lootLevel = player == null || event.getSource().func_76346_g() != player ? 0 : event.getLootingLevel();
                boolean xlooting = this.isXtremeLooting(lootLevel);
                if (isAdult && horse instanceof EntityHorse && (all || uncommonDrop)) {
                    n = 1;
                    if (lootLevel > 1) {
                        n += rand.nextInt(2 + (xlooting ? 2 : 0));
                    }
                    entity.func_145779_a(VfpObj.Horse_Tear_obj, n);
                }
                if (isAdult) {
                    if (all || rand.nextInt(4) == 0) {
                        n = all || event.getLootingLevel() > 0 ? 2 : 1;
                        entity.func_145779_a(VfpObj.Horse_Hoof_obj, n);
                    }
                    if (uncommonDrop) {
                        entity.func_145779_a(VfpObj.Horse_Sweat_obj, 1);
                    }
                }
                if (!this._skipHorseMeat) {
                    if (!isAdult) {
                        entity.func_145779_a(VfpObj.Horse_Raw_obj, 1);
                    } else {
                        int n2;
                        boolean bonanza = event.getLootingLevel() > 1 || all;
                        int n3 = n2 = bonanza ? 3 : 1;
                        if (all) {
                            ++n2;
                        }
                        entity.func_145779_a(VfpObj.Horse_Raw_obj, n2 + rand.nextInt(4));
                        int bone_count = (bonanza ? 2 : 1) + rand.nextInt(3);
                        if (!this._skipBones) {
                            entity.func_145779_a(MinecraftGlue.Items_bone, bone_count);
                        }
                    }
                }
            }
            return mine;
        }

        private boolean doWolfDrops(LivingDropsEvent event, Random rand, EntityLivingBase entity, boolean all, boolean onFire, EntityPlayer player, boolean isLucky) {
            boolean mine = entity instanceof EntityWolf;
            if (mine && !entity.func_70631_g_()) {
                if (((EntityWolf)entity).func_70909_n()) {
                    boolean uncommonDrop;
                    boolean bl = uncommonDrop = rand.nextInt(isLucky ? 32 : 64) == 0;
                    if (uncommonDrop) {
                        DamageSource ds = event.getSource();
                        if (player == null || ds.func_76346_g() != player) {
                            uncommonDrop = false;
                        }
                    }
                    if (uncommonDrop) {
                        entity.func_70099_a(WolfsSpiritElement.random(1, rand), 0.0f);
                    }
                } else {
                    boolean uncommonDrop;
                    int n;
                    int lootLevel = player == null || event.getSource().func_76346_g() != player ? 0 : event.getLootingLevel();
                    boolean xlooting = this.isXtremeLooting(lootLevel);
                    int n2 = n = lootLevel > 1 || all ? 3 : 2;
                    boolean bl = uncommonDrop = rand.nextInt(xlooting ? 4 : (all || isLucky ? 8 : 16)) == 0;
                    if (!this._skipWolfMeat) {
                        if (onFire) {
                            entity.func_145779_a(VfpObj.Wolf_Cooked_obj, n + rand.nextInt(2));
                        } else {
                            entity.func_145779_a(VfpObj.Wolf_Raw_obj, n + rand.nextInt(2));
                        }
                    }
                    if (uncommonDrop) {
                        entity.func_70099_a(WolfsSpiritElement.random(1, rand), 0.0f);
                    }
                    if (!this._skipWolfMeat && !this._skipBones) {
                        entity.func_145779_a(VfpObj.Small_Bone_obj, --n);
                    }
                }
            }
            return mine;
        }

        private boolean doBearDrops(LivingDropsEvent event, Random rand, EntityLivingBase entity, boolean all, boolean onFire, EntityPlayer player, boolean isLucky) {
            boolean mine = entity instanceof EntityPolarBear;
            if (mine && !entity.func_70631_g_()) {
                int n;
                DamageSource ds = event.getSource();
                int lootLevel = player == null || ds.func_76346_g() != player ? 0 : event.getLootingLevel();
                boolean uncommonDrop = false;
                if (lootLevel > 1 && !ds.func_180136_u() && !onFire) {
                    boolean xlooting = this.isXtremeLooting(lootLevel);
                    uncommonDrop = rand.nextInt(all || isLucky || xlooting ? 4 : 8) == 0;
                }
                int n2 = n = lootLevel > 0 || all ? 3 : 2;
                if (onFire) {
                    entity.func_145779_a(VfpObj.Bear_Raw_Charred_obj, n + rand.nextInt(3));
                } else {
                    entity.func_145779_a(VfpObj.Bear_Raw_obj, n + rand.nextInt(5));
                }
                if (uncommonDrop) {
                    entity.func_70099_a(new ItemStack(VfpObj.Polar_Raw_Crystal_obj), 0.0f);
                }
                if (!this._skipBones && !this._ensureDrops) {
                    entity.func_145779_a(MinecraftGlue.Items_bone, 2 + (uncommonDrop ? rand.nextInt(4) : 0));
                }
            }
            return mine;
        }

        private boolean doLlamaDrops(LivingDropsEvent event, Random rand, EntityLivingBase entity, boolean all, boolean onFire, EntityPlayer player, boolean isLucky) {
            boolean mine = entity instanceof EntityLlama;
            if (mine && !entity.func_70631_g_()) {
                if (!this._skipLlamaMeat) {
                    int n;
                    int n2 = n = event.getLootingLevel() > 1 || all ? 3 : 2;
                    if (onFire) {
                        AnimalDropsHandler.dropItem(event, VfpObj.Llama_Cooked_obj, n + rand.nextInt(2));
                    } else {
                        AnimalDropsHandler.dropItem(event, VfpObj.Llama_Raw_obj, n + rand.nextInt(2));
                    }
                }
                if (!onFire) {
                    int min_wool;
                    Block wool = this._skipFleece ? MinecraftGlue.Blocks_wool : VfpObj.Llama_Fleece_Block_obj;
                    int wool_meta = this._skipFleece ? 0 : ((EntityLlama)entity).func_190719_dM();
                    int wool_count = this.countDrops(event, false, Item.func_150898_a((Block)wool));
                    int n = min_wool = player != null ? 3 : rand.nextInt(2);
                    if (wool_count < min_wool) {
                        wool_count = min_wool - wool_count;
                        AnimalDropsHandler.dropItem(event, new ItemStack(Item.func_150898_a((Block)wool), wool_count, wool_meta));
                    }
                }
            }
            return mine;
        }
    }
}

