/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.integrations;

import java.util.Collection;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;

final class ImplMisc {
    ImplMisc() {
    }

    private static final ItemStack addItem(MinecraftGlue.ModIntegration mod, String itemid, String ... oreids) {
        ItemStack out = ItemStack.field_190927_a;
        Item item = mod.item(itemid);
        if (item != null) {
            out = new ItemStack(item, 1, 0);
            for (String oreid : oreids) {
                OreDictionary.registerOre((String)oreid, (ItemStack)out);
            }
        }
        return out;
    }

    static final void inferFoodDictionary(VfpConfig config, Collection<String> mappings) {
        if (MinecraftGlue.ModIntegration.TEASTORY.isLoaded()) {
            mappings.add("foodLemon");
        }
    }

    static final void fixFoodDictionary(VfpConfig config) {
        if (MinecraftGlue.ModIntegration.TEASTORY.isLoaded()) {
            ImplMisc.addItem(MinecraftGlue.ModIntegration.TEASTORY, "lemon", "foodLemon");
        }
    }

    static final void registerCompatibleForgeIds(VfpConfig config) {
        MinecraftGlue.ModIntegration modid;
        if (MinecraftGlue.ModIntegration.TOUGH_AS_NAILS.isLoaded()) {
            modid = MinecraftGlue.ModIntegration.TOUGH_AS_NAILS;
            ImplMisc.addItem(modid, "charcoal_filter", "itemWaterTreatment");
            ImplMisc.addItem(modid, "purified_water_bottle", "itemWaterBottle");
            ImplMisc.addItem(modid, "purified_water_bottle", "portionWater");
        }
        if (MinecraftGlue.ModIntegration.FAMILIAR_FAUNA.isLoaded()) {
            modid = MinecraftGlue.ModIntegration.FAMILIAR_FAUNA;
            ImplMisc.addItem(modid, "turkey_leg_raw", "foodGoodMeat", "ingredientKebabAdventure");
            ImplMisc.addItem(modid, "venison_raw", "foodGoodMeat", "foodRedMeat", "ingredientKebabAdventure");
            ImplMisc.addItem(modid, "venison_cooked", "foodRedMeatCooked", "foodNativeGameMeatCooked");
        }
        if (MinecraftGlue.ModIntegration.EXOTIC_BIRDS.isLoaded()) {
            String[] eggs;
            modid = MinecraftGlue.ModIntegration.EXOTIC_BIRDS;
            ImplMisc.addItem(modid, "peacock_feather", "itemSpecialFeather");
            ImplMisc.addItem(modid, "phoenix_feather", "itemSpecialFeather");
            for (String egg : eggs = new String[]{"duck_egg", "peafowl_egg", "kingfisher_egg", "toucan_egg", "swan_egg", "vulture_egg", "flamingo_egg", "pelican_egg", "owl_egg", "seagull_egg", "heron_egg", "crane_egg"}) {
                ImplMisc.addItem(modid, egg, "foodSimpleEgg");
            }
            ImplMisc.addItem(modid, "birdmeat", "ingredientKebabAdventure");
            ImplMisc.addItem(modid, "cooked_birdmeat", "foodProteinCooked");
        }
        if (MinecraftGlue.ModIntegration.BAMBOOZLED.isLoaded()) {
            modid = MinecraftGlue.ModIntegration.BAMBOOZLED;
            ImplMisc.addItem(modid, "salt_pile", "portionSalt");
        }
        if (MinecraftGlue.ModIntegration.SALTY_MOD.isLoaded()) {
            modid = MinecraftGlue.ModIntegration.SALTY_MOD;
            ImplMisc.addItem(modid, "salt", "portionSalt", "ingredientSalt");
            ImplMisc.addItem(modid, "salt_pinch", "portionSaltSmall");
            ImplMisc.addItem(modid, "saltwort_seed", "greenLitterSeeds");
            ImplMisc.addItem(modid, "salt_bread", "foodBreadSandwich");
            ImplMisc.addItem(modid, "salt_beef_cooked", "foodProteinCooked", "foodRedMeatCooked", "foodNativeGameMeatCooked");
            ImplMisc.addItem(modid, "salt_porkchop_cooked", "foodProteinCooked");
            ImplMisc.addItem(modid, "salt_mutton_cooked", "foodProteinCooked", "foodNativeGameMeatCooked");
            ImplMisc.addItem(modid, "salt_chicken_cooked", "foodProteinCooked");
            ImplMisc.addItem(modid, "salt_chicken_cooked", "foodChickenCooked");
            ImplMisc.addItem(modid, "salt_rabbit_cooked", "foodProteinCooked", "foodNativeGameMeatCooked");
            ImplMisc.addItem(modid, "salt_fish_cod_cooked", "foodProteinCooked");
            ImplMisc.addItem(modid, "salt_fish_salmon_cooked", "foodProteinCooked");
            ImplMisc.addItem(modid, "corned_beef", "foodProteinCooked");
            ImplMisc.addItem(modid, "salt_egg", "foodProteinCooked");
        }
        if (MinecraftGlue.ModIntegration.DYNAMIC_TREES.isLoaded()) {
            modid = MinecraftGlue.ModIntegration.DYNAMIC_TREES;
            ImplMisc.addItem(modid, "oakseed", "seedOakAcorn");
            ImplMisc.addItem(modid, "darkoakseed", "seedOakAcorn");
        }
        if (MinecraftGlue.ModIntegration.TWILIGHT_FOREST.isLoaded()) {
            modid = MinecraftGlue.ModIntegration.TWILIGHT_FOREST;
            ImplMisc.addItem(modid, "raw_venison", "foodGoodMeat", "foodRedMeat", "ingredientKebabAdventure");
            ImplMisc.addItem(modid, "cooked_venison", "foodRedMeatCooked", "foodNativeGameMeatCooked");
            ImplMisc.addItem(modid, "raw_meef", "foodGoodMeat", "foodRedMeat", "ingredientKebabAdventure");
            ImplMisc.addItem(modid, "cooked_meef", "foodRedMeatCooked", "foodNativeGameMeatCooked", "foodBeefsteakCooked");
            ImplMisc.addItem(modid, "hydra_chop", "foodProteinCooked");
        }
        if (MinecraftGlue.ModIntegration.THE_BETWEENLANDS.isLoaded()) {
            modid = MinecraftGlue.ModIntegration.THE_BETWEENLANDS;
            ImplMisc.addItem(modid, "angler_meat_raw", "ingredientKebabAdventure");
            ImplMisc.addItem(modid, "angler_meat_cooked", "foodProteinCooked");
            ImplMisc.addItem(modid, "frog_legs_raw", "ingredientKebabAdventure");
            ImplMisc.addItem(modid, "frog_legs_cooked", "foodProteinCooked");
            ImplMisc.addItem(modid, "snail_flesh_raw", "ingredientKebabAdventure");
            ImplMisc.addItem(modid, "snail_flesh_cooked", "foodProteinCooked");
            ImplMisc.addItem(modid, "crab_stick", "foodProteinCooked");
            ImplMisc.addItem(modid, "flat_head_mushroom_item", "ingredientMushroom", "ingredientKebabFill");
            ImplMisc.addItem(modid, "black_hat_mushroom_item", "ingredientMushroom", "ingredientKebabFill");
            ImplMisc.addItem(modid, "bulb_capped_mushroom_item", "ingredientMushroom", "ingredientKebabFill");
            ImplMisc.addItem(modid, "fried_swamp_kelp", "ingredientSalad");
            ImplMisc.addItem(modid, "yellow_dotted_fungus", "foodProteinCooked");
            ImplMisc.addItem(modid, "mire_snail_egg_cooked", "foodProteinCooked");
            ImplMisc.addItem(modid, "kraken_calamari", "foodProteinCooked");
        }
        if (MinecraftGlue.ModIntegration.DEFILED_LANDS.isLoaded()) {
            modid = MinecraftGlue.ModIntegration.DEFILED_LANDS;
            ImplMisc.addItem(modid, "book_wyrm_raw", "ingredientKebabAdventure");
            ImplMisc.addItem(modid, "book_wyrm_cooked", "foodProteinCooked");
        }
        if (MinecraftGlue.ModIntegration.TOTEMIC.isLoaded()) {
            modid = MinecraftGlue.ModIntegration.TOTEMIC;
            ImplMisc.addItem(modid, "buffalo_meat", "foodGoodMeat", "foodRedMeat", "ingredientKebabAdventure");
            ImplMisc.addItem(modid, "cooked_buffalo_meat", "foodRedMeatCooked", "foodNativeGameMeatCooked");
        }
        if (MinecraftGlue.ModIntegration.ABYSSALCRAFT.isLoaded()) {
            modid = MinecraftGlue.ModIntegration.ABYSSALCRAFT;
            ImplMisc.addItem(modid, "friedegg", "foodEggFried");
        }
        if (MinecraftGlue.ModIntegration.TEASTORY.isLoaded()) {
            modid = MinecraftGlue.ModIntegration.TEASTORY;
            ImplMisc.addItem(modid, "lemon", "ingredientLemonFlavor");
            ImplMisc.addItem(modid, "washed_rice", "ingredientCereal");
            ImplMisc.addItem(modid, "xian_rice", "ingredientCereal");
            ItemStack rice_seeds = modid.itemstack("xian_rice_seeds");
            if (!rice_seeds.func_190926_b()) {
                OreDictionary.registerOre((String)"additiveScaffold", (ItemStack)rice_seeds);
                OreDictionary.registerOre((String)"greenLitterSeeds", (ItemStack)rice_seeds);
            }
        }
        if (MinecraftGlue.ModIntegration.MYSTICAL_WILDLIFE.isLoaded()) {
            modid = MinecraftGlue.ModIntegration.MYSTICAL_WILDLIFE;
            ImplMisc.addItem(modid, "vrontausaurus_meat_raw", "foodGoodMeat", "foodRedMeat", "ingredientKebabAdventure");
            ImplMisc.addItem(modid, "vrontausaurus_meat_cooked", "foodRedMeatCooked", "foodNativeGameMeatCooked");
            ImplMisc.addItem(modid, "yaga_hog_meat_raw", "foodGoodMeat", "ingredientKebabAdventure");
            ImplMisc.addItem(modid, "yaga_hog_meat_cooked", "foodProteinCooked");
            ImplMisc.addItem(modid, "plumper_meat_raw", "foodGoodMeat", "ingredientKebabAdventure");
            ImplMisc.addItem(modid, "plumper_meat_cooked", "foodProteinCooked");
            ImplMisc.addItem(modid, "dusk_lurker_meat_raw", "ingredientKebabAdventure");
            ImplMisc.addItem(modid, "dusk_lurker_meat_cooked", "foodProteinCooked");
            ImplMisc.addItem(modid, "cicaptera_meat_raw", "ingredientKebabAdventure");
            ImplMisc.addItem(modid, "cicaptera_meat_cooked", "foodProteinCooked");
            ImplMisc.addItem(modid, "krill_meat_cooked", "foodProteinCooked");
        }
    }

    private static final ItemStack copy(ItemStack original, int n) {
        ItemStack out = original.func_77946_l();
        out.func_190920_e(n);
        return out;
    }

    static final void autorecipeMisc(VfpConfig config, IForgeRegistry<IRecipe> recipes) {
        if (MinecraftGlue.ModIntegration.EXOTIC_BIRDS.isLoaded()) {
            MinecraftGlue.ModIntegration modid = MinecraftGlue.ModIntegration.EXOTIC_BIRDS;
            ItemStack powdered_egg = FoodPowders.get(FoodPowders.Type.EGG, 1);
            Item item = modid.item("ostrich_egg");
            if (item != null) {
                recipes.register(new ShapelessOreRecipe(null, ImplMisc.copy(powdered_egg, 3), new Object[]{item, "additiveDrying"}).setRegistryName(ModInfo.r("powdered_egg_from_exb_ostrich_egg")));
            }
            if ((item = modid.item("emperorpenguin_egg")) != null) {
                recipes.register(new ShapelessOreRecipe(null, ImplMisc.copy(powdered_egg, 3), new Object[]{item, "additiveDrying"}).setRegistryName(ModInfo.r("powdered_egg_from_exb_emperor_penguin_egg")));
            }
            if ((item = modid.item("pigeon_egg")) != null) {
                recipes.register(new ShapelessOreRecipe(null, ImplMisc.copy(powdered_egg, 1), new Object[]{item, item, "additiveDrying"}).setRegistryName(ModInfo.r("powdered_egg_from_exb_pigeon_eggs")));
            }
        }
    }
}

