/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.integrations;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.logging.log4j.Logger;
import org.jwaresoftware.mcmods.vfp.Integrations;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.common.DictionaryNameItemAdaptor;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.PackagedFood;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.core.VfpRuntime;
import org.jwaresoftware.mcmods.vfp.core.crafting.LegacyShapelessOreRecipe;
import org.jwaresoftware.mcmods.vfp.integrations.ImplANM;
import org.jwaresoftware.mcmods.vfp.integrations.ImplAQC;
import org.jwaresoftware.mcmods.vfp.integrations.ImplCUI;
import org.jwaresoftware.mcmods.vfp.integrations.ImplHCB;
import org.jwaresoftware.mcmods.vfp.integrations.ImplHOV;
import org.jwaresoftware.mcmods.vfp.integrations.ImplHVC;
import org.jwaresoftware.mcmods.vfp.integrations.ImplMisc;
import org.jwaresoftware.mcmods.vfp.integrations.ImplNAT;
import org.jwaresoftware.mcmods.vfp.integrations.ImplPMP;
import org.jwaresoftware.mcmods.vfp.integrations.ImplPNKS;
import org.jwaresoftware.mcmods.vfp.integrations.ImplRUS;
import org.jwaresoftware.mcmods.vfp.integrations.ImplSCO;
import org.jwaresoftware.mcmods.vfp.integrations.ImplSMH;
import org.jwaresoftware.mcmods.vfp.integrations.ImplTRQ;
import org.jwaresoftware.mcmods.vfp.integrations.ImplXFB;
import org.jwaresoftware.mcmods.vfp.integrations.ImplYAFM;
import org.jwaresoftware.mcmods.vfp.meats.Kebabs;
import org.jwaresoftware.mcmods.vfp.meats.MeatPortions;

public final class IntegrationsImpl {
    static final String LITTER_SEEDS_LISTID = "greenLitterSeeds";
    static final String LITTER_FUNGI_LISTID = "greenLitterFungi";
    static final String LITTER_TUBER_LISTID = "greenLitterTuber";
    static final String LITTER_OTHER_LISTID = "greenLitterOther";
    static final int _ANY_TYPE = Short.MAX_VALUE;
    static final String[] COMMON_INGREDIENTS = new String[]{"Corn", "Soybean", "Peanuts", "SweetPotato", "Cassava", "Taro", "Onion", "Garlic", "Pepper", "Celery", "Tomato", "Leek", "Scallions", "BellPepper", "Cucumber", "Avocado", "Spinach", "Dasheen", "Kale", "MustardGreens", "WildDandelion", "Cabbage", "Beets", "Thyme", "Parsley", "Basil", "Sage", "Oregano", "Paprika", "Peppercorn", "BayLeaves", "Mint", "Eggplant", "Squash", "Zucchini", "Okra", "Broccoli", "Cauliflower", "BrusselSprouts", "GreenBeans", "KidneyBeans", "PintoBeans", "ButterBeans", "BlackBeans", "Lentils", "Ginger", "Cinnamon", "Nutmeg", "Apple", "Coconut", "Mango", "Banana", "Strawberry", "Blueberry", "Kiwi", "Grapes", "Cantaloupe", "Pineapple", "Papaya", "Plums", "Pear", "Cherry", "Orange", "Lime", "Lemon", "Grapefruit", "Tangerine", "Rice", "Tofu", "CoffeeBean", "Watercress"};
    static final String[] COMMON_MIXTURE_SEEDS = new String[]{"Peppercorn", "Celery", "Mustard", "Dill", "Cloves", "Allspice", "Fennel"};
    private static final ArrayList<ImmutablePair<String, String>> _ITEM_2_INGREDIENT = new ArrayList(23);
    static final AtomicInteger _ridCounter = new AtomicInteger(100);
    static final String _XP_NBT_TAG = "vanillafoodpantry:craftXp";

    private static final String getPresentAs(String prefix, Collection<String> mappings, String foodid) {
        String forgeid = prefix + foodid;
        boolean present = mappings.contains(forgeid);
        if (!present && foodid.charAt(foodid.length() - 1) == 's') {
            forgeid = prefix + foodid.substring(0, foodid.length() - 1);
            present = mappings.contains(forgeid);
        }
        return present ? forgeid : null;
    }

    public static final void inferGeneralFeatureSupport(VfpConfig config) {
        if (config.includeInterModRecipes()) {
            String forgeid;
            HashSet<String> mappings = new HashSet<String>(101, 0.8f);
            ImplPMP.inferFoodDictionary(config, mappings);
            ImplHVC.inferFoodDictionary(config, mappings);
            ImplNAT.inferFoodDictionary(config, mappings);
            ImplRUS.inferFoodDictionary(config, mappings);
            ImplTRQ.inferFoodDictionary(config, mappings);
            ImplCUI.inferFoodDictionary(config, mappings);
            ImplMisc.inferFoodDictionary(config, mappings);
            for (String foodid : COMMON_INGREDIENTS) {
                forgeid = IntegrationsImpl.getPresentAs("food", mappings, foodid);
                if (forgeid == null) continue;
                config.setPresentAs(foodid.toLowerCase(Locale.US), forgeid);
            }
            for (String foodid : COMMON_MIXTURE_SEEDS) {
                forgeid = IntegrationsImpl.getPresentAs("seed", mappings, foodid);
                if (forgeid == null) continue;
                config.setPresentAs(foodid.toLowerCase(Locale.US) + "_seed", forgeid);
            }
        }
        if (IntegrationsImpl.detectSmeltedFriedEggByOther(config)) {
            config.setPresent("fried_eggs");
        }
        if (!config.includeBoneDrops()) {
            config.setPresent("bone_drops");
        }
        if (IntegrationsImpl.detectRoastedSeedsByOther(config)) {
            config.setPresent("roast_seeds");
        }
    }

    public static final void detectActualFeatureSupport(VfpConfig config) {
        if (config.includeInterModRecipes()) {
            String as;
            String forgeid;
            ImplPMP.fixFoodDictionary(config);
            ImplHVC.fixFoodDictionary(config);
            ImplANM.fixFoodDictionary(config);
            ImplSCO.fixFoodDictionary(config);
            ImplNAT.fixFoodDictionary(config);
            ImplRUS.fixFoodDictionary(config);
            ImplTRQ.fixFoodDictionary(config);
            ImplCUI.fixFoodDictionary(config);
            ImplMisc.fixFoodDictionary(config);
            config.captureContextOres();
            List<String> mappings = config.capturedContextOres();
            for (String foodid : COMMON_INGREDIENTS) {
                forgeid = IntegrationsImpl.getPresentAs("food", mappings, foodid);
                String foodkey = foodid.toLowerCase(Locale.US);
                if (forgeid != null && !MinecraftGlue.ingredientDefinedLooking(forgeid)) {
                    forgeid = null;
                }
                if (forgeid != null) {
                    config.setPresentAs(foodkey, forgeid);
                    continue;
                }
                if (!config.isPresent(foodkey) || (as = config.getPresentAs(foodkey)) == null || MinecraftGlue.ingredientDefinedLooking(as)) continue;
                config.setNotPresent(foodkey);
            }
            for (String seedid : COMMON_MIXTURE_SEEDS) {
                forgeid = IntegrationsImpl.getPresentAs("seed", mappings, seedid);
                String seedkey = seedid.toLowerCase(Locale.US) + "_seed";
                if (forgeid != null && !MinecraftGlue.ingredientDefinedLooking(forgeid)) {
                    forgeid = null;
                }
                if (forgeid != null) {
                    config.setPresentAs(seedkey, forgeid);
                    continue;
                }
                if (!config.isPresent(seedkey) || (as = config.getPresentAs(seedkey)) == null || MinecraftGlue.ingredientDefinedLooking(as)) continue;
                config.setNotPresent(seedkey);
            }
        }
    }

    static final void _registerFoodItem(Integrations mod, String ingredient_id, String itemname) {
        Item item = mod.item(itemname);
        if (item instanceof ItemFood) {
            OreDictionary.registerOre((String)ingredient_id, (Item)item);
        }
    }

    static final void _registerFoodItems(Integrations mod, String ingredient_id, String[] choices) {
        for (String itemname : choices) {
            Item item = mod.item(itemname);
            if (!(item instanceof ItemFood)) continue;
            OreDictionary.registerOre((String)ingredient_id, (Item)item);
        }
    }

    static final void _registerFoodItems(String ingredient_id, Collection<ItemStack> choices) {
        for (ItemStack item : choices) {
            if (!(item.func_77973_b() instanceof ItemFood)) continue;
            OreDictionary.registerOre((String)ingredient_id, (ItemStack)item);
        }
    }

    private static final void foodItemToIngredient(String dictid, String ingredient_id) {
        if (OreDictionary.doesOreNameExist((String)dictid)) {
            NonNullList matches = OreDictionary.getOres((String)dictid);
            for (ItemStack food : matches) {
                OreDictionary.registerOre((String)ingredient_id, (ItemStack)food);
            }
        }
    }

    private static final void inferFoodItemToIngredient(String dictid, String ingredient_id) {
        _ITEM_2_INGREDIENT.add((ImmutablePair<String, String>)new ImmutablePair((Object)dictid, (Object)ingredient_id));
    }

    private static final void finishLinkFoodItemsToIngredients() {
        for (ImmutablePair<String, String> ab : _ITEM_2_INGREDIENT) {
            IntegrationsImpl.foodItemToIngredient((String)ab.getKey(), (String)ab.getValue());
        }
        _ITEM_2_INGREDIENT.clear();
    }

    static final void _registerMiscItem(Integrations mod, String ingredient_id, String itemname, boolean wildcard) {
        String moditemid = mod.itemid(itemname);
        Item item = Item.func_111206_d((String)moditemid);
        if (item != null) {
            ItemStack stack = new ItemStack(item, 1, wildcard && (item.func_77614_k() || item.func_77645_m()) ? Short.MAX_VALUE : 0);
            OreDictionary.registerOre((String)ingredient_id, (ItemStack)stack);
        } else {
            Block blok = Block.func_149684_b((String)moditemid);
            if (blok != null) {
                OreDictionary.registerOre((String)ingredient_id, (Block)blok);
            }
        }
    }

    static final void _registerMiscItem(Integrations mod, String ingredient_id, String itemname) {
        IntegrationsImpl._registerMiscItem(mod, ingredient_id, itemname, false);
    }

    static final void _registerMiscItem(Integrations mod, String ingredient_id, String itemname, int meta) {
        String moditemid = mod.itemid(itemname);
        Item item = Item.func_111206_d((String)moditemid);
        if (item != null) {
            ItemStack stack = new ItemStack(item, 1, meta);
            OreDictionary.registerOre((String)ingredient_id, (ItemStack)stack);
        } else {
            Block blok = Block.func_149684_b((String)moditemid);
            if (blok != null) {
                ItemStack stack = new ItemStack(blok, 1, meta);
                OreDictionary.registerOre((String)ingredient_id, (ItemStack)stack);
            }
        }
    }

    static final void _registerMeatPortionRecipe(Integrations mod, IForgeRegistry<IRecipe> recipes, ItemStack portions, String[] itemnames) {
        for (String itemname : itemnames) {
            Item mainfood = mod.item(itemname);
            if (mainfood == null) continue;
            recipes.register(new LegacyShapelessOreRecipe(null, portions, mainfood, "itemFoodCutter").setRegistryName(ModInfo.r("portion_meat_alt" + _ridCounter.getAndIncrement())));
        }
    }

    static final void _registerKebabRecipe(ItemStack raw_kebab, Object mainfood, IForgeRegistry<IRecipe> recipes) {
        if (mainfood != null) {
            recipes.register(new ShapedOreRecipe(null, raw_kebab, new Object[]{"vv", "ms", Character.valueOf('v'), "ingredientKebabFill", Character.valueOf('m'), mainfood, Character.valueOf('s'), VfpObj.Skewers_Wood_obj}).setRegistryName(ModInfo.r("kebab_alt" + _ridCounter.getAndIncrement())));
        }
    }

    static final void _registerKebabRecipe(Integrations mod, IForgeRegistry<IRecipe> recipes, ItemStack raw_kebab, String[] itemnames) {
        for (String itemname : itemnames) {
            Item mainfood = mod.item(itemname);
            if (mainfood == null) continue;
            IntegrationsImpl._registerKebabRecipe(raw_kebab, new ItemStack(mainfood), recipes);
        }
    }

    public static final void registerFoodPowders(VfpRuntime runtime) {
        FoodPowders.Type fpt;
        VfpConfig config = runtime.getConfig();
        if (!config.includeInterModRecipes()) {
            return;
        }
        boolean debug = config.isDebugMode();
        Logger log = runtime.getLog();
        int slotid = FoodPowders.Type.reservedPowderCount();
        int MAX_COMMON_SLOTS = 32;
        int NUM_COMMON_MIXED_POWDERS = 8;
        int id = slotid;
        String item = config.getPresentAs("strawberry");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "strawberry", DictionaryNameItemAdaptor.newi(item), 1, 2, null, (Integer)0xDD6161);
            if (debug) {
                log.info("GEN foodPowder(strawberry): '{}'", (Object)fpt);
            }
        }
        ++id;
        item = config.getPresentAs("blueberry");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "blueberry", DictionaryNameItemAdaptor.newi(item), 1, 3, null, (Integer)6384842);
            if (debug) {
                log.info("GEN foodPowder(blueberry): '{}'", (Object)fpt);
            }
        }
        ++id;
        item = config.getPresentAs("peanuts");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "peanuts", DictionaryNameItemAdaptor.newi(item), 0, 3, null, (Integer)12816928);
            if (debug) {
                log.info("GEN foodPowder(peanuts): '{}'", (Object)fpt);
            }
        }
        ++id;
        item = config.getPresentAs("mango");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "mango", DictionaryNameItemAdaptor.newi(item), 1, null, (Integer)16759296);
            if (debug) {
                log.info("GEN foodPowder(mango): '{}'", (Object)fpt);
            }
        }
        ++id;
        item = config.getPresentAs("pineapple");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "pineapple", DictionaryNameItemAdaptor.newi(item, 2), 1, null, (Integer)16769875);
            if (debug) {
                log.info("GEN foodPowder(pineapple): '{}'", (Object)fpt);
            }
        }
        ++id;
        item = config.getPresentAs("peppercorn");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "peppercorn", DictionaryNameItemAdaptor.newi(item), 0x100000, 3, "ingredientPeppercorn", null);
            IntegrationsImpl.inferFoodItemToIngredient(item, "ingredientPeppercorn");
            if (debug) {
                log.info("GEN foodPowder(peppercorn): '{}'", (Object)fpt);
            }
        }
        ++id;
        item = config.getPresentAs("onion");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "onion", DictionaryNameItemAdaptor.newi(item), 0x100000, "ingredientOnion", null);
            IntegrationsImpl.inferFoodItemToIngredient(item, "ingredientOnion");
            if (debug) {
                log.info("GEN foodPowder(onion): '{}'", (Object)fpt);
            }
        }
        ++id;
        item = config.getPresentAs("leek");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "leek", DictionaryNameItemAdaptor.newi(item), 0x101000, null, (Integer)15859668);
            if (debug) {
                log.info("GEN foodPowder(leek): '{}'", (Object)fpt);
            }
        }
        ++id;
        item = config.getPresentAs("tomato");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "tomato", DictionaryNameItemAdaptor.newi(item), 4096, 2, "ingredientTomato", (Integer)14111549);
            IntegrationsImpl.inferFoodItemToIngredient(item, "ingredientTomato");
            if (debug) {
                log.info("GEN foodPowder(tomato): '{}'", (Object)fpt);
            }
        }
        ++id;
        item = config.getPresentAs("celery");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "celery", DictionaryNameItemAdaptor.newi(item), 0x100000, null, null);
            if (debug) {
                log.info("GEN foodPowder(celery): '{}'", (Object)fpt);
            }
        }
        ++id;
        item = config.getPresentAs("garlic");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "garlic", DictionaryNameItemAdaptor.newi(item), 0x100000, "ingredientGarlic", null);
            IntegrationsImpl.inferFoodItemToIngredient(item, "ingredientGarlic");
            if (debug) {
                log.info("GEN foodPowder(garlic): '{}'", (Object)fpt);
            }
        }
        ++id;
        item = config.getPresentAs("coffeebean");
        if (item != null) {
            fpt = new FoodPowders.Type(id, "coffee", DictionaryNameItemAdaptor.newi(item), 0, 3, null, null);
            if (debug) {
                log.info("GEN foodPowder(coffee): '{}'", (Object)fpt);
            }
        }
        int slotid_mixes_0 = id + 1;
        int slotid_mixes_N = slotid + 32;
        Validate.validState((slotid_mixes_0 - slotid < 24 ? 1 : 0) != 0, (String)"Only expected to have at most %d predefined food powders (excluding mixes); currently have %d ", (Object[])new Object[]{24, slotid_mixes_0 - slotid});
        slotid_mixes_0 = slotid + 32 - 8;
        slotid += 32;
        for (Integrations ii : Integrations.orderedValues()) {
            if (ii.reserve() <= 0) continue;
            for (int i = 0; i < ii.reserve(); ++i) {
                slotid += 8;
            }
        }
        IntegrationsImpl.registerMixedFoodPowders(config, log, slotid_mixes_0, slotid_mixes_N);
    }

    private static void registerMixedFoodPowders(VfpConfig config, Logger log, int slotid_0, int slotid_N) {
        FoodPowders.Type fpt;
        String[] required;
        int id = slotid_0;
        boolean craftable = true;
        for (String ingredient : required = new String[]{"peppercorn", "celery", "onion"}) {
            if (config.isPresent(ingredient)) continue;
            craftable = false;
            break;
        }
        if (craftable) {
            fpt = new FoodPowders.Type(id, "stew_mix", DictionaryNameItemAdaptor.newi("unused"), 0x100000, null, true);
            if (config.isDebugMode()) {
                log.info("GEN foodPowder(stew_mix): '{}'", (Object)fpt);
            }
        }
        ++id;
        craftable = config.isPresent("lime");
        if (craftable) {
            String[] secondaries = new String[]{"lemon", "orange", "grapefruit", "tangerine"};
            int matches = 0;
            for (int i = 0; i < secondaries.length; ++i) {
                String s = config.getPresentAs(secondaries[i]);
                if (s == null) continue;
                IntegrationsImpl.inferFoodItemToIngredient(s, "ingredientCitrusFill");
                ++matches;
            }
            if (matches > 0) {
                FoodPowders.Type fpt2 = new FoodPowders.Type(id, "citrus", DictionaryNameItemAdaptor.newi("unused"), 1, null, 13563136, true);
                if (config.isDebugMode()) {
                    log.info("GEN foodPowder(citrus_mix): '{}'", (Object)fpt2);
                }
            }
        }
        ++id;
        boolean bl = craftable = FoodPowders.findType("coffee") != null;
        if (craftable) {
            fpt = new FoodPowders.Type(id, "mocha", DictionaryNameItemAdaptor.newi("unused"), 0, null, 7289344, true);
            if (config.isDebugMode()) {
                log.info("GEN foodPowder(mocha_mix): '{}'", (Object)fpt);
            }
        }
        ++id;
        craftable = config.isPresent("grapes");
        ++id;
        ++id;
    }

    private static boolean detectSmeltedFriedEggByOther(VfpConfig config) {
        if (config.isSuperCompatibilityMode()) {
            return true;
        }
        return config.isModLoaded(Integrations.ANM) || MinecraftGlue.ModIntegration.ABYSSALCRAFT.isLoaded() || config.isModLoaded(Integrations.YAFM) || config.isModLoaded(Integrations.BFo);
    }

    private static boolean detectRoastedSeedsByOther(VfpConfig config) {
        if (config.isSuperCompatibilityMode()) {
            return true;
        }
        return config.isModLoaded(Integrations.BFo);
    }

    public static final void registerDictRedMeat(VfpConfig config) {
        if (config.includeInterModRecipes()) {
            ImplHVC.registerRedMeat(config);
            ImplANM.registerRedMeat(config);
        }
    }

    public static final void registerDictKebabItems(VfpConfig config) {
        String[] nuggets;
        String[] fruits;
        String[] fillers;
        String forgeid;
        String[] primary;
        if (!config.includeInterModRecipes()) {
            return;
        }
        for (String foodid : primary = new String[]{"tofu", "broccoli", "eggplant", "cauliflower", "cassava", "sweetpotato", "taro"}) {
            forgeid = config.getPresentAs(foodid);
            if (forgeid == null) continue;
            NonNullList choices = OreDictionary.getOres((String)forgeid);
            IntegrationsImpl._registerFoodItems("ingredientKebabMain", (Collection<ItemStack>)choices);
        }
        for (String foodid : fillers = new String[]{"tomato", "onion", "leek", "corn", "bellpepper", "zucchini", "brusselsprouts", "pineapple"}) {
            forgeid = config.getPresentAs(foodid);
            if (forgeid == null) continue;
            NonNullList choices = OreDictionary.getOres((String)forgeid);
            IntegrationsImpl._registerFoodItems("ingredientKebabFill", (Collection<ItemStack>)choices);
        }
        for (String foodid : fruits = new String[]{"pineapple_slice", "cantaloupe_slice", "mango", "banana", "kiwi", "orange", "pear", "plums", "tangerine"}) {
            forgeid = config.getPresentAs(foodid);
            if (forgeid == null) continue;
            NonNullList choices = OreDictionary.getOres((String)forgeid);
            IntegrationsImpl._registerFoodItems("ingredientKebabFruit", (Collection<ItemStack>)choices);
        }
        String[] small_fruits = new String[]{"strawberry", "cherry", "raspberry", "blackberry", "blueberry"};
        int hits = 0;
        for (String foodid : small_fruits) {
            forgeid = config.getPresentAs(foodid);
            if (forgeid == null) continue;
            NonNullList choices = OreDictionary.getOres((String)forgeid);
            IntegrationsImpl._registerFoodItems("ingredientKebabMiniFruit", (Collection<ItemStack>)choices);
            ++hits;
        }
        if (hits > 0) {
            config.setPresent("mini_fruit");
        }
        for (String foodid : nuggets = new String[]{"broccoli", "eggplant", "cauliflower", "zucchini", "pack_okra"}) {
            forgeid = config.getPresentAs(foodid);
            if (forgeid == null) continue;
            NonNullList choices = OreDictionary.getOres((String)forgeid);
            IntegrationsImpl._registerFoodItems("ingredientVegNugget", (Collection<ItemStack>)choices);
        }
        ImplPNKS.registerKebabItems(config);
        ImplPMP.registerKebabItems(config);
        ImplHVC.registerKebabItems(config);
        ImplYAFM.registerKebabItems(config);
        ImplANM.registerKebabItems(config);
    }

    public static final void registerDictEdibleFlowers(VfpConfig config) {
        if (config.includeInterModRecipes()) {
            // empty if block
        }
    }

    public static final void registerDictMushrooms(VfpConfig config) {
        if (config.includeInterModRecipes()) {
            ImplPMP.registerMushrooms(config);
            ImplHVC.registerMushrooms(config);
        }
    }

    public static final void registerPackagedFoods(VfpConfig config) {
        if (!config.includeInterModRecipes()) {
            return;
        }
        for (Integrations ii : Integrations.orderedValues()) {
            switch (ii) {
                case PMP: {
                    ImplPMP.registerPackagedFoods(config);
                    break;
                }
                case HVC: {
                    ImplHVC.registerPackagedFoods(config);
                }
            }
            if (ii.reserve() <= 0) continue;
            for (int j = 0; j < ii.reserve(); ++j) {
                PackagedFood.shift16();
            }
        }
    }

    public static final void registerAsTie(Item item) {
        OreDictionary.registerOre((String)"itemTieStrong", (Item)item);
        OreDictionary.registerOre((String)"itemTieNormal", (Item)item);
        OreDictionary.registerOre((String)"itemTieWeak", (Item)item);
        if (item != MinecraftGlue.Items_string) {
            OreDictionary.registerOre((String)"string", (Item)item);
        }
    }

    public static final void registerAsBread(Item bread, boolean sandwichToo, String ... otherBreadIds) {
        OreDictionary.registerOre((String)"foodBread", (Item)bread);
        OreDictionary.registerOre((String)"bread", (Item)bread);
        if (sandwichToo) {
            OreDictionary.registerOre((String)"foodBreadSandwich", (Item)bread);
        }
        if (otherBreadIds != null) {
            for (String oid : otherBreadIds) {
                OreDictionary.registerOre((String)oid, (Item)bread);
            }
        }
    }

    public static final void registerAsBread(ItemStack bread, boolean sandwichToo, String ... otherIds) {
        OreDictionary.registerOre((String)"foodBread", (ItemStack)bread);
        OreDictionary.registerOre((String)"bread", (ItemStack)bread);
        if (sandwichToo) {
            OreDictionary.registerOre((String)"foodBreadSandwich", (ItemStack)bread);
        }
        if (otherIds != null) {
            for (String oid : otherIds) {
                OreDictionary.registerOre((String)oid, (ItemStack)bread);
            }
        }
    }

    public static final void finishFoodDictionary(VfpConfig config) {
        IntegrationsImpl.registerItemBucketIfMissing();
        IntegrationsImpl.finishLinkFoodItemsToIngredients();
        if (config.includeInterModRecipes()) {
            ImplPMP.registerCompatibleForgeIds(config);
            ImplHVC.registerCompatibleForgeIds(config);
            ImplANM.registerCompatibleForgeIds(config);
            ImplAQC.registerCompatibleForgeIds(config);
            ImplXFB.registerCompatibleForgeIds(config);
            ImplSCO.registerCompatibleForgeIds(config);
            ImplHCB.registerCompatibleForgeIds(config);
            ImplPNKS.registerCompatibleForgeIds(config);
            ImplYAFM.registerCompatibleForgeIds(config);
            ImplNAT.registerCompatibleForgeIds(config);
            ImplRUS.registerCompatibleForgeIds(config);
            ImplHOV.registerCompatibleForgeIds(config);
            ImplTRQ.registerCompatibleForgeIds(config);
            ImplCUI.registerCompatibleForgeIds(config);
            ImplMisc.registerCompatibleForgeIds(config);
        }
        IntegrationsImpl.registerGreenSaladIngredients(config);
        IntegrationsImpl.foodItemToIngredient("foodSimpleEgg", "ingredientEgg");
        IntegrationsImpl.foodItemToIngredient("foodSimpleEgg", "foodSimpleEggOrWhites");
        IntegrationsImpl.foodItemToIngredient("foodKebabGoodMeat", "foodProteinCooked");
        IntegrationsImpl.foodItemToIngredient("ingredientHotPeppers", "ingredientCondiment");
        IntegrationsImpl.foodItemToIngredient("portionMayo", "ingredientCondiment");
        IntegrationsImpl.foodItemToIngredient("foodEggFried", "foodProteinCooked");
        IntegrationsImpl.foodItemToIngredient("ingredientCraftyPreserve", "foodJamJelly");
        if (config.isPresent("onion")) {
            IntegrationsImpl.foodItemToIngredient(config.getPresentAs("onion"), "ingredientAllium");
        }
    }

    public static final void defineModdedLoot(VfpConfig config) {
        ImplSMH.registerLoot(config);
        ImplPNKS.registerLoot(config);
    }

    private static final void registerItemBucketIfMissing() {
        if (!MinecraftGlue.ingredientDefinedLooking("itemEmptyBucket")) {
            OreDictionary.registerOre((String)"itemEmptyBucket", (Item)MinecraftGlue.Items_bucket);
        }
        if (!MinecraftGlue.ingredientDefinedLooking("itemWaterBucket")) {
            OreDictionary.registerOre((String)"itemWaterBucket", (Item)MinecraftGlue.Items_water_bucket);
        }
        if (!MinecraftGlue.ingredientDefinedLooking("itemLavaBucket")) {
            OreDictionary.registerOre((String)"itemLavaBucket", (Item)MinecraftGlue.Items_lava_bucket);
        }
        if (!MinecraftGlue.ingredientDefinedLooking("itemMilkBucket")) {
            OreDictionary.registerOre((String)"itemMilkBucket", (Item)MinecraftGlue.Items_milk_bucket);
        }
    }

    private static final void registerGreenSaladIngredients(VfpConfig config) {
        IntegrationsImpl.foodItemToIngredient("foodLightGreens", "ingredientSalad");
        if (config.isPresent("avocado")) {
            IntegrationsImpl.foodItemToIngredient(config.getPresentAs("avocado"), "ingredientSalad");
        }
        if (config.isPresent("tomato")) {
            IntegrationsImpl.foodItemToIngredient(config.getPresentAs("tomato"), "ingredientSalad");
        }
        if (config.isPresent("grapes")) {
            IntegrationsImpl.foodItemToIngredient(config.getPresentAs("grapes"), "ingredientSalad");
        }
        if (config.isPresent("bellpepper")) {
            IntegrationsImpl.foodItemToIngredient(config.getPresentAs("bellpepper"), "ingredientSalad");
        }
        if (config.isPresent("cucumber")) {
            IntegrationsImpl.foodItemToIngredient(config.getPresentAs("cucumber"), "ingredientSalad");
        }
    }

    public static final void registerCookedGoodMeat(VfpConfig config) {
        FurnaceRecipes registry = FurnaceRecipes.func_77602_a();
        for (ItemStack next : OreDictionary.getOres((String)"foodGoodMeat")) {
            ItemStack smelted = registry.func_151395_a(next.func_77946_l());
            if (MinecraftGlue.ItemStacks_isEmpty(smelted)) continue;
            OreDictionary.registerOre((String)"foodGoodMeatCooked", (ItemStack)smelted);
        }
    }

    private static final void addAllRegisteredCraftingXpRecipes(VfpConfig config) {
        ImmutableList registrations = FMLInterModComms.fetchRuntimeMessages((Object)"vanillafoodpantry");
        if (config.includeCraftXpAndAchievements()) {
            for (FMLInterModComms.IMCMessage msg : registrations) {
                if (!"addRewardingCraftItem".equals(msg.key) || !msg.isItemStackMessage()) continue;
                ItemStack crafted = msg.getItemStackValue();
                NBTTagCompound itemdata = null;
                if (!crafted.func_77942_o() || !(itemdata = crafted.func_77978_p()).func_150297_b(_XP_NBT_TAG, 99)) continue;
                float xp = itemdata.func_74760_g(_XP_NBT_TAG);
                VfpRewards.addRewardingCraftItem(crafted, xp);
            }
        }
    }

    public static final void registerAutocraftingRecipes(VfpConfig config) {
        IntegrationsImpl.addAllRegisteredCraftingXpRecipes(config);
        if (config.isModLoaded(Integrations.SMH) && config.isAutocraftingEnabled()) {
            IntegrationsImpl.registerItemBucketIfMissing();
            IntegrationsImpl.addHoardercraftRecipesBuilder(config, "org.jwaresoftware.mcmods.vfp.integrations.ImplSMH");
        }
    }

    static final void addHoardercraftRecipesBuilder(VfpConfig config, String builderClassName) {
        FMLInterModComms.sendMessage((String)Integrations.SMH.modid(), (String)"registerRecipes", (String)builderClassName);
    }

    public static final void autorecipeMisc(VfpConfig config, IForgeRegistry<IRecipe> recipes) {
        if (config.includeInterModRecipes()) {
            IntegrationsImpl.addSimpleFishRecipes(config, recipes);
            ImplPNKS.autorecipeMisc(config, recipes);
            ImplPMP.autorecipeMisc(config, recipes);
            ImplHVC.autorecipeMisc(config, recipes);
            ImplANM.autorecipeMisc(config, recipes);
            ImplAQC.autorecipeMisc(config, recipes);
            ImplHCB.autorecipeMisc(config, recipes);
            ImplMisc.autorecipeMisc(config, recipes);
        }
    }

    private static void addSimpleFishRecipes(VfpConfig config, IForgeRegistry<IRecipe> recipes) {
        if (MinecraftGlue.ingredientDefinedLooking("foodSimpleFish")) {
            ItemStack raw_kebab = Kebabs.uncooked_fish(2);
            IntegrationsImpl._registerKebabRecipe(raw_kebab, "foodSimpleFish", recipes);
            ItemStack portions = MeatPortions.get(PackagedFood.CODFISH);
            MinecraftGlue.ItemStacks_setSize(portions, 4);
            recipes.register(new LegacyShapelessOreRecipe(null, portions, "foodSimpleFish", "itemFoodCutter").setRegistryName(ModInfo.r("portion_fish_from_any_fish")));
            recipes.register(new ShapedOreRecipe(null, new ItemStack(VfpObj.Salt_Fish_obj, 4), new Object[]{"Fs", "s ", Character.valueOf('F'), "foodSimpleFish", Character.valueOf('s'), "ingredientSalt"}).setRegistryName(ModInfo.r(VfpOid.Cod_Salted + "_from_any_fish")));
        }
    }

    public static final void dprintfOreId(String label, String oreid) {
        System.out.println("" + label + ", items under OREID=" + oreid);
        for (ItemStack i : OreDictionary.getOres((String)oreid, (boolean)false)) {
            System.out.println("   > " + i);
        }
    }
}

