/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.meats;

import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPotionTypes;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.core.VfpBuildHelperSupport;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRuntime;

public final class BearItems
extends VfpBuildHelperSupport {
    @Override
    protected String categoryName() {
        return "BearDrops";
    }

    @Override
    public void makeObjects(VfpRuntime runtime) {
        VfpObj.Polar_Raw_Crystal_obj = VfpBuilder.newMisc(VfpOid.Polar_Raw_Crystal).setUncommon(true);
        VfpObj.Polar_Crystal_obj = VfpBuilder.newBrewingItem(VfpOid.Polar_Crystal, false);
        VfpObj.Bear_Raw_obj = VfpBuilder.newFood(VfpOid.Bear_Raw, LikeFood.uncooked_bear);
        VfpObj.Bear_Raw_Prepped_obj = VfpBuilder.newFood(VfpOid.Bear_Raw_Prepped, LikeFood.uncooked_bear);
        VfpObj.Bear_Cooked_obj = VfpBuilder.newFood(VfpOid.Bear_Cooked, LikeFood.bear);
        VfpObj.Bear_Raw_Charred_obj = VfpBuilder.newFood(VfpOid.Bear_Raw_Charred, LikeFood.charred_bear);
    }

    @Override
    public void linkLikeFoods(VfpRuntime runtime) {
        LikeFood.bear.food().item(VfpObj.Bear_Cooked_obj);
        LikeFood.uncooked_bear.food().item(VfpObj.Bear_Raw_obj);
        LikeFood.charred_bear.food().item(VfpObj.Bear_Raw_Charred_obj);
    }

    @Override
    public void addDictionaryEntries(VfpRuntime runtime) {
        OreDictionary.registerOre((String)"ingredientKebabAdventure", (Item)VfpObj.Bear_Raw_Prepped_obj);
        OreDictionary.registerOre((String)"foodGoodMeat", (Item)VfpObj.Bear_Raw_Prepped_obj);
        OreDictionary.registerOre((String)"foodRedMeat", (Item)VfpObj.Bear_Raw_Prepped_obj);
        OreDictionary.registerOre((String)"foodRedMeatCooked", (Item)VfpObj.Bear_Cooked_obj);
        OreDictionary.registerOre((String)"foodNativeGameMeatCooked", (Item)VfpObj.Bear_Cooked_obj);
        OreDictionary.registerOre((String)"foodBearCooked", (Item)VfpObj.Bear_Cooked_obj);
    }

    @Override
    public void addLootEntries(VfpRuntime runtime) {
        if (runtime.getConfig().includeModDrops() && runtime.getConfig().includePolarBearDrops()) {
            MinecraftGlue.Loot.addLootEntry("vanillafoodpantry", LootTableList.field_186431_m, null, (LootEntry)MinecraftGlue.Loot.createEntryItem(VfpOid.Polar_Raw_Crystal.fmlid(), VfpObj.Polar_Raw_Crystal_obj, MinecraftGlue.UNCOMMON_WEIGHT(), 1));
        }
    }

    @Override
    public void buildRecipes(VfpRuntime runtime, IForgeRegistry<IRecipe> recipes) {
        VfpConfig config = runtime.getConfig();
        if (runtime.getConfig().includePotionBrewing()) {
            MinecraftGlue.BrewEffect.addRecipeFor(VfpObj.Polar_Crystal_obj, 0, VfpPotionTypes.BEAR_SPIRIT);
            MinecraftGlue.BrewEffect.addThickConversionFor(VfpObj.Polar_Crystal_obj, 0, VfpPotionTypes.BEAR_SPIRIT);
            MinecraftGlue.BrewEffect.addConversionFor(VfpPotionTypes.BEAR_SPIRIT, VfpObj.Polar_Crystal_obj, 0, VfpPotionTypes.SUPER_BEAR_SPIRIT);
        }
        ArrayList<Object> ingredients = new ArrayList<Object>();
        ingredients.add(VfpObj.Bear_Raw_obj);
        ingredients.add("portionSalt");
        ingredients.add("ingredientVinegar");
        ingredients.add("portionPotableWaterLarge");
        FoodPowders.Type type = FoodPowders.findType("peppercorn");
        if (type != null) {
            ingredients.add(FoodPowders.get(type, 1));
        }
        if (config.isPresent("bayleaves")) {
            ingredients.add(config.getPresentAs("bayleaves"));
        }
        recipes.register(new ShapelessOreRecipe(null, new ItemStack(VfpObj.Bear_Raw_Prepped_obj, 3), ingredients.toArray()).setRegistryName(ModInfo.r(VfpOid.Bear_Raw_Prepped.fmlid())));
        GameRegistry.addSmelting((Item)VfpObj.Bear_Raw_Prepped_obj, (ItemStack)new ItemStack(VfpObj.Bear_Cooked_obj), (float)LikeFood.uncooked_bear.smeltExperience());
        GameRegistry.addSmelting((Item)VfpObj.Bear_Raw_obj, (ItemStack)new ItemStack(VfpObj.Bear_Raw_Charred_obj), (float)0.0f);
        recipes.register(new ShapelessOreRecipe(null, VfpObj.Polar_Crystal_obj, new Object[]{VfpObj.Polar_Raw_Crystal_obj, "nuggetGold", "nuggetGold"}).setRegistryName(ModInfo.r(VfpOid.Polar_Crystal.fmlid())));
    }

    @Override
    public void linkRenderModels(VfpRuntime runtime) {
        if (runtime.hasUI()) {
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Polar_Raw_Crystal, VfpObj.Polar_Raw_Crystal_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Polar_Crystal, VfpObj.Polar_Crystal_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Bear_Raw, VfpObj.Bear_Raw_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Bear_Raw_Prepped, VfpObj.Bear_Raw_Prepped_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Bear_Cooked, VfpObj.Bear_Cooked_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Bear_Raw_Charred, VfpObj.Bear_Raw_Charred_obj);
        }
    }
}

