/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.meats;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.PackagedFood;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.crafting.EmptyBottlesLeftoverShapedOreRecipe;
import org.jwaresoftware.mcmods.vfp.meats.MeatPortions;
import org.jwaresoftware.mcmods.vfp.meats.PigMeats;
import org.jwaresoftware.mcmods.vfp.wheat.Fries;

public final class Nuggets
extends VfpPantryMultiItem {
    private static final int NUGGET_BATCH = 6;
    private static final String DARK_MEAT = "dark_meat";
    private static final String LIGHT_MEAT = "light_meat";
    private static final String ANY_FISH = "fish";
    private static final String ANY_VEGGIE = "veggie";
    private static final String SQUID = "squid";
    static VfpVariant[] VARIANT_ARRAY;
    private static final VfpVariantSet VARIANT_SET;
    private static Nuggets INSTANCE;
    private static ItemStack[] TYPED_INSTANCES;
    private static List<ItemStack> COMBO_INSTANCES;

    public Nuggets(VfpOid oid, CreativeTabs tab) {
        super((VfpProfile)oid, false, VARIANT_ARRAY, tab);
    }

    static final synchronized Nuggets makeObjects() {
        if (INSTANCE == null) {
            ArrayList<VfpVariant> variants = new ArrayList<VfpVariant>(41);
            for (NuggetDef nuggetDef : NuggetDef.values()) {
                nuggetDef.install(variants, VARIANT_SET);
            }
            VARIANT_ARRAY = variants.toArray(VfpVariant.EMPTY_ARRAY);
            INSTANCE = VfpBuilder.newMultiItem(VfpOid.Nuggets, Nuggets.class);
        }
        return INSTANCE;
    }

    static final void addDictionaryEntries() {
    }

    private static final void addFried(IForgeRegistry<IRecipe> recipes, NuggetDef def, ItemStack battermix, List<ItemStack> instances) {
        if (!def._can_fry) {
            return;
        }
        ItemStack fried_prepped = new ItemStack((Item)INSTANCE, 6, def.fried_prep_meta());
        ItemStack fried = new ItemStack((Item)INSTANCE, 1, def.fried_meta());
        if (def._type == ANY_VEGGIE) {
            recipes.register(new EmptyBottlesLeftoverShapedOreRecipe(false, fried_prepped, "vv", "bw", Character.valueOf('v'), def.raw_ingredient(), Character.valueOf('b'), battermix, Character.valueOf('w'), "portionWater").setRegistryName(ModInfo.r(def.fried_fmlid() + "_prep")));
        } else {
            recipes.register(new EmptyBottlesLeftoverShapedOreRecipe(false, fried_prepped, "nnn", "nnn", "bw ", Character.valueOf('n'), def.raw_ingredient(), Character.valueOf('b'), battermix, Character.valueOf('w'), "portionWater").setRegistryName(ModInfo.r(def.fried_fmlid() + "_prep")));
        }
        MinecraftGlue.ItemStacks_setSize(fried_prepped, 1);
        GameRegistry.addSmelting((ItemStack)fried_prepped, (ItemStack)fried, (float)LikeFood.uncooked_meat_portion.smeltExperience());
        instances.add(fried_prepped);
        instances.add(fried);
    }

    private static final void addJerky(IForgeRegistry<IRecipe> recipes, NuggetDef def, ItemStack rubmix, List<ItemStack> instances) {
        if (!def._can_dry) {
            return;
        }
        ItemStack jerky_prepped = new ItemStack((Item)INSTANCE, 6, def.jerky_prep_meta());
        ItemStack jerky = new ItemStack((Item)INSTANCE, 1, def.jerky_meta());
        recipes.register(new ShapedOreRecipe(null, jerky_prepped, new Object[]{"nnn", "nnn", "rd ", Character.valueOf('n'), def.raw_ingredient(), Character.valueOf('r'), rubmix, Character.valueOf('d'), "additiveDrying"}).setRegistryName(ModInfo.r(def.jerky_fmlid() + "_prep")));
        MinecraftGlue.ItemStacks_setSize(jerky_prepped, 1);
        GameRegistry.addSmelting((ItemStack)jerky_prepped, (ItemStack)jerky, (float)LikeFood.uncooked_meat_portion.smeltExperience());
        instances.add(jerky_prepped);
        instances.add(jerky);
    }

    private static final void addCombo(IForgeRegistry<IRecipe> recipes, NuggetDef def, List<ItemStack> instances, List<ItemStack> combos) {
        if (!def._can_mix || !def._can_fry) {
            return;
        }
        ItemStack combo = new ItemStack((Item)INSTANCE, 1, def.combo_meta());
        recipes.register(new ShapedOreRecipe(null, combo, new Object[]{"nnn", "fp ", Character.valueOf('n'), new ItemStack((Item)INSTANCE, 1, def.fried_meta()), Character.valueOf('f'), def._type == ANY_VEGGIE ? Fries.klingon(1) : "foodFrenchFries", Character.valueOf('p'), MinecraftGlue.Items_paper}).setRegistryName(ModInfo.r(def.combo_fmlid())));
        instances.add(combo);
        combos.add(combo);
    }

    private static final void addPorkBitesCombo(IForgeRegistry<IRecipe> recipes, List<ItemStack> instances, List<ItemStack> combos) {
        NuggetDef def = NuggetDef.Porkchop;
        ItemStack combo = new ItemStack((Item)INSTANCE, 1, def.combo_meta());
        recipes.register(new ShapelessOreRecipe(null, combo, new Object[]{PigMeats.pork_bites(1), "foodFrenchFries", MinecraftGlue.Items_paper}).setRegistryName(ModInfo.r(def.combo_fmlid())));
        instances.add(combo);
        combos.add(combo);
    }

    static final void buildRecipes(VfpConfig config, IForgeRegistry<IRecipe> recipes) {
        if (INSTANCE != null && TYPED_INSTANCES == null) {
            COMBO_INSTANCES = new ArrayList<ItemStack>();
            ArrayList<ItemStack> instances = new ArrayList<ItemStack>(51);
            ItemStack battermix = FoodPowders.get(FoodPowders.Type.BATTER_MIX, 1);
            ItemStack jerkyrub = FoodPowders.get(FoodPowders.Type.JERKY_RUB, 1);
            for (NuggetDef def : NuggetDef.values()) {
                if (def.raw_ingredient() instanceof String && !MinecraftGlue.ingredientDefinedLooking((String)def.raw_ingredient())) {
                    Nuggets.addCombo(recipes, def, instances, COMBO_INSTANCES);
                    continue;
                }
                Nuggets.addFried(recipes, def, battermix, instances);
                Nuggets.addJerky(recipes, def, jerkyrub, instances);
                Nuggets.addCombo(recipes, def, instances, COMBO_INSTANCES);
            }
            Nuggets.addPorkBitesCombo(recipes, instances, COMBO_INSTANCES);
            TYPED_INSTANCES = instances.toArray(new ItemStack[0]);
        }
    }

    static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    public static final ItemStack fried(NuggetDef def) {
        ItemStack stack = MinecraftGlue.ItemStacks_NULLSTACK();
        if (def != null && def._can_fry) {
            stack = new ItemStack((Item)INSTANCE, 1, def.fried_meta());
        }
        return stack;
    }

    public static final ItemStack combo(NuggetDef def) {
        ItemStack stack = MinecraftGlue.ItemStacks_NULLSTACK();
        if (def != null && def._can_mix) {
            stack = new ItemStack((Item)INSTANCE, 1, def.combo_meta());
        }
        return stack;
    }

    static {
        VARIANT_SET = new VfpVariantSet.ByMapInstance((VfpProfile)VfpOid.Nuggets, (Class)Nuggets.class, "type"){

            @Override
            public String[] renderNames() {
                VfpVariant[] enumset = this.declaredVariants();
                String[] names = new String[enumset.length];
                for (int i = 0; i < enumset.length; ++i) {
                    names[i] = "vanillafoodpantry:" + enumset[i].datadata(String.class);
                }
                return names;
            }

            @Override
            protected VfpVariant[] declaredVariants() {
                assert (VARIANT_ARRAY != null);
                return VARIANT_ARRAY;
            }
        };
    }

    public static enum NuggetDef {
        Chicken(12, "chicken", "light_meat", MeatPortions.getDef(PackagedFood.CHICKEN), true, false, true, false),
        Beef(24, "beef", "dark_meat", MeatPortions.getDef(PackagedFood.BEEF), true, true, true, false),
        Fish(36, "fish", "fish", "portionFish", true, true, true, false),
        Mushroom(48, "mushrooms", "mushroom", "foodMushroom", true, false, true, false),
        Veggie(60, "veggies", "veggie", "ingredientVegNugget", true, false, true, false),
        Squid(72, "squid", "squid", MeatPortions.getDef(PackagedFood.SQUID), true, false, true, false),
        Porkchop(84, "porkchop", "porkchop", MeatPortions.getDef(PackagedFood.COOKED_PORK), false, false, true, true);

        private final int _meta_raw;
        private final String _name;
        final String _type;
        private final Object _raw_ingredient;
        final boolean _can_fry;
        final boolean _can_dry;
        final boolean _can_mix;
        private final boolean _heavy;

        private NuggetDef(int meta, String name, String kind, Object raw, boolean fry, boolean dry, boolean mix, boolean heavy) {
            this._meta_raw = meta;
            this._name = name;
            this._type = kind;
            this._raw_ingredient = raw;
            this._heavy = heavy;
            this._can_fry = fry;
            this._can_dry = dry;
            this._can_mix = mix;
        }

        private void install(int prep_meta, String variety, LikeFood plate, List<VfpVariant> variants, VfpVariantSet variantset) {
            String rendername;
            String fmlid;
            if (plate == null) {
                fmlid = "nuggets_" + this._name + "_" + variety + "_prep";
                rendername = "nugget_" + this._type + "_" + variety + "_prep";
                variants.add(new VfpTransientVariant(prep_meta + 0, fmlid, LikeFood.uncooked_meat_portion, rendername, null, variantset));
            }
            fmlid = "nuggets_" + this._name + "_" + variety;
            rendername = "nugget_" + this._type + "_" + variety;
            variants.add(new VfpTransientVariant(prep_meta + 1, fmlid, plate == null ? ("jerky".equals(variety) ? LikeFood.jerky_bit : LikeFood.meat_portion) : plate, rendername, null, variantset));
        }

        void install(List<VfpVariant> variants, VfpVariantSet variantset) {
            if (this._can_fry) {
                this.install(this.fried_prep_meta(), "fried", null, variants, variantset);
            }
            if (this._can_dry) {
                this.install(this.jerky_prep_meta(), "jerky", null, variants, variantset);
            }
            if (this._can_mix) {
                this.install(this.combo_prep_meta(), "combo", this._heavy ? LikeFood.nugget_combo_heavy : LikeFood.nugget_combo, variants, variantset);
            }
        }

        final Object raw_ingredient() {
            return this._raw_ingredient instanceof MinecraftGlue.ItemStackDef ? MinecraftGlue.ItemStackDef.convert(this._raw_ingredient) : this._raw_ingredient;
        }

        final int fried_prep_meta() {
            return this._meta_raw + 0;
        }

        final int fried_meta() {
            return this._meta_raw + 1;
        }

        final int jerky_prep_meta() {
            return this._meta_raw + 2;
        }

        final int jerky_meta() {
            return this._meta_raw + 3;
        }

        final int combo_prep_meta() {
            return this._meta_raw + 4;
        }

        final int combo_meta() {
            return this._meta_raw + 5;
        }

        final String combo_fmlid() {
            return "nuggets_" + this._name + "_combo";
        }

        final String fried_fmlid() {
            return "nuggets_" + this._name + "_fried";
        }

        final String jerky_fmlid() {
            return "nuggets_" + this._name + "_jerky";
        }
    }
}

