/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.milk;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.common.Ingredient;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.LiquidType;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.milk.MilkDrinks;

public final class TeaDrinks
extends VfpLiquidMultiItem {
    private static final String _MILKY_MARKER = "milky";
    private static final int GENERIC_TEADRINK_COLOR = 6585650;
    private static int _BUSH_TEA = -1;
    private static final List<Ingredient> VARIANT_FLAVORS = new ArrayList<Ingredient>();
    private static final Map<Ingredient, Integer> VARIANT_COLORS = new Hashtable<Ingredient, Integer>();
    static VfpVariant[] VARIANT_ARRAY;
    private static final VfpVariantSet VARIANT_SET;
    private static TeaDrinks INSTANCE;
    private static ItemStack[] TYPED_INSTANCES;

    public static final synchronized boolean register(Ingredient flavor, int colorValue) {
        boolean registered = TeaDrinks.register(flavor, VARIANT_FLAVORS, "tea drinks");
        if (registered && colorValue > 0) {
            VARIANT_COLORS.put(flavor, colorValue);
        }
        return registered;
    }

    public static final synchronized boolean register(FoodPowders.Type flavor) {
        Validate.notNull((Object)flavor, (String)"A non-null flavor is required for a tea drink", (Object[])new Object[0]);
        String name = flavor.name_lowercased();
        return TeaDrinks.register(FoodPowders.toIngredient(flavor, FoodPowders.Usage.DRINK_FLAVOR, name), -1);
    }

    public TeaDrinks(VfpOid oid, CreativeTabs tab) {
        super((VfpProfile)oid, VARIANT_SET, LiquidType.TEA, tab);
    }

    @Override
    protected ItemStack getNewEmptyContainer() {
        return new ItemStack(VfpObj.Our_Empty_Bottle_obj);
    }

    @Override
    protected VfpCapacity getItemMaxStackSize() {
        return VfpConfig.getInstance().maxDrinksStackCapacity(super.getItemMaxStackSize());
    }

    @Override
    protected Integer getVariantColorFromMeta(VfpVariant type, Ingredient ingredient, int renderPass) {
        Integer colorValue = VARIANT_COLORS.get(ingredient);
        if (colorValue == null && (colorValue = super.getVariantColorFromMeta(type, ingredient, renderPass)) == null) {
            colorValue = 6585650;
        }
        return colorValue;
    }

    private static boolean isCurative(Ingredient ingredient) {
        return ingredient.name().contains(_MILKY_MARKER);
    }

    private boolean isCurative(ItemStack stack) {
        Ingredient ingredient = VfpVariant.byItemStack(stack, this._variant_default).datadata(Ingredient.class);
        return TeaDrinks.isCurative(ingredient);
    }

    @Override
    protected boolean canConsume(ItemStack drink, World world, EntityPlayer player) {
        return player.func_71043_e(this.isCurative(drink) || this._alwaysEdibleFlag);
    }

    @Override
    protected void onFoodEaten(ItemStack eaten, ItemStack remaining, World world, EntityPlayer player) {
        if (MinecraftGlue.isaServerWorld((IBlockAccess)world) && this.isCurative(eaten)) {
            MinecraftGlue.Potions.cureBadPotionEffectsWithMilk(player, false, false);
        }
        super.onFoodEaten(eaten, remaining, world, player);
    }

    static final TeaDrinks makeObjects() {
        if (INSTANCE == null && VARIANT_FLAVORS.size() > 0) {
            ArrayList<VfpTransientVariant> variants = new ArrayList<VfpTransientVariant>(18);
            String typeName = VARIANT_SET.typeName();
            for (Ingredient ingredient : VARIANT_FLAVORS) {
                boolean milky = TeaDrinks.isCurative(ingredient);
                variants.add(new VfpTransientVariant(ingredient.id(), typeName, milky ? LikeFood.milky_bush_tea : LikeFood.bush_tea, ingredient, null, VARIANT_SET));
                if (FoodPowders.findType(ingredient.name()) != FoodPowders.Type.BUSHTEA) continue;
                _BUSH_TEA = ingredient.id();
            }
            VARIANT_ARRAY = variants.toArray(VfpVariant.EMPTY_ARRAY);
            INSTANCE = VfpBuilder.newMultiItem(VfpOid.TeaDrink, TeaDrinks.class);
        }
        return INSTANCE;
    }

    static final void addDictionaryEntries() {
        if (INSTANCE != null) {
            for (Ingredient ingredient : VARIANT_FLAVORS) {
                if (!ingredient.isEnabled()) continue;
                ItemStack a_tea_drink = new ItemStack((Item)INSTANCE, 1, ingredient.id());
                OreDictionary.registerOre((String)"foodDrink", (ItemStack)a_tea_drink);
                if (!TeaDrinks.isCurative(ingredient)) continue;
                OreDictionary.registerOre((String)"foodCurative", (ItemStack)a_tea_drink);
            }
        }
    }

    static final void buildRecipes(@Nonnull IForgeRegistry<IRecipe> recipes) {
        if (INSTANCE != null && TYPED_INSTANCES == null) {
            ArrayList<ItemStack> instances = new ArrayList<ItemStack>(36);
            ItemStack cream_bottle = MilkDrinks.heavy(1);
            String water_bottle = "itemWaterBottle";
            for (int i = 0; i < VARIANT_ARRAY.length; ++i) {
                Ingredient ingredient = VARIANT_ARRAY[i].datadata(Ingredient.class);
                instances.add(new ItemStack((Item)INSTANCE, 1, ingredient.id()));
                if (!ingredient.isEnabled()) continue;
                boolean milky = TeaDrinks.isCurative(ingredient);
                ItemStack a_tea_drink = new ItemStack((Item)INSTANCE, 1, ingredient.id());
                String recipeitem = ingredient.isClassifier() ? ingredient.recipeitemName() : ingredient.recipeitem();
                String rid = VfpOid.TeaDrink.fmlid() + "_" + ingredient.name();
                recipes.register((IForgeRegistryEntry)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(null, a_tea_drink, new Object[]{"ts", "b ", Character.valueOf('t'), recipeitem, Character.valueOf('s'), "ingredientSweetener", Character.valueOf('b'), milky ? cream_bottle : water_bottle}).setRegistryName(ModInfo.r(rid)), LikeFood.bush_tea.craftExperience()));
                recipes.register(new ShapedOreRecipe(null, a_tea_drink, new Object[]{"t ", "b ", Character.valueOf('t'), recipeitem, Character.valueOf('b'), milky ? cream_bottle : water_bottle}).setRegistryName(ModInfo.r(rid + "_sugarfree")));
            }
            TYPED_INSTANCES = instances.toArray(new ItemStack[0]);
        }
    }

    public static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    public static final ItemStack bush(int amount) {
        return _BUSH_TEA >= 0 ? new ItemStack((Item)INSTANCE, amount, _BUSH_TEA) : MinecraftGlue.ItemStacks_NULLSTACK();
    }

    static {
        VARIANT_SET = new VfpLiquidMultiItem.VariantSet((VfpProfile)VfpOid.TeaDrink, (Class)TeaDrinks.class){

            @Override
            protected VfpVariant[] declaredVariants() {
                assert (VARIANT_ARRAY != null);
                return VARIANT_ARRAY;
            }
        };
    }
}

