/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.misc;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.oredict.OreDictionary;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpRecipe;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.misc.DeckerSandwiches;
import org.jwaresoftware.mcmods.vfp.misc.EdibleCactus;
import org.jwaresoftware.mcmods.vfp.wheat.Breads;

public class GenericDeckerSandwichRecipe
extends VfpRecipe {
    private static ItemStack _FLAT_BREAD;
    private static List<ItemStack> _ROASTED_VEGGIES_MAIN;
    private static List<ItemStack> _ROASTED_VEGGIES_FILL;
    private static String[] _PROTEIN_CATEGORIES;
    private static Iterable<ItemStack> _COOKED_PROTEIN_ITEMS;
    private static String[] _VEGFRUIT_CATEGORIES;
    private static Iterable<ItemStack> _COOKED_VEGFRUIT_ITEMS;

    private static final boolean is_cooked_protein(ItemStack stack) {
        if (_COOKED_PROTEIN_ITEMS == null) {
            _COOKED_PROTEIN_ITEMS = Iterables.concat((Iterable[])new Iterable[]{_ROASTED_VEGGIES_MAIN, OreDictionary.getOres((String)_PROTEIN_CATEGORIES[0]), OreDictionary.getOres((String)_PROTEIN_CATEGORIES[1]), OreDictionary.getOres((String)_PROTEIN_CATEGORIES[2]), OreDictionary.getOres((String)_PROTEIN_CATEGORIES[3])});
        }
        if (!MinecraftGlue.ItemStacks_isEmpty(stack)) {
            for (ItemStack protein : _COOKED_PROTEIN_ITEMS) {
                if (!OreDictionary.itemMatches((ItemStack)protein, (ItemStack)stack, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    private static final boolean is_cooked_vegfruit(ItemStack stack) {
        if (_COOKED_VEGFRUIT_ITEMS == null) {
            _COOKED_VEGFRUIT_ITEMS = Iterables.concat(_ROASTED_VEGGIES_FILL, (Iterable)OreDictionary.getOres((String)_VEGFRUIT_CATEGORIES[0]), (Iterable)OreDictionary.getOres((String)_VEGFRUIT_CATEGORIES[1]), (Iterable)OreDictionary.getOres((String)_VEGFRUIT_CATEGORIES[2]));
        }
        if (!MinecraftGlue.ItemStacks_isEmpty(stack)) {
            for (ItemStack vegfruit : _COOKED_VEGFRUIT_ITEMS) {
                if (!OreDictionary.itemMatches((ItemStack)vegfruit, (ItemStack)stack, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    static final void lateinit(VfpConfig config) {
        _FLAT_BREAD = Breads.flat(1);
        _ROASTED_VEGGIES_MAIN = Arrays.asList(VfpBuilder.newItemInstance(VfpObj.Roasted_Veg_Medley_obj), EdibleCactus.roasted_slice(1), VfpBuilder.newItemInstance(VfpObj.Glazed_Carrots_obj));
        _ROASTED_VEGGIES_FILL = Arrays.asList(_ROASTED_VEGGIES_MAIN.get(0).func_77946_l(), _ROASTED_VEGGIES_MAIN.get(1).func_77946_l(), _ROASTED_VEGGIES_MAIN.get(2).func_77946_l(), VfpBuilder.newItemInstance(VfpObj.Portion_Roasted_Veg_obj), EdibleCactus.steamed_portion(1));
        ItemStack junk = new ItemStack(MinecraftGlue.Items_brick);
        GenericDeckerSandwichRecipe.is_cooked_protein(junk);
        GenericDeckerSandwichRecipe.is_cooked_vegfruit(junk);
    }

    public ItemStack func_77571_b() {
        return MinecraftGlue.ItemStacks_NULLSTACK();
    }

    public boolean func_194133_a(int width, int height) {
        return this.canFitCommonTableGrid(width, height, true);
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting grid) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)grid);
    }

    public boolean func_77569_a(InventoryCrafting grid, World world) {
        int i;
        if (grid.func_70302_i_() < MinecraftGlue.TABLE_CRAFT_GRID_SIZE()) {
            return false;
        }
        ItemStack stack = grid.func_70301_a(0);
        if (!MinecraftGlue.RID.matches(stack, "foodBreadSandwich", MinecraftGlue.Items_bread) && !OreDictionary.itemMatches((ItemStack)_FLAT_BREAD, (ItemStack)stack, (boolean)false)) {
            return false;
        }
        stack = grid.func_70301_a(8);
        if (stack.func_77973_b() != VfpObj.Sandwich_Press_Plate_obj) {
            return false;
        }
        int n = 0;
        for (i = 1; i < 3; ++i) {
            stack = grid.func_70301_a(i);
            if (MinecraftGlue.ItemStacks_isEmpty(stack)) continue;
            if (!GenericDeckerSandwichRecipe.is_cooked_protein(stack)) {
                return false;
            }
            ++n;
        }
        if (n < 1) {
            return false;
        }
        for (i = 3; i < 6; ++i) {
            stack = grid.func_70301_a(i);
            if (MinecraftGlue.ItemStacks_isEmpty(stack) || GenericDeckerSandwichRecipe.is_cooked_vegfruit(stack)) continue;
            return false;
        }
        for (i = 6; i < 8; ++i) {
            stack = grid.func_70301_a(i);
            if (MinecraftGlue.ItemStacks_isEmpty(stack) || MinecraftGlue.RID.matches(stack, "ingredientCondiment")) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_77572_b(InventoryCrafting grid) {
        return DeckerSandwiches.create((IItemHandler)new InvWrapper((IInventory)grid));
    }

    static {
        _ROASTED_VEGGIES_MAIN = Collections.EMPTY_LIST;
        _ROASTED_VEGGIES_FILL = Collections.EMPTY_LIST;
        _PROTEIN_CATEGORIES = new String[]{"foodGoodMeatCooked", "foodCheese", "foodTofu", "foodProteinCooked"};
        _COOKED_PROTEIN_ITEMS = null;
        _VEGFRUIT_CATEGORIES = new String[]{"foodKebabVeggie", "foodKebabFruit", "ingredientSalad"};
        _COOKED_VEGFRUIT_ITEMS = null;
    }
}

