/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.misc;

import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jwaresoftware.mcmods.vfp.Integrations;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.agents.JuJuExtensions;
import org.jwaresoftware.mcmods.vfp.carton.BagsOf;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.OneXp;
import org.jwaresoftware.mcmods.vfp.common.PackagedFood;
import org.jwaresoftware.mcmods.vfp.common.VfpAware;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpCraftOnlyItem;
import org.jwaresoftware.mcmods.vfp.common.VfpFertilizerItem;
import org.jwaresoftware.mcmods.vfp.common.VfpMultiUseJarIngredient;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpSpecialSalad;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.core.ModDrops;
import org.jwaresoftware.mcmods.vfp.core.VfpBuildHelperSupport;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.core.VfpRuntime;
import org.jwaresoftware.mcmods.vfp.core.crafting.LegacyShapelessOreRecipe;
import org.jwaresoftware.mcmods.vfp.integrations.IntegrationsImpl;
import org.jwaresoftware.mcmods.vfp.misc.DeckerSandwiches;
import org.jwaresoftware.mcmods.vfp.misc.EdibleCactus;
import org.jwaresoftware.mcmods.vfp.misc.FluidSourceInteractionHandler;
import org.jwaresoftware.mcmods.vfp.misc.Gelos;
import org.jwaresoftware.mcmods.vfp.misc.GenericDeckerSandwichRecipe;
import org.jwaresoftware.mcmods.vfp.misc.Juices;
import org.jwaresoftware.mcmods.vfp.misc.Migration;
import org.jwaresoftware.mcmods.vfp.misc.RoastedSeeds;
import org.jwaresoftware.mcmods.vfp.misc.Sandwiches;
import org.jwaresoftware.mcmods.vfp.misc.StewedItems;
import org.jwaresoftware.mcmods.vfp.misc.Tatoes;
import org.jwaresoftware.mcmods.vfp.misc.VfpCutterItem;
import org.jwaresoftware.mcmods.vfp.sugar.DrinkSyrups;
import org.jwaresoftware.mcmods.vfp.sugar.FizzyDrinks;
import org.jwaresoftware.mcmods.vfp.sugar.SimpleCookies;
import org.jwaresoftware.mcmods.vfp.sugar.Snowcones;
import org.jwaresoftware.mcmods.vfp.tonics.BootlegGelo;
import org.jwaresoftware.mcmods.vfp.tonics.TonicDrink;
import org.jwaresoftware.mcmods.vfp.wheat.DessertPies;
import org.jwaresoftware.mcmods.vfp.wheat.DoughBallType;

public final class MiscBuildHelper
extends VfpBuildHelperSupport {
    private static final int FLINT_CUTTER_USES = 16;

    @Override
    protected String categoryName() {
        return "Miscellaneous";
    }

    @Override
    public void installEventBusHandlers(VfpRuntime runtime) {
        ModDrops.HarvestDropsHandler eventHandler = ModDrops.HarvestDropsHandler.init(runtime.getConfig());
        if (eventHandler != null) {
            MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        }
        MinecraftForge.EVENT_BUS.register((Object)new FluidSourceInteractionHandler());
    }

    @Override
    public void makeObjects(VfpRuntime runtime) {
        VfpConfig config = runtime.getConfig();
        boolean brewingEnabled = config.includePotionBrewing();
        VfpObj.Red_Flint_obj = VfpBuilder.newItem(VfpOid.Red_Flint);
        VfpObj.Flint_Cutter_obj = new VfpCutterItem((VfpProfile)VfpOid.Flint_Cutter, 16).autoregister();
        VfpObj.Sand_Jar_obj = new VfpCraftOnlyItem((VfpProfile)VfpOid.Sand_Jar, true).autoregister();
        VfpObj.Weighted_Plate_obj = VfpBuilder.newCraftOnlyItem(VfpOid.Weighted_Plate);
        VfpObj.Sandwich_Press_Plate_obj = VfpBuilder.newCraftOnlyItem(VfpOid.Sandwich_Press_Plate);
        VfpObj.Flesh_Meal_obj = new VfpFertilizerItem(VfpOid.Flesh_Meal).autoregister();
        VfpFertilizerItem.initDispenseBehavior(VfpObj.Flesh_Meal_obj);
        VfpObj.Animal_Hide_Tie_obj = VfpBuilder.newItem(VfpOid.Animal_Hide_Tie);
        VfpObj.Portion_Leather_obj = VfpBuilder.newItem(VfpOid.Portion_Leather);
        VfpObj.Bone_Pencil_obj = VfpBuilder.newMisc(VfpOid.Bone_Pencil);
        VfpObj.Fire_Proofing_Powder_obj = VfpBuilder.newBrewingItem(VfpOid.Fire_Proofing_Powder, brewingEnabled ? MinecraftGlue.BrewEffect.magmaCreamEffect : null, false);
        VfpObj.Fermented_Feather_obj = VfpBuilder.newBrewingItem(VfpOid.Fermented_Feather, brewingEnabled ? MinecraftGlue.BrewEffect.fermentedSpiderEyeEffect : null, false);
        SimpleCookies.register(FoodPowders.toIngredient(FoodPowders.Type.COCOA, SimpleCookies.COCOA_COOKIE_ID, null));
        SimpleCookies.register(FoodPowders.toIngredient(FoodPowders.Type.CACTUS, SimpleCookies.KLINGON_COOKIE_ID, "klingon"));
        SimpleCookies.register(FoodPowders.toIngredient(FoodPowders.Type.APPLE, SimpleCookies.APPLE_COOKIE_ID, null));
        VfpObj.Potion_Mixer_Funnel_obj = VfpBuilder.newItem(VfpOid.Potion_Mixer_Funnel);
        VfpObj.Potion_Mixer_Funnel_obj.func_77637_a(MinecraftGlue.CreativeTabs_brewing);
        VfpObj.Tonic_Drink_obj = new TonicDrink();
        VfpObj.Bootleg_Gelo_obj = new BootlegGelo();
        for (FoodPowders.Type powder : FoodPowders.Type.values()) {
            if (!powder.isDrinkFlavor() || powder == FoodPowders.Type.CREAM || powder == FoodPowders.Type.MILK) continue;
            Gelos.register(powder);
        }
        Gelos.register(FoodPowders.Type.UGLI_FRUIT);
        VfpObj.Roasted_Seeds_obj = RoastedSeeds.makeObjects(config);
        VfpObj.Raw_Veg_Medley_obj = VfpBuilder.newFood(VfpOid.Raw_Vegetables, LikeFood.raw_veg_medley);
        VfpObj.Roasted_Veg_Medley_obj = VfpBuilder.newFood(VfpOid.Roasted_Vegetables, LikeFood.roast_veg_medley);
        VfpObj.Portion_Roasted_Veg_obj = VfpBuilder.newBowlFood(VfpOid.Portion_Roasted_Veg, LikeFood.roast_veg);
        VfpObj.Chopped_Alliums_obj = VfpBuilder.newPortion(VfpOid.Chopped_Alliums);
        VfpObj.Caramelized_Alliums_obj = VfpBuilder.newFood(VfpOid.Caramelized_Alliums, LikeFood.crumb);
        VfpObj.Sauteed_Alliums_Mushrooms_obj = VfpBuilder.newFood(VfpOid.Sauteed_Alliums_Mushrooms, LikeFood.veg_portion);
        VfpObj.Edible_Cactus_obj = EdibleCactus.makeObjects();
        VfpObj.Glazed_Carrots_obj = VfpBuilder.newBowlFood(VfpOid.Molasses_Glazed_Carrots, LikeFood.glazed_carrots);
        VfpObj.AppleSlices_Sunbutter_Snack_obj = VfpBuilder.newFood(VfpOid.AppleSlices_Sunbutter_Snack, LikeFood.sunbutter_apple_snack).setConsumeFullyContainerItem(MinecraftGlue.Items_bowl);
        VfpObj.Carrot_Sunbutter_Snack_obj = VfpBuilder.newFood(VfpOid.Carrot_Sunbutter_Snack, LikeFood.sunbutter_carrot_snack);
        VfpObj.Carrot_Burger_obj = VfpBuilder.newFood(VfpOid.Carrot_Burger, LikeFood.vegetable_stew_meal);
        VfpObj.Special_Salad_obj = VfpSpecialSalad.newSalad();
        VfpObj.Fungi_Purged_obj = VfpBuilder.newFood(VfpOid.Fungi_Purged, LikeFood.uncooked_mushroom);
        VfpObj.Sunbutter_Jar_obj = VfpMultiUseJarIngredient.newPlainJar(VfpOid.Sunbutter_Jar, 5).func_77642_a(VfpObj.Dark_Empty_Jar_obj);
        VfpObj.Sandwiches_obj = Sandwiches.makeObjects();
        VfpObj.Decker_Sandwiches_obj = DeckerSandwiches.makeObjects();
        VfpObj.Pumpkin_Portion_obj = VfpBuilder.newFood(VfpOid.Pumpkin_Portion, LikeFood.uncooked_potato);
        VfpObj.Roasted_Pumpkin_Portion_obj = VfpBuilder.newFood(VfpOid.Roasted_Pumpkin_Portion, LikeFood.carrot);
        VfpObj.Uncooked_Pumpkin_Pie_obj = VfpBuilder.newItem(VfpOid.Uncooked_Enriched_Pumpkin_Pie);
        VfpObj.Pumpkin_Pie_obj = new DessertPies(VfpOid.Enriched_Pumpkin_Pie);
        VfpObj.Cake_Slice_obj = VfpBuilder.newSoakableFood(VfpOid.Cake_Slice, LikeFood.cake_slice);
        VfpObj.Stewed_Items_obj = StewedItems.makeObjects();
        VfpObj.Tatoes_obj = Tatoes.makeObjects();
        VfpObj.Raftugli_Fruit_obj = VfpBuilder.newFood(VfpOid.Raftugli_Fruit, LikeFood.raftugli_fruit);
        this.registerJuiceFlavors(config);
        this.registerSnoconeFlavors(config);
        VfpObj.Roast_Corn_obj = VfpBuilder.newOptionalFood(VfpOid.Roast_Corn, LikeFood.potato, VfpAware.IdDomain.MODID, Integrations.CFP.modid());
        VfpObj.Roasted_Eggplant_obj = VfpBuilder.newOptionalFood(VfpOid.Roasted_Eggplant, LikeFood.potato, VfpAware.IdDomain.MODID, Integrations.CFP.modid());
    }

    @Override
    public void makeObjectsFinalPass(VfpRuntime runtime) {
        VfpObj.SimpleCookies_obj = SimpleCookies.makeObjects();
        VfpObj.FizzyDrinks_obj = FizzyDrinks.makeObjects();
        VfpObj.Gelos_obj = Gelos.makeObjects();
        VfpObj.Juices_obj = Juices.makeObjects();
        VfpObj.Snocones_obj = Snowcones.makeObjects();
        VfpObj.Iron_Stomach_obj = VfpBuilder.newMisc(VfpOid.Iron_Stomach);
    }

    @Override
    public void linkLikeFoods(VfpRuntime runtime) {
        LikeFood.buttered_potato.food().item(MinecraftGlue.Items_baked_potato);
        LikeFood.mashed_potato.food().item(Tatoes.pinkmash());
        LikeFood.stuffed_potato.food().item(Tatoes.wellstuffed());
        LikeFood.overstuffed_potato.food().item(Tatoes.fishstuffed());
        LikeFood.raw_veg_medley.food().item(VfpObj.Raw_Veg_Medley_obj);
        LikeFood.roast_veg_medley.food().item(VfpObj.Roasted_Veg_Medley_obj);
        LikeFood.roast_veg.food().item(VfpObj.Portion_Roasted_Veg_obj);
        LikeFood.glazed_carrots.food().item(VfpObj.Glazed_Carrots_obj);
        LikeFood.special_salad.food().item(VfpObj.Special_Salad_obj);
        LikeFood.raftugli_fruit.food().item(VfpObj.Raftugli_Fruit_obj);
        LikeFood.sunbutter_apple_snack.food().item(VfpObj.AppleSlices_Sunbutter_Snack_obj);
        LikeFood.sunbutter_carrot_snack.food().item(VfpObj.Carrot_Sunbutter_Snack_obj);
        LikeFood.enriched_dessert_pie.food().item(VfpObj.Pumpkin_Pie_obj);
        LikeFood.cake_slice.food().item(VfpObj.Cake_Slice_obj);
    }

    @Override
    public void addDictionaryEntries(VfpRuntime runtime) {
        VfpConfig config = runtime.getConfig();
        OreDictionary.registerOre((String)"itemRawFlint", (Item)MinecraftGlue.Items_flint);
        OreDictionary.registerOre((String)"itemRawFlint", (Item)VfpObj.Red_Flint_obj);
        VfpCutterItem.registerAllUnderDictEntry("itemFoodCutter", VfpObj.Flint_Cutter_obj);
        OreDictionary.registerOre((String)"itemFoodCutter", (ItemStack)new ItemStack(VfpObj.Flint_Butcher_Axe_obj, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"itemFleshmeal", (Item)VfpObj.Flesh_Meal_obj);
        OreDictionary.registerOre((String)"bonemeal", (Item)VfpObj.Flesh_Meal_obj);
        IntegrationsImpl.registerAsTie(MinecraftGlue.Items_string);
        IntegrationsImpl.registerAsTie(VfpObj.Animal_Hide_Tie_obj);
        OreDictionary.registerOre((String)"portionHideSmall", (Item)MinecraftGlue.Items_rabbit_hide);
        OreDictionary.registerOre((String)"portionHideSmall", (Item)VfpObj.Portion_Leather_obj);
        OreDictionary.registerOre((String)"ingredientSalad", (Item)VfpObj.Portion_Roasted_Veg_obj);
        OreDictionary.registerOre((String)"ingredientSalad", (Item)VfpObj.Glazed_Carrots_obj);
        OreDictionary.registerOre((String)"ingredientAllium", (Item)VfpObj.Chopped_Alliums_obj);
        OreDictionary.registerOre((String)"ingredientCondiment", (Item)VfpObj.Caramelized_Alliums_obj);
        OreDictionary.registerOre((String)"ingredientCondiment", (Item)VfpObj.Sauteed_Alliums_Mushrooms_obj);
        OreDictionary.registerOre((String)"ingredientKebabFill", (Item)VfpObj.Fungi_Purged_obj);
        OreDictionary.registerOre((String)"ingredientMushroom", (Item)VfpObj.Fungi_Purged_obj);
        OreDictionary.registerOre((String)"foodMushroom", (Item)VfpObj.Fungi_Purged_obj);
        OreDictionary.registerOre((String)"ingredientKebabMain", (Item)VfpObj.Pumpkin_Portion_obj);
        OreDictionary.registerOre((String)"ingredientKebabMain", (Item)VfpObj.Roasted_Pumpkin_Portion_obj);
        if (config.isModLoaded(Integrations.CFP) || config.isModLoaded(Integrations.PMP)) {
            OreDictionary.registerOre((String)"foodGrilledeggplant", (Item)VfpObj.Roasted_Eggplant_obj);
        }
        OreDictionary.registerOre((String)"ingredientCitrusFill", (Item)VfpObj.Raftugli_Fruit_obj);
        OreDictionary.registerOre((String)"foodCitrusFruit", (Item)VfpObj.Raftugli_Fruit_obj);
        OreDictionary.registerOre((String)"foodDrinkPotion", (Item)MinecraftGlue.Items_potion_water);
        OreDictionary.registerOre((String)"foodDrinkPotion", (Item)VfpObj.Tonic_Drink_obj);
        OreDictionary.registerOre((String)"itemPotionBottle", (Item)VfpObj.Tonic_Drink_obj);
        OreDictionary.registerOre((String)"ingredientSunButter", (Item)VfpObj.Sunbutter_Jar_obj);
        OreDictionary.registerOre((String)"foodKebabVeggie", (Item)VfpObj.Carrot_Sunbutter_Snack_obj);
        OreDictionary.registerOre((String)"foodKebabFruit", (Item)VfpObj.AppleSlices_Sunbutter_Snack_obj);
        OreDictionary.registerOre((String)"foodPie", (Item)VfpObj.Pumpkin_Pie_obj);
        OreDictionary.registerOre((String)"foodSandwich", (Item)VfpObj.Carrot_Burger_obj);
        EdibleCactus.addDictionaryEntries();
        SimpleCookies.addDictionaryEntries();
        Gelos.addDictionaryEntries();
        Juices.addDictionaryEntries();
        FizzyDrinks.addDictionaryEntries();
        RoastedSeeds.addDictionaryEntries();
        Sandwiches.addDictionaryEntries();
        Tatoes.addDictionaryEntries();
        StewedItems.addDictionaryEntries();
        Snowcones.addDictionaryEntries();
    }

    @Override
    public void addLootEntries(VfpRuntime runtime) {
        MinecraftGlue.Loot.addFishedUpJunk("vanillafoodpantry", VfpOid.Bit_Pipette.fmlid(), VfpObj.Bit_Pipette_obj);
        MinecraftGlue.Loot.addFishedUpJunk("vanillafoodpantry", VfpOid.Flint_Cutter.fmlid(), VfpCutterItem.junk());
        MinecraftGlue.Loot.addFishedUpJunk("vanillafoodpantry", VfpOid.Empty_Jar.fmlid(), VfpObj.Empty_Jar_obj);
        MinecraftGlue.Loot.addFishedUpJunk("vanillafoodpantry", VfpOid.Dark_Empty_Jar.fmlid(), VfpObj.Dark_Empty_Jar_obj);
        MinecraftGlue.Loot.addFishedUpJunk("vanillafoodpantry", VfpOid.Animal_Hide_Tie.fmlid(), VfpObj.Animal_Hide_Tie_obj);
        MinecraftGlue.Loot.addFishedUpUncommon("vanillafoodpantry", VfpOid.Jungle_Juice_Jar.fmlid(), JuJuExtensions.jujujuice());
        MinecraftGlue.Loot.addFishedUpUncommon("vanillafoodpantry", VfpOid.Ink_Pearl_Shard.fmlid(), VfpObj.Ink_Pearl_Shard_obj);
    }

    private void autorecipeRottenThings(IForgeRegistry<IRecipe> recipes) {
        recipes.register(new ShapedOreRecipe(null, new ItemStack(MinecraftGlue.Items_rotten_flesh, 3), new Object[]{"mmm", "j  ", Character.valueOf('m'), "foodRedMeat", Character.valueOf('j'), "additivePoisoner"}).setRegistryName(ModInfo.r("crafted_rotten_flesh")));
        recipes.register((IForgeRegistryEntry)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(null, new ItemStack(VfpObj.Flesh_Meal_obj, VfpCapacity.MAX_STACK_LCD.count()), new Object[]{"rrr", "cfw", Character.valueOf('r'), "rottenflesh", Character.valueOf('c'), VfpObj.Charcoal_obj, Character.valueOf('f'), FoodPowders.get(FoodPowders.Type.FEATHER, 1), Character.valueOf('w'), "portionWaterSmall"}).setRegistryName(ModInfo.r(VfpOid.Flesh_Meal.fmlid())), VfpOid.Flesh_Meal.craftingXp()));
        ItemStack bonemeal = VfpObj.Bonemeal_obj.func_77946_l();
        MinecraftGlue.ItemStacks_setSize(bonemeal, 7);
        recipes.register(new ShapedOreRecipe(null, bonemeal, new Object[]{"xbx", "xbx", "xbx", Character.valueOf('x'), VfpObj.Flesh_Meal_obj, Character.valueOf('b'), VfpObj.Small_Bone_obj}).setRegistryName(ModInfo.r("bonemeal_from_fleshmeal_and_smallbones")));
        if (VfpUtils.ingredientDefined("dustBleach")) {
            recipes.register(new ShapedOreRecipe(null, bonemeal, new Object[]{"xxx", "xbx", "xxx", Character.valueOf('x'), VfpObj.Flesh_Meal_obj, Character.valueOf('b'), "dustBleach"}).setRegistryName(ModInfo.r("bonemeal_from_fleshmeal")));
        }
        recipes.register(new ShapedOreRecipe(null, new ItemStack(VfpObj.Fermented_Feather_obj, 3), new Object[]{"fff", "fff", "jB ", Character.valueOf('f'), "feather", Character.valueOf('j'), "additivePoisoner", Character.valueOf('B'), VfpObj.Fermenting_Bucket_obj}).setRegistryName(ModInfo.r(VfpOid.Fermented_Feather.fmlid())));
        if (VfpUtils.ingredientDefined("packFeathers")) {
            recipes.register(new ShapedOreRecipe(null, new ItemStack(VfpObj.Fermented_Feather_obj, 13), new Object[]{"fff", "jB ", Character.valueOf('f'), "packFeathers", Character.valueOf('j'), "additivePoisoner", Character.valueOf('B'), VfpObj.Fermenting_Bucket_obj}).setRegistryName(ModInfo.r(VfpOid.Fermented_Feather.fmlid() + "_batch")));
        }
        recipes.register(new ShapedOreRecipe(null, new ItemStack(MinecraftGlue.Items_poisonous_potato, 6), new Object[]{"ppp", "ppp", "jB ", Character.valueOf('p'), MinecraftGlue.Items_potato, Character.valueOf('j'), "additivePoisoner", Character.valueOf('B'), VfpObj.Fermenting_Bucket_obj}).setRegistryName(ModInfo.r("crafted_poisonous_potatoes")));
    }

    private void autorecipeVanillaStorageBlockIntegration(VfpConfig config, IForgeRegistry<IRecipe> recipes) {
        recipes.register(new LegacyShapelessOreRecipe(null, new ItemStack(MinecraftGlue.Items_melon, VfpCapacity.STANDARD_BLOCK.count()), MinecraftGlue.Blocks_melon_block, "itemFoodCutter").setRegistryName(ModInfo.r("crafted_melon_slices_from_melon_block")));
        recipes.register(new LegacyShapelessOreRecipe(null, new ItemStack(VfpObj.Pumpkin_Portion_obj, VfpCapacity.STANDARD_BLOCK.count()), MinecraftGlue.Blocks_pumpkin, "itemFoodCutter").setRegistryName(ModInfo.r(VfpOid.Pumpkin_Portion.fmlid())));
        recipes.register(new ShapedOreRecipe(null, MinecraftGlue.Blocks_pumpkin, new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), VfpObj.Pumpkin_Portion_obj}).setRegistryName(ModInfo.r("pumpkin_pantry_block")));
        if (config.allowGeneralFlintCutter()) {
            ItemStack any_wool_block = new ItemStack(MinecraftGlue.Blocks_wool, 1, Short.MAX_VALUE);
            recipes.register(new LegacyShapelessOreRecipe(null, new ItemStack(MinecraftGlue.Items_string, 4), any_wool_block, "itemFoodCutter").setRegistryName(ModInfo.r("crafted_string_from_wool_block")));
            recipes.register(new LegacyShapelessOreRecipe(null, new ItemStack(MinecraftGlue.Items_snowball, 4), MinecraftGlue.Blocks_snow, "itemFoodCutter").setRegistryName(ModInfo.r("crafted_snowball_from_snow_block")));
            recipes.register(new LegacyShapelessOreRecipe(null, new ItemStack(MinecraftGlue.Items_clay_ball, 4), MinecraftGlue.Blocks_clay, "itemFoodCutter").setRegistryName(ModInfo.r("crafted_clayball_from_clay_block")));
        }
    }

    private void autorecipeCutterAnimalHideIntegration(VfpConfig config, IForgeRegistry<IRecipe> recipes) {
        if (config.includeCraftableGravel()) {
            recipes.register(new ShapedOreRecipe(null, new ItemStack(MinecraftGlue.Blocks_gravel, 3), new Object[]{"xx", "xc", Character.valueOf('x'), "sand", Character.valueOf('c'), "cobblestone"}).setRegistryName(ModInfo.r("crafted_gravel")));
        }
        ItemStack flint_cutter_unused = new ItemStack(VfpObj.Flint_Cutter_obj, 1, 16);
        recipes.register((IForgeRegistryEntry)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(null, flint_cutter_unused, new Object[]{"x ", " x", Character.valueOf('x'), "itemRawFlint"}).setRegistryName(ModInfo.r(VfpOid.Flint_Cutter.fmlid())), VfpOid.Flint_Cutter.craftingXp()));
        recipes.register(new ShapelessOreRecipe(null, new ItemStack(VfpObj.Animal_Hide_Tie_obj, 6), new Object[]{"leather", VfpObj.Red_Flint_obj}).setRegistryName(ModInfo.r(VfpOid.Animal_Hide_Tie.fmlid() + "_from_large_hide")));
        recipes.register(new ShapelessOreRecipe(null, new ItemStack(VfpObj.Animal_Hide_Tie_obj, 1), new Object[]{"portionHideSmall", VfpObj.Red_Flint_obj}).setRegistryName(ModInfo.r(VfpOid.Animal_Hide_Tie.fmlid() + "_from_small_hide")));
        if (config.allowGeneralFlintCutter()) {
            recipes.register(new LegacyShapelessOreRecipe(null, new ItemStack(VfpObj.Portion_Leather_obj, 4), "leather", "itemFoodCutter").setRegistryName(ModInfo.r(VfpOid.Portion_Leather.fmlid())));
        }
        recipes.register(new ShapedOreRecipe(null, new ItemStack(MinecraftGlue.Items_fishing_rod), new Object[]{"  #", " #X", "# X", Character.valueOf('#'), MinecraftGlue.Items_stick, Character.valueOf('X'), VfpObj.Animal_Hide_Tie_obj}).setRegistryName(ModInfo.r("fishing_rod_from_hide_ties")));
        recipes.register(new ShapedOreRecipe(null, new ItemStack(MinecraftGlue.Items_bow), new Object[]{" #X", "# X", " #X", Character.valueOf('X'), VfpObj.Animal_Hide_Tie_obj, Character.valueOf('#'), MinecraftGlue.Items_stick}).setRegistryName(ModInfo.r("bow_from_hide_ties")));
        Object stickiness = MinecraftGlue.Items_slime_ball;
        if (VfpUtils.ingredientDefined("portionAdhesive")) {
            stickiness = "portionAdhesive";
        }
        recipes.register(new ShapedOreRecipe(null, new ItemStack(MinecraftGlue.Items_lead, 2), new Object[]{"~~ ", "~O ", "  ~", Character.valueOf('~'), VfpObj.Animal_Hide_Tie_obj, Character.valueOf('O'), stickiness}).setRegistryName(ModInfo.r("animal_lead_from_hide_ties")));
    }

    private void autorecipeVegetablesMisc(VfpConfig config, IForgeRegistry<IRecipe> recipes) {
        EdibleCactus.buildRecipes(recipes);
        ItemStack allium = new ItemStack(MinecraftGlue.Blocks_red_flower, 1, BlockFlower.EnumFlowerType.ALLIUM.func_176968_b());
        recipes.register(new ShapedOreRecipe(null, new ItemStack(VfpObj.Chopped_Alliums_obj), new Object[]{"AAA", "AAA", "X  ", Character.valueOf('A'), allium, Character.valueOf('X'), "itemFoodCutter"}).setRegistryName(ModInfo.r(VfpOid.Chopped_Alliums.fmlid())));
        recipes.register(new ShapedOreRecipe(null, new ItemStack(VfpObj.Caramelized_Alliums_obj, 4), new Object[]{"AAX", "sS ", "obh", Character.valueOf('A'), "ingredientAllium", Character.valueOf('s'), "portionSaltSmall", Character.valueOf('S'), "portionSugarSmall", Character.valueOf('o'), "portionOil", Character.valueOf('b'), "ingredientButter", Character.valueOf('X'), "itemFoodCutter", Character.valueOf('h'), "portionHeatSmall"}).setRegistryName(ModInfo.r(VfpOid.Caramelized_Alliums.fmlid())));
        String bellpepper = config.getPresentAs("bellpepper");
        if (bellpepper == null) {
            recipes.register(new ShapedOreRecipe(null, new ItemStack(VfpObj.Sauteed_Alliums_Mushrooms_obj, 2), new Object[]{"A  ", "MMX", "obh", Character.valueOf('A'), "ingredientAllium", Character.valueOf('M'), "foodMushroom", Character.valueOf('o'), "portionOil", Character.valueOf('b'), "ingredientButter", Character.valueOf('X'), "itemFoodCutter", Character.valueOf('h'), "portionHeatSmall"}).setRegistryName(ModInfo.r(VfpOid.Sauteed_Alliums_Mushrooms.fmlid())));
        } else {
            recipes.register(new ShapedOreRecipe(null, new ItemStack(VfpObj.Sauteed_Alliums_Mushrooms_obj, 2), new Object[]{"Ap ", "MMX", "obh", Character.valueOf('A'), "ingredientAllium", Character.valueOf('M'), "foodMushroom", Character.valueOf('o'), "portionOil", Character.valueOf('b'), "ingredientButter", Character.valueOf('p'), bellpepper, Character.valueOf('X'), "itemFoodCutter", Character.valueOf('h'), "portionHeatSmall"}).setRegistryName(ModInfo.r(VfpOid.Sauteed_Alliums_Mushrooms.fmlid())));
        }
        GameRegistry.addSmelting((Item)VfpObj.Pumpkin_Portion_obj, (ItemStack)new ItemStack(VfpObj.Roasted_Pumpkin_Portion_obj), (float)LikeFood.uncooked_carrot.smeltExperience());
        if (!config.isPresent("roast_seeds")) {
            GameRegistry.addSmelting((Block)MinecraftGlue.Blocks_pumpkin, (ItemStack)new ItemStack(VfpObj.Roasted_Pumpkin_Portion_obj, VfpCapacity.STANDARD_BLOCK.count()), (float)(LikeFood.uncooked_carrot.smeltExperience() * (float)VfpCapacity.STANDARD_BLOCK.count()));
        }
        recipes.register(new ShapedOreRecipe(null, VfpBuilder.newItemInstance(VfpObj.Raw_Veg_Medley_obj), new Object[]{"pcP", "xxx", "Xos", Character.valueOf('p'), MinecraftGlue.Items_potato, Character.valueOf('c'), "foodCarrot", Character.valueOf('P'), VfpObj.Pumpkin_Portion_obj, Character.valueOf('x'), "ingredientKebabFill", Character.valueOf('X'), "itemFoodCutter", Character.valueOf('o'), "portionOil", Character.valueOf('s'), "portionSaltSmall"}).setRegistryName(ModInfo.r(VfpOid.Raw_Vegetables.fmlid())));
        ItemStack roast_veg_medley = VfpBuilder.newItemInstance(VfpObj.Roasted_Veg_Medley_obj);
        GameRegistry.addSmelting((Item)VfpObj.Raw_Veg_Medley_obj, (ItemStack)roast_veg_medley, (float)LikeFood.raw_veg_medley.smeltExperience());
        recipes.register(new ShapedOreRecipe(null, new ItemStack(VfpObj.Portion_Roasted_Veg_obj, 3), new Object[]{" v ", "bbb", Character.valueOf('v'), roast_veg_medley, Character.valueOf('b'), "bowlWood"}).setRegistryName(ModInfo.r(VfpOid.Portion_Roasted_Veg.fmlid() + "_batch")));
        VfpRewards.addRewardingCraftItem(new ItemStack(VfpObj.Glazed_Carrots_obj), VfpOid.Molasses_Glazed_Carrots.craftingXp());
    }

    private void autorecipeMultisourceVFPMisc(VfpConfig config, IForgeRegistry<IRecipe> recipes) {
        recipes.register((IForgeRegistryEntry)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(null, FoodPowders.get(FoodPowders.Type.VINEGAR, VfpCapacity.ADDITIVE_BATCH.count()), new Object[]{"aaa", "aaa", "Fbd", Character.valueOf('a'), "foodApple", Character.valueOf('F'), VfpObj.Fermenting_Bucket_obj, Character.valueOf('b'), "itemCheeseCloth", Character.valueOf('d'), "additiveDrying"}).setRegistryName(ModInfo.r("foodpowder_vinegar_cider")), OneXp.Per03.value()));
        String acorn = "seedOakAcorn";
        if (config.isSuperCompatibilityMode()) {
            acorn = VfpObj.Oak_Acorn_obj;
        }
        recipes.register(new ShapedOreRecipe(null, new ItemStack(VfpObj.Acornmeal_Portion_obj, 2), new Object[]{"aaa", "aaa", "Wbd", Character.valueOf('a'), acorn, Character.valueOf('W'), "portionPotableWaterLarge", Character.valueOf('b'), "itemCheeseCloth", Character.valueOf('d'), "additiveDrying"}).setRegistryName(ModInfo.r(VfpOid.Acornmeal_Portion.fmlid())));
        ItemStack cheese_powder = FoodPowders.get(FoodPowders.Type.CHEESE, 1);
        recipes.register(new ShapelessOreRecipe(null, DoughBallType.cheese(2), new Object[]{"foodDough", cheese_powder, cheese_powder}).setRegistryName(ModInfo.r(VfpOid.Uncooked_Cheese_Minibread.fmlid())));
        GameRegistry.addSmelting((ItemStack)DoughBallType.cheese(1), (ItemStack)DoughBallType.cookedCheese(1), (float)LikeFood.mini_bread.smeltExperience());
        ItemStack bagof_eggs = BagsOf.sample(PackagedFood.EGG);
        if (!MinecraftGlue.ItemStacks_isEmpty(bagof_eggs)) {
            GameRegistry.addSmelting((ItemStack)bagof_eggs, (ItemStack)new ItemStack(VfpObj.Fried_Egg_obj, VfpCapacity.TRAY.count()), (float)(LikeFood.uncooked_egg.smeltExperience() * (float)VfpCapacity.TRAY.count()));
        }
        PackagedFood[] meats = new PackagedFood[]{PackagedFood.CHICKEN, PackagedFood.COOKED_CHICKEN, PackagedFood.BEEF, PackagedFood.COOKED_BEEF, PackagedFood.PORK, PackagedFood.COOKED_PORK, PackagedFood.MUTTON, PackagedFood.COOKED_MUTTON, PackagedFood.RABBIT, PackagedFood.COOKED_RABBIT, PackagedFood.SQUID, PackagedFood.COOKED_SQUID, PackagedFood.LLAMA, PackagedFood.COOKED_LLAMA, PackagedFood.SALMON, PackagedFood.COOKED_SALMON, PackagedFood.CODFISH, PackagedFood.COOKED_CODFISH};
        int n = meats.length;
        for (int i = 0; i < n; i += 2) {
            ItemStack bagof_meat = BagsOf.sample(meats[i]);
            if (MinecraftGlue.ItemStacks_isEmpty(bagof_meat)) continue;
            GameRegistry.addSmelting((ItemStack)bagof_meat, (ItemStack)meats[i + 1].food().sample(VfpCapacity.TRAY.count()), (float)(meats[i].food().smeltExperience() * (float)VfpCapacity.TRAY.count()));
        }
        recipes.register(new ShapelessOreRecipe(null, new ItemStack(VfpObj.Fungi_Purged_obj), new Object[]{"foodMushroom", "portionWaterSmall"}).setRegistryName(ModInfo.r(VfpOid.Fungi_Purged.fmlid())));
        recipes.register(new ShapelessOreRecipe(null, new ItemStack(MinecraftGlue.Items_mushroom_stew), new Object[]{VfpObj.Fungi_Purged_obj, VfpObj.Fungi_Purged_obj, "bowlWood"}).setRegistryName(ModInfo.r("mstew_from_cleaned_mushrooms")));
    }

    private void autorecipeOtherSourcesOfHeat(VfpConfig config, IForgeRegistry<IRecipe> recipes) {
        recipes.register(new LegacyShapelessOreRecipe(null, new ItemStack(VfpObj.Heat_Portion_obj, 8), new ItemStack(MinecraftGlue.Items_coal, 1, Short.MAX_VALUE), "itemFoodCutter").setRegistryName(ModInfo.r("bit_heat_from_coal")));
        recipes.register(new LegacyShapelessOreRecipe(null, new ItemStack(VfpObj.Heat_Portion_obj, 12), MinecraftGlue.Items_blaze_rod, "itemFoodCutter").setRegistryName(ModInfo.r("bit_heat_from_blazerod")));
        if (config.allowGeneralFlintCutter()) {
            recipes.register(new LegacyShapelessOreRecipe(null, new ItemStack(VfpObj.Heat_Portion_obj, 2), "logWood", "itemFoodCutter").setRegistryName(ModInfo.r("bit_heat_from_woodlog")));
        }
        if (config.allowGeneralFlintCutter()) {
            recipes.register(new LegacyShapelessOreRecipe(null, new ItemStack(VfpObj.Heat_Portion_obj, 24), MinecraftGlue.Blocks_magma, "itemFoodCutter").setRegistryName(ModInfo.r("bit_heat_from_magma_block")));
        }
        recipes.register(new ShapelessOreRecipe(null, new ItemStack(MinecraftGlue.Items_flint_steel), new Object[]{"ingotIron", VfpObj.Red_Flint_obj}).setRegistryName(ModInfo.r("flintsteel_from_red_flint")));
    }

    private void autorecipeOtherSourcesOfWater(VfpConfig config, IForgeRegistry<IRecipe> recipes) {
        recipes.register(new ShapedOreRecipe(null, new ItemStack(VfpObj.Weighted_Plate_obj), new Object[]{"sg", "gp", Character.valueOf('s'), new ItemStack(MinecraftGlue.Blocks_stone), Character.valueOf('g'), "paneGlassColorless", Character.valueOf('p'), MinecraftGlue.Blocks_stone_pressure_plate}).setRegistryName(ModInfo.r(VfpOid.Weighted_Plate.fmlid())));
        if (config.craftOtherSourcesOfWater()) {
            recipes.register(new ShapedOreRecipe(null, new ItemStack(VfpObj.Water_Bucket_obj), new Object[]{"SS", "SS", "B ", Character.valueOf('S'), MinecraftGlue.Blocks_snow, Character.valueOf('B'), VfpObj.Empty_Bucket_obj}).setRegistryName(ModInfo.r("bucket_water_from_snow")));
            recipes.register(new ShapedOreRecipe(null, new ItemStack(VfpObj.Water_Bucket_obj), new Object[]{"I ", "B ", Character.valueOf('I'), MinecraftGlue.Blocks_ice, Character.valueOf('B'), VfpObj.Empty_Bucket_obj}).setRegistryName(ModInfo.r("bucket_water_from_ice")));
            if (config.allowGeneralFlintCutter()) {
                recipes.register(new ShapedOreRecipe(null, new ItemStack(MinecraftGlue.Blocks_ice, 4), new Object[]{"I ", "hx", Character.valueOf('I'), MinecraftGlue.Blocks_packed_ice, Character.valueOf('h'), "portionHeatSmall", Character.valueOf('x'), "itemFoodCutter"}).setRegistryName(ModInfo.r("ice_from_packed_ice_using_hot_cutter")));
            }
            recipes.register(new ShapedOreRecipe(null, new ItemStack(MinecraftGlue.Blocks_ice), new Object[]{"pw", "SS", "SS", Character.valueOf('S'), MinecraftGlue.Blocks_snow, Character.valueOf('w'), "portionWaterSmall", Character.valueOf('p'), VfpObj.Weighted_Plate_obj}).setRegistryName(ModInfo.r("ice_from_snow_using_heavy_weight")));
            recipes.register(new ShapedOreRecipe(null, new ItemStack(MinecraftGlue.Blocks_packed_ice), new Object[]{"pw", "II", "II", Character.valueOf('I'), MinecraftGlue.Blocks_ice, Character.valueOf('w'), "portionWaterSmall", Character.valueOf('p'), VfpObj.Weighted_Plate_obj}).setRegistryName(ModInfo.r("packed_ice_from_ice_using_heavy_weight")));
        }
    }

    private void autorecipeNoTroubleBrewingMisc(VfpConfig config, IForgeRegistry<IRecipe> recipes) {
        recipes.register(new ShapedOreRecipe(null, new ItemStack(VfpObj.Fire_Proofing_Powder_obj, 1), new Object[]{"In", "nn", Character.valueOf('I'), MinecraftGlue.Blocks_ice, Character.valueOf('n'), MinecraftGlue.Blocks_netherrack}).setRegistryName(ModInfo.r(VfpOid.Fire_Proofing_Powder.fmlid())));
    }

    private void autorecipeUncraftables(VfpConfig config, IForgeRegistry<IRecipe> recipes) {
        recipes.register(new ShapelessOreRecipe(null, new ItemStack(VfpObj.Bone_Pencil_obj, 2), new Object[]{MinecraftGlue.Items_bone, "portionHeatSmall", VfpObj.Charcoal_obj}).setRegistryName(ModInfo.r(VfpOid.Bone_Pencil.fmlid())));
        recipes.register(new ShapelessOreRecipe(null, new ItemStack(MinecraftGlue.Items_name_tag), new Object[]{"portionHideSmall", "itemTieNormal", VfpObj.Bone_Pencil_obj}).setRegistryName(ModInfo.r("nametag_from_bone_pencil")));
        recipes.register(new ShapelessOreRecipe(null, new ItemStack(MinecraftGlue.Items_writable_book), new Object[]{VfpObj.Bone_Pencil_obj, VfpObj.Bone_Pencil_obj, MinecraftGlue.Items_book}).setRegistryName(ModInfo.r("writable_book_from_bone_pencil")));
    }

    private void autorecipeSmeltingAndCraftXp(VfpConfig config, IForgeRegistry<IRecipe> recipes) {
        VfpRewards.addRewardingCraftItem(new ItemStack(VfpObj.Uncooked_Pumpkin_Pie_obj), VfpOid.Uncooked_Enriched_Pumpkin_Pie.craftingXp());
        GameRegistry.addSmelting((Item)VfpObj.Uncooked_Pumpkin_Pie_obj, (ItemStack)VfpBuilder.newItemInstance(VfpObj.Pumpkin_Pie_obj), (float)LikeFood.enriched_dessert_pie.smeltExperience());
    }

    @Override
    public void buildRecipes(VfpRuntime runtime, IForgeRegistry<IRecipe> recipes) {
        VfpConfig config = runtime.getConfig();
        GenericDeckerSandwichRecipe.lateinit(config);
        recipes.register(new ShapedOreRecipe(null, new ItemStack(VfpObj.Sand_Jar_obj, 2), new Object[]{"x ", "jj", Character.valueOf('x'), "sand", Character.valueOf('j'), "itemEmptyJar"}).setRegistryName(ModInfo.r(VfpOid.Sand_Jar.fmlid())));
        recipes.register(new ShapedOreRecipe(null, new ItemStack(VfpObj.Sandwich_Press_Plate_obj), new Object[]{"sg ", "gpg", " gs", Character.valueOf('s'), new ItemStack(MinecraftGlue.Blocks_stone), Character.valueOf('g'), "paneGlassColorless", Character.valueOf('p'), MinecraftGlue.Blocks_stone_pressure_plate}).setRegistryName(ModInfo.r(VfpOid.Sandwich_Press_Plate.fmlid())));
        SimpleCookies.buildRecipes(recipes);
        FizzyDrinks.buildRecipes(recipes);
        Gelos.buildRecipes(config, recipes);
        RoastedSeeds.buildRecipes(config, recipes);
        Juices.buildRecipes(recipes);
        Snowcones.buildRecipes(recipes);
        Sandwiches.buildRecipes(recipes);
        DeckerSandwiches.buildRecipes(recipes);
        StewedItems.buildRecipes(config, recipes);
        Tatoes.buildRecipes(config, recipes);
        this.autorecipeCutterAnimalHideIntegration(config, recipes);
        this.autorecipeOtherSourcesOfHeat(config, recipes);
        this.autorecipeVegetablesMisc(config, recipes);
        this.autorecipeMultisourceVFPMisc(config, recipes);
        this.autorecipeRottenThings(recipes);
        this.autorecipeVanillaStorageBlockIntegration(config, recipes);
        IntegrationsImpl.autorecipeMisc(config, recipes);
        this.autorecipeOtherSourcesOfWater(config, recipes);
        this.autorecipeNoTroubleBrewingMisc(config, recipes);
        this.autorecipeUncraftables(config, recipes);
        this.autorecipeSmeltingAndCraftXp(config, recipes);
        if (config.craftPantryMigrationRecipes()) {
            new Migration().buildRecipes(runtime, recipes);
        }
    }

    @Override
    public void linkRenderModels(VfpRuntime runtime) {
        if (!runtime.hasUI()) {
            return;
        }
        VfpCutterItem cutter = (VfpCutterItem)VfpObj.Flint_Cutter_obj;
        runtime.doRenderSetupOrFail(VfpOid.Flint_Cutter, VfpObj.Flint_Cutter_obj, cutter.getUsesRenderNames(), cutter.getUsesRenderMetas());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Red_Flint, VfpObj.Red_Flint_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Animal_Hide_Tie, VfpObj.Animal_Hide_Tie_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Portion_Leather, VfpObj.Portion_Leather_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Bone_Pencil, VfpObj.Bone_Pencil_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Sand_Jar, VfpObj.Sand_Jar_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Weighted_Plate, VfpObj.Weighted_Plate_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Sandwich_Press_Plate, VfpObj.Sandwich_Press_Plate_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Flesh_Meal, VfpObj.Flesh_Meal_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Fire_Proofing_Powder, VfpObj.Fire_Proofing_Powder_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Fermented_Feather, VfpObj.Fermented_Feather_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Fungi_Purged, VfpObj.Fungi_Purged_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Roasted_Seeds, VfpObj.Roasted_Seeds_obj, RoastedSeeds.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Pumpkin_Portion, VfpObj.Pumpkin_Portion_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Roasted_Pumpkin_Portion, VfpObj.Roasted_Pumpkin_Portion_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Uncooked_Enriched_Pumpkin_Pie, VfpObj.Uncooked_Pumpkin_Pie_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Enriched_Pumpkin_Pie, VfpObj.Pumpkin_Pie_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Cake_Slice, VfpObj.Cake_Slice_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Roast_Corn, VfpObj.Roast_Corn_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Roasted_Eggplant, VfpObj.Roasted_Eggplant_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Chopped_Alliums, VfpObj.Chopped_Alliums_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Raw_Vegetables, VfpObj.Raw_Veg_Medley_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Roasted_Vegetables, VfpObj.Roasted_Veg_Medley_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Portion_Roasted_Veg, VfpObj.Portion_Roasted_Veg_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Caramelized_Alliums, VfpObj.Caramelized_Alliums_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Sauteed_Alliums_Mushrooms, VfpObj.Sauteed_Alliums_Mushrooms_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Molasses_Glazed_Carrots, VfpObj.Glazed_Carrots_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Carrot_Burger, VfpObj.Carrot_Burger_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Special_Salad, VfpObj.Special_Salad_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Raftugli_Fruit, VfpObj.Raftugli_Fruit_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Juice, VfpObj.Juices_obj, Juices.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Cookie, VfpObj.SimpleCookies_obj, SimpleCookies.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.FizzyDrink, VfpObj.FizzyDrinks_obj, FizzyDrinks.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Potion_Mixer_Funnel, VfpObj.Potion_Mixer_Funnel_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.TonicDrink, VfpObj.Tonic_Drink_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Bootleg_Gelo, VfpObj.Bootleg_Gelo_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Gelo, VfpObj.Gelos_obj, Gelos.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Snowcone, VfpObj.Snocones_obj, Snowcones.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Sunbutter_Jar, VfpObj.Sunbutter_Jar_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.AppleSlices_Sunbutter_Snack, VfpObj.AppleSlices_Sunbutter_Snack_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Carrot_Sunbutter_Snack, VfpObj.Carrot_Sunbutter_Snack_obj);
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Sandwich, VfpObj.Sandwiches_obj, Sandwiches.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Decker, VfpObj.Decker_Sandwiches_obj, DeckerSandwiches.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Stewed, VfpObj.Stewed_Items_obj, StewedItems.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Tatoes, VfpObj.Tatoes_obj, Tatoes.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Edible_Cactus, VfpObj.Edible_Cactus_obj, EdibleCactus.variants());
        runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Iron_Stomach, VfpObj.Iron_Stomach_obj);
    }

    private void registerJuiceFlavors(VfpConfig config) {
        int MOD_OFFSET = 10;
        int id0 = FoodPowders.Usage.DRINK_FLAVOR.idFirst();
        Juices.register(new Juices.Flavor("apple", id0 + 0, "foodApple", null, 10974244));
        Juices.register(new Juices.Flavor("carrot", id0 + 1, MinecraftGlue.Items_carrot, null, MinecraftGlue.MapColor_ADOBE.field_76291_p));
        Juices.register(new Juices.Flavor("cane", id0 + 2, MinecraftGlue.Items_reeds, (Object)MinecraftGlue.Items_melon, 15189861).setFortified());
        Juices.register(new Juices.Flavor("cactus", id0 + 3, new MinecraftGlue.ItemStackDef(MinecraftGlue.Blocks_cactus), null, 10009467).setFortified());
        Juices.register(new Juices.Flavor("raftugli", id0 + 4, VfpObj.Raftugli_Fruit_obj, (Object)"ingredientSweetener", 16776528).setUncommon().setFortified().setDiluted());
        if (config.includeInterModRecipes()) {
            int id = id0 + 10;
            String item1 = null;
            String item2 = null;
            item1 = config.getPresentAs("tomato");
            item2 = config.getPresentAs("leek");
            if (item1 != null && item2 != null) {
                Juices.register(new Juices.Flavor("tomato", id, item1, (Object)item2, 12791562));
            }
            ++id;
            item1 = config.getPresentAs("grapes");
            if (item1 != null) {
                Juices.register(new Juices.Flavor("grape", id, item1, (Object)"foodApple", 8595540));
            }
            ++id;
            item1 = config.getPresentAs("kiwi");
            if (item1 != null) {
                Juices.register(new Juices.Flavor("kiwi", id, item1, (Object)MinecraftGlue.Items_melon, 12308059).setFortified());
            }
            ++id;
            item1 = config.getPresentAs("broccoli");
            item2 = config.getPresentAs("cucumber");
            if (item1 != null && item2 != null) {
                Juices.register(new Juices.Flavor("veggies", id, item1, (Object)item2, -1));
            }
            ++id;
            item1 = config.getPresentAs("mango");
            if (item1 != null) {
                Juices.register(new Juices.Flavor("mango", id, item1, (Object)MinecraftGlue.Items_melon, 16759296).setFortified());
            }
            ++id;
        }
    }

    private void registerSnoconeFlavors(VfpConfig config) {
        boolean customAllowed = config.includeInterModRecipes();
        for (DrinkSyrups.Flavor flavor : DrinkSyrups.Flavor.values()) {
            if (!flavor.isAlwaysPresent() && (!customAllowed || !DrinkSyrups.isAvailable(flavor))) continue;
            Snowcones.register(flavor);
        }
    }
}

