/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.misc;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.PackagedFood;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.crafting.EmptyBottlesLeftoverShapelessOreRecipe;
import org.jwaresoftware.mcmods.vfp.meats.MeatPortions;
import org.jwaresoftware.mcmods.vfp.meats.Nuggets;
import org.jwaresoftware.mcmods.vfp.meats.Spam;
import org.jwaresoftware.mcmods.vfp.milk.MilkDrinks;

public final class Tatoes
extends VfpPantryMultiItem {
    private static final VfpVariantSet VARIANT_SET = new VfpVariantSet.ByMapInstanceVType(VfpOid.Tatoes, Tatoes.class, "type");
    static VfpVariant[] VARIANT_ARRAY = new VfpVariant[]{new VfpVariant(0, "pink_mashed_tatoes", LikeFood.mashed_potato, VARIANT_SET, true), new VfpVariant(1, "green_mashed_tatoes", LikeFood.mashed_potato, VARIANT_SET, false), new VfpVariant(2, "wild_mashed_tatoes", new LikeFood(10, 0.9f), VARIANT_SET, false), new VfpVariant(3, "stuffed_potato", LikeFood.stuffed_potato, VARIANT_SET, false), new VfpVariant(4, "stuffed_potato_egg", LikeFood.overstuffed_potato, VARIANT_SET, false), new VfpVariant(5, "stuffed_potato_shroom", LikeFood.overstuffed_potato, VARIANT_SET, false), new VfpVariant(6, "stuffed_potato_meat", LikeFood.overstuffed_potato, VARIANT_SET, false), new VfpVariant(7, "stuffed_potato_poultry", LikeFood.overstuffed_potato, VARIANT_SET, false), new VfpVariant(8, "stuffed_potato_spam", LikeFood.overstuffed_potato, VARIANT_SET, false), new VfpVariant(9, "stuffed_potato_fish", LikeFood.overstuffed_potato, VARIANT_SET, false), new VfpVariant(10, "stuffed_potato_cheese", LikeFood.overstuffed_potato, VARIANT_SET, false), new VfpVariant(11, "stuffed_potato_veggie", LikeFood.overstuffed_potato, VARIANT_SET, false), new VfpVariant(12, "stuffed_potato_muscle_egg", new LikeFood("muscle_tato++", -1, LikeFood.overstuffed_potato, LikeFood.muscle_boost), VARIANT_SET, false)};
    private static final int _PINK_MASH_META = 0;
    private static final int _WILDER_MASH = 2;
    private static final int _WELL_STUFFED_META = 3;
    private static final int _FIRST_OVERSTUFFED_META = 4;
    private static final int _LAST_OVERSTUFFED_META = 12;
    private static final int _FISH_OVERSTUFFED_META = 9;
    private static boolean _GOT_WILD_POTATOES = false;
    private static Tatoes INSTANCE;

    public Tatoes(VfpOid oid, CreativeTabs tab) {
        super((VfpProfile)oid, false, VARIANT_ARRAY, tab);
    }

    @Override
    protected int getDefaultPortionFoodPoints() {
        return LikeFood.buttered_potato.healAmount();
    }

    @Override
    protected boolean showSubItem(VfpVariant variant, CreativeTabs forTab, CreativeTabs pickedTab) {
        boolean show = true;
        if (variant.metadata() == 2) {
            show = _GOT_WILD_POTATOES;
        }
        return show;
    }

    private static final ItemStack newTatoFood(int amount, int meta) {
        VfpVariant variant = VARIANT_ARRAY[meta];
        ItemStack food = variant.food().healAmount() < MinecraftGlue.HEARTY_FOOD_POINTS_THRESHOLD() ? new ItemStack((Item)INSTANCE, amount, meta) : Tatoes.createMultiuseInstance((Item)INSTANCE, amount, meta, variant.food().healAmount(), LikeFood.buttered_potato.healAmount());
        return food;
    }

    @Override
    public ItemStack createInstance(Item item, int amount, int meta) {
        if (item != INSTANCE) {
            return MinecraftGlue.ItemStacks_NULLSTACK();
        }
        if (meta < 0 || meta >= VARIANT_ARRAY.length) {
            meta = 0;
        }
        return Tatoes.newTatoFood(amount, meta);
    }

    static final Tatoes makeObjects() {
        if (INSTANCE == null) {
            INSTANCE = VfpBuilder.newMultiItem(VfpOid.Tatoes, Tatoes.class);
        }
        return INSTANCE;
    }

    static final void addDictionaryEntries() {
        if (INSTANCE != null) {
            for (int i = 0; i < 3; ++i) {
                ItemStack mashed = Tatoes.newTatoFood(1, VARIANT_ARRAY[i].metadata());
                OreDictionary.registerOre((String)"foodMashedpotatoes", (ItemStack)mashed);
            }
        }
    }

    static final void buildRecipes(VfpConfig config, @Nonnull IForgeRegistry<IRecipe> recipes) {
        PackagedFood[] meats;
        assert (INSTANCE != null);
        recipes.register(new ShapelessOreRecipe(null, Tatoes.newTatoFood(1, 0), new Object[]{MinecraftGlue.Items_baked_potato, VfpObj.Portion_Butter_obj, "portionMilkSmall", "portionSaltSmall", FoodPowders.get(FoodPowders.Type.BEET, 1), "bowlWood"}).setRegistryName(ModInfo.r(VARIANT_ARRAY[0].fmlid())));
        recipes.register(new ShapelessOreRecipe(null, Tatoes.newTatoFood(1, 1), new Object[]{MinecraftGlue.Items_baked_potato, VfpObj.Portion_Butter_obj, "portionMilkSmall", "portionSaltSmall", FoodPowders.get(FoodPowders.Type.CACTUS, 1), "bowlWood"}).setRegistryName(ModInfo.r(VARIANT_ARRAY[1].fmlid())));
        _GOT_WILD_POTATOES = MinecraftGlue.ingredientDefinedLooking("foodWildPotato");
        if (_GOT_WILD_POTATOES) {
            recipes.register(new ShapelessOreRecipe(null, Tatoes.newTatoFood(1, 2), new Object[]{"foodWildPotato", VfpObj.Portion_Butter_obj, VfpObj.Portion_Butter_obj, "portionMilkSmall", "portionSaltSmall", "bowlWood"}).setRegistryName(ModInfo.r(VARIANT_ARRAY[2].fmlid())));
        }
        recipes.register(new EmptyBottlesLeftoverShapelessOreRecipe(false, Tatoes.newTatoFood(2, 3), MinecraftGlue.Items_baked_potato, MinecraftGlue.Items_baked_potato, MinecraftGlue.Items_baked_potato, VfpObj.Butter_obj, MilkDrinks.heavy(1), "portionSaltSmall", "portionHeatSmall").setRegistryName(ModInfo.r(VARIANT_ARRAY[3].fmlid())));
        if (_GOT_WILD_POTATOES) {
            recipes.register(new EmptyBottlesLeftoverShapelessOreRecipe(false, Tatoes.newTatoFood(2, 3), "foodWildPotato", "foodWildPotato", VfpObj.Butter_obj, MilkDrinks.heavy(1), "portionSaltSmall", "portionHeatSmall").setRegistryName(ModInfo.r(VARIANT_ARRAY[3].fmlid() + "_from_wild_uns")));
        }
        ItemStack stuffed_potato = Tatoes.wellstuffed();
        Object overstuffing = VfpObj.Steamed_Egg_obj;
        recipes.register(new ShapelessOreRecipe(null, Tatoes.newTatoFood(1, 4), new Object[]{stuffed_potato, overstuffing}).setRegistryName(ModInfo.r(VARIANT_ARRAY[4].fmlid())));
        overstuffing = Nuggets.fried(Nuggets.NuggetDef.Mushroom);
        recipes.register(new ShapelessOreRecipe(null, Tatoes.newTatoFood(1, 5), new Object[]{stuffed_potato, overstuffing, overstuffing}).setRegistryName(ModInfo.r(VARIANT_ARRAY[5].fmlid() + "_from_shroom_nugs")));
        overstuffing = "foodMushroom";
        recipes.register(new ShapelessOreRecipe(null, Tatoes.newTatoFood(1, 5), new Object[]{stuffed_potato, overstuffing, overstuffing, "portionHeatSmall"}).setRegistryName(ModInfo.r(VARIANT_ARRAY[5].fmlid())));
        overstuffing = Nuggets.fried(Nuggets.NuggetDef.Beef);
        recipes.register(new ShapelessOreRecipe(null, Tatoes.newTatoFood(1, 6), new Object[]{stuffed_potato, overstuffing, overstuffing}).setRegistryName(ModInfo.r(VARIANT_ARRAY[6].fmlid() + "_from_steak_nugs")));
        for (PackagedFood meat : meats = new PackagedFood[]{PackagedFood.BEEF, PackagedFood.MUTTON, PackagedFood.LLAMA, PackagedFood.HORSE}) {
            overstuffing = MeatPortions.get(meat);
            recipes.register(new ShapelessOreRecipe(null, Tatoes.newTatoFood(1, 6), new Object[]{stuffed_potato, overstuffing, overstuffing, "portionHeatSmall"}).setRegistryName(ModInfo.r(VARIANT_ARRAY[6].fmlid() + "_from_" + meat.fmlid_suffix())));
        }
        overstuffing = Nuggets.fried(Nuggets.NuggetDef.Chicken);
        recipes.register(new ShapelessOreRecipe(null, Tatoes.newTatoFood(1, 7), new Object[]{stuffed_potato, overstuffing, overstuffing}).setRegistryName(ModInfo.r(VARIANT_ARRAY[7].fmlid() + "_from_chikin_nugs")));
        overstuffing = MeatPortions.get(PackagedFood.CHICKEN);
        recipes.register(new ShapelessOreRecipe(null, Tatoes.newTatoFood(1, 7), new Object[]{stuffed_potato, overstuffing, overstuffing, "portionHeatSmall"}).setRegistryName(ModInfo.r(VARIANT_ARRAY[7].fmlid())));
        overstuffing = Spam.portion(1);
        recipes.register(new ShapelessOreRecipe(null, Tatoes.newTatoFood(1, 8), new Object[]{stuffed_potato, overstuffing, overstuffing, "portionHeatSmall"}).setRegistryName(ModInfo.r(VARIANT_ARRAY[8].fmlid() + "_from_spam_nugs")));
        overstuffing = "foodSPAM";
        recipes.register(new ShapelessOreRecipe(null, Tatoes.newTatoFood(1, 8), new Object[]{stuffed_potato, overstuffing}).setRegistryName(ModInfo.r(VARIANT_ARRAY[8].fmlid() + "_from_any_spam")));
        LikeFood[] seafood = new LikeFood[]{LikeFood.fish, LikeFood.salmon, LikeFood.squid};
        for (int i = 0; i < seafood.length; ++i) {
            LikeFood likefood = seafood[i];
            overstuffing = likefood.sample();
            recipes.register(new ShapelessOreRecipe(null, Tatoes.newTatoFood(1, 9), new Object[]{stuffed_potato, overstuffing}).setRegistryName(ModInfo.r(VARIANT_ARRAY[9].fmlid() + "_alt" + (i + 1))));
        }
        overstuffing = "portionFish";
        recipes.register(new ShapelessOreRecipe(null, Tatoes.newTatoFood(1, 9), new Object[]{stuffed_potato, overstuffing, overstuffing, "portionHeatSmall"}).setRegistryName(ModInfo.r(VARIANT_ARRAY[9].fmlid() + "_from_any_fish")));
        overstuffing = "foodCheese";
        recipes.register(new ShapelessOreRecipe(null, Tatoes.newTatoFood(1, 10), new Object[]{stuffed_potato, overstuffing, "portionHeatSmall"}).setRegistryName(ModInfo.r(VARIANT_ARRAY[10].fmlid())));
        overstuffing = Nuggets.fried(Nuggets.NuggetDef.Veggie);
        recipes.register(new ShapelessOreRecipe(null, Tatoes.newTatoFood(1, 11), new Object[]{stuffed_potato, overstuffing, overstuffing}).setRegistryName(ModInfo.r(VARIANT_ARRAY[11].fmlid() + "_from_veggie_nugs")));
        overstuffing = VfpObj.Portion_Roasted_Veg_obj;
        recipes.register(new ShapelessOreRecipe(null, Tatoes.newTatoFood(1, 11), new Object[]{stuffed_potato, overstuffing}).setRegistryName(ModInfo.r(VARIANT_ARRAY[11].fmlid())));
        overstuffing = VfpObj.Muscle_Egg_obj;
        recipes.register(new ShapelessOreRecipe(null, Tatoes.newTatoFood(1, 12), new Object[]{stuffed_potato, overstuffing}).setRegistryName(ModInfo.r(VARIANT_ARRAY[12].fmlid())));
    }

    public static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    public static final List<ItemStack> achievementCandidates() {
        ArrayList<ItemStack> candidates = new ArrayList<ItemStack>();
        for (int meta = 4; meta < 12; ++meta) {
            candidates.add(Tatoes.newTatoFood(1, meta));
        }
        return candidates;
    }

    public static final ItemStack pinkmash() {
        return Tatoes.newTatoFood(1, 0);
    }

    public static final ItemStack wellstuffed() {
        return Tatoes.newTatoFood(1, 3);
    }

    public static final ItemStack fishstuffed() {
        return Tatoes.newTatoFood(1, 9);
    }
}

