/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.tonics;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jwaresoftware.mcmods.vfp.common.IMultiColored;
import org.jwaresoftware.mcmods.vfp.common.LiquidType;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidNonFood;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.tonics.TonicDrink;

public final class BootlegGelo
extends VfpLiquidNonFood
implements IMultiColored {
    public BootlegGelo() {
        super((VfpProfile)VfpOid.Bootleg_Gelo, LiquidType.NONE);
        this._instaDrinkingAllowed = true;
        this.autoregister();
    }

    @Override
    protected ItemStack getNewEmptyContainer() {
        return MinecraftGlue.ItemStacks_NULLSTACK();
    }

    @Override
    protected int getRegularItemUseDuration() {
        return MinecraftGlue.SHORT_FOOD_CONSUME_DURATION();
    }

    @Override
    protected EnumAction getRegularItemUseAction() {
        return EnumAction.EAT;
    }

    @Override
    protected void applyPotionEffectsOnDrunk(ItemStack original, ItemStack remaining, World world, EntityPlayer player) {
        MinecraftGlue.Potions.addPotionEffects((EntityLivingBase)player, original);
    }

    @Override
    protected ItemStack onItemConsumedFully(ItemStack original, ItemStack remaining, World world, EntityPlayer player) {
        return remaining;
    }

    @Override
    public int getColorFrom(ItemStack gelo, int tintIndex) {
        return TonicDrink.getColorFromMoonshine(gelo, tintIndex);
    }

    public void func_77622_d(ItemStack gelo, World world, EntityPlayer player) {
        if (!MinecraftGlue.Potions.isa(gelo, true)) {
            TonicDrink.initDefaultEffect(gelo);
        }
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab) && !this._hidden) {
            ItemStack gelo = new ItemStack((Item)this);
            TonicDrink.initDefaultEffect(gelo);
            list.add((Object)gelo);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_190903_i() {
        return TonicDrink.initDefaultEffect(super.func_190903_i());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack tonic, World world, List tooltip, ITooltipFlag flags) {
        MinecraftGlue.Potions.addPotionInformation(MinecraftGlue.Potions.getEffects(tonic, false), tooltip, true);
        super.func_77624_a(tonic, world, tooltip, flags);
    }

    static final boolean isa(ItemStack stack) {
        return stack.func_77973_b() == VfpObj.Bootleg_Gelo_obj;
    }

    @Nonnull
    public static final ItemStack create(@Nonnull ItemStack origin, @Nonnull Collection<PotionEffect> effects) {
        ItemStack gelo = new ItemStack((Item)VfpObj.Bootleg_Gelo_obj);
        MinecraftGlue.Potions.copyDefinition(gelo, effects, MinecraftGlue.Potions.getColorOrNull(origin, effects));
        return gelo;
    }
}

