/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.tonics;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.core.crafting.LegacyShapelessOreRecipe;
import org.jwaresoftware.mcmods.vfp.tonics.BasicTonicRecipe;
import org.jwaresoftware.mcmods.vfp.tonics.BootlegGelo;
import org.jwaresoftware.mcmods.vfp.tonics.CompositeTonicRecipe;
import org.jwaresoftware.mcmods.vfp.tonics.TonicDrink;

public class SoakFoodShapelessRecipe
extends LegacyShapelessOreRecipe {
    public SoakFoodShapelessRecipe(@Nonnull ItemStack result, Object ... recipe) {
        super(null, result, recipe);
    }

    SoakFoodShapelessRecipe(ShapelessOreRecipe template) {
        super(null, (NonNullList<Ingredient>)template.func_192400_c(), template.func_77571_b());
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting grid) {
        return BasicTonicRecipe.getRemainingIncludingEmptyGlassBottles(grid);
    }

    static final ItemStack getCraftedSoakedFood(InventoryCrafting grid) {
        List<PotionEffect> effects;
        ItemStack out = MinecraftGlue.ItemStacks_NULLSTACK();
        if (!VfpConfig.getInstance().allowMoonshineMixing()) {
            return out;
        }
        ItemStack item_prototoype = null;
        int n_spread = 0;
        ItemStack potionsource = null;
        for (int i = 0; i < grid.func_70302_i_(); ++i) {
            ItemStack next = grid.func_70301_a(i);
            if (MinecraftGlue.ItemStacks_isEmpty(next)) continue;
            if (TonicDrink.isa(next) || MinecraftGlue.Potions.isap(next, true)) {
                if (potionsource != null) {
                    return out;
                }
                potionsource = next;
                continue;
            }
            if (MinecraftGlue.Potions.isa(next, true)) {
                return out;
            }
            if (item_prototoype == null) {
                item_prototoype = next;
            } else if (!MinecraftGlue.ItemStacks_areEqualIgnoreAmounts(next, item_prototoype)) {
                return out;
            }
            if (++n_spread <= 1 || item_prototoype.func_77985_e()) continue;
            return out;
        }
        if (potionsource != null && item_prototoype != null && !(effects = MinecraftGlue.Potions.getEffects(potionsource, true)).isEmpty()) {
            if ((effects = CompositeTonicRecipe.splitEffects(effects, n_spread)).isEmpty()) {
                return out;
            }
            if (item_prototoype.func_77973_b() == VfpObj.Gelatin_Ball_obj) {
                out = BootlegGelo.create(potionsource, effects);
            } else {
                out = MinecraftGlue.ItemStacks_copyItemStackSingle(item_prototoype);
                PotionUtils.func_185184_a((ItemStack)out, effects);
            }
            out.func_190920_e(n_spread);
        }
        return out;
    }

    public ItemStack func_77572_b(InventoryCrafting grid) {
        return SoakFoodShapelessRecipe.getCraftedSoakedFood(grid);
    }

    public static final class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            ShapelessOreRecipe impl = ShapelessOreRecipe.factory((JsonContext)context, (JsonObject)json);
            return new SoakFoodShapelessRecipe(impl);
        }
    }
}

