/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jwaresoftware.mcmods.lib.SharedGlue;

public final class BlockXyz {
    @Nullable
    public BlockState state;
    @Nullable
    public BlockPos pos;
    @Nullable
    public IWorldReader worldr;
    @Nullable
    public Object data;

    public static final BlockXyz none() {
        return new BlockXyz();
    }

    public BlockXyz() {
    }

    public BlockXyz(IWorldReader w) {
        this.worldr = w;
    }

    public BlockXyz(@Nonnull IWorldReader w, @Nonnull BlockPos p) {
        this.set(w, p);
    }

    public BlockXyz(IWorldReader w, BlockState s, BlockPos p) {
        this.worldr = w;
        this.pos = p;
        this.state = s;
        this.data = null;
    }

    public BlockXyz(@Nonnull BlockXyz from) {
        this.worldr = from.worldr;
        this.pos = from.pos;
        this.state = from.state;
        this.data = from.data;
    }

    public BlockXyz set(@Nonnull IWorldReader w, @Nonnull BlockPos p) {
        this.worldr = Objects.requireNonNull(w);
        this.pos = Objects.requireNonNull(p);
        this.state = w.func_180495_p(p);
        this.data = null;
        return this;
    }

    public BlockXyz set(@Nonnull BlockPos p) {
        return this.set(this.worldr, p);
    }

    public BlockXyz state(@Nonnull BlockState s) {
        this.state = Objects.requireNonNull(s);
        return this;
    }

    public BlockXyz in(IWorldReader w) {
        this.worldr = w;
        return this;
    }

    public final Optional<World> worldworld() {
        return this.worldr instanceof World ? Optional.of((World)this.worldr) : Optional.empty();
    }

    public final Optional<ServerWorld> serverworld() {
        return this.worldr instanceof ServerWorld ? Optional.of((ServerWorld)this.worldr) : Optional.empty();
    }

    public BlockXyz withdata(@Nullable Object d) {
        this.data = d;
        return this;
    }

    public BlockXyz position(@Nonnull BlockPos p) {
        this.pos = Objects.requireNonNull(p);
        return this;
    }

    public BlockXyz position(IWorldReader w, BlockPos p) {
        this.worldr = w;
        this.pos = p;
        return this;
    }

    public String toString() {
        return "pos: " + this.pos + " -> state: " + this.state;
    }

    public boolean isDefined() {
        return this.worldr != null;
    }

    public boolean isLocated() {
        return this.pos != null && !BlockPos.field_177992_a.equals((Object)this.pos) && !SharedGlue.NOWHERE.equals((Object)this.pos);
    }

    public final BlockXyz copy() {
        return new BlockXyz(this);
    }

    @Nullable
    public <T> T datadata(Class<? extends T> ofType) {
        return ofType.isInstance(this.data) ? (T)ofType.cast(this.data) : null;
    }

    @FunctionalInterface
    public static interface BooleanSupplier {
        public boolean getAsBoolean(@Nonnull BlockXyz var1);
    }

    @FunctionalInterface
    public static interface BiConsumer<T>
    extends java.util.function.BiConsumer<BlockXyz, T> {
    }

    @FunctionalInterface
    public static interface Supplier<T> {
        public T get(@Nonnull BlockXyz var1);
    }
}

