/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import java.lang.reflect.Method;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.event.brewing.PotionBrewEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.recipes.BrewingRecipeBase;

public enum BrewEffect {
    goldenCarrotEffect{

        @Override
        public void register(Ingredient is_ingredient) {
            1.addMix(SharedGlue.PotionType_awkward, is_ingredient, SharedGlue.PotionType_night_vision);
        }
    }
    ,
    goldenCarrotEffectII{

        @Override
        public void register(Ingredient is_ingredient) {
            2.addMix(SharedGlue.PotionType_awkward, is_ingredient, SharedGlue.PotionType_long_night_vision);
        }
    }
    ,
    blazePowderEffect{

        @Override
        public void register(Ingredient is_ingredient) {
            3.addMix(SharedGlue.PotionType_awkward, is_ingredient, SharedGlue.PotionType_strength);
        }
    }
    ,
    blazePowderEffectII{

        @Override
        public void register(Ingredient is_ingredient) {
            4.addMix(SharedGlue.PotionType_awkward, is_ingredient, SharedGlue.PotionType_strong_strength);
        }
    }
    ,
    ghastTearEffect{

        @Override
        public void register(Ingredient is_ingredient) {
            5.addMix(SharedGlue.PotionType_awkward, is_ingredient, SharedGlue.PotionType_regeneration);
            5.addMix(SharedGlue.PotionType_thick, is_ingredient, SharedGlue.PotionType_healing);
        }
    }
    ,
    ghastTearEffectII{

        @Override
        public void register(Ingredient is_ingredient) {
            6.addMix(SharedGlue.PotionType_awkward, is_ingredient, SharedGlue.PotionType_strong_regeneration);
            6.addMix(SharedGlue.PotionType_thick, is_ingredient, SharedGlue.PotionType_strong_healing);
        }
    }
    ,
    gunpowderEffect{

        @Override
        public void register(Item item) {
            7.addContainerConverter(Items.field_151068_bn, item, Items.field_185155_bH);
        }

        @Override
        public void register(Ingredient is_ingredient) {
        }
    }
    ,
    spiderEyeEffect{

        @Override
        public void register(Ingredient is_ingredient) {
            8.addMix(SharedGlue.PotionType_water, is_ingredient, SharedGlue.PotionType_poison);
            8.addMix(SharedGlue.PotionType_awkward, is_ingredient, SharedGlue.PotionType_poison);
        }
    }
    ,
    spiderEyeEffectII{

        @Override
        public void register(Ingredient is_ingredient) {
            9.addMix(SharedGlue.PotionType_water, is_ingredient, SharedGlue.PotionType_strong_poison);
            9.addMix(SharedGlue.PotionType_awkward, is_ingredient, SharedGlue.PotionType_strong_poison);
            9.addMix(SharedGlue.PotionType_poison, is_ingredient, SharedGlue.PotionType_strong_poison);
            9.addMix(SharedGlue.PotionType_thick, is_ingredient, SharedGlue.PotionType_strong_poison);
        }
    }
    ,
    fermentedSpiderEyeEffect{

        @Override
        public void register(Ingredient is_ingredient) {
            10.addMix(SharedGlue.PotionType_water, is_ingredient, SharedGlue.PotionType_weakness);
            10.addMix(SharedGlue.PotionType_awkward, is_ingredient, SharedGlue.PotionType_harming);
            10.addMix(SharedGlue.PotionType_healing, is_ingredient, SharedGlue.PotionType_harming);
            10.addMix(SharedGlue.PotionType_strong_healing, is_ingredient, SharedGlue.PotionType_strong_harming);
            10.addMix(SharedGlue.PotionType_swiftness, is_ingredient, SharedGlue.PotionType_slowness);
            10.addMix(SharedGlue.PotionType_long_swiftness, is_ingredient, SharedGlue.PotionType_long_slowness);
            10.addMix(SharedGlue.PotionType_strong_swiftness, is_ingredient, SharedGlue.PotionType_long_slowness);
            10.addMix(SharedGlue.PotionType_strength, is_ingredient, SharedGlue.PotionType_weakness);
            10.addMix(SharedGlue.PotionType_strong_strength, is_ingredient, SharedGlue.PotionType_long_weakness);
            10.addMix(SharedGlue.PotionType_night_vision, is_ingredient, SharedGlue.PotionType_invisibility);
        }
    }
    ,
    magmaCreamEffect{

        @Override
        public void register(Ingredient is_ingredient) {
            11.addMix(SharedGlue.PotionType_awkward, is_ingredient, SharedGlue.PotionType_fire_resistance);
        }
    }
    ,
    magmaCreamEffectII{

        @Override
        public void register(Ingredient is_ingredient) {
            12.addMix(SharedGlue.PotionType_awkward, is_ingredient, SharedGlue.PotionType_long_fire_resistance);
        }
    }
    ,
    dragonbreathEffect{

        @Override
        public void register(Item item) {
            13.addContainerConverter(Items.field_185155_bH, item, Items.field_185156_bI);
        }

        @Override
        public void register(Ingredient is_ingredient) {
        }
    }
    ,
    dragonbreathEffectII{

        @Override
        public void register(Item item) {
            14.addContainerConverter(Items.field_151068_bn, item, Items.field_185156_bI);
            14.addContainerConverter(Items.field_185155_bH, item, Items.field_185156_bI);
        }

        @Override
        public void register(Ingredient is_ingredient) {
        }
    }
    ,
    sugarbombEffect{

        @Override
        public void register(Ingredient is_ingredient) {
            15.addMix(SharedGlue.PotionType_water, is_ingredient, SharedGlue.PotionType_long_swiftness);
            15.addMix(SharedGlue.PotionType_awkward, is_ingredient, SharedGlue.PotionType_long_swiftness);
            15.addMix(SharedGlue.PotionType_thick, is_ingredient, SharedGlue.PotionType_long_swiftness);
        }
    }
    ,
    luckEffect{

        @Override
        public void register(Ingredient is_ingredient) {
            16.addMix(SharedGlue.PotionType_awkward, is_ingredient, SharedGlue.PotionType_luck);
        }
    };

    private static Method _ADD_CONTAINER_RECIPE;
    public static final Ingredient IS_DURATION_EXTENDER;
    public static final Ingredient IS_STRENGTH_EXTENDER;

    public static final void initRecipeSupport() {
        try {
            Method m;
            _ADD_CONTAINER_RECIPE = m = ObfuscationReflectionHelper.findMethod(PotionBrewing.class, (String)"func_196207_a", (Class[])new Class[]{Item.class, Item.class, Item.class});
            LibInfo.LOG.info("Potion type converter hook initialized successfully!");
        }
        catch (Throwable igX) {
            LibInfo.LOG.warn("Unable to initialize potion type converter recipes hook! ({})", (Object)ExceptionUtils.getRootCauseMessage((Throwable)igX));
        }
    }

    public abstract void register(Ingredient var1);

    public void register(Item item) {
        Ingredient predicate = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item});
        this.register(predicate);
    }

    public void registerAnyOf(Tag<Item> items) {
        Ingredient predicate = Ingredient.func_199805_a(items);
        this.register(predicate);
    }

    public static final void onBrewedSwitchColor(PotionBrewEvent.Post event, Map<Potion, Integer> typeToColorMap) {
        for (int slotindex = 0; slotindex < 3; ++slotindex) {
            ItemStack brewed = event.getItem(slotindex);
            Integer color = null;
            if (ItemStacks.isEmpty(brewed) || (color = typeToColorMap.get(PotionUtils.func_185191_c((ItemStack)brewed))) == null) continue;
            brewed.func_77983_a(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME(), (INBT)IntNBT.func_229692_a_((int)color));
        }
    }

    public static void registerAll(Item item, BrewEffect ... effects) {
        Ingredient predicate = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)item)});
        for (BrewEffect effect : effects) {
            effect.register(predicate);
        }
    }

    public static final void addWaterConversionFor(Item item, Potion named_effect) {
        Ingredient predicate = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)item)});
        BrewEffect.addMix(SharedGlue.PotionType_water, predicate, named_effect);
    }

    public static final void addThickConversionFor(Item item, Potion named_effect) {
        Ingredient predicate = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)item)});
        BrewEffect.addMix(SharedGlue.PotionType_thick, predicate, named_effect);
    }

    public static final void addThickConversionFor(Tag<Item> items, Potion named_effect) {
        Ingredient predicate = Ingredient.func_199805_a(items);
        BrewEffect.addMix(SharedGlue.PotionType_thick, predicate, named_effect);
    }

    public static final void addRecipeFor(Ingredient predicate, Potion named_effect) {
        BrewEffect.addMix(SharedGlue.PotionType_awkward, predicate, named_effect);
    }

    public static final void addRecipeFor(Item item, Potion named_effect) {
        Ingredient predicate = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)item)});
        BrewEffect.addMix(SharedGlue.PotionType_awkward, predicate, named_effect);
    }

    public static final void addRecipeFor(Item item, Potion base, Potion named_effect) {
        Ingredient predicate = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item});
        BrewEffect.addMix(base == null ? SharedGlue.PotionType_awkward : base, predicate, named_effect);
    }

    public static final void addRecipeForAnyOf(Tag<Item> items, Potion base, Potion named_effect) {
        Ingredient predicate = Ingredient.func_199805_a(items);
        BrewEffect.addMix(base == null ? SharedGlue.PotionType_awkward : base, predicate, named_effect);
    }

    public static final void addConversionFor(@Nonnull Potion named_base, ItemStack item, Potion named_effect) {
        Ingredient predicate = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{item});
        BrewEffect.addMix(named_base, predicate, named_effect);
    }

    public static final void addConversionFor(@Nonnull Potion named_base, Item item, Potion named_effect) {
        Ingredient predicate = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)item)});
        BrewEffect.addMix(named_base, predicate, named_effect);
    }

    public static final void addDurationConversionFor(@Nonnull Potion named_base, @Nonnull Potion longer_effect) {
        BrewEffect.addMix(named_base, IS_DURATION_EXTENDER, longer_effect);
    }

    public static final void addStrengthConversionFor(@Nonnull Potion named_base, @Nonnull Potion stronger_effect) {
        BrewEffect.addMix(named_base, IS_STRENGTH_EXTENDER, stronger_effect);
    }

    public static final void addRecipeFor(Ingredient predicate, Potion named_effect, @Nullable Potion stronger_effect, @Nullable Potion longer_effect) {
        BrewEffect.addRecipeFor(predicate, named_effect);
        if (stronger_effect != null) {
            BrewEffect.addMix(named_effect, IS_STRENGTH_EXTENDER, stronger_effect);
        }
        if (longer_effect != null) {
            BrewEffect.addMix(named_effect, IS_DURATION_EXTENDER, longer_effect);
        }
    }

    public static final void addRecipeFor(Item item, Potion named_effect, @Nullable Potion stronger_effect, @Nullable Potion longer_effect) {
        BrewEffect.addRecipeFor(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)item)}), named_effect, stronger_effect, longer_effect);
    }

    public static final void addRecipeFor(Tag<Item> items, Potion named_effect, @Nullable Potion stronger_effect, @Nullable Potion longer_effect) {
        BrewEffect.addRecipeFor(Ingredient.func_199805_a(items), named_effect, stronger_effect, longer_effect);
    }

    public static final void addMix(Potion from, Ingredient reagent, Potion to) {
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BrewingRecipeBase(Potions.newPotionHeldItem(from), reagent, Potions.newPotionHeldItem(to)));
    }

    public static final void addContainerConverter(@Nonnull Item from_c, @Nonnull Item converter, @Nonnull Item to_c) {
        if (_ADD_CONTAINER_RECIPE != null) {
            try {
                _ADD_CONTAINER_RECIPE.invoke(null, from_c, converter, to_c);
            }
            catch (Throwable igX) {
                LibInfo.LOG.warn("Unable to add potion container conversion: {} to {} using {}", (Object)ClassUtils.getSimpleName((Object)from_c, (String)"nil(from)"), (Object)ClassUtils.getSimpleName((Object)to_c, (String)"nil(to)"), (Object)ClassUtils.getSimpleName((Object)converter, (String)"nil(itm)"));
            }
        }
    }

    static {
        _ADD_CONTAINER_RECIPE = null;
        IS_DURATION_EXTENDER = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151137_ax});
        IS_STRENGTH_EXTENDER = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151114_aO});
    }
}

