/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Logger;
import org.jwaresoftware.mcmods.lib.Armory;
import org.jwaresoftware.mcmods.lib.BrewEffect;
import org.jwaresoftware.mcmods.lib.IniRegistries;
import org.jwaresoftware.mcmods.lib.LibConfig;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.Tooltips;
import org.jwaresoftware.mcmods.lib.Whatis;
import org.jwaresoftware.mcmods.lib.advancements.CarrotsTriggers;
import org.jwaresoftware.mcmods.lib.barter.Bartering;
import org.jwaresoftware.mcmods.lib.impl.ItemSupport;
import org.jwaresoftware.mcmods.lib.impl.PlaceboEffect;
import org.jwaresoftware.mcmods.lib.impl.block.BlockSupport;
import org.jwaresoftware.mcmods.lib.impl.fluid.UniversalFluids;
import org.jwaresoftware.mcmods.lib.impl.network.LibNetworkMessages;
import org.jwaresoftware.mcmods.lib.integration.BaublesHelper;
import org.jwaresoftware.mcmods.lib.loot.Loot;
import org.jwaresoftware.mcmods.lib.recipes.JR;

@Mod(value="carrots")
@Mod.EventBusSubscriber(modid="carrots", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CarrotsLib {
    public static final String NAME = "Carrots Lib";
    public static final String MOD_ID = "carrots";
    public static final String RESOURCES_ID = "carrots:";
    public static final String PREFIX = "carrots.";
    public static final String CAMEL_PREFIX = "carrots_";
    public static final String VERSION = "2.5.1";
    public static final String VERSION_CHECK_URL = "http://jwaresoftware.org/files/mcmods/versions/carrotslib.json";
    public static CarrotsLib instance;
    LibConfig _libConfig;

    public CarrotsLib() {
        instance = this;
        this.getLog().info("{} mod constructor called", (Object)NAME);
        Tooltips.initLanguageSupport();
        LibNetworkMessages.initIDSupport();
        this._libConfig = new LibConfig().setInstance();
        BlockSupport.initAmendmentSupport();
        ItemSupport.initAmendmentSupport();
        Potions.initAmendmentSupport();
        BrewEffect.initRecipeSupport();
        JR.initRecipeSupport();
        Loot.initAmendmentSupport();
        Whatis.initLoad0();
        PlaceboEffect.initRecipeSupport();
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Block.class, e -> {
            this._libConfig.initEarly();
            UniversalFluids.makeFluids();
            IniRegistries.autoregisterBlocks(MOD_ID, (IForgeRegistry<Block>)ForgeRegistries.BLOCKS);
        });
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, e -> {
            Bartering.makeTokens();
            IniRegistries.autoregisterItems(MOD_ID, (IForgeRegistry<Item>)ForgeRegistries.ITEMS);
        });
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Fluid.class, e -> IniRegistries.autoregisterFluids(MOD_ID, (IForgeRegistry<Fluid>)ForgeRegistries.FLUIDS));
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Effect.class, e -> IniRegistries.autoregisterPotions(MOD_ID, (IForgeRegistry<Effect>)ForgeRegistries.POTIONS));
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Potion.class, e -> IniRegistries.autoregisterPotionMixes(MOD_ID, (IForgeRegistry<Potion>)ForgeRegistries.POTION_TYPES));
        IEventBus initEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        initEventBus.addListener(this::init1);
        initEventBus.addListener(this::init2);
        initEventBus.addListener(this::init3);
        MinecraftForge.EVENT_BUS.addListener(this::serverHasStarted);
    }

    @Nonnull
    public final Logger getLog() {
        return LibInfo.LOG;
    }

    private void init1(FMLCommonSetupEvent event) {
        Loot.initDefaults();
        CarrotsTriggers.initTriggerSupport();
    }

    private void init2(InterModEnqueueEvent event) {
        BaublesHelper.initFinalize();
    }

    private void init3(InterModProcessEvent event) {
        this._libConfig.initFinalize();
        Loot.initFinalize();
        Potions.initFinalize();
        CarrotsTriggers.initFinalize();
    }

    private void serverHasStarted(FMLServerStartedEvent unused) {
        RID.tagsFinalize();
        Armory.tagsFinalize();
        Loot.tagsFinalize();
    }
}

