/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.Tooltips;
import org.jwaresoftware.mcmods.lib.Whatis;
import org.jwaresoftware.mcmods.lib.api.IAirPlaceable;
import org.jwaresoftware.mcmods.lib.api.IBurnable;
import org.jwaresoftware.mcmods.lib.api.ICompostable;
import org.jwaresoftware.mcmods.lib.api.IModBlock;
import org.jwaresoftware.mcmods.lib.api.IMultiStateBlock;
import org.jwaresoftware.mcmods.lib.api.IRegistrationListener;
import org.jwaresoftware.mcmods.lib.impl.block.AirGrabbingItemBlock;
import org.jwaresoftware.mcmods.lib.impl.block.HiddenItemBlock;
import org.jwaresoftware.mcmods.lib.impl.block.ItemBlockBase;
import org.jwaresoftware.mcmods.lib.impl.block.MultistateItemBlock;

public final class IniRegistries {
    private static final ConcurrentMap<String, ModDefs> registryDefsINSTANCE = new ConcurrentHashMap<String, ModDefs>();

    public static final boolean isStarted(String modid) {
        return registryDefsINSTANCE.containsKey(modid);
    }

    public static final void clearAll(@Nullable String modid) {
        if (modid != null) {
            registryDefsINSTANCE.remove(modid);
        } else {
            registryDefsINSTANCE.clear();
        }
    }

    @Nullable
    static final ModDefs getModDefs(@Nonnull String modid, boolean force) {
        ModDefs winner;
        ModDefs modDefs = (ModDefs)registryDefsINSTANCE.get(modid);
        if (modDefs == null && force && (winner = registryDefsINSTANCE.putIfAbsent(modid, modDefs = new ModDefs())) != null) {
            modDefs = winner;
        }
        return modDefs;
    }

    @Nonnull
    public static final List<Block> autoregisterBlocks(@Nonnull String modid, @Nonnull IForgeRegistry<Block> blocks) {
        List<Object> pending;
        ModDefs modDefs = IniRegistries.getModDefs(modid, false);
        if (modDefs != null && !modDefs._unregisteredBlocks.isEmpty()) {
            pending = (List)modDefs._unregisteredBlocks.clone();
            modDefs._unregisteredBlocks.clear();
            for (Block block : pending) {
                blocks.register((IForgeRegistryEntry)block);
            }
            for (Block block : pending) {
                if (!(block instanceof IRegistrationListener)) continue;
                ((IRegistrationListener)block).notifyRegistered(blocks);
            }
        } else {
            pending = new ArrayList<Block>();
        }
        return pending;
    }

    @Nonnull
    public static final List<Item> autoregisterItems(@Nonnull String modid, @Nonnull IForgeRegistry<Item> items) {
        List<Object> pending;
        ModDefs modDefs = IniRegistries.getModDefs(modid, false);
        if (modDefs != null && !modDefs._unregisteredItems.isEmpty()) {
            pending = (List)modDefs._unregisteredItems.clone();
            modDefs._unregisteredItems.clear();
            modDefs._unregisteredItemFromBlockMap.clear();
            for (Item item : pending) {
                items.register((IForgeRegistryEntry)item);
            }
            for (Item item : pending) {
                float chance;
                if (item instanceof IRegistrationListener) {
                    ((IRegistrationListener)item).notifyRegistered(items);
                }
                if (!(item instanceof ICompostable) || !((chance = ((ICompostable)item).getCompostChance()) > 0.0f)) continue;
                try {
                    ComposterBlock.field_220299_b.put((Object)item, chance);
                }
                catch (Throwable throwable) {}
            }
        } else {
            pending = new ArrayList<Item>();
        }
        return pending;
    }

    public static final <T> T autoregisterItem(@Nonnull String modid, @Nonnull Item item, @Nonnull String oid) {
        item.setRegistryName(oid);
        IniRegistries.getModDefs((String)modid, (boolean)true)._unregisteredItems.add(item);
        return (T)item;
    }

    public static final void autoregisterBlockItem(@Nonnull String modid, @Nonnull BlockItem blockitem, @Nonnull String oid) {
        IniRegistries.autoregisterItem(modid, (Item)blockitem, oid);
        Block block = blockitem.func_179223_d();
        IniRegistries.getModDefs((String)modid, (boolean)true)._unregisteredItemFromBlockMap.put(block, blockitem);
    }

    @Nonnull
    public static final BlockItem bestFitBlockItem(Block block, @Nullable Item.Properties ip) {
        boolean hidden;
        BlockItem itemblock = null;
        if (block instanceof IModBlock) {
            IModBlock modblock = (IModBlock)block;
            itemblock = modblock.makeItemBlock(block, ip);
            hidden = modblock.hasNoItemForm();
        } else {
            hidden = Whatis.isLikelyNotShownAsItem(block);
        }
        if (itemblock == null) {
            if (hidden) {
                itemblock = new HiddenItemBlock(block, ip);
            } else if (block instanceof IAirPlaceable) {
                itemblock = new AirGrabbingItemBlock(block, ip);
            } else if (block instanceof IMultiStateBlock) {
                itemblock = new MultistateItemBlock(block, ip);
            } else if (block instanceof IBurnable) {
                itemblock = new ItemBlockBase(block, ip);
            } else if (block instanceof IModBlock) {
                itemblock = new ItemBlockBase(block, ip);
            } else if (Tooltips.hasUiTip(block)) {
                itemblock = new ItemBlockBase(block, ip);
            }
        }
        return itemblock != null ? itemblock : new BlockItem(block, ip);
    }

    @Nonnull
    public static final Block autoregisterBlock(@Nonnull String modid, @Nonnull Block block, @Nonnull String oid, @Nullable Item.Properties ip) {
        block.setRegistryName(oid);
        IniRegistries.getModDefs((String)modid, (boolean)true)._unregisteredBlocks.add(block);
        if (ip != null) {
            BlockItem itemblock = IniRegistries.bestFitBlockItem(block, ip);
            IniRegistries.autoregisterBlockItem(modid, itemblock, oid);
        }
        return block;
    }

    @Nonnull
    public static final FlowingFluidBlock autoregisterFluidBlock(@Nonnull String modid, @Nonnull FlowingFluidBlock fluid_block, @Nonnull String oid) {
        return (FlowingFluidBlock)IniRegistries.autoregisterBlock(modid, (Block)fluid_block, oid, null);
    }

    @Nullable
    public static final BlockItem getItemFromBlock(@Nonnull String modid, @Nonnull Block block) {
        BlockItem blockitem;
        ModDefs modDefs = IniRegistries.getModDefs(modid, false);
        if (modDefs != null && (blockitem = modDefs._unregisteredItemFromBlockMap.get(block)) != null) {
            return blockitem;
        }
        return (BlockItem)BlockItem.class.cast(block.func_199767_j());
    }

    public static final <T extends TileEntity> TileEntityType<T> autoregisterBlockTile(@Nonnull String modid, String oid, Supplier<T> tileConstructor, Block ... blocks) {
        TileEntityType type = TileEntityType.Builder.func_223042_a(tileConstructor, (Block[])blocks).func_206865_a(null);
        type.setRegistryName(oid);
        IniRegistries.getModDefs((String)modid, (boolean)true)._unregisteredTiles.add(type);
        return type;
    }

    public static final void autoregisterBlockTiles(@Nonnull String modid, @Nonnull IForgeRegistry<TileEntityType<?>> types) {
        ModDefs modDefs = IniRegistries.getModDefs(modid, false);
        if (modDefs != null && !modDefs._unregisteredTiles.isEmpty()) {
            List pending = (List)modDefs._unregisteredTiles.clone();
            modDefs._unregisteredTiles.clear();
            for (TileEntityType tt : pending) {
                types.register((IForgeRegistryEntry)tt);
            }
        }
    }

    public static final Effect autoregisterPotion(@Nonnull String modid, @Nonnull Effect potion, @Nonnull String oid) {
        if (potion.getRegistryName() == null) {
            potion.setRegistryName(modid, oid);
        }
        IniRegistries.getModDefs((String)modid, (boolean)true)._unregisteredPotions.add(potion);
        return potion;
    }

    public static final Effect autoregisterPotion(@Nonnull String modid, @Nonnull Effect potion) {
        Validate.notNull((Object)potion.getRegistryName());
        IniRegistries.getModDefs((String)modid, (boolean)true)._unregisteredPotions.add(potion);
        return potion;
    }

    public static final Potion autoregisterPotionType(@Nonnull String modid, @Nonnull Potion mix, @Nonnull String oid) {
        if (mix.getRegistryName() == null) {
            mix.setRegistryName(modid, oid);
        }
        IniRegistries.getModDefs((String)modid, (boolean)true)._unregisteredPotionMixes.add(mix);
        return mix;
    }

    public static final Potion autoregisterPotionType(@Nonnull String modid, @Nonnull Potion mix) {
        Validate.notNull((Object)mix.getRegistryName());
        IniRegistries.getModDefs((String)modid, (boolean)true)._unregisteredPotionMixes.add(mix);
        return mix;
    }

    public static final void autoregisterPotions(@Nonnull String modid, @Nonnull IForgeRegistry<Effect> effects) {
        ModDefs modDefs = IniRegistries.getModDefs(modid, false);
        if (modDefs != null && !modDefs._unregisteredPotions.isEmpty()) {
            List pending = (List)modDefs._unregisteredPotions.clone();
            modDefs._unregisteredPotions.clear();
            for (Effect e : pending) {
                effects.register((IForgeRegistryEntry)e);
            }
            for (Effect e : pending) {
                if (!(e instanceof IRegistrationListener)) continue;
                ((IRegistrationListener)e).notifyRegistered(effects);
            }
        }
    }

    public static final void autoregisterPotionMixes(@Nonnull String modid, @Nonnull IForgeRegistry<Potion> mixes) {
        ModDefs modDefs = IniRegistries.getModDefs(modid, false);
        if (modDefs != null && !modDefs._unregisteredPotionMixes.isEmpty()) {
            List pending = (List)modDefs._unregisteredPotionMixes.clone();
            modDefs._unregisteredPotionMixes.clear();
            for (Potion mix : pending) {
                mixes.register((IForgeRegistryEntry)mix);
            }
        }
    }

    public static final Enchantment autoregisterEnchantment(@Nonnull String modid, @Nonnull Enchantment enchant, @Nonnull String oid) {
        if (enchant.getRegistryName() == null) {
            enchant.setRegistryName(modid, oid);
        }
        IniRegistries.getModDefs((String)modid, (boolean)true)._unregisteredEnchantments.add(enchant);
        return enchant;
    }

    public static final void autoregisterEnchantments(@Nonnull String modid, @Nonnull IForgeRegistry<Enchantment> enchantments) {
        ModDefs modDefs = IniRegistries.getModDefs(modid, false);
        if (modDefs != null && !modDefs._unregisteredEnchantments.isEmpty()) {
            List pending = (List)modDefs._unregisteredEnchantments.clone();
            modDefs._unregisteredEnchantments.clear();
            for (Enchantment e : pending) {
                enchantments.register((IForgeRegistryEntry)e);
            }
            for (Enchantment e : pending) {
                if (!(e instanceof IRegistrationListener)) continue;
                ((IRegistrationListener)e).notifyRegistered(enchantments);
            }
        }
    }

    public static final Fluid autoregisterFluid(@Nonnull String modid, @Nonnull Fluid fluid, @Nonnull String oid) {
        if (fluid.getRegistryName() == null) {
            fluid.setRegistryName(modid, oid);
        }
        IniRegistries.getModDefs((String)modid, (boolean)true)._unregisteredFluids.add(fluid);
        return fluid;
    }

    public static final void autoregisterFluids(@Nonnull String modid, @Nonnull IForgeRegistry<Fluid> fluids) {
        ModDefs modDefs = IniRegistries.getModDefs(modid, false);
        if (modDefs != null && !modDefs._unregisteredFluids.isEmpty()) {
            List pending = (List)modDefs._unregisteredFluids.clone();
            modDefs._unregisteredFluids.clear();
            for (Fluid f : pending) {
                fluids.register((IForgeRegistryEntry)f);
            }
            for (Fluid f : pending) {
                if (!(f instanceof IRegistrationListener)) continue;
                ((IRegistrationListener)f).notifyRegistered(fluids);
            }
        }
    }

    public static final <T extends Entity> EntityType<T> autoregisterEntity(@Nonnull String modid, String oid, EntityType.IFactory<T> entityConstructor, EntityClassification klass) {
        EntityType type = EntityType.Builder.func_220322_a(entityConstructor, (EntityClassification)klass).func_206830_a(oid);
        type.setRegistryName(oid);
        IniRegistries.getModDefs((String)modid, (boolean)true)._unregisteredEntities.add(type);
        return type;
    }

    public static final <T extends Entity> EntityType<T> autoregisterEntity(@Nonnull String modid, @Nonnull EntityType<T> type, @Nonnull String oid) {
        type.setRegistryName(oid);
        IniRegistries.getModDefs((String)modid, (boolean)true)._unregisteredEntities.add(type);
        return type;
    }

    public static final void autoregisterEntities(@Nonnull String modid, @Nonnull IForgeRegistry<EntityType<?>> types) {
        ModDefs modDefs = IniRegistries.getModDefs(modid, false);
        if (modDefs != null && !modDefs._unregisteredEntities.isEmpty()) {
            List pending = (List)modDefs._unregisteredEntities.clone();
            modDefs._unregisteredEntities.clear();
            for (EntityType et : pending) {
                types.register((IForgeRegistryEntry)et);
            }
        }
    }

    private IniRegistries() {
    }

    public static final class ModDefs {
        final ArrayList<Block> _unregisteredBlocks = new ArrayList(101);
        final ArrayList<Item> _unregisteredItems = new ArrayList(213);
        final HashMap<Block, BlockItem> _unregisteredItemFromBlockMap = new HashMap(101, 0.8f);
        final ArrayList<Effect> _unregisteredPotions = new ArrayList(23);
        final ArrayList<Potion> _unregisteredPotionMixes = new ArrayList(41);
        final ArrayList<Enchantment> _unregisteredEnchantments = new ArrayList(23);
        final ArrayList<Fluid> _unregisteredFluids = new ArrayList(11);
        final ArrayList<TileEntityType<?>> _unregisteredTiles = new ArrayList(11);
        final ArrayList<EntityType<?>> _unregisteredEntities = new ArrayList(31);
    }
}

