/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.RandomStringUtils;
import org.jwaresoftware.mcmods.lib.Instructions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IModBlock;
import org.jwaresoftware.mcmods.lib.api.IModItem;
import org.jwaresoftware.mcmods.lib.impl.fluid.MilkBucketWrapper;

public final class ItemStacks {
    public static final ItemStack[] EMPTY_ARRAY = new ItemStack[0];

    @Nonnull
    public static final ItemStack NULLSTACK() {
        return ItemStack.field_190927_a;
    }

    @Nullable
    public static final ResourceLocation registryName(@Nullable ItemStack stack) {
        return ItemStacks.isEmpty(stack) ? null : stack.func_77973_b().getRegistryName();
    }

    public static final ItemStack modded_create(Item item, int amount) {
        if (amount < 1) {
            amount = 1;
        }
        return item instanceof IModItem ? ((IModItem)item).createInstance(item, amount) : new ItemStack((IItemProvider)item, amount);
    }

    @Nonnull
    public static final ItemStack create(@Nullable Item from, int amount) {
        return SharedGlue.isDefined(from) ? ItemStacks.modded_create(from, amount) : ItemStack.field_190927_a;
    }

    @Nonnull
    public static final ItemStack create(@Nullable Item from) {
        return ItemStacks.create(from, 1);
    }

    @Nonnull
    public static final ItemStack create(String item_name) {
        ResourceLocation rid;
        ItemStack out = ItemStack.field_190927_a;
        ResourceLocation resourceLocation = rid = item_name != null ? ResourceLocation.func_208304_a((String)item_name) : null;
        if (rid != null && ForgeRegistries.ITEMS.containsKey(rid)) {
            out = ItemStacks.create((Item)ForgeRegistries.ITEMS.getValue(rid));
        }
        return out;
    }

    public static final ItemStack modded_create(BlockState state, int amount) {
        Block blok;
        if (amount < 1) {
            amount = 1;
        }
        return (blok = state.func_177230_c()) instanceof IModBlock ? ((IModBlock)blok).createInstance(state, amount) : new ItemStack((IItemProvider)blok, amount);
    }

    public static final ItemStack modded_create(Block blok, int amount) {
        return ItemStacks.modded_create(blok.func_176223_P(), amount);
    }

    @Nonnull
    public static final ItemStack create(@Nullable Block from, int amount) {
        return SharedGlue.isDefined(from) ? ItemStacks.modded_create(from, amount) : ItemStack.field_190927_a;
    }

    @Nonnull
    public static final ItemStack create(@Nullable Block from) {
        return ItemStacks.create(from, 1);
    }

    @Nonnull
    public static final ItemStack safe(@Nullable ItemStack stack) {
        return stack == null ? ItemStack.field_190927_a : stack;
    }

    public static final int getSize(@Nullable ItemStack stack) {
        return stack != null ? stack.func_190916_E() : 0;
    }

    public static final boolean isEmpty(@Nullable ItemStack stack) {
        return stack == null || stack.func_190926_b();
    }

    public static final boolean isSingle(@Nullable ItemStack stack) {
        return stack != null ? stack.func_190916_E() == 1 : false;
    }

    public static final void setSingle(@Nonnull ItemStack stack) {
        if (stack != ItemStack.field_190927_a) {
            stack.func_190920_e(1);
        }
    }

    public static final boolean setSize(@Nullable ItemStack stack, int size) {
        boolean is = true;
        if (stack != null && stack != ItemStack.field_190927_a) {
            stack.func_190920_e(size);
            is = stack.func_190926_b();
        }
        return is;
    }

    public static final boolean decrBy(@Nullable ItemStack stack, int by) {
        boolean is = true;
        if (stack != null && stack != ItemStack.field_190927_a) {
            stack.func_190918_g(by);
            is = stack.func_190926_b();
        }
        return is;
    }

    public static final void incrBy(@Nullable ItemStack stack, int by) {
        if (stack != null && stack != ItemStack.field_190927_a) {
            stack.func_190917_f(by);
        }
    }

    public static final boolean areItemStacksEqual(@Nullable ItemStack stackA, @Nullable ItemStack stackB) {
        return stackA == null && stackB == null ? true : (stackA != null && stackB != null ? ItemStack.func_77989_b((ItemStack)stackA, (ItemStack)stackB) : false);
    }

    public static final boolean areEqualIgnoreAmountsAndTags(ItemStack a, ItemStack b) {
        return ItemStack.func_179545_c((ItemStack)a, (ItemStack)b);
    }

    public static final boolean areEqualIgnoreAmounts(ItemStack a, ItemStack b) {
        return ItemStack.func_179545_c((ItemStack)a, (ItemStack)b) && ItemStack.func_77970_a((ItemStack)a, (ItemStack)b);
    }

    @Nonnull
    public static final ItemStack copy(@Nullable ItemStack stack) {
        return stack == null ? ItemStack.field_190927_a : (stack == ItemStack.field_190927_a ? ItemStack.field_190927_a : stack.func_77946_l());
    }

    @Nonnull
    public static final ItemStack copy1(@Nullable ItemStack stack) {
        if (stack == null || stack == ItemStack.field_190927_a) {
            return ItemStack.field_190927_a;
        }
        ItemStack copy = stack.func_77946_l();
        copy.func_190920_e(1);
        return copy;
    }

    @Nonnull
    public static final ItemStack copy(@Nonnull ItemStack stack, int n) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack copy = stack.func_77946_l();
        copy.func_190920_e(Math.max(0, n));
        return copy;
    }

    @Nonnull
    public static final ItemStack copysplit(@Nonnull ItemStack stack, int n) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack copy = stack.func_77946_l();
        n = Math.min(n, stack.func_190916_E());
        copy.func_190918_g(n);
        return copy;
    }

    @Nonnull
    public static final ItemStack copysplit(@Nonnull ItemStack stack) {
        return ItemStacks.copysplit(stack, 1);
    }

    @Nonnull
    public static final ItemStack copyDisplayName(@Nonnull ItemStack from, @Nonnull ItemStack to) {
        CompoundNBT displayData;
        if (from != to && ItemStacks.hasData(from) && (displayData = from.func_179543_a("display")) != null && displayData.func_150297_b("Name", 8)) {
            to.func_190925_c("display").func_74778_a("Name", displayData.func_74779_i("Name"));
        }
        return to;
    }

    @Nonnull
    public static final ItemStack copyWithUnlocalizedName(@Nonnull ItemStack stack, String key) {
        if (!ItemStacks.isEmpty(stack)) {
            stack = ItemStacks.copy(stack).func_200302_a((ITextComponent)new TranslationTextComponent(key, new Object[0]));
        }
        return stack;
    }

    public static final void setUnlocalizedNameOverride(ItemStack stack, String key) {
        if (!ItemStacks.isEmpty(stack)) {
            stack.func_200302_a((ITextComponent)new TranslationTextComponent(key, new Object[0]));
        }
    }

    public static final boolean hasData(@Nonnull ItemStack stack) {
        return stack != null && stack.func_77942_o();
    }

    public static final boolean hasNonEmptyData(@Nonnull ItemStack stack) {
        return stack != null && stack.func_77942_o() && !stack.func_77978_p().isEmpty();
    }

    @Nullable
    public static final CompoundNBT getData(@Nonnull ItemStack stack) {
        return stack.func_77978_p();
    }

    @Nonnull
    public static final CompoundNBT getOrCreateData(@Nonnull ItemStack stack) {
        return stack.func_196082_o();
    }

    public static final CompoundNBT getOrCreateData(@Nonnull ItemStack stack, String key) {
        return stack.func_190925_c(key);
    }

    public static final void removeData(@Nonnull ItemStack stack) {
        stack.func_77982_d(null);
    }

    public static final void normalizeData(@Nonnull ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().isEmpty()) {
            stack.func_77982_d(null);
        }
    }

    public static final boolean hasData(@Nonnull ItemStack stack, String key) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(key);
    }

    public static final boolean hasData(@Nonnull ItemStack stack, String key, int type) {
        return stack.func_77942_o() && stack.func_77978_p().func_150297_b(key, type);
    }

    public static final void removeData(@Nonnull ItemStack stack, String key, int type, boolean normalize) {
        if (ItemStacks.hasData(stack, key, type)) {
            stack.func_77978_p().func_82580_o(key);
            if (normalize && stack.func_77978_p().isEmpty()) {
                ItemStacks.removeData(stack);
            }
        }
    }

    public static final void removeData(@Nonnull ItemStack stack, String key, boolean normalize) {
        if (ItemStacks.hasData(stack, key)) {
            stack.func_77978_p().func_82580_o(key);
            if (normalize && stack.func_77978_p().isEmpty()) {
                ItemStacks.removeData(stack);
            }
        }
    }

    public static final boolean hasMap(@Nonnull ItemStack stack, String key) {
        return stack.func_77942_o() && stack.func_77978_p().func_150297_b(key, 10);
    }

    @Nonnull
    public static final CompoundNBT getMap(@Nonnull ItemStack stack, String key) {
        return stack.func_190925_c(key);
    }

    public static final boolean hasString(@Nonnull ItemStack stack, String key) {
        return ItemStacks.hasData(stack, key, 8);
    }

    @Nonnull
    public static final String getString(@Nonnull ItemStack stack, String key) {
        return stack.func_77978_p().func_74779_i(key);
    }

    public static final void setString(@Nonnull ItemStack stack, String key, String value) {
        ItemStacks.getOrCreateData(stack).func_74778_a(key, value);
    }

    @Nonnull
    public static final int getInt(@Nonnull ItemStack stack, String key) {
        return stack.func_77978_p().func_74762_e(key);
    }

    public static final void setInt(@Nonnull ItemStack stack, String key, int value) {
        ItemStacks.getOrCreateData(stack).func_74768_a(key, value);
    }

    public static final void setSampleFlag(@Nonnull ItemStack stack) {
        ItemStacks.getOrCreateData(stack).func_74757_a("SAMPLE", true);
    }

    public static final void clrSampleFlag(@Nonnull ItemStack stack) {
        ItemStacks.removeData(stack, "SAMPLE", true);
    }

    public static final void setFlag(@Nonnull ItemStack stack, String key, boolean value) {
        ItemStacks.getOrCreateData(stack).func_74757_a(key, value);
    }

    public static final boolean hasFlag(@Nonnull ItemStack stack, String key, boolean defaultIfMissing) {
        boolean b = defaultIfMissing;
        if (ItemStacks.hasData(stack, key, 1)) {
            b = stack.func_77978_p().func_74767_n(key);
        }
        return b;
    }

    public static final void setColorRgb(@Nonnull ItemStack stack, int color) {
        ItemStacks.setInt(stack, SharedGlue.CUSTOM_COLOR_TAGNAME(), color);
    }

    public static final void stampUnique(@Nonnull CompoundNBT subcompound, String prefix, String chaosString) {
        if (prefix == null) {
            prefix = "";
        }
        if (chaosString == null) {
            chaosString = prefix + System.nanoTime() + RandomStringUtils.randomAlphanumeric((int)6);
        }
        subcompound.func_74778_a("CHAOS", chaosString);
    }

    public static final void stampUnique(@Nonnull ItemStack stack, String prefix) {
        ItemStacks.stampUnique(ItemStacks.getOrCreateData(stack), prefix, null);
    }

    public static final boolean hasUniqueStamp(@Nonnull ItemStack stack, @Nullable String prefix, boolean defaultIfMissing) {
        boolean b = defaultIfMissing;
        if (ItemStacks.hasString(stack, "CHAOS")) {
            String s = ItemStacks.getString(stack, "CHAOS");
            boolean bl = b = !s.isEmpty();
            if (b && prefix != null) {
                b = s.length() > prefix.length() && s.startsWith(prefix);
            }
        }
        return b;
    }

    public static final boolean hasUniqueStamp(@Nonnull ItemStack stack) {
        return ItemStacks.hasUniqueStamp(stack, null, false);
    }

    public static final int getUsesLeft(@Nonnull ItemStack stack) {
        return ItemStacks.isEmpty(stack) ? 0 : stack.func_77958_k() - stack.func_77952_i();
    }

    public static final float getDurabilityLeft(@Nonnull ItemStack stack) {
        return ItemStacks.isEmpty(stack) ? 0.0f : 1.0f - (float)stack.func_77952_i() / (float)stack.func_77958_k();
    }

    public static final float getDurabilityUsed(@Nonnull ItemStack stack) {
        return ItemStacks.isEmpty(stack) ? 1.0f : (float)stack.func_77952_i() / (float)stack.func_77958_k();
    }

    public static final boolean isFlaggedAsSample(@Nonnull ItemStack stack) {
        return ItemStacks.hasData(stack, "SAMPLE") || Instructions.hasSampleFlag(stack);
    }

    public static final boolean isFlaggedUnbreakable(@Nonnull ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n("Unbreakable");
    }

    public static boolean isFlaggedUnrepairable(@Nonnull ItemStack stack) {
        return stack.func_82838_A() >= SharedGlue.UNREPAIRABLE_TOOL_COST();
    }

    public static final boolean isFlaggedVanishing(@Nonnull ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n("Vanishing");
    }

    @Nullable
    public static final IFluidHandlerItem getFluidHandler(ItemStack stack) {
        Object fH;
        IFluidHandlerItem iFluidHandlerItem = fH = ItemStacks.isEmpty(stack) ? null : (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElse(null);
        if (fH != null && fH.getClass() == FluidBucketWrapper.class && stack.func_77973_b() == Items.field_151117_aB) {
            fH = new MilkBucketWrapper(stack);
        }
        return fH;
    }

    private ItemStacks() {
    }

    public static final void init() {
    }
}

