/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import java.util.Vector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import org.jwaresoftware.mcmods.lib.Fluids;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.api.IDrink;

public class LiquidType
implements IDrink {
    private static final Vector<LiquidType> _INSTANCES = new Vector(57);
    public static final LiquidType WATER = new LiquidType(1, "Water", 6, 0.8f, true, "water", "potable_water", "purified_water", "dist_water");
    public static final LiquidType JUICE = new LiquidType(1, "Juice", 8, 0.6f, true, "juice", "fruit_juice");
    public static final LiquidType POWER = new LiquidType(1, "Power", 12, 1.0f, false, "birch_sap");
    public static final LiquidType TEA = new LiquidType(1, "Tea", 8, 0.7f, true, "tea");
    public static final LiquidType MILK = new LiquidType(1, "Milk", 4, 0.3f, true, "milk", "cow_milk", "sheep_milk", "goat_milk", "muscle_milk");
    public static final LiquidType PLANTMILK = new LiquidType(1, "PlantMilk", 4, 0.3f, true, "plant_milk", "soy_milk", "almond_milk", "coconut_milk", "acorn_milk", "kelp_milk");
    public static final LiquidType FIZZY = new LiquidType(1, "Fizzy", 5, 0.4f, true, "soda", "pop");
    public static final LiquidType ICE = new LiquidType(1, "Ice", 5, 0.7f, false, "cold_water", "ice_water");
    public static final LiquidType BROTH = new LiquidType(1, "Broth", 4, 0.3f, false, "broth", "stock");
    public static final LiquidType SOUP = new LiquidType(1, "Soup", 3, 0.2f, true, "soup", "gruel");
    public static final LiquidType STEW = new LiquidType(1, "Stew", 2, 0.2f, true, "stew", "mooshroo_stew", "mushroom_stew");
    public static final LiquidType POTION = new LiquidType(1, "Potion", POWER, true, "potion", "tonic", "elixir");
    public static final LiquidType CURATIVE = new LiquidType(1, "Curative", 2, 0.1f, false, "aloe", "nectar", "liquid_sunlight");
    public static final LiquidType HONEY = new LiquidType(1, "Honey", 1, 0.05f, true, "honey", "honeymilk");
    public static final LiquidType ALCOHOL = new LiquidType(1, "Alcohol", 2, 0.1f, true, "alcohol", "spirits", "beer", "liquor", "wine", "booze", "rum", "mead", "hard_cider", "vodka");
    public static final LiquidType XP = new LiquidType(1, "XpJuice", POTION, true, "experience", "xpjuice", "liquid_xp");
    public static final LiquidType MANA = new LiquidType(1, "Mana", POTION, true, "mana", "chaos", "liquid_chaos");
    public static final LiquidType SLIGHT = new LiquidType("Slight", 2, 0.1f);
    public static final LiquidType TRACE = new LiquidType("Trace", 1, 0.05f);
    public static final LiquidType MEATMILK = new LiquidType(1, "MeatMilk", SLIGHT, false, "meat", "meatmilk", "liquid_meat");
    public static final LiquidType NONE = new LiquidType(1, "None", 0, 0.0f, false, new String[0]);
    public static final LiquidType DYNAMIC = new LiquidType("Dynamic", 0, 0.0f);
    private String _name;
    protected final int _thirst;
    protected final float _hydration;
    @Nullable
    protected final String[] _fluids;
    @Nullable
    protected final String _fluid_tag;

    public LiquidType(String name, int thirst, float hydration, boolean tag, String ... fluids) {
        this(0, name, thirst, hydration, tag, fluids);
    }

    protected LiquidType(int x, String name, int thirst, float hydration, boolean tag, String ... fluids) {
        this._name = name;
        this._thirst = thirst;
        this._hydration = hydration;
        this._fluids = fluids != null && fluids.length > 0 ? fluids : null;
        this._fluid_tag = tag && this._fluids != null ? fluids[0] : null;
        if (x > 0) {
            _INSTANCES.add(this);
        }
    }

    public LiquidType(String name, LiquidType like, boolean t, String ... fluids) {
        this(0, name, like, t, fluids);
    }

    protected LiquidType(int x, String name, LiquidType like, boolean t, String ... fluids) {
        this._name = name;
        this._thirst = like._thirst;
        this._hydration = like._hydration;
        this._fluids = fluids != null && fluids.length > 0 ? fluids : null;
        this._fluid_tag = t && this._fluids != null ? fluids[0] : null;
        if (x > 0) {
            _INSTANCES.add(this);
        }
    }

    private LiquidType(String name, int thirst, float hydration) {
        this(1, name, thirst, hydration, false, new String[0]);
    }

    public final boolean isPredefined() {
        return this != DYNAMIC;
    }

    public final String getName() {
        return this._name;
    }

    @Override
    public int getThirstQuenched(ItemStack liquid) {
        return this._thirst;
    }

    @Override
    public float getHydrationAdded(ItemStack liquid) {
        return this._hydration;
    }

    public float getDamageChance(@Nullable ItemStack liquid) {
        return this.getThirstTriggerChance(liquid);
    }

    public boolean match(@Nonnull Fluid fluid) {
        if (this._fluids != null) {
            if (this._fluid_tag != null && RID.isIn(fluid, this._fluid_tag)) {
                return true;
            }
            String test = Fluids.name(fluid);
            for (String id : this._fluids) {
                if (!id.equals(test)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static final LiquidType find(@Nonnull Fluid fluid) {
        for (LiquidType lqT : _INSTANCES) {
            if (!lqT.match(fluid)) continue;
            return lqT;
        }
        return null;
    }
}

