/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.TNTBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.jwaresoftware.mcmods.lib.Fluids;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IBucketful;

@ParametersAreNonnullByDefault
public enum ModIntegration {
    MINECRAFT("minecraft"),
    FORGE_LIB("forge"),
    CARROTS_LIB("carrots"),
    ABYSSALCRAFT("abyssalcraft"),
    ACTUALLY_ADDITIONS("actuallyadditions"),
    ADVENTURERS_TOOLBOX("toolbox"),
    AGRICRAFT("agricraft"),
    ANCIENT_WARFARE("ancientwarfare"),
    ANIMANIA("animania"),
    APOTHEOSIS("apotheosis"),
    APPLECORE("applecore"),
    APPLESKIN("appleskin"),
    AQUACULTURE("aquaculture"),
    ARMOR_UNDERWEAR("armorunder"),
    ARMORPLUS("armorplus"),
    ASTRAL_SORCERY("astralsorcery"),
    ATUM2("atum"),
    AVARITA("avaritia"),
    BAUBLES("baubles"),
    BAUBLEY_HEARTS("bhc"),
    BASE_METALS("basemetals"),
    BETTER_AGRICULTURE("betteragriculture"),
    BETTER_WITH_MODS("betterwithmods"),
    BEWITCHMENT("bewitchment"),
    BIOMESOPLENTY("biomesoplenty"),
    BLOOD_MAGIC("bloodmagic"),
    CAVERN("cavern"),
    CERAMICS("ceramics"),
    CHAMPIONS("champions"),
    CHARCOAL_PIT("charcoal_pit"),
    COMBUSTIVE_FISHIN("combustfish"),
    COOKING_FOR_BLOCKHEADS("cookingforblockheads"),
    CREEPER_CONFETTI("creeperconfetti"),
    CUISINE("cuisine"),
    CURIOS("curios"),
    CYCLIC_MAGIC("cyclicmagic"),
    DEFILED_LANDS("defiledlands"),
    DIMENSIONAL_DOORS("dimdoors"),
    DMONSTERS("dmonsters"),
    DUNGEON_MOBS("dungeonmobs"),
    DYNAMIC_TREES("dynamictrees"),
    ELDER_ARSENAL("elderarsenal"),
    ELECTROBLOB_WIZARDRY("ebwizardry"),
    ELEMENTAL_CREEPERS("elementalcreepers"),
    ENDER_ZOO("enderiozoo"),
    EXOTIC_BIRDS("exoticbirds"),
    EXTENDED_FOODPANTRY("extendedfoodpantry"),
    EXTRA_ALCHEMY("extraalchemy"),
    FARMING_FOR_BLOCKHEADS("farmingforblockheads"),
    FERDINANDS_FLOWERS("ferdinandsflowers"),
    FLUID_COWS("fluidcows"),
    FORESTRY("forestry"),
    GALACTICRAFT("galacticraftcore"),
    GRAVESTONE_EXT("gravestone-extended"),
    GHOSTLY("ghostly"),
    HARVESTCRAFT_CROPS("pamhc2crops"),
    HEARTDROPS("heartdrops"),
    HUNGER_OVERHAUL("hungeroverhaul"),
    ICE_AND_FIRE("iceandfire"),
    INFERNAL_MOBS("infernalmobs"),
    INVENTORY_TWEAKS("inventorytweaks"),
    JEI("jei"),
    LOOT_SLASH_CONQUER("lsc"),
    LYCANITES_MOBS("lycanitesmobs"),
    MAGMA_MONSTERS("magma_monsters"),
    MEGALOOT("megaloot"),
    MILLENAIRE("millenaire"),
    MOBULTION("mobultion"),
    MOCREATURES("mocreatures"),
    MONK_MOD("monkmod"),
    MOREBUCKETS("morebuckets"),
    MOWZIE_MOBS("mowziesmobs"),
    MUTANT_BEASTS("mutantbeasts"),
    MUCH_MORE_SPIDERS("muchmorespiders"),
    MYSTICAL_AGRICULTURE("mysticalagriculture"),
    MYSTICAL_WILDLIFE("mysticalwildlife"),
    NATURA("natura"),
    NETHER_EX("netherex"),
    NUTRITION("nutrition"),
    PERSONAL_EFFECTS("personaleffects"),
    PILLAGERS("pillagers"),
    PINKLYSHEEP("pinklysheep"),
    POTION_CORE("potioncore"),
    PRIMAL("primal"),
    PRIMITIVE_MOBS("primitivemobs"),
    QUARK("quark"),
    RANDOMLOOT("randomloot"),
    REFORGED_MOD("reforged"),
    REPTILE_MOD("reptilemod"),
    ROUGH_MOBS("roughmobs"),
    RUSTIC("rustic"),
    SALRADAHN_COLLECTIBLES("scollectibles"),
    SALTY_MOD("saltmod"),
    SCALING_HEALTH("scalinghealth"),
    SILENT_GEMS("silentgems"),
    SILENT_GEAR("silentgear"),
    SIMPLE_FARMING("simplefarming"),
    SMARTHOPPERS("smarthoppers"),
    SPARTAN_SHIELDS("spartanshields"),
    SPARTAN_WEAPONRY("spartanweaponry"),
    STYLED_BLOCKS("styledblocks"),
    SUPERBLOCKS("superblocks"),
    SURVIVALIST("survivalist"),
    TEASTORY("teastory"),
    TERRAQUEOUS("terraqueous"),
    TETRA("tetra"),
    THAUMCRAFT("thaumcraft"),
    THE_BENEATH("beneath"),
    THE_BETWEENLANDS("thebetweenlands"),
    TINKERS_CONSTRUCT("tconstruct"),
    TOTEMIC("totemic"),
    TRAVERSE("traverse"),
    TREASURE2("treasure2"),
    TROPICRAFT("tropicraft"),
    TWILIGHT_FOREST("twilightforest"),
    UNIQUE_CROPS("uniquecrops"),
    UPSIZER("upsizer"),
    VANILLA_FOODPANTRY("vanillafoodpantry"),
    WINGS("wings"),
    WOLF_ARMOR("wolfarmor");

    private static final Map<String, ModIntegration> _CACHE;
    private static final Map<ModIntegration, String> _WABBITY_MODS;
    private final String _modid;

    private ModIntegration(String modid) {
        this._modid = modid;
    }

    public String modid() {
        return this._modid;
    }

    public final boolean isLoaded() {
        return this == MINECRAFT || ModList.get().isLoaded(this._modid);
    }

    public final boolean is(String modid) {
        return this._modid.equals(modid);
    }

    public final boolean belongsTo(@Nullable ResourceLocation r) {
        return r != null && this._modid.equals(r.func_110624_b());
    }

    public final boolean matches(@Nullable ResourceLocation r, @Nonnull String item_name) {
        return this.belongsTo(r) && item_name.equals(r.func_110623_a());
    }

    static final ResourceLocation getEKey(@Nullable Entity e) {
        return e == null ? null : Objects.requireNonNull(e.func_200600_R().getRegistryName());
    }

    public final boolean matches(@Nullable Entity e, @Nonnull String entity_name) {
        ResourceLocation r = e != null ? ModIntegration.getEKey(e) : null;
        return this.matches(r, entity_name);
    }

    public final boolean matchesAny(@Nullable Entity e, String ... names) {
        ResourceLocation r;
        ResourceLocation resourceLocation = r = e != null ? ModIntegration.getEKey(e) : null;
        if (this.belongsTo(r)) {
            String entity_name = r.func_110623_a();
            for (String next_name : names) {
                if (!entity_name.equals(next_name)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean belongsTo(@Nullable Biome b) {
        return b != null ? this.belongsTo(b.getRegistryName()) : false;
    }

    public final boolean belongsTo(@Nullable Entity e) {
        ResourceLocation r = e != null ? ModIntegration.getEKey(e) : null;
        return this.belongsTo(r);
    }

    public final boolean belongsTo(@Nullable Fluid f) {
        ResourceLocation r = f != null && f != Fluids.NO_FLUID ? f.getRegistryName() : null;
        return this.belongsTo(r);
    }

    public final boolean belongsTo(@Nonnull ItemStack i) {
        ResourceLocation r = i != null && !i.func_190926_b() ? i.func_77973_b().getRegistryName() : null;
        return this.belongsTo(r);
    }

    public static final String itemid(@Nonnull String mod_id, @Nonnull String item_name) {
        return "" + mod_id + ":" + item_name;
    }

    public final String anyid() {
        return this.modid() + ":*";
    }

    public final String itemid(@Nonnull String item_name) {
        return this.modid() + ":" + item_name;
    }

    public final ResourceLocation resource(@Nonnull String res_name) {
        return res_name.indexOf(58) > 0 ? new ResourceLocation(res_name) : new ResourceLocation(this.modid(), res_name);
    }

    @Nullable
    public final Item item(@Nonnull String item_name) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(this.resource(item_name));
        return SharedGlue.isDefined(item) ? item : null;
    }

    @Nullable
    public final Block block(@Nonnull String block_name) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(this.resource(block_name));
        return block != null && block != Blocks.field_150350_a ? block : null;
    }

    @Nonnull
    public final ItemStack itemstack(@Nonnull String item_name) {
        Item item = this.item(item_name);
        return item != null ? new ItemStack((IItemProvider)item, 1) : ItemStack.field_190927_a;
    }

    @Nonnull
    public static final ItemStack itemstack(@Nonnull String mod_id, @Nonnull String item_name) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(mod_id, item_name));
        return SharedGlue.isDefined(item) ? new ItemStack((IItemProvider)item, 1) : ItemStack.field_190927_a;
    }

    @Nullable
    public final Effect potion(@Nonnull String potion_name) {
        return (Effect)ForgeRegistries.POTIONS.getValue(this.resource(potion_name));
    }

    @Nullable
    public final Enchantment enchantment(@Nonnull String ench_name) {
        return (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(this.resource(ench_name));
    }

    @Nonnull
    public final Fluid fluid(@Nonnull String fluid_name) {
        return (Fluid)ForgeRegistries.FLUIDS.getValue(this.resource(fluid_name));
    }

    @Nullable
    public static final ModIntegration get(@Nullable String modid) {
        return modid != null ? _CACHE.get(modid) : null;
    }

    @Nullable
    public static final ModIntegration get(@Nonnull ItemStack stack) {
        ResourceLocation rid = stack != null ? stack.func_77973_b().getRegistryName() : null;
        return rid != null ? ModIntegration.get(rid.func_110624_b()) : null;
    }

    public static final boolean isPresent(@Nonnull String modid) {
        return "minecraft".equals(modid) || modid != null && ModList.get().isLoaded(modid);
    }

    public static final boolean anyPresent(ModIntegration ... mods) {
        for (ModIntegration mod : mods) {
            if (!mod.isLoaded()) continue;
            return true;
        }
        return false;
    }

    public static final boolean isVanillaBaselineReplaced() {
        return PRIMAL.isLoaded() || BETTER_WITH_MODS.isLoaded();
    }

    public static final boolean isUniversalBucket(@Nonnull ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof BucketItem || item instanceof IBucketful) {
            return true;
        }
        ResourceLocation r = item.getRegistryName();
        if (r == null) {
            return false;
        }
        String item_name = r.func_110623_a();
        if (VANILLA_FOODPANTRY.belongsTo(r) && "full_bucket_jar".equals(item_name)) {
            return true;
        }
        if (CERAMICS.belongsTo(r) && "clay_bucket".equals(item_name)) {
            return true;
        }
        return MOREBUCKETS.belongsTo(r) && item_name.endsWith("_bucket");
    }

    public static final boolean isCustomMilkBottle(@Nonnull ItemStack stack) {
        ResourceLocation r = stack.func_77973_b().getRegistryName();
        if (r == null) {
            return false;
        }
        String item_name = r.func_110623_a();
        if (VANILLA_FOODPANTRY.belongsTo(r) || EXTENDED_FOODPANTRY.belongsTo(r)) {
            return item_name.startsWith("milkdrink") || item_name.contains("honeymilk");
        }
        if (ANIMANIA.belongsTo(r)) {
            return "milk_bottle".equals(item_name);
        }
        if (RUSTIC.belongsTo(r) && "fluid_bottle".equals(item_name)) {
            return Fluids.isMilk(Fluids.getGenericFluid(stack));
        }
        return false;
    }

    public static final boolean isCustomAlcoholBottle(@Nonnull ItemStack stack) {
        return false;
    }

    public static final boolean hasTipsyEffect(@Nonnull Potion potion) {
        ResourceLocation name = potion.getRegistryName();
        if (name == null) {
            return false;
        }
        String potion_name = name.func_110623_a();
        if ("tipsy".equals(potion_name) || "booze".equals(potion_name) || "drunk".equals(potion_name)) {
            return true;
        }
        if (RUSTIC.belongsTo(name)) {
            return "tipsy".equals(potion_name);
        }
        return false;
    }

    public static final boolean hasBleedingEffect(@Nonnull Effect potion) {
        if (Potions.isHarmful(potion, false)) {
            ResourceLocation name = potion.getRegistryName();
            if (name == null) {
                return false;
            }
            String potion_name = name.func_110623_a();
            if (potion_name.contains("bleed")) {
                return true;
            }
        }
        return false;
    }

    public static final boolean isDetonateable(Block block) {
        if (block == Blocks.field_150335_W || block instanceof TNTBlock) {
            return true;
        }
        ResourceLocation r = block.getRegistryName();
        if (r == null) {
            return false;
        }
        return ELDER_ARSENAL.belongsTo(r) && "gunpowder_barrel".equals(r.func_110623_a());
    }

    public static final boolean isNaturalFlightGear(@Nonnull Item item) {
        ResourceLocation name;
        if (SharedGlue.isDefined(item) && WINGS.belongsTo(name = item.getRegistryName())) {
            return name.func_110623_a().endsWith("_wings");
        }
        return false;
    }

    public static final boolean isSimpleShield(@Nonnull Item item) {
        if (SharedGlue.isDefined(item)) {
            ResourceLocation name = item.getRegistryName();
            if (SPARTAN_SHIELDS.belongsTo(name)) {
                return name.func_110623_a().startsWith("shield_basic_");
            }
            if (ELDER_ARSENAL.belongsTo(name) || BASE_METALS.belongsTo(name)) {
                return name.func_110623_a().endsWith("_shield");
            }
        }
        return false;
    }

    public static final boolean isAnimalArmor(@Nonnull Item item) {
        if (SharedGlue.isDefined(item)) {
            ResourceLocation name = item.getRegistryName();
            if (BASE_METALS.belongsTo(name) || ARMORPLUS.belongsTo(name)) {
                return name.func_110623_a().endsWith("_horse_armor");
            }
            if (WOLF_ARMOR.belongsTo(name)) {
                return name.func_110623_a().endsWith("_wolf_armor");
            }
        }
        return false;
    }

    public static final boolean isLikenessTrophy(ItemStack drop) {
        ResourceLocation r = drop.func_77973_b().getRegistryName();
        if (r != null && !MINECRAFT.belongsTo(r)) {
            if (SALRADAHN_COLLECTIBLES.belongsTo(r)) {
                return true;
            }
            String itemname = r.func_110623_a();
            if (TWILIGHT_FOREST.belongsTo(r)) {
                return itemname.startsWith("trophy");
            }
            if (THE_BETWEENLANDS.belongsTo(r)) {
                if (itemname.startsWith("spirit_tree_face")) {
                    return true;
                }
                return itemname.startsWith("skull_mask");
            }
            if (PINKLYSHEEP.belongsTo(r)) {
                return itemname.startsWith("plaquette_");
            }
        }
        return false;
    }

    public static final boolean isOneOfWabbits(ModIntegration modid) {
        return modid == null ? false : _WABBITY_MODS.containsKey((Object)modid);
    }

    public static final boolean isOneOfWabbits(String modid) {
        return modid == null ? false : _WABBITY_MODS.values().contains(modid);
    }

    static {
        _CACHE = (Map)Util.func_200696_a(new HashMap(91), cache -> {
            for (ModIntegration m : ModIntegration.values()) {
                cache.put(m._modid, m);
            }
        });
        _WABBITY_MODS = (Map)Util.func_200696_a(new HashMap(), m -> {
            m.put(CARROTS_LIB, CARROTS_LIB.modid());
            m.put(UPSIZER, UPSIZER.modid());
            m.put(PERSONAL_EFFECTS, PERSONAL_EFFECTS.modid());
            m.put(VANILLA_FOODPANTRY, VANILLA_FOODPANTRY.modid());
            m.put(SUPERBLOCKS, SUPERBLOCKS.modid());
            m.put(SMARTHOPPERS, SMARTHOPPERS.modid());
            m.put(EXTENDED_FOODPANTRY, EXTENDED_FOODPANTRY.modid());
            m.put(ARMOR_UNDERWEAR, ARMOR_UNDERWEAR.modid());
            m.put(PINKLYSHEEP, PINKLYSHEEP.modid());
        });
    }
}

