/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.CaveSpiderEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.monster.MagmaCubeEntity;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.monster.SilverfishEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.monster.StrayEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombiePigmanEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.SnowGolemEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.projectile.WitherSkullEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.jwaresoftware.mcmods.lib.ExtendedResourceLocation;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.Locations;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.SharedGlue;

public final class NPE {
    public static final String[] PARROT_COLORS = new String[]{"red_blue", "blue", "green", "yellow_blue", "grey"};
    private static final List<ResourceLocation> _BAD_GUYS = new Vector<ResourceLocation>(40);

    public static final MobEntity getOrNull(@Nullable Entity entity) {
        return entity instanceof MobEntity ? (MobEntity)entity : null;
    }

    public static final boolean isa(@Nullable Entity entity) {
        return entity instanceof MobEntity;
    }

    public static final boolean isaAnimal(@Nullable Entity entity, boolean modded) {
        return entity instanceof AnimalEntity;
    }

    public static final boolean healIfHurt(@Nonnull MobEntity entity, float amount) {
        boolean apply;
        boolean bl = apply = !entity.func_175446_cd() && entity.func_110143_aJ() < entity.func_110138_aP();
        if (apply) {
            if (amount < 0.0f) {
                entity.func_70691_i(entity.func_110138_aP() - entity.func_110143_aJ());
            } else {
                entity.func_70691_i(amount);
            }
        }
        return apply;
    }

    public static final int NUM_PARROT_COLORS() {
        return PARROT_COLORS.length;
    }

    public static final int GREEN_PARROT_COLOR() {
        return 2;
    }

    public static final boolean isSolidParrotColor(int color) {
        return color != 0 || color != 3;
    }

    public static final boolean isaWitch(Entity target, boolean modded) {
        if (target == null) {
            return false;
        }
        if (modded) {
            if (target instanceof WitchEntity) {
                return true;
            }
            String eid = String.valueOf(SharedGlue.getEntityKey(target));
            return eid.endsWith("witch");
        }
        return !modded && target.getClass() == WitchEntity.class;
    }

    public static final boolean isaFish(ItemStack stack, boolean modded) {
        if (ItemStacks.isEmpty(stack)) {
            return false;
        }
        Item item = stack.func_77973_b();
        return item.func_206844_a(ItemTags.field_206964_G);
    }

    public static final boolean isaSilverfish(Entity target, boolean modded) {
        return modded && target instanceof SilverfishEntity || !modded && target != null && target.getClass().equals(SilverfishEntity.class);
    }

    public static final boolean isaSlime(Entity target, boolean modded) {
        return modded && target instanceof SlimeEntity || !modded && target != null && (target.getClass().equals(SlimeEntity.class) || target.getClass().equals(MagmaCubeEntity.class));
    }

    public static final boolean isaTinySlime(Entity target, boolean modded) {
        boolean iz = NPE.isaSlime(target, modded);
        if (iz) {
            SlimeEntity slime = (SlimeEntity)target;
            iz = slime.func_70809_q() == 1;
        }
        return iz;
    }

    public static final boolean isaSkeleton(Entity target, boolean modded, boolean wither_ok) {
        boolean iz;
        if (target == null) {
            return false;
        }
        boolean bl = iz = target instanceof AbstractSkeletonEntity || EntityTypeTags.field_219764_a.func_199685_a_((Object)target.func_200600_R());
        if (modded) {
            return wither_ok ? iz : !(target instanceof WitherSkeletonEntity);
        }
        if (iz) {
            Class<?> klass = target.getClass();
            iz = klass == SkeletonEntity.class || klass == WitherSkeletonEntity.class && wither_ok || klass == StrayEntity.class;
        }
        return iz;
    }

    public static final boolean isaArthropod(Entity target, boolean modded) {
        boolean iz;
        if (target == null) {
            return false;
        }
        if (modded) {
            if (NPE.isaSpider(target, modded)) {
                return true;
            }
            if (NPE.isaSilverfish(target, modded)) {
                return true;
            }
            if (ModIntegration.THE_BETWEENLANDS.matchesAny(target, "sludge", "leech", "blood_snail", "mire_snail", "termite", "silt_crab")) {
                return true;
            }
        }
        boolean bl = iz = target instanceof MobEntity && ((MobEntity)target).func_70668_bt() == CreatureAttribute.field_223224_c_;
        if (iz && !modded) {
            Class<?> klass = target.getClass();
            iz = klass == SpiderEntity.class || klass == CaveSpiderEntity.class || klass == SilverfishEntity.class || klass == EndermiteEntity.class;
        }
        return iz;
    }

    public static final boolean isaSkeleton(Entity target, boolean modded) {
        return NPE.isaSkeleton(target, modded, true);
    }

    public static final boolean isaTaintableSoul(Entity victim, boolean modded, boolean strict) {
        if (victim != null) {
            if (victim instanceof ZombieEntity) {
                return !strict || !(victim instanceof ZombiePigmanEntity);
            }
            if (victim instanceof AbstractIllagerEntity) {
                return true;
            }
            if (victim instanceof AbstractVillagerEntity) {
                return !strict;
            }
            if (NPE.isaWitch(victim, modded)) {
                return true;
            }
            if (!strict && SharedGlue.isaRealPlayer(victim)) {
                return true;
            }
        }
        return false;
    }

    public static final boolean isaTaintedSoul(Entity victim, boolean modded) {
        return NPE.isaTaintableSoul(victim, modded, true);
    }

    public static final boolean isZombieLike(Entity victim, boolean strict) {
        if (victim instanceof MobEntity) {
            if (victim instanceof ZombieEntity) {
                return true;
            }
            if (!strict && victim instanceof AbstractIllagerEntity) {
                return true;
            }
            if (!strict && NPE.isaWitch(victim, true)) {
                return true;
            }
            String cn = victim.getClass().getName();
            if (ModIntegration.ABYSSALCRAFT.belongsTo(victim)) {
                return cn.endsWith("Zombie");
            }
            if (ModIntegration.THE_BETWEENLANDS.belongsTo(victim)) {
                return cn.endsWith("Mummy");
            }
        }
        return false;
    }

    public static final boolean isVillagerish(Entity victim) {
        if (victim != null) {
            if (victim instanceof AbstractVillagerEntity || victim instanceof ZombieVillagerEntity) {
                return true;
            }
            if (victim instanceof AbstractIllagerEntity) {
                return true;
            }
            if (NPE.isaWitch(victim, true)) {
                return true;
            }
        }
        return false;
    }

    public static final boolean isVillageProtector(Entity entity, boolean wolves, boolean modded) {
        boolean wolf;
        if (entity == null) {
            return false;
        }
        boolean golem = entity instanceof IronGolemEntity || entity.getClass() == SnowGolemEntity.class;
        boolean bl = wolf = wolves && !golem && entity instanceof WolfEntity && ((WolfEntity)entity).func_70909_n();
        return modded ? golem || wolf : (golem ? entity.getClass() == IronGolemEntity.class || entity.getClass() == SnowGolemEntity.class : (wolf ? entity.getClass() == WolfEntity.class : false));
    }

    public static final boolean isaSpider(Entity target, boolean modded) {
        if (target == null) {
            return false;
        }
        if (modded) {
            if (target instanceof SpiderEntity) {
                return true;
            }
            String cn = target.getClass().getName();
            if (cn.contains(".primitivemobs.") && cn.endsWith("Spider")) {
                return true;
            }
        }
        return !modded && (target.getClass() == SpiderEntity.class || target.getClass() == CaveSpiderEntity.class);
    }

    public static final boolean isaVenomousSpider(Entity target, boolean modded) {
        if (target == null) {
            return false;
        }
        if (modded) {
            return target instanceof CaveSpiderEntity;
        }
        return !modded && target.getClass() == CaveSpiderEntity.class;
    }

    public static final boolean isaCreeper(Entity target, boolean modded) {
        if (target == null) {
            return false;
        }
        if (!modded) {
            return target.getClass() == CreeperEntity.class;
        }
        if (target instanceof CreeperEntity) {
            return true;
        }
        return ModIntegration.NETHER_EX.matches(target, "monster_spore_creeper");
    }

    public static final boolean isPoweredCreeper(CreeperEntity creeper) {
        return creeper != null && creeper.func_225509_J__();
    }

    public static final boolean isaBlaze(Entity target, boolean modded) {
        if (target == null) {
            return false;
        }
        if (!modded) {
            return target.getClass() == BlazeEntity.class;
        }
        if (target instanceof BlazeEntity) {
            return true;
        }
        return ModIntegration.PRIMITIVE_MOBS.matches(target, "blazing_juggernaut");
    }

    public static final boolean isTooEasyTarget(Entity target, boolean modded, float threshold) {
        if (SharedGlue.isBoss(target)) {
            return false;
        }
        if (target instanceof MobEntity) {
            MobEntity livingtarget = (MobEntity)target;
            IAttributeInstance ia = livingtarget.func_110148_a(SharedMonsterAttributes.field_111264_e);
            if (ia != null && ia.func_111126_e() < (double)threshold) {
                return true;
            }
            if (target instanceof SlimeEntity) {
                return ((SlimeEntity)target).func_70809_q() < 3;
            }
            return false;
        }
        return !SharedGlue.isaRealPlayer(target);
    }

    public static final boolean isaWither(Entity target, boolean modded) {
        if (target == null) {
            return false;
        }
        if (modded && target instanceof WitherEntity) {
            return true;
        }
        return !modded && target.getClass() == WitherEntity.class;
    }

    public static final boolean isaDragon(Entity target, boolean modded) {
        if (target != null) {
            ResourceLocation eid;
            if (modded && target instanceof EnderDragonEntity || !modded && target.getClass().equals(EnderDragonEntity.class)) {
                return true;
            }
            if (target instanceof EnderDragonPartEntity) {
                EnderDragonPartEntity mp = (EnderDragonPartEntity)target;
                if (mp.field_213852_b != null) {
                    return NPE.isaDragon((Entity)mp.field_213852_b, modded);
                }
            } else if (modded && target instanceof LivingEntity && (eid = SharedGlue.getEntityKey(target)) != null && "dragonboss".equals(eid.func_110623_a())) {
                return true;
            }
        }
        return false;
    }

    public static final boolean isaEnderman(Entity target, boolean modded) {
        if (target == null) {
            return false;
        }
        if (modded) {
            if (target instanceof EndermanEntity) {
                return true;
            }
            String cn = target.getClass().getName();
            if (cn.contains(".spectrite.") && cn.endsWith("Enderman")) {
                return true;
            }
        }
        return !modded && target.getClass() == EndermanEntity.class;
    }

    public static final boolean isaFlyingEntity(Entity target, boolean modded) {
        if (target == null) {
            return false;
        }
        Class<?> klass = target.getClass();
        if (target instanceof FlyingEntity) {
            return modded ? true : klass == GhastEntity.class || klass == PhantomEntity.class;
        }
        if (target instanceof BlazeEntity) {
            return modded ? true : klass == BlazeEntity.class;
        }
        if (target instanceof VexEntity) {
            return modded ? true : klass == VexEntity.class;
        }
        if (target instanceof WitherEntity) {
            return modded ? true : klass == WitherEntity.class;
        }
        return NPE.isaBlaze(target, modded) || NPE.isaDragon(target, modded);
    }

    public static final boolean isaFlightCapableEntity(Entity target, boolean modded) {
        if (target == null) {
            return false;
        }
        if (NPE.isaFlyingEntity(target, modded)) {
            return true;
        }
        return NPE.isaEnderman(target, modded) || target instanceof ShulkerEntity;
    }

    static final boolean isaWitheringThingy(Entity thingy) {
        return thingy != null && (thingy.getClass() == WitherSkeletonEntity.class || thingy.getClass() == WitherSkullEntity.class);
    }

    public static final boolean isWardingProtectionFrom(Entity target, boolean modded) {
        return NPE.isaWitch(target, modded) || NPE.isaWither(target, modded) || NPE.isaWitheringThingy(target);
    }

    public static final boolean isMisusedMagic(@Nonnull DamageSource ds) {
        Entity e = ds.func_76346_g();
        if (e == null || !ds.func_82725_o()) {
            return false;
        }
        return e instanceof GuardianEntity;
    }

    public static final boolean isPrimedTnT(@Nullable Entity entity) {
        if (entity == null) {
            return false;
        }
        if (entity instanceof TNTEntity) {
            return true;
        }
        return ModIntegration.PRIMITIVE_MOBS.matches(entity, "primitive_tnt_primed");
    }

    public static final boolean isWaterSensitive(Entity hit) {
        return NPE.isaEnderman(hit, true) || NPE.isaBlaze(hit, true);
    }

    public static final String getTranslationKey(@Nullable ResourceLocation subject, String defaultIfNotFound) {
        if (ExtendedResourceLocation.isa(subject)) {
            subject = ExtendedResourceLocation.narrow(subject);
        }
        if (defaultIfNotFound == null) {
            defaultIfNotFound = subject != null ? "entity.UNKNOWN" : "";
        }
        return subject != null && ForgeRegistries.ENTITIES.containsKey(subject) ? Util.func_200697_a((String)"entity", (ResourceLocation)subject) : defaultIfNotFound;
    }

    public static final String getTranslationKey(@Nullable ResourceLocation subject) {
        return NPE.getTranslationKey(subject, null);
    }

    @Nonnull
    public static final ITextComponent getTranslatedName(String translationKey) {
        translationKey = (String)StringUtils.defaultIfBlank((CharSequence)translationKey, (CharSequence)"entity.UNKNOWN");
        return new TranslationTextComponent(translationKey, new Object[0]);
    }

    @Nonnull
    public static final ITextComponent getTranslatedName(@Nullable ResourceLocation subject) {
        String translationKey = NPE.getTranslationKey(subject);
        return NPE.getTranslatedName(translationKey);
    }

    @Nonnull
    public static final ITextComponent getTranslatedName(@Nonnull Entity subject) {
        return subject.func_200600_R().func_212546_e();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addModdedBadGuy(ResourceLocation rLoc) {
        if (rLoc != null) {
            List<ResourceLocation> list = _BAD_GUYS;
            synchronized (list) {
                if (!_BAD_GUYS.contains(rLoc)) {
                    _BAD_GUYS.add(rLoc);
                }
            }
        }
    }

    static final boolean isKnownBadGuy(ResourceLocation rLoc) {
        return ModIntegration.MOWZIE_MOBS.belongsTo(rLoc) || ModIntegration.GHOSTLY.belongsTo(rLoc) || ModIntegration.DMONSTERS.belongsTo(rLoc);
    }

    static final boolean isBadGuy(ResourceLocation rLoc) {
        for (ResourceLocation deny : _BAD_GUYS) {
            if (deny.equals((Object)rLoc)) {
                return true;
            }
            if (!"*".equals(deny.func_110623_a()) || !deny.func_110624_b().equals(rLoc.func_110624_b())) continue;
            return true;
        }
        return NPE.isKnownBadGuy(rLoc);
    }

    public static final boolean isModdedBadGuy(@Nullable ResourceLocation rLoc) {
        return rLoc != null && NPE.isBadGuy(rLoc);
    }

    public static final void resetModdedBadGuys() {
        _BAD_GUYS.clear();
    }

    public static final boolean isBiomeNative(@Nonnull MobEntity mob, @Nonnull ResourceLocation biome_id) {
        Biome theBiome_orDim;
        EntityType klass = mob.func_200600_R();
        boolean is = false;
        Biome biome = theBiome_orDim = ForgeRegistries.BIOMES.containsKey(biome_id) ? (Biome)ForgeRegistries.BIOMES.getValue(biome_id) : null;
        if (theBiome_orDim == null) {
            return false;
        }
        for (Biome.SpawnListEntry spawnable : theBiome_orDim.func_76747_a(EntityClassification.MONSTER)) {
            if (!klass.equals(spawnable.field_200702_b)) continue;
            is = true;
            break;
        }
        return is;
    }

    public static final boolean isEndNativeSpawn(@Nonnull MobEntity mob) {
        Class<?> klass = mob.getClass();
        boolean is = klass == ShulkerEntity.class || NPE.isaEnderman((Entity)mob, true) || klass == EndermiteEntity.class || NPE.isaDragon((Entity)mob, false);
        return is || NPE.isBiomeNative(mob, Locations.BIOME_ID_END);
    }

    public static final boolean isNetherNativeSpawn(@Nonnull MobEntity mob) {
        Class<?> klass = mob.getClass();
        boolean is = klass == ZombiePigmanEntity.class || klass == WitherSkeletonEntity.class || klass == GhastEntity.class || klass == MagmaCubeEntity.class || NPE.isaWither((Entity)mob, true);
        return is || NPE.isBiomeNative(mob, Locations.BIOME_ID_NETHER);
    }

    public static final void clearAttackTarget(@Nonnull MobEntity mob) {
        mob.func_70624_b(null);
    }

    private NPE() {
    }

    public static final void init() {
    }

    public static class IS_UNFRIENDLY_TOWARDS
    implements Predicate<Entity> {
        protected final LivingEntity _player;

        public IS_UNFRIENDLY_TOWARDS(@Nullable LivingEntity player) {
            this._player = player;
        }

        public boolean apply(Entity e) {
            return e.func_70089_S() && SharedGlue.isMonsterOrPiOoed(e, this._player);
        }
    }
}

