/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import cpw.mods.modlauncher.api.INameMappingService;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.TippedArrowItem;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.EffectUtils;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jwaresoftware.mcmods.lib.Effects;
import org.jwaresoftware.mcmods.lib.Fluids;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LibConfig;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.MagnifyingPotionEffect;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.NPE;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Strings;
import org.jwaresoftware.mcmods.lib.StubbornPotionEffect;
import org.jwaresoftware.mcmods.lib.Tooltips;
import org.jwaresoftware.mcmods.lib.api.ICurative;

public final class Potions {
    public static final EffectInstance[] EMPTY_EFFECTS = new EffectInstance[0];
    public static final int MAX_AMPLIFY_LEVEL = 4;
    public static Potion PLACEHOLDER = net.minecraft.potion.Potions.field_185229_a;
    public static final Effect NO_EFFECT = new Effect(EffectType.NEUTRAL, 0xFFFFFF){

        protected String func_210758_b() {
            return "effect." + LibInfo.lstring("placeholder");
        }

        public boolean func_76397_a(int d, int a) {
            return false;
        }

        public void func_76394_a(LivingEntity le, int amplifier) {
        }

        public void func_180793_a(@Nullable Entity e, @Nullable Entity es, LivingEntity le, int a, double h) {
        }
    };
    private static final int _FOREVER_THRESHOLD_DURATION = 32000;
    static final String _CUSTOM_ELIXIR_EFFECTS_TAGNAME = "ElixirEffects";
    public static final String _DEFAULT_MINECRAFT_PREFIX = "item.minecraft.potion.effect.";
    private static Method _ON_FINISHED_POTION_EFFECT = null;
    private static Field _FOOD_POTION_EFFECTS = null;

    public static final void registerSharedDictIds(@Nonnull String dictKey) {
        RID.addToGroup(dictKey, Items.field_151068_bn);
        RID.addToGroup(dictKey, Items.field_185155_bH);
        RID.addToGroup(dictKey, Items.field_185156_bI);
    }

    public static final void registerSharedDictIds() {
        Potions.registerSharedDictIds("carrots:potion_bottles");
    }

    public static final boolean isEmpty(@Nullable Effect e) {
        return e == null || e == NO_EFFECT;
    }

    public static final boolean isEmpty(@Nullable Potion p) {
        if (p != null && !p.func_185170_a().isEmpty()) {
            for (EffectInstance e : p.func_185170_a()) {
                if (Potions.isEmpty(e.func_188419_a())) continue;
                return false;
            }
        }
        return true;
    }

    public static final boolean isLikelyForever(EffectInstance e) {
        return e != null && e.func_76459_b() > 32000;
    }

    public static final ItemStack newPotionHeldItem(Potion potion) {
        ItemStack potionitem = new ItemStack((IItemProvider)Items.field_151068_bn);
        potionitem = !ForgeRegistries.POTION_TYPES.containsKey(potion.getRegistryName()) ? PotionUtils.func_185184_a((ItemStack)potionitem, (Collection)potion.func_185170_a()) : PotionUtils.func_185188_a((ItemStack)potionitem, (Potion)potion);
        return potionitem;
    }

    public static final void addEffect(ItemStack to, EffectInstance effect) {
        if (to != ItemStack.field_190927_a) {
            PotionUtils.func_185184_a((ItemStack)to, Collections.singleton(effect));
        }
    }

    public static final ItemStack newSoakedPotionPlaceholderItem(@Nonnull ItemStack original) {
        return PotionUtils.func_185188_a((ItemStack)ItemStacks.copy1(original), (Potion)SharedGlue.PotionType_harmless);
    }

    public static final EffectInstance newPotionEffect(Effect effect, int duration, int amplifier, boolean ambient, boolean particles) {
        return new EffectInstance(effect, duration, amplifier, ambient, particles);
    }

    public static final EffectInstance newPotionEffect(Effect effect, int duration, int amplifier) {
        return new EffectInstance(effect, duration, amplifier);
    }

    public static final EffectInstance newPotionTypeEffect(Effect effect, int duration_secs, int amplifier) {
        return new EffectInstance(effect, SharedGlue.ticksFromSeconds(duration_secs), amplifier, false, true);
    }

    public static final EffectInstance newHiddenPotionTypeEffect(Effect effect, int duration_secs, int amplifier) {
        return new EffectInstance(effect, SharedGlue.ticksFromSeconds(duration_secs), amplifier, false, false);
    }

    public static final EffectInstance newStubbornPotionEffect(Effect effect, int duration, int amplifier, boolean ambient, boolean particles) {
        return new StubbornPotionEffect(false, effect, duration, amplifier, ambient, particles);
    }

    public static final EffectInstance newFortifiedPotionEffect(Effect effect, int duration, int amplifier, boolean ambient, boolean particles) {
        return new StubbornPotionEffect(true, effect, duration, amplifier, ambient, particles);
    }

    public static final EffectInstance newForeverEffect(Effect effect, int amplifier) {
        return new EffectInstance(effect, Integer.MAX_VALUE, amplifier, false, false);
    }

    public static final EffectInstance copyPotionEffect(EffectInstance source) {
        if (source instanceof MagnifyingPotionEffect) {
            return new MagnifyingPotionEffect((MagnifyingPotionEffect)source);
        }
        if (source instanceof StubbornPotionEffect) {
            return new StubbornPotionEffect((StubbornPotionEffect)source);
        }
        return new EffectInstance(source);
    }

    public static final boolean removePotionEffectUnconditionally(@Nonnull LivingEntity entity, @Nonnull Effect effect) {
        boolean tried = false;
        EffectInstance effectinstance = entity.func_184596_c(effect);
        if (effectinstance != null) {
            Potions.onFinishedPotionEffect(entity, effectinstance);
            tried = !entity.func_70644_a(effect);
        }
        return tried;
    }

    public static final boolean removePotionEffect(@Nonnull LivingEntity entity, @Nonnull Effect effect) {
        boolean tried = entity.func_70644_a(effect);
        entity.func_195063_d(effect);
        return tried && !entity.func_70644_a(effect);
    }

    static final boolean _removeEffect(LivingEntity entity, Effect effect, boolean unconditional) {
        return unconditional ? Potions.removePotionEffectUnconditionally(entity, effect) : Potions.removePotionEffect(entity, effect);
    }

    public static final void removePotionEffect(@Nonnull LivingEntity entity, @Nonnull Potion potion) {
        for (EffectInstance e : potion.func_185170_a()) {
            entity.func_195063_d(e.func_188419_a());
        }
    }

    public static final void removePotionEffectUnconditionally(@Nonnull LivingEntity entity, @Nonnull Potion potion) {
        for (EffectInstance e : potion.func_185170_a()) {
            Potions._removeEffect(entity, e.func_188419_a(), true);
        }
    }

    public static final void curePotionEffects(LivingEntity player, ItemStack with) {
        player.curePotionEffects(with);
    }

    public static final void addPotionEffect(LivingEntity entity, Effect effect, int duration_secs, int amplifier, boolean ambient, boolean particles) {
        entity.func_195064_c(Potions.newPotionEffect(effect, SharedGlue.ticksFromSeconds(duration_secs), amplifier, ambient, particles));
    }

    public static final void addPotionEffect(LivingEntity entity, Effect effect, int duration_secs, int amplifier) {
        entity.func_195064_c(Potions.newPotionEffect(effect, SharedGlue.ticksFromSeconds(duration_secs), amplifier));
    }

    public static final void addSecondaryPotionEffect(LivingEntity entity, Effect neweffect, Effect oldeffect, int amplifier) {
        EffectInstance current = entity.func_70660_b(oldeffect);
        if (current != null) {
            if (amplifier < 0) {
                amplifier = current.func_76458_c();
            }
            entity.func_195064_c(Potions.newPotionEffect(neweffect, current.func_76459_b(), amplifier, false, false));
        }
    }

    public static final boolean addFoodEffect(Item item, EffectInstance to, float chance) {
        Food food;
        if (item.func_219971_r() && (food = item.func_219967_s()) != null) {
            List<Pair<Supplier<EffectInstance>, Float>> itemeffects = Potions.effectsFor(item.func_219967_s());
            if (itemeffects == null) {
                return false;
            }
            itemeffects.add((Pair<Supplier<EffectInstance>, Float>)Pair.of(() -> to, (Object)Float.valueOf(chance)));
        }
        return true;
    }

    public static final void addPotionEffect(Item food, Effect effect, int duration_secs, int amplifier, float chance) {
        Potions.addFoodEffect(food, Potions.newPotionEffect(effect, SharedGlue.ticksFromSeconds(duration_secs), amplifier), chance);
    }

    public static final boolean setFoodEffect(Item item, EffectInstance to, float chance) {
        Food food;
        if (item.func_219971_r() && (food = item.func_219967_s()) != null) {
            List<Pair<Supplier<EffectInstance>, Float>> itemeffects = Potions.effectsFor(item.func_219967_s());
            if (itemeffects == null) {
                return false;
            }
            itemeffects.clear();
            itemeffects.add((Pair<Supplier<EffectInstance>, Float>)Pair.of(() -> to, (Object)Float.valueOf(chance)));
        }
        return true;
    }

    public static final void applyPotionEffect(LivingEntity victim, Effect effect, int duration_secs, int amplifier) {
        if (effect.func_76403_b() && duration_secs <= 0) {
            effect.func_180793_a(null, null, victim, amplifier, 1.0);
        } else {
            Potions.addPotionEffect(victim, effect, duration_secs, amplifier);
        }
    }

    public static final void applyEffect(@Nonnull EffectInstance effect, @Nonnull LivingEntity victim) {
        if (effect.func_188419_a().func_76403_b() && effect.func_188419_a() != SharedGlue.Potion_saturation) {
            effect.func_188419_a().func_180793_a(null, null, victim, effect.func_76458_c(), 1.0);
        } else {
            victim.func_195064_c(Potions.copyPotionEffect(effect));
        }
    }

    public static final void addPotionEffects(@Nonnull LivingEntity victim, @Nonnull Potion potion) {
        for (EffectInstance e : potion.func_185170_a()) {
            Potions.applyEffect(e, victim);
        }
    }

    public static final void addPotionEffects(@Nonnull LivingEntity victim, @Nonnull ItemStack potion_source) {
        List<EffectInstance> effects = Potions.getEffects(potion_source, false);
        for (EffectInstance e : effects) {
            Potions.applyEffect(e, victim);
        }
    }

    public static final void addPotionEffect(LivingEntity victim, Effect effect, int duration_secs, int amplifier, Object ... cures) {
        EffectInstance potioneffect = Potions.newPotionEffect(effect, SharedGlue.ticksFromSeconds(duration_secs), amplifier);
        if (cures != null) {
            for (Object cure : cures) {
                potioneffect.addCurativeItem(cure instanceof ItemStack ? (ItemStack)cure : ItemStacks.create((Item)cure));
            }
        }
        victim.func_195064_c(potioneffect);
    }

    public static final void addStubbornPotionEffect(LivingEntity entity, Effect effect, int duration_secs, int amplifier, boolean ambient, boolean particles) {
        entity.func_195064_c(Potions.newStubbornPotionEffect(effect, SharedGlue.ticksFromSeconds(duration_secs), amplifier, ambient, particles));
    }

    public static final void addStubbornPotionEffect(LivingEntity entity, Effect effect, int duration_secs, int amplifier, Object ... cures) {
        EffectInstance potioneffect = Potions.newStubbornPotionEffect(effect, SharedGlue.ticksFromSeconds(duration_secs), amplifier, false, false);
        if (cures != null) {
            for (Object cure : cures) {
                potioneffect.addCurativeItem(cure instanceof ItemStack ? (ItemStack)cure : ItemStacks.create((Item)cure));
            }
        }
        entity.func_195064_c(potioneffect);
    }

    public static final void addStubbornPotionEffects(@Nonnull LivingEntity victim, @Nonnull ItemStack potion_source) {
        List effects = Potions.getEffects(potion_source, false).stream().map(e -> StubbornPotionEffect.fortifed_from(e)).collect(Collectors.toList());
        for (EffectInstance e2 : effects) {
            Potions.applyEffect(e2, victim);
        }
    }

    public static final void addFortifiedPotionEffect(LivingEntity entity, Effect effect, int duration_secs, int amplifier, boolean ambient, boolean particles) {
        entity.func_195064_c(Potions.newFortifiedPotionEffect(effect, SharedGlue.ticksFromSeconds(duration_secs), amplifier, ambient, particles));
    }

    public static final void addMagniferPotionEffect(LivingEntity entity, Effect effect, int duration_secs, int amplifier, boolean ambient, boolean particles) {
        MagnifyingPotionEffect e = new MagnifyingPotionEffect(false, effect, SharedGlue.ticksFromSeconds(duration_secs), amplifier, ambient, particles);
        entity.func_195064_c((EffectInstance)e);
    }

    public static final boolean isMilk(ItemStack stack, boolean modded) {
        Item item;
        Item item2 = item = !ItemStacks.isEmpty(stack) ? stack.func_77973_b() : null;
        if (item != null) {
            UseAction useaction;
            if (item == Items.field_151117_aB) {
                return true;
            }
            FluidStack fluidstack = Fluids.getBucketFluid(stack);
            if (fluidstack.isEmpty()) {
                fluidstack = (FluidStack)FluidUtil.getFluidContained((ItemStack)stack).orElse((Object)FluidStack.EMPTY);
            }
            if (!fluidstack.isEmpty()) {
                String fluidName = Fluids.name(fluidstack.getFluid());
                if (Fluids.isMilkLike(fluidName)) {
                    if (ModIntegration.isUniversalBucket(stack)) {
                        return true;
                    }
                    UseAction useaction2 = stack.func_77975_n();
                    if (useaction2 == UseAction.DRINK || useaction2 == UseAction.EAT) {
                        return true;
                    }
                } else if (modded && (fluidName.startsWith("milk_") || fluidName.endsWith("_milk"))) {
                    return true;
                }
            } else if (modded && ((useaction = stack.func_77975_n()) == UseAction.DRINK || useaction == UseAction.EAT)) {
                return ModIntegration.isCustomMilkBottle(stack);
            }
        }
        return false;
    }

    public static final EffectType getEffectType(Effect effect) {
        return effect != null ? effect.func_220303_e() : EffectType.NEUTRAL;
    }

    static final boolean isReallyNeutral(Effect effect) {
        return effect == NO_EFFECT || effect instanceof IPlacebo;
    }

    public static final boolean isHarmful(@Nonnull Effect effect, boolean neutralIsBad) {
        EffectType et = Potions.getEffectType(effect);
        return et == EffectType.NEUTRAL && !Potions.isReallyNeutral(effect) ? neutralIsBad : et == EffectType.HARMFUL;
    }

    public static final boolean isCurative(@Nonnull PlayerEntity player, ItemStack item) {
        return Potions.isCurative(player, item, false);
    }

    public static final boolean isCurative(@Nonnull PlayerEntity player, ItemStack item, boolean general) {
        if (!ItemStacks.isEmpty(item)) {
            if (general && item.func_77973_b() instanceof ICurative) {
                return true;
            }
            for (EffectInstance potioneffect : player.func_70651_bq()) {
                if (!potioneffect.isCurativeItem(item)) continue;
                return true;
            }
        }
        return false;
    }

    public static final void addMilkBasedRegenEffect(Item food, int duration, int amplifier) {
        Potions.addPotionEffect(food, SharedGlue.Potion_regeneration, duration, amplifier, 1.0f);
    }

    public static final void addMilkBasedRegenEffect(Item food) {
        Potions.addMilkBasedRegenEffect(food, 15, 2);
    }

    public static final void addMilkBoostRegenEffect(@Nullable LivingEntity entity) {
        if (entity != null) {
            Potions.addPotionEffect(entity, SharedGlue.Potion_regeneration, 15, 1);
        }
    }

    public static final void removeAllEffects(@Nullable LivingEntity entity) {
        if (entity != null && entity.func_70089_S()) {
            ArrayList all = new ArrayList(entity.func_70651_bq());
            for (EffectInstance goodOrBad : all) {
                entity.func_195063_d(goodOrBad.func_188419_a());
            }
        }
    }

    public static final boolean isEffectivelyBad(EffectInstance effect, @Nullable LivingEntity entity) {
        Effect potion = effect.func_188419_a();
        boolean is = Potions.isHarmful(potion, false);
        if (!is) {
            boolean inversed;
            boolean bl = inversed = effect.func_76458_c() < 0;
            if (inversed && (potion == SharedGlue.Potion_healthBoost || potion == SharedGlue.Potion_moveSpeed || potion == SharedGlue.Potion_resistance || potion == SharedGlue.Potion_jump || potion == SharedGlue.Potion_digSpeed || potion == SharedGlue.Potion_slowfall)) {
                is = true;
            }
        }
        if (NPE.isa((Entity)entity) && entity.func_70662_br()) {
            if (potion == net.minecraft.potion.Effects.field_76433_i) {
                is = false;
            } else if (potion == net.minecraft.potion.Effects.field_76432_h) {
                is = true;
            }
        }
        return is;
    }

    public static final boolean isEffectivelyBad(EffectInstance effect) {
        return Potions.isEffectivelyBad(effect, null);
    }

    public static final boolean hasAtLeastOneNegativeEffect(@Nullable PlayerEntity player) {
        if (player != null) {
            Collection effects = player.func_70651_bq();
            for (EffectInstance effect : effects) {
                if (!Potions.isEffectivelyBad(effect)) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean cureAllBadEffects(@Nullable LivingEntity entity) {
        int affected = 0;
        if (entity != null) {
            Collection effects = entity.func_70651_bq();
            ArrayList<Effect> remove = null;
            for (EffectInstance effect : effects) {
                if (!Potions.isEffectivelyBad(effect, entity)) continue;
                if (remove == null) {
                    remove = new ArrayList<Effect>();
                }
                remove.add(effect.func_188419_a());
            }
            if (remove != null) {
                for (Effect badpotion : remove) {
                    Potions.removePotionEffectUnconditionally(entity, badpotion);
                    if (entity.func_70660_b(badpotion) != null) continue;
                    ++affected;
                }
            }
        }
        return affected > 0;
    }

    public static final boolean removeAllHelpfulEffects(@Nullable LivingEntity entity) {
        int affected = 0;
        if (entity != null) {
            Collection effects = entity.func_70651_bq();
            ArrayList<Effect> remove = null;
            for (EffectInstance effect : effects) {
                if (Potions.isEffectivelyBad(effect, entity)) continue;
                if (remove == null) {
                    remove = new ArrayList<Effect>();
                }
                remove.add(effect.func_188419_a());
            }
            if (remove != null) {
                for (Effect goodpotion : remove) {
                    Potions.removePotionEffectUnconditionally(entity, goodpotion);
                    if (entity.func_70660_b(goodpotion) != null) continue;
                    ++affected;
                }
            }
        }
        return affected > 0;
    }

    public static final boolean removeOneHelpfulEffect(@Nullable LivingEntity entity) {
        if (entity != null) {
            Collection effects = entity.func_70651_bq();
            if (effects.isEmpty()) {
                return false;
            }
            ArrayList<Effect> remove = null;
            for (EffectInstance effect : effects) {
                if (Potions.isEffectivelyBad(effect, entity)) continue;
                if (remove == null) {
                    remove = new ArrayList<Effect>();
                }
                remove.add(effect.func_188419_a());
            }
            if (remove != null) {
                Effect p;
                int i = 0;
                int M = Math.min(2, remove.size());
                do {
                    p = (Effect)remove.get(entity.func_70681_au().nextInt(remove.size()));
                    Potions.removePotionEffectUnconditionally(entity, p);
                } while (entity.func_70660_b(p) != null && ++i < M);
                return i < M;
            }
        }
        return false;
    }

    public static final boolean cureJumpFailImplEffect(@Nonnull LivingEntity entity, boolean forced) {
        boolean done = false;
        EffectInstance e = entity.func_70660_b(SharedGlue.Potion_jump);
        if (e != null && e.func_76458_c() < 0) {
            Potions._removeEffect(entity, SharedGlue.Potion_jump, forced);
            done = true;
        }
        return done;
    }

    public static final void cureBadPotionEffectsWithHoney(@Nullable LivingEntity entity, boolean forced, boolean boosted) {
        if (entity != null) {
            Potions._removeEffect(entity, SharedGlue.Potion_nausea, forced);
            Potions._removeEffect(entity, SharedGlue.Potion_poison, forced);
            Potions._removeEffect(entity, SharedGlue.Potion_hunger, forced);
            if (boosted) {
                Potions.cureJumpFailImplEffect(entity, forced);
                Potions.cureBadPotionEffectsWithMuscleBoost(entity, forced);
            }
        }
    }

    public static final void cureBadPotionEffectsWithMilk(@Nullable LivingEntity entity, boolean forced, boolean combatant, boolean muscle_boosted) {
        if (entity != null) {
            Potions._removeEffect(entity, SharedGlue.Potion_harm, forced);
            Potions._removeEffect(entity, SharedGlue.Potion_blindness, forced);
            Potions._removeEffect(entity, SharedGlue.Potion_nausea, forced);
            Potions._removeEffect(entity, SharedGlue.Potion_poison, forced);
            Potions._removeEffect(entity, SharedGlue.Potion_hunger, forced);
            Potions._removeEffect(entity, SharedGlue.Potion_badLuck, false);
            Potions.cureJumpFailImplEffect(entity, forced);
            if (combatant) {
                Potions._removeEffect(entity, SharedGlue.Potion_wither, forced);
                EffectInstance e = entity.func_70660_b(SharedGlue.Potion_resistance);
                if (e != null && e.func_76458_c() < 0) {
                    Potions._removeEffect(entity, SharedGlue.Potion_resistance, forced);
                }
            }
            if (muscle_boosted) {
                Potions.cureBadPotionEffectsWithMuscleBoost(entity, forced);
            }
        }
    }

    public static final void cureBadPotionEffectsWithMilkBucket(@Nullable LivingEntity entity) {
        if (entity != null) {
            Potions.cureAllBadEffects(entity);
            Potions.addPotionEffect(entity, SharedGlue.Potion_regeneration, 10, 2, false, false);
        }
    }

    public static final void cureBadPotionEffectsWithMuscleBoost(LivingEntity entity, boolean forced) {
        if (entity != null) {
            Potions._removeEffect(entity, SharedGlue.Potion_weakness, forced);
            Potions._removeEffect(entity, SharedGlue.Potion_moveSlowdown, forced);
            Potions._removeEffect(entity, SharedGlue.Potion_digSlowdown, forced);
            Potions.cureJumpFailImplEffect(entity, forced);
        }
    }

    public static final void addMuscleBoostPotionEffect(LivingEntity entity, int duration_mins) {
        if (entity != null) {
            if (duration_mins <= 0) {
                duration_mins = 2;
            }
            int duration = 60 * duration_mins;
            Potions.addPotionEffect(entity, SharedGlue.Potion_absorption, duration, 1, false, false);
            Potions.addPotionEffect(entity, SharedGlue.Potion_strength, duration, 1, false, false);
            Potions.addPotionEffect(entity, SharedGlue.Potion_resistance, duration, 1, false, false);
        }
    }

    public static final void onMuscleFoodEaten(LivingEntity entity, int duration_mins) {
        Potions.cureBadPotionEffectsWithMuscleBoost(entity, true);
        Potions.addMuscleBoostPotionEffect(entity, duration_mins);
    }

    public static final void cureBadPotionEffectsWithSmellingSalts(@Nullable LivingEntity entity) {
        if (SharedGlue.hasPotionsInEffect(entity)) {
            Potions._removeEffect(entity, SharedGlue.Potion_blindness, true);
            Potions._removeEffect(entity, SharedGlue.Potion_nausea, true);
            Potions._removeEffect(entity, SharedGlue.Potion_hunger, true);
            Potions.cureJumpFailImplEffect(entity, true);
            Potions.cureBadPotionEffectsWithMuscleBoost(entity, true);
        }
    }

    public static final ItemStack newTippedArrow(Potion type) {
        ItemStack arrow = new ItemStack((IItemProvider)Items.field_185167_i);
        return PotionUtils.func_185188_a((ItemStack)arrow, (Potion)type);
    }

    public static final void cure(@Nonnull LivingEntity entity, @Nonnull ModIntegration mod, @Nonnull String effect_name) {
        Effect e = mod.potion(effect_name);
        if (e != null) {
            Potions.removePotionEffectUnconditionally(entity, e);
        }
    }

    public static final void cureChokingEffects(PlayerEntity player) {
        Potions.cure((LivingEntity)player, ModIntegration.GRAVESTONE_EXT, "gs_choke_potion");
    }

    public static final void cureFireBurningEffects(@Nonnull PlayerEntity player, boolean immediate) {
        if (SharedGlue.hasPotionsInEffect((LivingEntity)player)) {
            Potions.cure((LivingEntity)player, ModIntegration.POTION_CORE, "fire");
            Potions.cure((LivingEntity)player, ModIntegration.LYCANITES_MOBS, "smouldering");
            Potions.cure((LivingEntity)player, ModIntegration.GRAVESTONE_EXT, "gs_burning_potion");
            Potions.cure((LivingEntity)player, ModIntegration.GRAVESTONE_EXT, "gs_inferno_potion");
            Potions.cure((LivingEntity)player, ModIntegration.EXTRA_ALCHEMY, "effect.combustion");
            Potions.cure((LivingEntity)player, ModIntegration.PRIMAL, "sun_burn");
        }
        if (immediate && player.func_70027_ad()) {
            player.func_70066_B();
            Effects.playExtinguishedBurning(player.func_130014_f_(), player);
        }
    }

    public static final void cureFreezingEffects(@Nonnull PlayerEntity player, boolean immediate) {
        if (SharedGlue.hasPotionsInEffect((LivingEntity)player)) {
            Potions.cure((LivingEntity)player, ModIntegration.PRIMAL, "water_burn");
            Potions.cure((LivingEntity)player, ModIntegration.ELECTROBLOB_WIZARDRY, "frost");
            Potions.cure((LivingEntity)player, ModIntegration.NETHER_EX, "freeze");
            Potions.cure((LivingEntity)player, ModIntegration.NETHER_EX, "frostbite");
            Potions.cure((LivingEntity)player, ModIntegration.SILENT_GEMS, "freezing");
            Potions.cure((LivingEntity)player, ModIntegration.LYCANITES_MOBS, "paralysis");
            Potions.cure((LivingEntity)player, ModIntegration.EXTRA_ALCHEMY, "freezing");
        }
    }

    public static final void cureBleedingEffects(@Nonnull PlayerEntity player, boolean immediate) {
        if (SharedGlue.hasPotionsInEffect((LivingEntity)player)) {
            Potions.cure((LivingEntity)player, ModIntegration.LYCANITES_MOBS, "bleed");
            if (ModIntegration.isPresent("bloodarsenal")) {
                // empty if block
            }
        }
    }

    public static final boolean hasCustomElixirEffects(@Nonnull ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_150297_b(_CUSTOM_ELIXIR_EFFECTS_TAGNAME, 9);
    }

    static final List<EffectInstance> mergeCustomElixirEffects(@Nonnull CompoundNBT from, @Nullable List<EffectInstance> effects) {
        if (effects == null) {
            effects = new ArrayList<EffectInstance>();
        }
        if (from.func_150297_b(_CUSTOM_ELIXIR_EFFECTS_TAGNAME, 9)) {
            ListNBT tagList = from.func_150295_c(_CUSTOM_ELIXIR_EFFECTS_TAGNAME, 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundNBT effectData = tagList.func_150305_b(i);
                ResourceLocation effectName = new ResourceLocation(effectData.func_74779_i("Effect"));
                Effect potion = (Effect)ForgeRegistries.POTIONS.getValue(effectName);
                if (potion == null) continue;
                int duration = effectData.func_74762_e("Duration");
                int amplifier = effectData.func_74762_e("Amplifier");
                if (duration <= 0 && (duration != 0 || !potion.func_76403_b())) continue;
                effects.add(new EffectInstance(potion, duration, amplifier));
            }
        }
        return effects;
    }

    public static final List<EffectInstance> getEffects(@Nonnull ItemStack stack, boolean any) {
        List effects = PotionUtils.func_185189_a((ItemStack)stack);
        if (any && Potions.hasCustomElixirEffects(stack)) {
            Potions.mergeCustomElixirEffects(stack.func_77978_p(), effects);
        }
        return effects;
    }

    public static final boolean matches(@Nonnull ItemStack stack, Potion ingredient, boolean any) {
        if (Potions.isReal(ingredient)) {
            List<EffectInstance> have = Potions.getEffects(stack, any);
            List want = ingredient.func_185170_a();
            if (have.size() == want.size()) {
                if (want.size() == 1) {
                    return ((EffectInstance)want.get(0)).equals((Object)have.get(0));
                }
                for (EffectInstance e : want) {
                    if (have.contains(e)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static final void addCustomEffects(@Nonnull CompoundNBT to, boolean replace, @Nullable Collection<EffectInstance> effects) {
        if (replace) {
            to.func_82580_o(SharedGlue.CUSTOM_POTION_EFFECTS_TAGNAME());
        }
        if (effects != null && !effects.isEmpty()) {
            ListNBT eList = to.func_150295_c(SharedGlue.CUSTOM_POTION_EFFECTS_TAGNAME(), 10);
            for (EffectInstance effect : effects) {
                eList.add((Object)effect.func_82719_a(new CompoundNBT()));
            }
            to.func_218657_a(SharedGlue.CUSTOM_POTION_EFFECTS_TAGNAME(), (INBT)eList);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static final void trackAttributeModifiers(EffectInstance effect, List<Tuple<String, AttributeModifier>> local_copies) {
        Effect potion = effect.func_188419_a();
        Map map = potion.func_111186_k();
        if (!map.isEmpty()) {
            for (Map.Entry iattrib : map.entrySet()) {
                AttributeModifier modifier = (AttributeModifier)iattrib.getValue();
                AttributeModifier local_copy = new AttributeModifier(modifier.func_111166_b(), potion.func_111183_a(effect.func_76458_c(), modifier), modifier.func_220375_c());
                local_copies.add((Tuple<String, AttributeModifier>)new Tuple((Object)((IAttribute)iattrib.getKey()).func_111108_a(), (Object)local_copy));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static final void addModifierInformation(List<Tuple<String, AttributeModifier>> attribs, List<ITextComponent> tooltip) {
        tooltip.add(Tooltips.NL());
        tooltip.add(new TranslationTextComponent("potion.whenDrank", new Object[0]).func_211708_a(TextFormatting.DARK_PURPLE));
        for (Tuple<String, AttributeModifier> tuple : attribs) {
            AttributeModifier modifier = (AttributeModifier)tuple.func_76340_b();
            double amount = modifier.func_111164_d();
            int op = modifier.func_220375_c().func_220371_a();
            double value = op != SharedGlue.OP_MUL_BASE_ATTR && op != SharedGlue.OP_MUL_TOTAL_ATTR ? modifier.func_111164_d() : modifier.func_111164_d() * 100.0;
            if (amount > 0.0) {
                tooltip.add(new TranslationTextComponent("attribute.modifier.plus." + op, new Object[]{ItemStack.field_111284_a.format(value), new TranslationTextComponent("attribute.name." + (String)tuple.func_76341_a(), new Object[0])}).func_211708_a(TextFormatting.BLUE));
                continue;
            }
            if (!(amount < 0.0)) continue;
            tooltip.add(new TranslationTextComponent("attribute.modifier.take." + op, new Object[]{ItemStack.field_111284_a.format(value *= -1.0), new TranslationTextComponent("attribute.name." + (String)tuple.func_76341_a(), new Object[0])}).func_211708_a(TextFormatting.RED));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final void addPotionInformation(@Nonnull Collection<EffectInstance> effects, @Nonnull List<ITextComponent> tooltip, int durationOverride, boolean full, boolean indent) {
        String _PS;
        ArrayList<Tuple<String, AttributeModifier>> attribs = null;
        String string = _PS = indent ? " " : "";
        if (full) {
            if (effects.isEmpty()) {
                ITextComponent displayString = new StringTextComponent(_PS).func_150257_a(new TranslationTextComponent("effect.none", new Object[0]).func_211708_a(TextFormatting.GRAY));
                tooltip.add(displayString);
                return;
            }
            attribs = new ArrayList<Tuple<String, AttributeModifier>>();
        }
        for (EffectInstance effect : effects) {
            if (full) {
                Potions.trackAttributeModifiers(effect, attribs);
            }
            boolean bad = Potions.isEffectivelyBad(effect);
            ITextComponent displayString = new StringTextComponent(_PS).func_150257_a((ITextComponent)new TranslationTextComponent(effect.func_76453_d(), new Object[0]));
            if (effect.func_76458_c() != 0) {
                displayString = displayString.func_150257_a(Tooltips.SP1()).func_150257_a((ITextComponent)new TranslationTextComponent("potion.potency." + Math.abs(effect.func_76458_c()), new Object[0]));
            }
            if (effect.func_76459_b() > SharedGlue.SECS_TO_TICKS_DURATION_MULTIPLIER()) {
                if (durationOverride > 0) {
                    effect = new EffectInstance(effect.func_188419_a(), durationOverride);
                }
                String durationstring = " (" + EffectUtils.func_188410_a((EffectInstance)effect, (float)1.0f) + ")";
                displayString = displayString.func_150257_a((ITextComponent)new StringTextComponent(durationstring));
            }
            tooltip.add(displayString.func_211708_a(bad ? TextFormatting.RED : TextFormatting.BLUE));
        }
        if (full && attribs != null && !attribs.isEmpty()) {
            Potions.addModifierInformation(attribs, tooltip);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final void addPotionInformation(@Nonnull Collection<EffectInstance> effects, @Nonnull List<ITextComponent> tooltip) {
        Potions.addPotionInformation(effects, tooltip, -1, false, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final void addPotionInformation(@Nonnull Collection<EffectInstance> effects, @Nonnull List<ITextComponent> tooltip, boolean full) {
        Potions.addPotionInformation(effects, tooltip, -1, full, false);
    }

    private static final boolean isdefined(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        Potion type = PotionUtils.func_185187_c((CompoundNBT)stack.func_77978_p());
        return type != null && type != SharedGlue.PotionType_empty || stack.func_77978_p().func_150297_b(SharedGlue.CUSTOM_POTION_EFFECTS_TAGNAME(), 9) || Potions.hasCustomElixirEffects(stack);
    }

    public static final boolean isa(@Nullable ItemStack stack, boolean any) {
        boolean is = false;
        if (!ItemStacks.isEmpty(stack)) {
            Item item = stack.func_77973_b();
            if (item != Items.field_151068_bn && !any) {
                item = null;
            }
            is = item != null && Potions.isdefined(stack);
        }
        return is;
    }

    public static final boolean isap(@Nullable ItemStack stack, boolean any) {
        boolean is = false;
        if (!ItemStacks.isEmpty(stack)) {
            Item item = stack.func_77973_b();
            if (!(item == Items.field_151068_bn || item == Items.field_185155_bH || item == Items.field_185156_bI || any && RID.matches(stack, "carrots:potion_bottles"))) {
                item = null;
            }
            is = item != null && Potions.isdefined(stack);
        }
        return is;
    }

    public static final void eraseDefinition(CompoundNBT from) {
        if (from != null) {
            from.func_82580_o("Potion");
            from.func_82580_o(SharedGlue.CUSTOM_POTION_EFFECTS_TAGNAME());
            from.func_82580_o(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME());
        }
    }

    public static final void eraseDefinition(ItemStack stack) {
        if (!ItemStacks.isEmpty(stack) && stack.func_77942_o()) {
            Potions.eraseDefinition(stack.func_77978_p());
        }
    }

    public static final boolean copyDefinition(CompoundNBT from, @Nonnull CompoundNBT to) {
        boolean copied = false;
        if (from != null && to != null) {
            int tagcount = 0;
            Potions.eraseDefinition(to);
            CompoundNBT data = from;
            if (data.func_74764_b("Potion")) {
                to.func_218657_a("Potion", data.func_74781_a("Potion").func_74737_b());
                ++tagcount;
            }
            if (data.func_74764_b(SharedGlue.CUSTOM_POTION_EFFECTS_TAGNAME())) {
                to.func_218657_a(SharedGlue.CUSTOM_POTION_EFFECTS_TAGNAME(), data.func_74781_a(SharedGlue.CUSTOM_POTION_EFFECTS_TAGNAME()).func_74737_b());
                ++tagcount;
            }
            boolean bl = copied = tagcount > 0;
            if (copied && data.func_150297_b(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME(), 99)) {
                to.func_218657_a(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME(), data.func_74781_a(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME()).func_74737_b());
            }
        }
        return copied;
    }

    public static final boolean copyDefinition(ItemStack from, @Nonnull ItemStack to) {
        boolean copied = false;
        if (Potions.isa(from, true)) {
            int color;
            Potions.eraseDefinition(to);
            CompoundNBT data = from.func_77978_p();
            boolean is_registered = data.func_74764_b("Potion");
            if (is_registered) {
                to.func_77983_a("Potion", data.func_74781_a("Potion").func_74737_b());
            }
            if (data.func_74764_b(SharedGlue.CUSTOM_POTION_EFFECTS_TAGNAME())) {
                to.func_77983_a(SharedGlue.CUSTOM_POTION_EFFECTS_TAGNAME(), data.func_74781_a(SharedGlue.CUSTOM_POTION_EFFECTS_TAGNAME()).func_74737_b());
            }
            if (data.func_150297_b(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME(), 99)) {
                to.func_77983_a(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME(), data.func_74781_a(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME()).func_74737_b());
            } else if (!is_registered && to.func_77973_b() instanceof TippedArrowItem && (color = PotionUtils.func_185181_a(Potions.getEffects(from, false))) != 3694022) {
                to.func_77983_a(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME(), (INBT)IntNBT.func_229692_a_((int)color));
            }
            copied = true;
        }
        return copied;
    }

    public static final void copyDefinition(@Nonnull ItemStack to, @Nonnull Collection<EffectInstance> effects, @Nullable Integer customColor) {
        Potions.eraseDefinition(to);
        Potions.addCustomEffects(ItemStacks.getOrCreateData(to), false, effects);
        if (customColor != null) {
            to.func_77983_a(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME(), (INBT)IntNBT.func_229692_a_((int)customColor));
        }
    }

    public static final boolean isReal(@Nullable Potion type) {
        return type == null ? false : type != SharedGlue.PotionType_empty && type != SharedGlue.PotionType_water && type != SharedGlue.PotionType_harmless && !type.func_185170_a().isEmpty();
    }

    @Nullable
    private static final String getCustomUnlocalizedName(ItemStack stack) {
        String name = null;
        if (ItemStacks.hasData(stack, SharedGlue.CUSTOM_POTION_UNLOCALIZED_TAGNAME(), 8)) {
            name = ItemStacks.getString(stack, SharedGlue.CUSTOM_POTION_UNLOCALIZED_TAGNAME());
        }
        return name;
    }

    @Nullable
    public static final ITextComponent getTypeDisplayNameOrNull(@Nonnull ItemStack stack) {
        ITextComponent displayName = null;
        String name = Potions.getCustomUnlocalizedName(stack);
        if (name != null) {
            displayName = new TranslationTextComponent(name, new Object[0]).func_150257_a((ITextComponent)new StringTextComponent("*"));
        } else {
            Potion type = PotionUtils.func_185191_c((ItemStack)stack);
            if (Potions.isReal(type)) {
                displayName = new TranslationTextComponent(type.func_185174_b(_DEFAULT_MINECRAFT_PREFIX), new Object[0]);
            }
        }
        return displayName;
    }

    @Nullable
    public static final String getTypeTranslationKeyOrNull(@Nonnull ItemStack stack, String prefix) {
        String lookup = null;
        Potion type = PotionUtils.func_185191_c((ItemStack)stack);
        if (type == SharedGlue.PotionType_empty) {
            lookup = Potions.getCustomUnlocalizedName(stack);
        } else if (Potions.isReal(type)) {
            if (prefix == null) {
                prefix = "";
            }
            if (!Strings.hasTranslation(lookup = type.func_185174_b(prefix))) {
                lookup = null;
            }
        }
        return lookup;
    }

    @Nullable
    public static final Integer getColorOrNull(ItemStack stack, @Nonnull Collection<EffectInstance> effects) {
        CompoundNBT data;
        Integer color_num = null;
        if (ItemStacks.hasData(stack) && (data = stack.func_77978_p()).func_150297_b(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME(), 99)) {
            color_num = data.func_74762_e(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME());
        }
        if (color_num == null && !effects.isEmpty()) {
            color_num = PotionUtils.func_185181_a(effects);
        }
        return color_num;
    }

    @Nullable
    public static final Integer getColorOrNull(ItemStack stack) {
        Integer color_num = null;
        if (ItemStacks.hasData(stack)) {
            CompoundNBT data = stack.func_77978_p();
            color_num = data.func_150297_b(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME(), 99) ? Integer.valueOf(data.func_74762_e(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME())) : Integer.valueOf(PotionUtils.func_185181_a((Collection)PotionUtils.func_185189_a((ItemStack)stack)));
        }
        return color_num;
    }

    public static final int getColor(@Nullable Potion potion) {
        return PotionUtils.func_185183_a((Potion)(potion == null ? SharedGlue.PotionType_harmless : potion));
    }

    static final void initAmendmentSupport() {
        try {
            Method m = LivingEntity.class.getDeclaredMethod(ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.METHOD, (String)"func_70688_c"), EffectInstance.class);
            m.setAccessible(true);
            _ON_FINISHED_POTION_EFFECT = m;
            LibInfo.LOG.info("Potion effect neutralizer hook initialized successfully!");
        }
        catch (Throwable igX) {
            LibInfo.LOG.warn("Unable to initialize potion effect neutralizer hook! ({})", (Object)ExceptionUtils.getRootCauseMessage((Throwable)igX));
        }
        try {
            _FOOD_POTION_EFFECTS = ObfuscationReflectionHelper.findField(Food.class, (String)"field_221475_f");
        }
        catch (Throwable igX) {
            LibInfo.LOG.warn("Unable to obtain potion effects list hook! ({})", (Object)ExceptionUtils.getRootCauseMessage((Throwable)igX));
        }
    }

    static final void initFinalize() {
        if (LibConfig.allowUncurablePotionEffects()) {
            MinecraftForge.EVENT_BUS.register((Object)new EventsListener());
        }
    }

    static final void onFinishedPotionEffect(@Nonnull LivingEntity entity, EffectInstance effect) {
        if (_ON_FINISHED_POTION_EFFECT != null) {
            try {
                _ON_FINISHED_POTION_EFFECT.invoke((Object)entity, effect);
            }
            catch (Throwable igX) {
                LibInfo.LOG.warn("Unable to notify potion effect {} finished for entity {}", (Object)effect.func_76453_d(), (Object)entity.func_189512_bd());
            }
        }
    }

    @Nullable
    private static final List<Pair<Supplier<EffectInstance>, Float>> effectsFor(Food food) {
        if (_FOOD_POTION_EFFECTS != null) {
            try {
                return (List)List.class.cast(_FOOD_POTION_EFFECTS.get(food));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    protected Potions() {
    }

    public static final class EventsListener {
        EventsListener() {
        }

        @SubscribeEvent(priority=EventPriority.LOW)
        public final void onTryRemoveStubbornPotion(PotionEvent.PotionRemoveEvent event) {
            StubbornPotionEffect.onTryRemove(event);
        }
    }

    public static interface IPlacebo {
    }
}

