/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.EmptyFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IModItem;
import org.jwaresoftware.mcmods.lib.impl.TagSupport;

public final class RID {
    public static final String nullProxy = "carrots:null";
    public static final String adhesiveBlock = "carrots:adhesive_blocks";
    public static final String anyArrow = "minecraft:arrows";
    public static final String anyBone = "bones";
    public static final String anyBook = "books";
    public static final String anyChest = "chests";
    public static final String anyColorlessGlass = "carrots:colorless_glass";
    public static final String anyDirt = "dirt";
    public static final String anyDye = "dyes";
    public static final String anyEgg = "eggs";
    public static final String anyFeather = "feathers";
    public static final String anyGlass = "carrots:glass";
    public static final String anyOreBlock = "ores";
    public static final String anyPaper = "paper";
    public static final String anyHead = "carrots:heads";
    public static final String anyString = "strings";
    public static final String anyStone = "stone";
    public static final String anyVine = "vines";
    public static final String blazepowder = "dusts/blaze";
    public static final String bonemeal = "bonemeals";
    public static final String cactusBlock = "cactus";
    public static final String clayball = "ingots/clay";
    public static final String coalBlock = "storage_blocks/coal";
    public static final String cobblestone = "cobblestone";
    public static final String darkprismarineBlock = "prismarine/dark";
    public static final String diamond = "gems/diamond";
    public static final String diamondBlock = "storage_blocks/diamonds";
    public static final String diamondNugget = "nuggets/diamond";
    public static final String dirtDust = "dusts/dirt";
    public static final String emerald = "gems/emerald";
    public static final String emeraldBlock = "storage_blocks/emerald";
    public static final String emeraldNugget = "nuggets/emerald";
    public static final String emptyBottle = "empty_bottles";
    public static final String emptyBowl = "bowls";
    public static final String emptyBucket = "buckets/empty/iron";
    public static final String emptyIronBucket = "buckets/empty/iron";
    public static final String emptyJar = "carrots:empty_jars";
    public static final String enderpearl = "enderpearls";
    public static final String xpBucket = "buckets/experience";
    public static final String flint = "flint";
    public static final String gelatinBlock = "storage_blocks/gelatin";
    public static final String glowstoneDust = "dusts/glowstone";
    public static final String goldIngot = "ingots/gold";
    public static final String goldNugget = "nuggets/gold";
    public static final String goldBlock = "storage_blocks/gold";
    public static final String gravel = "gravel";
    public static final String gunpowder = "dusts/gunpowder";
    public static final String ironBlock = "storage_blocks/iron";
    public static final String ironIngot = "ingots/iron";
    public static final String ironNugget = "nuggets/iron";
    public static final String lapis = "gems/lapis";
    public static final String lapisBlock = "storage_blocks/lapis";
    public static final String lapisNugget = "nuggets/lapis";
    public static final String lavaBucket = "buckets/lava";
    public static final String lavaDust = "dusts/lava";
    public static final String lavaFluid = "minecraft:lava";
    public static final String lifeEssence = "carrots:life_essences";
    public static final String lifeRebirth = "carrots:rebirth_essences";
    public static final String looseEmptyBucket = "buckets/empty";
    public static final String mendingTwine = "carrots:ties/mending";
    public static final String milkBucket = "buckets/milk";
    public static final String netherrack = "netherrack";
    public static final String obsidian = "obsidian";
    public static final String ore = "ores";
    public static final String paper = "paper";
    public static final String pinkWool = "wool/pink";
    public static final String portionHide = "carrots:portions_hide";
    public static final String prismarineBlock = "prismarine";
    public static final String potionBottle = "carrots:potion_bottles";
    public static final String quartz = "gems/quartz";
    public static final String quartzNugget = "nuggets/quartz";
    public static final String redstoneBlock = "storage_blocks/redstone";
    public static final String redstoneDust = "dusts/redstone";
    public static final String rock = "rocks";
    public static final String rottenflesh = "rotten_flesh";
    public static final String sand = "minecraft:sand";
    public static final String slimeball = "slime_balls";
    public static final String slimeBlock = "storage_blocks/slime_balls";
    public static final String slimeBucket = "buckets/slime";
    public static final String slimeNugget = "nuggets/slime";
    public static final String smallrock = "rocks/small";
    public static final String sponge = "carrots:portions_sponge";
    public static final String spongeBlock = "sponges";
    public static final String stone = "stone";
    public static final String stoneNugget = "nuggets/stone";
    public static final String stoneStick = "rods/stone";
    public static final String strongTie = "carrots:ties/strong";
    public static final String tipped_arrow = "carrots:arrows/tipped";
    public static final String treeLeaves = "minecraft:leaves";
    public static final String treeSapling = "minecraft:saplings";
    public static final String waterBottle = "water_bottles";
    public static final String waterBucket = "buckets/water";
    public static final String waterFluid = "minecraft:water";
    public static final String waterTreatment = "carrots:water_treatments";
    public static final String wheatCrop = "crops/wheat";
    public static final String witherBone = "bones/wither";
    public static final String woodBowl = "bowls/wooden";
    public static final String woodChest = "chests/wooden";
    public static final String woodFence = "fences/wooden";
    public static final String woodLog = "minecraft:logs";
    public static final String woodPlank = "minecraft:planks";
    public static final String woodSlab = "minecraft:slabs";
    public static final String woodStick = "rods/wooden";
    public static final String woolBlock = "minecraft:wool";
    private static boolean _DEFAULTS_INITED = false;

    static final ResourceLocation _r(String tag) {
        int i = tag.indexOf(58);
        if (i < 0) {
            tag = "forge:" + tag;
        } else if (i == 0) {
            tag = "forge" + tag;
        }
        return new ResourceLocation(tag);
    }

    static final ItemStack _i(Item item) {
        if (item instanceof IModItem) {
            return ((IModItem)item).createInstance(item);
        }
        return new ItemStack((IItemProvider)item);
    }

    public static final String _s(String tag) {
        return RID._r(tag).toString();
    }

    @Nullable
    public static final ResourceLocation r(String tag) {
        if (tag == null) {
            return null;
        }
        int i = tag.indexOf(58);
        if (i < 0) {
            tag = "forge:" + tag;
        } else if (i == 0) {
            tag = "forge" + tag;
        }
        return ResourceLocation.func_208304_a((String)tag);
    }

    public static final Tag<Item> itemTagsOrEmpty(ResourceLocation r) {
        Tag<Item> t = ItemTags.func_199903_a().func_199910_a(r);
        return t != null ? t : Tags.NO_ITEMS;
    }

    public static final Tag<Block> blockTagsOrEmpty(ResourceLocation r) {
        Tag<Block> t = BlockTags.func_199896_a().func_199910_a(r);
        return t != null ? t : Tags.NO_BLOKS;
    }

    public static final void addToGroup(String tag, Item item) {
        if (SharedGlue.isDefined(item)) {
            TagSupport.item(RID._r(tag), item);
        }
    }

    public static final void addToGroup(String tag, Block block) {
        ResourceLocation r = RID._r(tag);
        TagSupport.block(r, block);
        Item item = block.func_199767_j();
        if (SharedGlue.isDefined(item)) {
            TagSupport.item(r, item);
        }
    }

    public static final void addToGroup(String tag, ItemStack stack) {
        if (!stack.func_190926_b()) {
            RID.addToGroup(tag, stack.func_77973_b());
        }
    }

    public static final boolean isGroupDefined(String tag) {
        return ItemTags.func_199903_a().func_199908_a().contains(RID._r(tag));
    }

    @Nonnull
    public static final Collection<Item> getItemsInGroup(String tag) {
        if (!RID.isGroupDefined(tag)) {
            return Collections.EMPTY_LIST;
        }
        ResourceLocation r = RID._r(tag);
        return new ArrayList<Item>(RID.itemTagsOrEmpty(r).func_199885_a());
    }

    @Nonnull
    public static final List<ItemStack> getAllInGroup(String tag) {
        if (!RID.isGroupDefined(tag)) {
            return Collections.EMPTY_LIST;
        }
        ResourceLocation r = RID._r(tag);
        ArrayList<ItemStack> all = new ArrayList<ItemStack>(11);
        for (Item item : RID.itemTagsOrEmpty(r).func_199885_a()) {
            all.add(RID._i(item));
        }
        return all;
    }

    @Nullable
    public static final Tag<Item> getTag(String tag) {
        return tag == null ? null : (Tag)ItemTags.func_199903_a().func_200039_c().get(RID.r(tag));
    }

    public static final boolean isIn(Item item, String tag) {
        Tag<Item> group = RID.getTag(tag);
        return group != null && item.func_206844_a(group);
    }

    @Nullable
    public static final Tag<Block> getBlockTag(String tag) {
        return tag == null ? null : (Tag)BlockTags.func_199896_a().func_200039_c().get(RID.r(tag));
    }

    public static final boolean isIn(Block block, String tag) {
        Tag<Block> group = RID.getBlockTag(tag);
        return group != null && block.func_203417_a(group);
    }

    @Nullable
    public static final Tag<Fluid> getFluidTag(String tag) {
        return tag == null ? null : (Tag)FluidTags.func_226157_a_().func_200039_c().get(RID.r(tag));
    }

    public static final boolean isIn(Fluid fluid, String tag) {
        Tag<Fluid> group = RID.getFluidTag(tag);
        return group != null && fluid.func_207185_a(group);
    }

    @Nullable
    public static final Tag<EntityType<?>> getEntityTypeTag(String tag) {
        return tag == null ? null : (Tag)EntityTypeTags.func_219762_a().func_200039_c().get(RID.r(tag));
    }

    public static final boolean isIn(EntityType<?> type, String tag) {
        Tag<EntityType<?>> group = RID.getEntityTypeTag(tag);
        return group != null && type.func_220341_a(group);
    }

    @Nonnull
    public static final ItemStack getFirst(String tag) {
        Iterator iterator;
        Tag all;
        Tag tag2 = all = tag == null ? null : (Tag)ItemTags.func_199903_a().func_200039_c().get(RID.r(tag));
        if (all != null && (iterator = all.func_199885_a().iterator()).hasNext()) {
            Item item = (Item)iterator.next();
            return RID._i(item);
        }
        return ItemStack.field_190927_a;
    }

    public static final boolean isIngredientDefined(String tag) {
        return !RID.getFirst(tag).func_190926_b();
    }

    public static final boolean isFluidDefined(String tag) {
        Tag<Fluid> all = RID.getFluidTag(tag);
        if (all != null) {
            for (Fluid f : all.func_199885_a()) {
                if (f == Fluids.field_204541_a || f instanceof EmptyFluid) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean matches(@Nonnull ItemStack target, @Nonnull ItemStack input, boolean strict) {
        return ItemStack.func_179545_c((ItemStack)input, (ItemStack)target);
    }

    public static final boolean matches(@Nullable ItemStack stack, @Nonnull String tag, @Nullable Item preference, boolean strict) {
        if (!ItemStacks.isEmpty(stack)) {
            Item item = stack.func_77973_b();
            if (item == preference) {
                return true;
            }
            if (tag.charAt(0) == '#') {
                tag = tag.substring(1);
            } else if (tag.contains(":")) {
                ResourceLocation r = new ResourceLocation(tag);
                Item item2 = preference = ForgeRegistries.ITEMS.containsKey(r) ? (Item)ForgeRegistries.ITEMS.getValue(r) : null;
                if (preference != null && item == preference) {
                    return true;
                }
            }
            if (RID.getItemsInGroup(tag).contains(item)) {
                return true;
            }
        }
        return false;
    }

    public static final boolean matches(ItemStack stack, @Nonnull String tag) {
        return RID.matches(stack, tag, null, false);
    }

    public static final boolean matches(ItemStack stack, @Nonnull String tag, @Nullable Item preference) {
        return RID.matches(stack, tag, preference, false);
    }

    public static final boolean matches(@Nullable ItemStack stack, @Nonnull ResourceLocation tag, @Nullable Item preference) {
        if (!ItemStacks.isEmpty(stack) && tag != null) {
            Item item = stack.func_77973_b();
            if (item == preference) {
                return true;
            }
            Tag tagcoll = ItemTags.func_199903_a().func_199910_a(tag);
            if (tagcoll != null && tagcoll.func_199885_a().contains(item)) {
                return true;
            }
        }
        return false;
    }

    public static final void tagsFinalize() {
        if (_DEFAULTS_INITED) {
            return;
        }
        RID.addToGroup(anyBone, Items.field_151103_aS);
        RID.addToGroup(anyString, Items.field_151007_F);
        RID.addToGroup(anyFeather, Items.field_151008_G);
        RID.addToGroup("paper", Items.field_151121_aF);
        RID.addToGroup(slimeball, Items.field_151123_aH);
        RID.addToGroup(gunpowder, Items.field_151016_H);
        RID.addToGroup(blazepowder, Items.field_151065_br);
        RID.addToGroup(bonemeal, Items.field_196106_bc);
        RID.addToGroup(clayball, Items.field_151119_aD);
        RID.addToGroup(flint, Items.field_151145_ak);
        RID.addToGroup(rottenflesh, Items.field_151078_bh);
        RID.addToGroup(emptyBowl, Items.field_151054_z);
        RID.addToGroup(woodBowl, Items.field_151054_z);
        RID.addToGroup(emptyBottle, Items.field_151069_bo);
        RID.addToGroup("buckets/empty/iron", Items.field_151133_ar);
        RID.addToGroup(lavaBucket, Items.field_151129_at);
        RID.addToGroup(lavaDust, Items.field_151065_br);
        RID.addToGroup(milkBucket, Items.field_151117_aB);
        RID.addToGroup(waterBucket, Items.field_151131_as);
        RID.addToGroup(adhesiveBlock, Blocks.field_180399_cE);
        RID.addToGroup(cactusBlock, Blocks.field_150434_aF);
        RID.addToGroup(spongeBlock, Blocks.field_150360_v);
        RID.addToGroup(sponge, Blocks.field_150360_v);
        RID.addToGroup(strongTie, Items.field_151007_F);
        RID.addToGroup(portionHide, Items.field_179555_bs);
        _DEFAULTS_INITED = true;
    }

    private RID() {
    }

    public static final void init() {
    }

    static final class DynTag
    extends Vector<Item> {
        static final List<DynTag> _indexedTags = new ArrayList<DynTag>(111);
        private static final Map<String, Integer> _namedIndices = new ConcurrentHashMap<String, Integer>(31);
        final int _index;
        final String _tag;

        DynTag(int index, String name) {
            super(11);
            Validate.notBlank((CharSequence)name);
            this._tag = name;
            this._index = index;
        }

        @Nonnull
        static DynTag get(@Nonnull String tag) {
            Validate.isTrue((tag.indexOf(58) > 0 ? 1 : 0) != 0, (String)"tag name must belong to a namespace", (Object[])new Object[0]);
            Integer index = _namedIndices.computeIfAbsent(tag, s -> {
                int next_i = _indexedTags.size();
                _indexedTags.add(new DynTag(next_i, (String)s));
                return next_i;
            });
            return _indexedTags.get(index);
        }

        final boolean in(Item item) {
            return RID.isIn(item, this._tag) || super.contains(item);
        }

        static final boolean isIn(Item item, String tag) {
            if (!SharedGlue.isDefined(item)) {
                return false;
            }
            int n = _namedIndices.compute(tag, (s, i) -> i == null ? -1 : (_indexedTags.get((int)i).in(item) ? i : -1));
            return n >= 0 && n < _indexedTags.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void add(Item item, @Nonnull String tag) {
            if (SharedGlue.isDefined(item)) {
                DynTag tagd;
                DynTag dynTag = tagd = DynTag.get(tag);
                synchronized (dynTag) {
                    if (!tagd.contains(item)) {
                        tagd.add(item);
                    }
                }
            }
        }
    }

    public static class Tags {
        public static final Tag<Item> NO_ITEMS = new Tag(new ResourceLocation("carrots:null"));
        public static final Tag<Block> NO_BLOKS = new Tag(new ResourceLocation("carrots:null"));
        public static final Tag<Block> DIRT_LIKE = Tags.forBlocks("minecraft", "dirt_like");
        public static final Tag<Block> MAGMA_LIKE = Tags.forBlocks("minecraft", "magma_like");
        public static final Tag<Block> CACTUS_BLOCKS = Tags.forBlocks("forge", "cactus");
        public static final Tag<Block> GRASS_BLOCKS = Tags.forBlocks("forge", "grass");
        public static final Tag<Block> FARMLAND = Tags.forBlocks("forge", "farmland");
        public static final Tag<Item> HAPPY_FOODS = Tags.forItems(LibInfo.MOD_ID(), "happy_foods");
        public static final Tag<Item> HEADS = Tags.forItems(LibInfo.MOD_ID(), "heads");
        public static final Tag<Item> LIGHTING_DUSTS = Tags.forItems("forge", "dusts/lighting");
        public static final Tag<Item> MOB_HEADS = Tags.forItems(LibInfo.MOD_ID(), "heads/mobs");
        public static final Tag<Block> LADDERS = Tags.forBlocks("minecraft", "ladders");
        public static final Tag<Block> LEVERS = Tags.forBlocks("minecraft", "levers");
        public static final Tag<Block> TORCHES = Tags.forBlocks("minecraft", "torches");
        public static final Tag<Block> CAMPFIRES = Tags.forBlocks(LibInfo.MOD_ID(), "campfires");
        public static final Tag<Block> OTHER_BONEMEALABLE = Tags.forBlocks("forge", "other_bonemealables");
        public static final Tag<Block> SUGARCANE = Tags.forBlocks("forge", "sugar_cane");
        public static final Tag<Block> TALL_FLOWERS = Tags.forBlocks("forge", "tall_flowers");
        public static final Tag<Block> VINES = Tags.forBlocks("forge", "vines");
        public static final Tag<Fluid> HEALING_WATERS = Tags.forFluids("forge", "healing");
        public static final Tag<Block> TNT_LIKE = Tags.forBlocks("forge", "tnt_like");
        public static final Tag<EntityType<?>> BOAT_ENTITIES = Tags.forEntities("forge:boats");

        public static final Tag<Block> forBlocks(String rid) {
            return new BlockTags.Wrapper(new ResourceLocation(rid));
        }

        public static final Tag<Block> forBlocks(String domain, String rid) {
            return new BlockTags.Wrapper(new ResourceLocation(domain, rid));
        }

        public static final Tag<Item> forItems(String rid) {
            return new ItemTags.Wrapper(new ResourceLocation(rid));
        }

        public static final Tag<Item> forItems(String domain, String rid) {
            return new ItemTags.Wrapper(new ResourceLocation(domain, rid));
        }

        public static final Tag<Fluid> forFluids(String rid) {
            return new FluidTags.Wrapper(new ResourceLocation(rid));
        }

        public static final Tag<Fluid> forFluids(String domain, String rid) {
            return new FluidTags.Wrapper(new ResourceLocation(domain, rid));
        }

        public static final Tag<EntityType<?>> forEntities(String rid) {
            return new EntityTypeTags.Wrapper(new ResourceLocation(rid));
        }
    }
}

