/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.Strings;

public final class SkinsHelper {
    public static final String NBT_TAGNAME = LibInfo.rstring("Skin");
    public static final String _PROPERTY_SKIN = "skin";

    public static final String getSkinUnbounded(@Nonnull ItemStack stack, String default_skin) {
        String x;
        String skin = default_skin;
        if (ItemStacks.hasData(stack, NBT_TAGNAME, 8) && !Strings.isDefaultValue(x = ItemStacks.getString(stack, NBT_TAGNAME), true)) {
            skin = x;
        }
        return skin;
    }

    public static final int getSkinUnbounded(@Nonnull ItemStack stack, int default_skin) {
        int x;
        int skin = default_skin;
        if (ItemStacks.hasData(stack, NBT_TAGNAME, 3) && (x = ItemStacks.getInt(stack, NBT_TAGNAME)) >= 0) {
            skin = x;
        }
        return skin;
    }

    public static final int getSkin(@Nonnull ItemStack stack, int num_skins, int default_skin) {
        int x;
        int skin = default_skin;
        if (ItemStacks.hasData(stack, NBT_TAGNAME, 3) && (x = ItemStacks.getInt(stack, NBT_TAGNAME)) > 0 && x < num_skins) {
            skin = x;
        }
        return skin;
    }

    public static final void initSkinUnbounded(ItemStack stack, @Nonnull Random rand, int[] skins, int default_skin) {
        int f;
        int n = f = skins.length > 0 ? skins[rand.nextInt(skins.length)] : default_skin;
        if (f != default_skin) {
            ItemStacks.setInt(stack, NBT_TAGNAME, f);
        }
    }

    public static final void initSkin(ItemStack stack, @Nonnull Random rand, int num_skins, int default_skin) {
        int f = rand.nextInt(num_skins);
        if (f != default_skin) {
            ItemStacks.setInt(stack, NBT_TAGNAME, f);
        }
    }

    public static final void initSkinConditionally(ItemStack stack, @Nonnull Random rand, int[] skins, int default_skin) {
        int f = SkinsHelper.getSkinUnbounded(stack, default_skin);
        if (f == default_skin) {
            SkinsHelper.initSkinUnbounded(stack, rand, skins, default_skin);
        }
    }

    public static final void initSkinConditionally(ItemStack stack, @Nonnull Random rand, int num_skins, int default_skin) {
        int f = SkinsHelper.getSkin(stack, num_skins, default_skin);
        if (f == default_skin) {
            SkinsHelper.initSkin(stack, rand, num_skins, default_skin);
        }
    }

    public static final void setSkin(ItemStack stack, int skin_id) {
        ItemStacks.setInt(stack, NBT_TAGNAME, skin_id);
    }

    public static final void setSkinUnbounded(ItemStack stack, String skin_id) {
        if (skin_id == null) {
            ItemStacks.removeData(stack, NBT_TAGNAME, 8, true);
        } else {
            ItemStacks.setString(stack, NBT_TAGNAME, skin_id);
        }
    }

    private SkinsHelper() {
    }

    public static final void init() {
    }
}

