/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractSkullBlock;
import net.minecraft.block.AttachedStemBlock;
import net.minecraft.block.BambooSaplingBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.CakeBlock;
import net.minecraft.block.CocoaBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.KelpBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.SilverfishBlock;
import net.minecraft.block.SpawnerBlock;
import net.minecraft.block.StemBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.FlintAndSteelItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.ShieldItem;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ObjectHolder;
import org.jwaresoftware.mcmods.lib.Fluids;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.Locations;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;

@ParametersAreNonnullByDefault
public final class Whatis {
    @ObjectHolder(value="minecraft:wheat_seeds")
    public static final Item wheat_seeds = null;
    @ObjectHolder(value="minecraft:red_mushroom")
    public static final Block red_mushroom = null;
    @ObjectHolder(value="minecraft:brown_mushroom")
    public static final Block brown_mushroom = null;
    @ObjectHolder(value="minecraft:brown_mushroom_block")
    public static final Block brown_mushroom_block = null;
    @ObjectHolder(value="minecraft:red_mushroom_block")
    public static final Block red_mushroom_block = null;
    @ObjectHolder(value="minecraft:hopper")
    public static final Block hopper = null;

    public static final boolean isCobblestone(BlockState what) {
        return what.func_177230_c() == Blocks.field_150347_e || what.func_177230_c() == Blocks.field_150341_Y;
    }

    public static final boolean isRawstone(BlockState what) {
        return what.func_177230_c() == Blocks.field_150348_b;
    }

    public static final boolean isCobblestoneLike(BlockState what) {
        return Whatis.isCobblestone(what) || Tags.Blocks.COBBLESTONE.func_199685_a_((Object)what.func_177230_c());
    }

    public static final boolean isCake(BlockState what) {
        return what.func_177230_c() == Blocks.field_150414_aQ || what.func_177230_c() instanceof CakeBlock;
    }

    public static final boolean isBlankBook(Item what) {
        return what == Items.field_151122_aG || what == Items.field_151099_bA;
    }

    public static final boolean isLavaBucket(ItemStack what) {
        if (!ItemStacks.isEmpty(what) && what.func_77973_b() == Items.field_151129_at) {
            return true;
        }
        return Fluids.isLavaBucket(what);
    }

    public static final boolean isLikelyNotShownAsItem(@Nonnull Object o) {
        return o == null || o == Blocks.field_150350_a || o == Items.field_190931_a || o instanceof StemBlock || o instanceof AttachedStemBlock || o instanceof CropsBlock || o instanceof CocoaBlock || o instanceof KelpBlock;
    }

    public static final boolean isBirchLog(@Nonnull BlockState what) {
        return what.func_177230_c() == Blocks.field_196619_M;
    }

    public static final boolean isDarkOakLog(@Nonnull BlockState what) {
        return what.func_177230_c() == Blocks.field_196623_P;
    }

    public static final boolean isLikelyTree(World world, BlockPos blockpos, @Nonnull BlockState what) {
        Block block = what.func_177230_c();
        if (!block.func_203417_a(BlockTags.field_200031_h)) {
            return false;
        }
        if (!Locations.isOverworld((IWorldReader)world)) {
            return false;
        }
        int radius = 3;
        int i = radius + 1;
        int leaf_block_count = 0;
        if (world.func_175707_a(blockpos.func_177982_a(-i, -i, -i), blockpos.func_177982_a(i, i, i))) {
            for (BlockPos test_blockpos : BlockPos.func_218278_a((BlockPos)blockpos.func_177982_a(-radius, -radius, -radius), (BlockPos)blockpos.func_177982_a(radius, radius, radius))) {
                BlockState test_blockstate = world.func_180495_p(test_blockpos);
                if (!test_blockstate.func_177230_c().func_203417_a(BlockTags.field_206952_E)) continue;
                ++leaf_block_count;
            }
        }
        return leaf_block_count > 6;
    }

    public static final boolean isLikelySapling(World world, BlockState what) {
        boolean likely;
        Block block = what.func_177230_c();
        if (block instanceof SaplingBlock || block.func_203417_a(BlockTags.field_200030_g) || block instanceof BambooSaplingBlock) {
            return true;
        }
        String klassname = block.getClass().getSimpleName();
        boolean bl = likely = klassname.endsWith("Sapling") || klassname.startsWith("Sapling");
        if (likely && block instanceof IGrowable) {
            if (!(block instanceof BushBlock)) {
                boolean found = false;
                for (IProperty p : what.func_206869_a()) {
                    if (!(p instanceof IntegerProperty) || !"stage".equals(p.func_177701_a()) && !"age".equals(p.func_177701_a()) && !"growth".equals(p.func_177701_a())) continue;
                    found = true;
                    break;
                }
                likely = found;
            }
        } else {
            likely = false;
        }
        return likely;
    }

    public static boolean isLikelySpawner(BlockState blockstate) {
        Block block = blockstate.func_177230_c();
        return block == Blocks.field_150474_ac || block instanceof SilverfishBlock || block instanceof SpawnerBlock;
    }

    public static boolean isLikelyDetonateable(BlockState blockstate) {
        Block block = blockstate.func_177230_c();
        return blockstate.func_203425_a(RID.Tags.TNT_LIKE) || block == Blocks.field_150335_W || ModIntegration.isDetonateable(block);
    }

    public static final boolean isBoat(@Nullable Entity what) {
        if (what instanceof BoatEntity) {
            return true;
        }
        return what != null && what.func_200600_R().func_220341_a(RID.Tags.BOAT_ENTITIES);
    }

    public static final boolean isNaturalFlightGear(Item what) {
        if (what == Items.field_185160_cR || what instanceof ElytraItem) {
            return true;
        }
        if (SharedGlue.isDefined(what) && RID.isIn(what, "forge:armor/wings")) {
            return true;
        }
        return ModIntegration.isNaturalFlightGear(what);
    }

    public static final boolean isSimpleShield(Item what) {
        if (what == Items.field_185159_cQ || what instanceof ShieldItem) {
            return true;
        }
        if (SharedGlue.isDefined(what) && RID.isIn(what, "forge:armor/shields")) {
            return true;
        }
        return ModIntegration.isSimpleShield(what);
    }

    public static final boolean isSimpleShears(Item what) {
        if (what == Items.field_151097_aZ || what instanceof ShearsItem) {
            return true;
        }
        return SharedGlue.isDefined(what) && RID.isIn(what, "tools/shears");
    }

    public static final boolean isFlintAndSteel(Item what) {
        if (what == Items.field_151033_d || what instanceof FlintAndSteelItem) {
            return true;
        }
        return SharedGlue.isDefined(what) && RID.isIn(what, "tools/flint_steels");
    }

    public static final boolean isAnimalArmor(Item what) {
        if (what == Items.field_222110_op || what == Items.field_151125_bZ || what == Items.field_151138_bX || what == Items.field_151136_bY) {
            return true;
        }
        return RID.isIn(what, "armor/animals") || ModIntegration.isAnimalArmor(what);
    }

    public static final boolean isLikenessTrophy(ItemStack what) {
        Block block;
        if (ItemStacks.isEmpty(what)) {
            return false;
        }
        Item whatwhat = what.func_77973_b();
        if (RID.matches(what, "carrots:heads")) {
            return true;
        }
        if (whatwhat instanceof BlockItem && (block = ((BlockItem)whatwhat).func_179223_d()) instanceof AbstractSkullBlock) {
            return true;
        }
        return ModIntegration.isLikenessTrophy(what);
    }

    private Whatis() {
    }

    public static final void initLoad0() {
    }
}

