/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public final class AdvancementPredicate
implements Predicate<PlayerEntity> {
    public static final String MEMBER = "advancement";
    @Nonnull
    private final ResourceLocation _match;

    public AdvancementPredicate(ResourceLocation name) {
        this._match = Objects.requireNonNull(name, "The advancement's name must be defined");
    }

    public ResourceLocation getId() {
        return this._match;
    }

    public static final boolean isDone(ResourceLocation advancement_id, PlayerEntity player) {
        boolean r = false;
        if (player instanceof ServerPlayerEntity) {
            AdvancementManager am = ServerLifecycleHooks.getCurrentServer().func_191949_aK();
            Advancement a = am.func_192778_a(advancement_id);
            r = a != null && ((ServerPlayerEntity)player).func_192039_O().func_192747_a(a).func_192105_a();
        }
        return r;
    }

    @Override
    public boolean test(PlayerEntity player) {
        return AdvancementPredicate.isDone(this._match, player);
    }

    public final boolean test(PlayerEntity player, @Nullable ResourceLocation advancement_id) {
        return this._match.equals((Object)advancement_id) && this.test(player);
    }

    @Nonnull
    public JsonElement serialize_value() {
        return new JsonPrimitive(this._match.toString());
    }

    @Nonnull
    public JsonObject serialize_into(@Nonnull JsonObject into) {
        into.add(MEMBER, this.serialize_value());
        return into;
    }

    @Nonnull
    public JsonElement serialize() {
        return this.serialize_into(new JsonObject());
    }

    @Nonnull
    public static final AdvancementPredicate deserialize_value(JsonElement json) {
        String rid = null;
        if (json.isJsonPrimitive()) {
            rid = json.getAsString();
        } else {
            JsonObject body = JSONUtils.func_151210_l((JsonElement)json, (String)MEMBER);
            if (body.size() == 1) {
                rid = JSONUtils.func_151200_h((JsonObject)body, (String)"name");
            }
        }
        if (rid == null) {
            throw new JsonParseException("Unable to find advancement name");
        }
        return new AdvancementPredicate(ResourceLocation.func_208304_a((String)rid));
    }

    @Nonnull
    public static final Optional<AdvancementPredicate> deserialize_outof(JsonObject from) {
        return Optional.ofNullable(from.has(MEMBER) ? AdvancementPredicate.deserialize_value(from.get(MEMBER)) : null);
    }
}

