/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.advancements;

import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.util.ResourceLocation;

public abstract class ObservedTrigger<T extends ICriterionInstance>
implements ICriterionTrigger<T> {
    protected final Map<PlayerAdvancements, Listeners<T>> _playersToListeners = Maps.newHashMap();
    private final ResourceLocation _id;

    public ObservedTrigger(ResourceLocation rid) {
        this._id = Objects.requireNonNull(rid);
    }

    public final ResourceLocation func_192163_a() {
        return this._id;
    }

    public final void func_192165_a(PlayerAdvancements player, ICriterionTrigger.Listener<T> listener) {
        Listeners<T> listeners = this._playersToListeners.get(player);
        if (listeners == null) {
            listeners = new Listeners(player);
            this._playersToListeners.put(player, listeners);
        }
        listeners.add(listener);
    }

    public final void func_192164_b(PlayerAdvancements player, ICriterionTrigger.Listener<T> listener) {
        Listeners<T> listeners = this._playersToListeners.get(player);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this._playersToListeners.remove(player);
            }
        }
    }

    public final void func_192167_a(PlayerAdvancements player) {
        this._playersToListeners.remove(player);
    }

    @ParametersAreNonnullByDefault
    public static class Listeners<T extends ICriterionInstance> {
        protected final PlayerAdvancements _advancements;
        private final Set<ICriterionTrigger.Listener<T>> _listenerset = Sets.newHashSet();

        public Listeners(PlayerAdvancements advancements) {
            this._advancements = Objects.requireNonNull(advancements);
        }

        public final boolean isEmpty() {
            return this._listenerset.isEmpty();
        }

        public final void add(ICriterionTrigger.Listener<T> l) {
            this._listenerset.add(l);
        }

        public final void remove(ICriterionTrigger.Listener<T> l) {
            this._listenerset.remove(l);
        }

        public final void trigger(Predicate<T> filter) {
            ArrayList<ICriterionTrigger.Listener<T>> affected = null;
            for (ICriterionTrigger.Listener<T> listener : this._listenerset) {
                if (!filter.test(listener.func_192158_a())) continue;
                if (affected == null) {
                    affected = new ArrayList<ICriterionTrigger.Listener<T>>();
                }
                affected.add(listener);
            }
            if (affected != null) {
                for (ICriterionTrigger.Listener listener : affected) {
                    listener.func_192159_a(this._advancements);
                }
            }
        }

        public final void trigger() {
            this.trigger((Predicate<T>)Predicates.alwaysTrue());
        }
    }
}

