/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.capability;

import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.Tag;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.capability.IGradeable;

public enum QualityGrade implements IStringSerializable
{
    UNKNOWN(0.0f, null, null, new String[0]),
    VERYPOOR(0.05f, "minecraft:stripped_oak_wood", "minecraft:logs", "0", "wood", "reject"),
    POOR(0.2f, "minecraft:stone_bricks", "minecraft:stone_bricks", "1", "stone", "copper"),
    BASE(0.3f, "minecraft:book", "forge:bookshelves", "paper", "bronze"),
    GOOD(0.45f, "minecraft:iron_ingot", "forge:ingots/iron", "2", "iron", "silver", "invar"),
    VERYGOOD(0.55f, "minecraft:gold_ingot", "forge:ingots/gold", "3", "gold"),
    EXCELLENT(0.7f, "minecraft:obsidian", "forge:obsidian", "4", "obsidian", "magma"),
    GREAT(0.8f, "minecraft:diamond", "forge:gems/diamond", "6", "diamond"),
    EPIC(0.9f, "minecraft:emerald", "forge:gems/emerald", "8", "emerald"),
    LEGENDARY(1.0f, "minecraft:enchanted_golden_apple", null, "10");

    public static final QualityGrade WOOD;
    public static final QualityGrade STONE;
    public static final QualityGrade PAPER;
    public static final QualityGrade IRON;
    public static final QualityGrade GOLD;
    public static final QualityGrade OBSIDIAN;
    public static final QualityGrade DIAMOND;
    public static final QualityGrade EMERALD;
    private static final QualityGrade[] _VALUES_CACHE;
    private final String _name_lc;
    private final float _value;
    @Nullable
    private final ResourceLocation _barter_given;
    @Nullable
    private final String _barter_group;
    @Nullable
    private final String[] _synonyms;

    private QualityGrade(float f, String given, String group, String ... synonyms) {
        this._value = f;
        this._name_lc = this.name().toLowerCase(Locale.US);
        this._barter_given = given == null ? null : new ResourceLocation(given);
        this._barter_group = group;
        this._synonyms = synonyms != null && synonyms.length > 0 ? synonyms : null;
    }

    public float value() {
        return this._value;
    }

    @Nonnull
    public String func_176610_l() {
        return this._name_lc;
    }

    public String toString() {
        return this._name_lc;
    }

    @Nonnull
    public String suffix() {
        return this == UNKNOWN ? "" : "_" + this._name_lc;
    }

    @Nonnull
    public Item defaultBarterItem() {
        return this == UNKNOWN || this._barter_given == null ? Items.field_190931_a : (Item)ForgeRegistries.ITEMS.getValue(this._barter_given);
    }

    @Nullable
    public Tag<Item> defaultBarterGroup() {
        return this._barter_group != null ? RID.getTag(this._barter_group) : null;
    }

    public final boolean isKnown() {
        return this != UNKNOWN;
    }

    private final boolean matches(String s) {
        if (this._name_lc.equals(s)) {
            return true;
        }
        if (this._synonyms != null) {
            for (String altname : this._synonyms) {
                if (!altname.equals(s)) continue;
                return true;
            }
        }
        return false;
    }

    public static final QualityGrade sameOrUnknown(@Nullable QualityGrade g) {
        return g == null ? UNKNOWN : g;
    }

    public static final QualityGrade findOrUnknown(@Nullable String s) {
        if ((s = StringUtils.trimToNull((String)s)) != null) {
            s = s.toLowerCase(Locale.ROOT);
            for (QualityGrade g : _VALUES_CACHE) {
                if (!g.matches(s)) continue;
                return g;
            }
        }
        return UNKNOWN;
    }

    public final boolean isEqualOrBetter(@Nonnull QualityGrade other) {
        return this.ordinal() >= other.ordinal();
    }

    public final int multiplierTier(@Nonnull QualityGrade other) {
        int d = this.ordinal() - other.ordinal();
        return d < 0 ? 0 : 1 + d;
    }

    public final QualityGrade oneUp() {
        return this == UNKNOWN || this.ordinal() == _VALUES_CACHE.length - 1 ? this : _VALUES_CACHE[this.ordinal() + 1];
    }

    public static final boolean isGoldOrBetter(ItemStack item) {
        return !item.func_190926_b() && IGradeable.QualityGradePropertyGetter.getFrom(item).isEqualOrBetter(GOLD);
    }

    public static final boolean isEpicOrBetter(ItemStack item) {
        return !item.func_190926_b() && IGradeable.QualityGradePropertyGetter.getFrom(item).isEqualOrBetter(EPIC);
    }

    static {
        WOOD = VERYPOOR;
        STONE = POOR;
        PAPER = BASE;
        IRON = GOOD;
        GOLD = VERYGOOD;
        OBSIDIAN = EXCELLENT;
        DIAMOND = GREAT;
        EMERALD = EPIC;
        _VALUES_CACHE = QualityGrade.values();
    }
}

