/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.DisplayEffectsScreen;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IModPotionEffect;
import org.jwaresoftware.mcmods.lib.api.mod.IModInfo;

public abstract class EffectBase
extends Effect
implements IModPotionEffect {
    protected static final int _1SEC_TICKS = SharedGlue.SECS_TO_TICKS_DURATION_MULTIPLIER();
    protected final String _oid;
    protected final boolean _milkFlag;
    private boolean _visible;
    protected ResourceLocation _icon;
    private final String _translationKey;

    protected EffectBase(IModInfo mod, String name, boolean visible, EffectType type, int liquidColor, boolean milkCures) {
        super(type, liquidColor);
        this._oid = name;
        this._visible = visible;
        this._icon = new ResourceLocation(mod.mod_id(), "textures/mob_effect/" + name + ".png");
        this._milkFlag = milkCures;
        String ns = mod.itemid_prefix();
        if (ns.isEmpty()) {
            ns = mod.mod_id() + ".";
        }
        this._translationKey = "potion." + ns + name;
        this.setRegistryName(new ResourceLocation(mod.mod_id(), name));
    }

    protected EffectBase(IModInfo mod, String name, boolean visible, boolean bad, int liquidColor, boolean milkCures) {
        this(mod, name, visible, bad ? EffectType.HARMFUL : EffectType.BENEFICIAL, liquidColor, milkCures);
    }

    protected EffectBase(IModInfo mod, String name, boolean bad, int liquidColor) {
        this(mod, name, true, bad, liquidColor, true);
    }

    @Override
    public final String oid() {
        return this._oid;
    }

    protected String func_210758_b() {
        return this._translationKey;
    }

    @Override
    public final boolean isHiddenByDefault() {
        return !this._visible;
    }

    public boolean shouldRender(EffectInstance effect) {
        return !this.isHiddenByDefault();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderInventoryEffect(EffectInstance effect, DisplayEffectsScreen<?> gui, int x, int y, float z) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this._icon);
        AbstractGui.blit((int)(x + 6), (int)(y + 7), (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderHUDEffect(EffectInstance effect, AbstractGui gui, int x, int y, float z, float alpha) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this._icon);
        AbstractGui.blit((int)(x + 3), (int)(y + 3), (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
    }

    public List<ItemStack> getCurativeItems() {
        return this._milkFlag ? super.getCurativeItems() : new ArrayList();
    }

    protected final boolean isReady(int cooldown_ticks, int duration_ticks, int amplifier) {
        int i = cooldown_ticks >> amplifier;
        return i > 0 ? duration_ticks % i == 0 : true;
    }

    public void func_76394_a(LivingEntity victim, int amplifier) {
    }
}

