/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.block;

import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IAirPlaceable;
import org.jwaresoftware.mcmods.lib.api.IModBlock;
import org.jwaresoftware.mcmods.lib.impl.ItemSupport;
import org.jwaresoftware.mcmods.lib.impl.block.AirGrabbingItemBlock;
import org.jwaresoftware.mcmods.lib.impl.block.ItemBlockBase;

public abstract class ContainerBlockBase
extends ContainerBlock
implements IModBlock {
    @Nonnull
    protected final String _oid;
    protected boolean _hidden;
    @Nonnull
    protected String _i18n = "";

    public ContainerBlockBase(@Nonnull String oid, @Nullable Block.Properties p, boolean hidden) {
        super(p != null ? p : Block.Properties.func_200949_a((Material)SharedGlue.Material_rock, (MaterialColor)SharedGlue.Material_rock.func_151565_r()));
        this._oid = Objects.requireNonNull(oid, "Non-null oid required");
        this._hidden = hidden;
    }

    public ContainerBlockBase(@Nonnull String oid, @Nonnull Block likeBlock, boolean hidden) {
        this(oid, Block.Properties.func_200950_a((Block)likeBlock), hidden);
    }

    @Override
    @Nonnull
    public final String oid() {
        return this._oid;
    }

    public final Random getRNG() {
        return this.RANDOM;
    }

    @Override
    public String getTranslationKey(ItemStack stack) {
        if (this._i18n.isEmpty()) {
            this._i18n = ItemSupport.defaultTranslationKey((Block)this);
        }
        return this._i18n;
    }

    public final String func_149739_a() {
        return this.getTranslationKey(ItemStack.field_190927_a);
    }

    @Override
    public BlockItem makeItemBlock(@Nonnull Block thisblock, @Nullable Item.Properties ip) {
        return this instanceof IAirPlaceable ? new AirGrabbingItemBlock(thisblock, ip) : new ItemBlockBase(thisblock, ip);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public boolean isHiddenByDefault() {
        return this._hidden;
    }

    public void func_149666_a(ItemGroup tab, NonNullList<ItemStack> list) {
        if (!this.isHiddenByDefault() || tab == SharedGlue.CreativeTabs_search) {
            super.func_149666_a(tab, list);
        }
    }
}

