/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.block;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jwaresoftware.mcmods.lib.Tooltips;
import org.jwaresoftware.mcmods.lib.api.Gidable;
import org.jwaresoftware.mcmods.lib.api.IModBlock;
import org.jwaresoftware.mcmods.lib.api.IModItem;
import org.jwaresoftware.mcmods.lib.api.Oidable;
import org.jwaresoftware.mcmods.lib.impl.ItemSupport;
import org.jwaresoftware.mcmods.lib.impl.block.BlocksetPiece;

public class ItemBlockBase
extends BlockItem
implements IModItem {
    @Nonnull
    protected String _i18n = "";
    @Nullable
    protected BlocksetPiece _blockset;
    protected final String _oid;

    protected ItemBlockBase(@Nonnull Block block, @Nonnull String oid, @Nullable Item.Properties ip) {
        super(block, ip != null ? ip : new Item.Properties());
        this._oid = Objects.requireNonNull(oid);
    }

    public ItemBlockBase(@Nonnull Block block, @Nullable Item.Properties ip) {
        this(block, ((Oidable)block).oid(), ip);
    }

    @Override
    public final String oid() {
        return this.func_179223_d() instanceof Oidable ? ((Oidable)this.func_179223_d()).oid() : "iambroken";
    }

    @Override
    public String gid(Object object) {
        return this.func_179223_d() instanceof Gidable ? ((Gidable)this.func_179223_d()).gid(object) : "";
    }

    @Override
    public <T> T inGroup(@Nullable String gid) {
        if (this.func_179223_d() instanceof Gidable) {
            ((Gidable)this.func_179223_d()).inGroup(gid);
        }
        return (T)this;
    }

    public int getItemStackLimit(ItemStack stack) {
        int m;
        int n = super.getItemStackLimit(stack);
        if (this.func_179223_d() instanceof IModBlock && (m = ((IModBlock)this.func_179223_d()).getItemStackLimit(stack)) > 0) {
            n = m;
        }
        return n;
    }

    @Override
    public int getBurnTime(ItemStack stack) {
        return IModItem.super.getBurnTime(stack);
    }

    protected String func_195935_o() {
        if (this._i18n.isEmpty()) {
            this._i18n = ItemSupport.defaultTranslationKey(this.func_179223_d());
            if ("x".equals(this._i18n)) {
                this._i18n = ItemSupport.defaultTranslationKey((Item)this);
            }
        }
        return this._i18n;
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_179223_d() instanceof IModBlock ? ((IModBlock)this.func_179223_d()).getTranslationKey(stack) : this.func_179223_d().func_149739_a();
    }

    public final void setBlocksetDetails(@Nullable BlocksetPiece details) {
        this._blockset = details;
    }

    public final void setBlocksetDetails(String material, String blockset, String derivative) {
        this._blockset = new BlocksetPiece(derivative, material, blockset);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return this._blockset == null ? super.func_200295_i(stack) : this._blockset.getDisplayString(stack);
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
        if (!this.isHiddenByDefault() && this.func_194125_a(tab)) {
            this.func_179223_d().func_149666_a(tab, items);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flags) {
        if (this.isShowingUiTips(stack)) {
            Tooltips.addDocTipDefault(stack, tooltip);
        }
        super.func_77624_a(stack, world, tooltip, flags);
    }
}

