/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.fluid;

import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraftforge.fluids.FluidStack;
import org.jwaresoftware.mcmods.lib.Misc;

public final class BucketProperties
extends Item.Properties {
    protected int _capacity_buckets = 1;
    protected Supplier<Item> _fliptBucket = Misc.NO_ITEM;
    protected Supplier<ItemStack> _emptyBucket = Misc.NO_STACK;
    protected Predicate<FluidStack> _allowFluid = f -> true;
    protected boolean _wlmPropertySetter = true;
    protected boolean _renderFluidTexture = true;

    public BucketProperties() {
        super.func_200916_a(ItemGroup.field_78026_f);
    }

    public BucketProperties(BucketProperties from) {
        this._capacity_buckets = from._capacity_buckets;
        this._allowFluid = from._allowFluid;
        this._fliptBucket = from._fliptBucket;
        this._emptyBucket = from._emptyBucket;
        this._renderFluidTexture = from._renderFluidTexture;
    }

    public BucketProperties(int buckets_capacity) {
        this();
        this._capacity_buckets = Math.max(0, buckets_capacity);
    }

    public final BucketProperties zeroed() {
        this._fliptBucket = null;
        this._emptyBucket = null;
        this._allowFluid = null;
        return this;
    }

    public BucketProperties group(ItemGroup g) {
        super.func_200916_a(g);
        return this;
    }

    public BucketProperties rarity(Rarity r) {
        super.func_208103_a(r);
        return this;
    }

    public BucketProperties maxStackSize(int max) {
        super.func_200917_a(max);
        return this;
    }

    public BucketProperties food(Food food) {
        super.func_221540_a(food);
        return this;
    }

    public BucketProperties setNoRepair() {
        return this;
    }

    public BucketProperties containerItem(Item b) {
        super.func_200919_a(b);
        return this;
    }

    public BucketProperties flipBucket(@Nonnull Supplier<Item> fliptBucket, @Nullable Supplier<ItemStack> emptyBucket) {
        this._fliptBucket = Objects.requireNonNull(fliptBucket);
        this._emptyBucket = emptyBucket == null ? Misc.NO_STACK : emptyBucket;
        return this;
    }

    public final BucketProperties flipBucket(@Nonnull Supplier<Item> fliptBucket) {
        return this.flipBucket(fliptBucket, null);
    }

    public BucketProperties emptyBucket(@Nonnull Supplier<ItemStack> emptyBucket) {
        this._emptyBucket = emptyBucket == null ? Misc.NO_STACK : emptyBucket;
        return this;
    }

    public BucketProperties allow(@Nonnull Predicate<FluidStack> hold_test) {
        this._allowFluid = hold_test == null ? f -> false : hold_test;
        return this;
    }

    public BucketProperties wlmAware(boolean flag) {
        this._wlmPropertySetter = flag;
        return this;
    }

    public final boolean wantWLMProperty() {
        return this._wlmPropertySetter;
    }

    public BucketProperties renderByColor() {
        this._renderFluidTexture = false;
        return this;
    }

    public BucketProperties renderByFluid() {
        this._renderFluidTexture = true;
        return this;
    }

    public final boolean usingFluidTexture() {
        return this._renderFluidTexture;
    }
}

