/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.fluid;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.ActionResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jwaresoftware.mcmods.lib.SharedGlue;

public interface CauldronBucketful {
    default public boolean canEmptyCauldron(BlockState cauldron, BlockPos at, ItemStack with) {
        return false;
    }

    @Nullable
    default public ActionResult<ItemStack> onCauldronEmptied(World world, PlayerEntity player, BlockPos at, ItemStack held, int cauldron_level) {
        return null;
    }

    public boolean canFillCauldron(BlockState var1, BlockPos var2, ItemStack var3);

    @Nullable
    public ActionResult<ItemStack> onCauldronFilled(World var1, PlayerEntity var2, BlockPos var3, ItemStack var4);

    default public ItemStack onCauldronRightClick(ItemStack held, World world, PlayerEntity player, BlockState hitstate, BlockPos at) {
        Block hit;
        if (world.func_175660_a(player, at) && (hit = hitstate.func_177230_c()) == Blocks.field_150383_bp && hit.getClass() == CauldronBlock.class) {
            int cauldron_level = (Integer)hitstate.func_177229_b((IProperty)CauldronBlock.field_176591_a);
            if (cauldron_level < SharedGlue.MAX_LEVEL_CAULDRON() && this.canFillCauldron(hitstate, at, held)) {
                ((CauldronBlock)hit).func_176590_a(world, at, hitstate, SharedGlue.MAX_LEVEL_CAULDRON());
                ActionResult<ItemStack> decision = this.onCauldronFilled(world, player, at, held);
                if (decision != null) {
                    held = (ItemStack)decision.func_188398_b();
                }
            } else if (cauldron_level > 0 && this.canEmptyCauldron(hitstate, at, held)) {
                ((CauldronBlock)hit).func_176590_a(world, at, hitstate, 0);
                ActionResult<ItemStack> decision = this.onCauldronEmptied(world, player, at, held, cauldron_level);
                if (decision != null) {
                    held = (ItemStack)decision.func_188398_b();
                }
            }
        }
        return held;
    }
}

