/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.fluid;

import java.util.function.BiFunction;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class ContainerFluidAttributes
extends FluidAttributes {
    private final int _flatColor;

    public ContainerFluidAttributes(FluidAttributes.Builder b, Fluid f) {
        super(b, f);
        this._flatColor = ((Builder)b).flatColor();
    }

    public int getFlatColor(FluidStack fluid) {
        return this._flatColor;
    }

    public static Builder builder(ResourceLocation stillTexture, ResourceLocation flowingTexture) {
        return new Builder(stillTexture, flowingTexture, ContainerFluidAttributes::new);
    }

    public static class Builder
    extends FluidAttributes.Builder {
        protected int _flatColor = -1;

        public Builder(ResourceLocation stillTexture, ResourceLocation flowingTexture, BiFunction<FluidAttributes.Builder, Fluid, FluidAttributes> ctor) {
            super(stillTexture, flowingTexture, ctor);
            this.sound(SoundEvents.field_187630_M, SoundEvents.field_187624_K);
        }

        public final Builder flatColor(int color) {
            this._flatColor = color;
            return this;
        }

        public final int flatColor() {
            return this._flatColor;
        }
    }
}

