/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.fluid;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.thirdparty.silentchaos512.utils.Color;
import org.jwaresoftware.mcmods.lib.Fluids;
import org.jwaresoftware.mcmods.lib.IniRegistries;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.Materials;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.impl.fluid.ContainerFluidAttributes;
import org.jwaresoftware.mcmods.lib.impl.fluid.FlowingFluidEffectBlock;
import org.jwaresoftware.mcmods.lib.impl.fluid.SlowFluid;

public class UniversalFluids {
    static FlowingFluidBlock MILK_BLOCK;
    @Nullable
    public static BucketItem LIQUID_XP_BUCKET;
    static FlowingFluidBlock LIQUID_XP_BLOCK;
    @Nullable
    public static BucketItem HONEY_BUCKET;
    static FlowingFluidBlock LIQUID_HONEY_BLOCK;
    @Nullable
    public static BucketItem SEEDOIL_BUCKET;
    static FlowingFluidBlock SEEDOIL_BLOCK;
    @Nullable
    public static BucketItem INK_BUCKET;
    static FlowingFluidBlock INK_BLOCK;

    static final Item.Properties bucketproperties() {
        return new Item.Properties().func_200917_a(1).func_200919_a(Items.field_151133_ar).func_200916_a(SharedGlue.CreativeTabs_misc);
    }

    private static final void makeMilk() {
        ResourceLocation still = LibInfo.r("fluids/fluid_milk_still");
        ResourceLocation flowing = LibInfo.r("fluids/fluid_milk_flowing");
        MILK_BLOCK = new FlowingFluidBlock(() -> Fluids.MILK, Block.Properties.func_200945_a((Material)Materials.milk).func_200942_a().func_200943_b(100.0f).func_222380_e());
        IniRegistries.autoregisterFluidBlock(LibInfo.MOD_ID(), MILK_BLOCK, LibInfo.rstring("liquid_milk_block"));
        ForgeFlowingFluid.Properties fluidproperties = new ForgeFlowingFluid.Properties(() -> Fluids.MILK, () -> Fluids.FLOWING_MILK, FluidAttributes.builder((ResourceLocation)still, (ResourceLocation)flowing).viscosity(1200).density(1200).sound(SoundEvents.field_187630_M, SoundEvents.field_187624_K)).block(() -> MILK_BLOCK).bucket(() -> Items.field_151117_aB);
        Fluids.MILK = new ForgeFlowingFluid.Source(fluidproperties);
        Fluids.FLOWING_MILK = new ForgeFlowingFluid.Flowing(fluidproperties);
        IniRegistries.autoregisterFluid(LibInfo.MOD_ID(), (Fluid)Fluids.MILK, "milk");
        IniRegistries.autoregisterFluid(LibInfo.MOD_ID(), (Fluid)Fluids.FLOWING_MILK, "flowing_milk");
    }

    private static final void makeLiquidXp() {
        ResourceLocation still = LibInfo.r("fluids/fluid_xp_still");
        ResourceLocation flowing = LibInfo.r("fluids/fluid_xp_flowing");
        LIQUID_XP_BUCKET = new BucketItem(() -> Fluids.EXPERIENCE, UniversalFluids.bucketproperties());
        IniRegistries.autoregisterItem(LibInfo.MOD_ID(), (Item)LIQUID_XP_BUCKET, "experience_bucket");
        LIQUID_XP_BLOCK = new FlowingFluidBlock(() -> Fluids.EXPERIENCE, Block.Properties.func_200945_a((Material)Materials.liquid_slime).func_200942_a().func_200943_b(100.0f).func_222380_e());
        IniRegistries.autoregisterFluidBlock(LibInfo.MOD_ID(), LIQUID_XP_BLOCK, LibInfo.rstring("liquid_xp_block"));
        ForgeFlowingFluid.Properties fluidproperties = new ForgeFlowingFluid.Properties(() -> Fluids.EXPERIENCE, () -> Fluids.FLOWING_EXPERIENCE, ContainerFluidAttributes.builder(still, flowing).flatColor(Color.fluidColor(11665166)).viscosity(1400).density(1250).sound(SoundEvents.field_187633_N, SoundEvents.field_187627_L)).block(() -> LIQUID_XP_BLOCK).bucket(() -> LIQUID_XP_BUCKET);
        Fluids.EXPERIENCE = new ForgeFlowingFluid.Source(fluidproperties);
        Fluids.FLOWING_EXPERIENCE = new ForgeFlowingFluid.Flowing(fluidproperties);
        IniRegistries.autoregisterFluid(LibInfo.MOD_ID(), (Fluid)Fluids.EXPERIENCE, "experience");
        IniRegistries.autoregisterFluid(LibInfo.MOD_ID(), (Fluid)Fluids.FLOWING_EXPERIENCE, "flowing_experience");
    }

    private static final void makeHoney() {
        ResourceLocation still = LibInfo.r("fluids/fluid_honey_still");
        ResourceLocation flowing = LibInfo.r("fluids/fluid_honey_flowing");
        HONEY_BUCKET = new BucketItem(() -> Fluids.HONEY, UniversalFluids.bucketproperties());
        IniRegistries.autoregisterItem(LibInfo.MOD_ID(), (Item)HONEY_BUCKET, "honey_bucket");
        LIQUID_HONEY_BLOCK = new FlowingFluidEffectBlock(() -> Fluids.HONEY, Block.Properties.func_200945_a((Material)Materials.sticky_goo).func_200942_a().func_200943_b(100.0f).func_222380_e(), (xyz, ent) -> {
            FlowingFluidEffectBlock.slowMovementEffect(ent);
            if (SharedGlue.isaPlayerOrFriendly(ent)) {
                FlowingFluidEffectBlock.addPotionEffect((LivingEntity)ent, SharedGlue.Potion_regeneration, 15, false);
            }
        });
        IniRegistries.autoregisterFluidBlock(LibInfo.MOD_ID(), LIQUID_HONEY_BLOCK, LibInfo.rstring("liquid_honey_block"));
        ForgeFlowingFluid.Properties fluidproperties = new ForgeFlowingFluid.Properties(() -> Fluids.HONEY, () -> Fluids.FLOWING_HONEY, ContainerFluidAttributes.builder(still, flowing).flatColor(Color.fluidColor(13607429)).viscosity(1400).density(1400).sound(SoundEvents.field_187633_N, SoundEvents.field_187627_L)).block(() -> LIQUID_HONEY_BLOCK).bucket(() -> HONEY_BUCKET);
        Fluids.HONEY = new SlowFluid.Source(fluidproperties);
        Fluids.FLOWING_HONEY = new SlowFluid.Flowing(fluidproperties);
        IniRegistries.autoregisterFluid(LibInfo.MOD_ID(), (Fluid)Fluids.HONEY, "honey");
        IniRegistries.autoregisterFluid(LibInfo.MOD_ID(), (Fluid)Fluids.FLOWING_HONEY, "flowing_honey");
    }

    private static final void makeSeedoil() {
        ResourceLocation still = LibInfo.r("fluids/fluid_seedoil_still");
        ResourceLocation flowing = LibInfo.r("fluids/fluid_seedoil_flowing");
        SEEDOIL_BUCKET = new BucketItem(() -> Fluids.SEEDOIL, UniversalFluids.bucketproperties());
        IniRegistries.autoregisterItem(LibInfo.MOD_ID(), (Item)SEEDOIL_BUCKET, "seedoil_bucket");
        SEEDOIL_BLOCK = new FlowingFluidBlock(() -> Fluids.SEEDOIL, Block.Properties.func_200945_a((Material)Materials.sticky_goo).func_200942_a().func_200943_b(100.0f).func_222380_e());
        IniRegistries.autoregisterFluidBlock(LibInfo.MOD_ID(), SEEDOIL_BLOCK, LibInfo.rstring("liquid_seedoil_block"));
        ForgeFlowingFluid.Properties fluidproperties = new ForgeFlowingFluid.Properties(() -> Fluids.SEEDOIL, () -> Fluids.FLOWING_SEEDOIL, ContainerFluidAttributes.builder(still, flowing).flatColor(Color.fluidColor(11708802)).viscosity(1250).density(1250).sound(SoundEvents.field_187630_M, SoundEvents.field_187624_K)).block(() -> SEEDOIL_BLOCK).bucket(() -> SEEDOIL_BUCKET);
        Fluids.SEEDOIL = new ForgeFlowingFluid.Source(fluidproperties);
        Fluids.FLOWING_SEEDOIL = new ForgeFlowingFluid.Flowing(fluidproperties);
        IniRegistries.autoregisterFluid(LibInfo.MOD_ID(), (Fluid)Fluids.SEEDOIL, "seedoil");
        IniRegistries.autoregisterFluid(LibInfo.MOD_ID(), (Fluid)Fluids.FLOWING_SEEDOIL, "flowing_seedoil");
    }

    private static final void makeInk() {
        ResourceLocation still = LibInfo.r("fluids/fluid_squidink_still");
        ResourceLocation flowing = LibInfo.r("fluids/fluid_squidink_flowing");
        INK_BUCKET = new BucketItem(() -> Fluids.SQUIDINK, UniversalFluids.bucketproperties());
        IniRegistries.autoregisterItem(LibInfo.MOD_ID(), (Item)INK_BUCKET, "squidink_bucket");
        INK_BLOCK = new FlowingFluidEffectBlock(() -> Fluids.SQUIDINK, Block.Properties.func_200945_a((Material)Materials.squid_ink).func_200942_a().func_200943_b(100.0f).func_222380_e(), (xyz, ent) -> {
            FlowingFluidEffectBlock.slowMovementEffect(ent);
            if (ent instanceof LivingEntity) {
                FlowingFluidEffectBlock.addPotionEffect((LivingEntity)ent, SharedGlue.Potion_blindness, 15, false);
            }
        });
        IniRegistries.autoregisterFluidBlock(LibInfo.MOD_ID(), INK_BLOCK, LibInfo.rstring("liquid_squidink_block"));
        ForgeFlowingFluid.Properties fluidproperties = new ForgeFlowingFluid.Properties(() -> Fluids.SQUIDINK, () -> Fluids.FLOWING_SQUIDINK, ContainerFluidAttributes.builder(still, flowing).flatColor(Color.fluidColor(196881)).viscosity(1200).density(1200).sound(SoundEvents.field_187630_M, SoundEvents.field_187624_K)).block(() -> INK_BLOCK).bucket(() -> INK_BUCKET);
        Fluids.SQUIDINK = new ForgeFlowingFluid.Source(fluidproperties);
        Fluids.FLOWING_SQUIDINK = new ForgeFlowingFluid.Flowing(fluidproperties);
        IniRegistries.autoregisterFluid(LibInfo.MOD_ID(), (Fluid)Fluids.SQUIDINK, "squidink");
        IniRegistries.autoregisterFluid(LibInfo.MOD_ID(), (Fluid)Fluids.FLOWING_SQUIDINK, "flowing_squidink");
    }

    public static final void makeFluids() {
        UniversalFluids.makeMilk();
        UniversalFluids.makeLiquidXp();
        UniversalFluids.makeHoney();
        UniversalFluids.makeSeedoil();
        UniversalFluids.makeInk();
    }

    public static enum Selector {
        MILK(100),
        LAVA(99),
        WATER(98),
        EXP(97),
        HONEY(96),
        INK(95),
        RESIN(94),
        SLIME(93),
        SLURRY(92),
        SEEDOIL(91),
        CUSTOM0(90);

        private final int _value;

        private Selector(int i) {
            this._value = i;
        }

        public final int value() {
            return this._value;
        }
    }
}

