/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.network;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.Effects;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.impl.network.ParticleAtMessage;
import org.jwaresoftware.mcmods.lib.impl.network.XyzMessage;

public class LibNetworkMessages {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)LibInfo.r("channel"), () -> "1", "1"::equals, "1"::equals);
    private static final ConcurrentMap<ModIntegration, AtomicInteger> __modMessageIDs = new ConcurrentHashMap<ModIntegration, AtomicInteger>();
    private static final AtomicInteger __nextBaseID = new AtomicInteger(0);

    public static final int nextID(ModIntegration mod) {
        Validate.isTrue((boolean)ModIntegration.isOneOfWabbits(mod));
        AtomicInteger modIDs = __modMessageIDs.computeIfAbsent(mod, m -> new AtomicInteger(__nextBaseID.addAndGet(100)));
        return modIDs.incrementAndGet();
    }

    public static final void initIDSupport() {
        LibNetworkMessages.nextID(ModIntegration.CARROTS_LIB);
    }

    public static final PacketDistributor<PacketDistributor.TargetPoint> toAllAround() {
        return PacketDistributor.NEAR;
    }

    public static final PacketDistributor.PacketTarget toAllAround(double x, double y, double z, double r, World in) {
        return PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)x, (double)y, (double)z, (double)r, (DimensionType)in.func_201675_m().func_186058_p()));
    }

    public static final PacketDistributor.PacketTarget toAllAround(Vec3d center, double r, World in) {
        return PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)center.func_82615_a(), (double)center.func_82617_b(), (double)center.func_82616_c(), (double)r, (DimensionType)in.func_201675_m().func_186058_p()));
    }

    public static final PacketDistributor.PacketTarget toAllAround(BlockPos center, double r, World in) {
        return PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p(), (double)r, (DimensionType)in.func_201675_m().func_186058_p()));
    }

    public static final PacketDistributor.PacketTarget toAllAround(Entity center, double r) {
        return PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)center.func_226277_ct_(), (double)center.func_226278_cu_(), (double)center.func_226281_cx_(), (double)r, (DimensionType)center.func_130014_f_().func_201675_m().func_186058_p()));
    }

    public static final PacketDistributor<ServerPlayerEntity> toPlayer() {
        return PacketDistributor.PLAYER;
    }

    public static final PacketDistributor.PacketTarget toPlayer(@Nonnull ServerPlayerEntity mp) {
        return PacketDistributor.PLAYER.with(() -> mp);
    }

    public static final PacketDistributor.PacketTarget toServer() {
        return PacketDistributor.SERVER.noArg();
    }

    public static final void sparkleAt(XyzMessage message, Supplier<NetworkEvent.Context> ctx, Supplier<World> clientworld) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> Effects.spawnHappyParticles((World)clientworld.get(), message.vec()));
            context.setPacketHandled(true);
        }
    }

    public static final void particlesAt(ParticleAtMessage message, Supplier<NetworkEvent.Context> ctx, Supplier<World> clientworld) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                Vec3d at = message.vec();
                int n = message.count();
                Effects.spawnParticles((World)clientworld.get(), at.func_82615_a(), at.func_82617_b(), at.func_82616_c(), null, message.particle(), n, n == 1, n < 1);
            });
            context.setPacketHandled(true);
        }
    }

    protected LibNetworkMessages() {
    }
}

